/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.RegistrationPeriodInDegreeCurricularPlan_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.joda.time.DateTime;

public class RegistrationPeriodInDegreeCurricularPlan
extends RegistrationPeriodInDegreeCurricularPlan_Base {
    private RegistrationPeriodInDegreeCurricularPlan() {
    }

    public RegistrationPeriodInDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear, DateTime startDate, DateTime endDate) {
        this.init(degreeCurricularPlan, executionYear, startDate, endDate);
    }

    protected void init(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear, DateTime startDate, DateTime endDate) {
        this.checkRuleToCreate(degreeCurricularPlan, executionYear);
        super.init(degreeCurricularPlan, executionYear.getFirstExecutionPeriod(), startDate, endDate);
    }

    private void checkRuleToCreate(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        if (degreeCurricularPlan.hasRegistrationPeriodFor(executionYear)) {
            throw new DomainException("error.RegistrationPeriodInDegreeCurricularPlan.degree.curricular.plan.already.contains.registration.period.for.execution.year", new String[0]);
        }
    }

    public ExecutionYear getExecutionYear() {
        return this.getExecutionPeriod().getExecutionYear();
    }
}

