/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.FinalEvaluation;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.Mark_Base;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.InvalidMarkDomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.bennu.core.domain.Bennu;

public class Mark
extends Mark_Base {
    public Mark() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public Mark(Attends attends, Evaluation evaluation, String mark) {
        this();
        this.setAttend(attends);
        this.setEvaluation(evaluation);
        this.setMark(mark);
        this.setPublishedMark(null);
    }

    public void setMark(String mark) {
        if (!this.validateMark(mark)) {
            throw new InvalidMarkDomainException("errors.invalidMark", mark, this.getAttend().getRegistration().getNumber().toString());
        }
        super.setMark(mark);
    }

    public void delete() {
        this.setAttend(null);
        this.setEvaluation(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    private boolean validateMark(String mark) {
        Registration registration;
        StudentCurricularPlan studentCurricularPlan;
        DegreeCurricularPlan degreeCurricularPlan;
        DegreeType degreeType;
        GradeScale gradeScale = this.getEvaluation() instanceof Project || this.getEvaluation() instanceof FinalEvaluation ? (this.getAttend().getEnrolment() == null ? ((degreeType = (degreeCurricularPlan = (studentCurricularPlan = (registration = this.getAttend().getRegistration()).getStudentCurricularPlan(this.getAttend().getExecutionPeriod())).getDegreeCurricularPlan()).getDegreeType()).isEmpty() ? GradeScale.TYPE20 : degreeCurricularPlan.getGradeScaleChain()) : this.getAttend().getEnrolment().getCurricularCourse().getGradeScaleChain()) : this.getEvaluation().getGradeScale();
        return gradeScale.isValid(mark, this.getEvaluation().getEvaluationType());
    }
}

