/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularCourseScope;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeInfo;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.DegreeOfficialPublication;
import org.fenixedu.academic.domain.Degree_Base;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.EmptyDegree;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.ScientificCommission;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.AnyCurricularCourse;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degree.degreeCurricularPlan.DegreeCurricularPlanState;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisState;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import pt.ist.fenixframework.DomainObject;

public class Degree
extends Degree_Base
implements Comparable<Degree> {
    public static final String CREATED_SIGNAL = "academic.degree.create";
    public static final String DEFAULT_MINISTRY_CODE = "9999";
    private static final Collator collator = Collator.getInstance();
    public static final Comparator<Degree> COMPARATOR_BY_NAME = new Comparator<Degree>(){

        @Override
        public int compare(Degree o1, Degree o2) {
            String name1 = o1.getNameFor((AcademicInterval)null).getContent(I18N.getLocale());
            String name2 = o2.getNameFor((AcademicInterval)null).getContent(I18N.getLocale());
            if (Strings.isNullOrEmpty((String)name1) || Strings.isNullOrEmpty((String)name2)) {
                name1 = o1.getNameFor((AcademicInterval)null).getContent();
                name2 = o2.getNameFor((AcademicInterval)null).getContent();
            }
            return collator.compare(name1, name2);
        }
    };
    public static final Comparator<Degree> COMPARATOR_BY_NAME_AND_ID = new Comparator<Degree>(){

        @Override
        public int compare(Degree o1, Degree o2) {
            int nameResult = COMPARATOR_BY_NAME.compare(o1, o2);
            return nameResult == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : nameResult;
        }
    };
    private static final Comparator<Degree> COMPARATOR_BY_DEGREE_TYPE_NAME = new Comparator<Degree>(){

        @Override
        public int compare(Degree o1, Degree o2) {
            return collator.compare(o1.getDegreeType().getName().getContent(), o2.getDegreeType().getName().getContent());
        }
    };
    private static final Comparator<Degree> COMPARATOR_BY_DEGREE_TYPE = new Comparator<Degree>(){

        @Override
        public int compare(Degree o1, Degree o2) {
            return o1.getDegreeType().compareTo(o2.getDegreeType());
        }
    };
    public static final Comparator<Degree> COMPARATOR_BY_DEGREE_TYPE_DEGREE_NAME_AND_ID = new Comparator<Degree>(){

        @Override
        public int compare(Degree o1, Degree o2) {
            int typeResult = COMPARATOR_BY_DEGREE_TYPE.compare(o1, o2);
            return typeResult == 0 ? COMPARATOR_BY_NAME_AND_ID.compare(o1, o2) : typeResult;
        }
    };
    public static final Comparator<Degree> COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID = new ComparatorByDegreeTypeAndNameAndId();
    public static final Comparator<Degree> COMPARATOR_BY_FIRST_ENROLMENTS_PERIOD_AND_ID = new Comparator<Degree>(){

        @Override
        public int compare(Degree degree1, Degree degree2) {
            ExecutionSemester semester2;
            ExecutionSemester semester1 = degree1.getFirstDegreeCurricularPlan().getFirstExecutionPeriodEnrolments();
            int result = semester1.compareTo(semester2 = degree2.getFirstDegreeCurricularPlan().getFirstExecutionPeriodEnrolments());
            return result == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)degree1, (DomainObject)degree2) : result;
        }
    };
    private static final Map<String, SoftReference<Degree>> degrees = new Hashtable<String, SoftReference<Degree>>();

    @Override
    public int compareTo(Degree o) {
        return COMPARATOR_BY_NAME_AND_ID.compare(this, o);
    }

    protected Degree() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public Degree(String name, String nameEn, String code, DegreeType degreeType, GradeScale gradeScale) {
        this(name, nameEn, code, degreeType, gradeScale, ExecutionYear.readCurrentExecutionYear());
    }

    public Degree(String name, String nameEn, String code, DegreeType degreeType, GradeScale gradeScale, ExecutionYear executionYear) {
        this();
        this.commonFieldsChange(name, nameEn, code, gradeScale, executionYear);
        if (degreeType == null) {
            throw new DomainException("degree.degree.type.not.null", new String[0]);
        }
        this.setDegreeType(degreeType);
    }

    public Degree(String name, String nameEn, String acronym, DegreeType degreeType, Double ectsCredits, GradeScale gradeScale, String prevailingScientificArea, AdministrativeOffice administrativeOffice) {
        this();
        this.commonFieldsChange(name, nameEn, acronym, gradeScale, ExecutionYear.readCurrentExecutionYear());
        this.newStructureFieldsChange(degreeType, ectsCredits, prevailingScientificArea);
        this.setAdministrativeOffice(administrativeOffice);
    }

    private void commonFieldsChange(String name, String nameEn, String code, GradeScale gradeScale, ExecutionYear executionYear) {
        if (name == null) {
            throw new DomainException("degree.name.not.null", new String[0]);
        }
        if (nameEn == null) {
            throw new DomainException("degree.name.en.not.null", new String[0]);
        }
        if (code == null) {
            throw new DomainException("degree.code.not.null", new String[0]);
        }
        DegreeInfo degreeInfo = this.getDegreeInfoFor(executionYear);
        if (degreeInfo == null) {
            degreeInfo = this.tryCreateUsingMostRecentInfo(executionYear);
        }
        degreeInfo.setName(new MultiLanguageString().with(MultiLanguageString.pt, name.trim()).with(MultiLanguageString.en, nameEn.trim()));
        this.setNome(name);
        this.setNameEn(nameEn);
        this.setSigla(code.trim());
        this.setGradeScale(gradeScale);
    }

    private void newStructureFieldsChange(DegreeType degreeType, Double ectsCredits, String prevailingScientificArea) {
        if (degreeType == null) {
            throw new DomainException("degree.degree.type.not.null", new String[0]);
        }
        if (ectsCredits == null) {
            throw new DomainException("degree.ectsCredits.not.null", new String[0]);
        }
        this.setDegreeType(degreeType);
        this.setEctsCredits(ectsCredits);
        this.setPrevailingScientificArea(prevailingScientificArea == null ? null : prevailingScientificArea.trim());
    }

    public void edit(String name, String nameEn, String code, DegreeType degreeType, GradeScale gradeScale, ExecutionYear executionYear) {
        this.commonFieldsChange(name, nameEn, code, gradeScale, executionYear);
        if (degreeType == null) {
            throw new DomainException("degree.degree.type.not.null", new String[0]);
        }
        this.setDegreeType(degreeType);
    }

    public void edit(String name, String nameEn, String acronym, DegreeType degreeType, Double ectsCredits, GradeScale gradeScale, String prevailingScientificArea, ExecutionYear executionYear) {
        this.checkIfCanEdit(degreeType);
        this.commonFieldsChange(name, nameEn, acronym, gradeScale, executionYear);
        this.newStructureFieldsChange(degreeType, ectsCredits, prevailingScientificArea);
    }

    private void checkIfCanEdit(DegreeType degreeType) {
        if (!this.getDegreeType().equals(degreeType) && !this.getDegreeCurricularPlansSet().isEmpty()) {
            throw new DomainException("degree.cant.edit.bolonhaDegreeType", new String[0]);
        }
    }

    public Boolean getCanBeDeleted() {
        return this.getDeletionBlockers().isEmpty();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getDegreeCurricularPlansSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)"error.degree.has.degree.curricular.plans", (String[])new String[0]));
        }
        if (!this.getStudentGroupSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)"error.academicProgram.cannotDeleteBacauseUsedInAccessControl", (String[])new String[0]));
        }
        if (!this.getTeacherGroupSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)"error.academicProgram.cannotDeleteBacauseUsedInAccessControl", (String[])new String[0]));
        }
        if (this.getScientificCommissionGroup() != null) {
            blockers.add(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)"error.academicProgram.cannotDeleteBacauseUsedInAccessControl", (String[])new String[0]));
        }
        if (!this.getCoordinatorGroupSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)"error.academicProgram.cannotDeleteBacauseUsedInAccessControl", (String[])new String[0]));
        }
        if (!this.getStudentsConcludedInExecutionYearGroupSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)"error.academicProgram.cannotDeleteBacauseUsedInAccessControl", (String[])new String[0]));
        }
        if (this.getAlumniGroup() != null) {
            blockers.add(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)"error.academicProgram.cannotDeleteBacauseUsedInAccessControl", (String[])new String[0]));
        }
    }

    protected void disconnect() {
        Iterator degreeInfosIterator = this.getDegreeInfosSet().iterator();
        while (degreeInfosIterator.hasNext()) {
            DegreeInfo degreeInfo = (DegreeInfo)((Object)degreeInfosIterator.next());
            degreeInfosIterator.remove();
            degreeInfo.delete();
        }
        while (!this.getParticipatingAnyCurricularCourseCurricularRulesSet().isEmpty()) {
            ((AnyCurricularCourse)((Object)this.getParticipatingAnyCurricularCourseCurricularRulesSet().iterator().next())).delete();
        }
        if (this.getSender() != null) {
            this.setSender(null);
        }
        this.setUnit(null);
        this.setDegreeType(null);
        this.setPhdProgram(null);
        this.setRootDomainObject(null);
        super.disconnect();
    }

    public GradeScale getGradeScaleChain() {
        return super.getGradeScale();
    }

    public DegreeCurricularPlan createDegreeCurricularPlan(String name, GradeScale gradeScale, Person creator, AcademicPeriod duration) {
        if (name == null) {
            throw new DomainException("DEGREE.degree.curricular.plan.name.cannot.be.null", new String[0]);
        }
        for (DegreeCurricularPlan dcp : this.getDegreeCurricularPlansSet()) {
            if (!dcp.getName().equalsIgnoreCase(name)) continue;
            throw new DomainException("DEGREE.degreeCurricularPlan.existing.name.and.degree", new String[0]);
        }
        if (creator == null) {
            throw new DomainException("DEGREE.degree.curricular.plan.creator.cannot.be.null", new String[0]);
        }
        if (!RoleType.BOLONHA_MANAGER.isMember(creator.getUser())) {
            RoleType.grant(RoleType.BOLONHA_MANAGER, creator.getUser());
        }
        CurricularPeriod curricularPeriod = new CurricularPeriod(duration);
        return new DegreeCurricularPlan(this, name, gradeScale, creator, curricularPeriod);
    }

    public Collection<CycleType> getCycleTypes() {
        return this.getDegreeType().getCycleTypes();
    }

    @Deprecated
    public DegreeType getBolonhaDegreeType() {
        return this.getDegreeType();
    }

    public boolean isBolonhaDegree() {
        return this.getDegreeType().isBolonhaType();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isDegreeOrBolonhaDegreeOrBolonhaIntegratedMasterDegree() {
        return this.getDegreeType().isDegreeOrBolonhaDegreeOrBolonhaIntegratedMasterDegree();
    }

    public static Degree find(String code) {
        if (StringUtils.isBlank((String)code)) {
            return null;
        }
        for (Degree degree : Degree.readNotEmptyDegrees()) {
            if (!StringUtils.equalsIgnoreCase((String)degree.getCode(), (String)code)) continue;
            return degree;
        }
        return null;
    }

    public List<DegreeCurricularPlan> findDegreeCurricularPlansByState(DegreeCurricularPlanState state) {
        ArrayList<DegreeCurricularPlan> result = new ArrayList<DegreeCurricularPlan>();
        if (!this.isBolonhaDegree()) {
            for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
                if (!degreeCurricularPlan.getState().equals((Object)state)) continue;
                result.add(degreeCurricularPlan);
            }
        }
        return result;
    }

    public List<DegreeCurricularPlan> getActiveDegreeCurricularPlans() {
        ArrayList<DegreeCurricularPlan> result = new ArrayList<DegreeCurricularPlan>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
            if (degreeCurricularPlan.getState() != DegreeCurricularPlanState.ACTIVE) continue;
            result.add(degreeCurricularPlan);
        }
        return result;
    }

    public List<DegreeCurricularPlan> getPastDegreeCurricularPlans() {
        ArrayList<DegreeCurricularPlan> result = new ArrayList<DegreeCurricularPlan>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
            if (degreeCurricularPlan.getState() != DegreeCurricularPlanState.PAST) continue;
            result.add(degreeCurricularPlan);
        }
        return result;
    }

    public List<DegreeCurricularPlan> getDegreeCurricularPlansForYear(ExecutionYear year) {
        ArrayList<DegreeCurricularPlan> result = new ArrayList<DegreeCurricularPlan>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
            if (!degreeCurricularPlan.hasExecutionDegreeFor(year)) continue;
            result.add(degreeCurricularPlan);
        }
        return result;
    }

    public boolean getCanBeAccessedByUser() {
        return AcademicPredicates.MANAGE_DEGREE_CURRICULAR_PLANS.evaluate(this);
    }

    private List<ExecutionDegree> getInternalExecutionDegrees() {
        ArrayList<ExecutionDegree> result = new ArrayList<ExecutionDegree>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
            result.addAll(degreeCurricularPlan.getExecutionDegreesSet());
        }
        return result;
    }

    public List<ExecutionDegree> getExecutionDegrees() {
        return this.getExecutionDegrees(null);
    }

    public List<ExecutionDegree> getExecutionDegrees(final AcademicInterval academicInterval) {
        if (academicInterval == null) {
            return this.getInternalExecutionDegrees();
        }
        return FluentIterable.from(this.getInternalExecutionDegrees()).filter((com.google.common.base.Predicate)new com.google.common.base.Predicate<ExecutionDegree>(){

            public boolean apply(ExecutionDegree input) {
                return academicInterval.equals(input.getAcademicInterval());
            }
        }).toList();
    }

    public List<ExecutionDegree> getExecutionDegreesForExecutionYear(ExecutionYear executionYear) {
        ArrayList<ExecutionDegree> result = new ArrayList<ExecutionDegree>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
            ExecutionDegree executionDegree = degreeCurricularPlan.getExecutionDegreeByYear(executionYear);
            if (executionDegree == null) continue;
            result.add(executionDegree);
        }
        return result;
    }

    public List<ExecutionYear> getDegreeCurricularPlansExecutionYears() {
        TreeSet<ExecutionYear> result = new TreeSet<ExecutionYear>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
            for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
                result.add(executionDegree.getExecutionYear());
            }
        }
        return new ArrayList<ExecutionYear>(result);
    }

    public List<CurricularCourse> getExecutedCurricularCoursesByExecutionYear(ExecutionYear executionYear) {
        if (this.isBolonhaDegree()) {
            return Collections.emptyList();
        }
        ArrayList<CurricularCourse> result = new ArrayList<CurricularCourse>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
            if (!degreeCurricularPlan.getState().equals((Object)DegreeCurricularPlanState.ACTIVE)) continue;
            block1: for (CurricularCourse course : degreeCurricularPlan.getCurricularCoursesSet()) {
                for (ExecutionCourse executionCourse : course.getAssociatedExecutionCoursesSet()) {
                    if (!executionCourse.getExecutionPeriod().getExecutionYear().equals(executionYear)) continue;
                    result.add(course);
                    continue block1;
                }
            }
        }
        return result;
    }

    public List<CurricularCourse> getExecutedCurricularCoursesByExecutionYearAndYear(ExecutionYear executionYear, Integer curricularYear) {
        if (this.isBolonhaDegree()) {
            return Collections.emptyList();
        }
        ArrayList<CurricularCourse> result = new ArrayList<CurricularCourse>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
            if (!degreeCurricularPlan.getState().equals((Object)DegreeCurricularPlanState.ACTIVE)) continue;
            block1: for (CurricularCourse course : degreeCurricularPlan.getCurricularCoursesSet()) {
                for (ExecutionCourse executionCourse : course.getAssociatedExecutionCoursesSet()) {
                    if (!executionCourse.getExecutionPeriod().getExecutionYear().equals(executionYear)) continue;
                    for (CurricularCourseScope curricularCourseScope : course.getScopesSet()) {
                        if (!curricularCourseScope.getCurricularSemester().getCurricularYear().getYear().equals(curricularYear)) continue;
                        result.add(course);
                        continue block1;
                    }
                }
            }
        }
        return result;
    }

    public List<ExecutionCourse> getExecutionCourses(String curricularCourseAcronym, ExecutionSemester executionSemester) {
        ArrayList<ExecutionCourse> result = new ArrayList<ExecutionCourse>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
            for (CurricularCourse course : degreeCurricularPlan.getCurricularCoursesSet()) {
                if (course.getAcronym() == null || !course.getAcronym().equalsIgnoreCase(curricularCourseAcronym)) continue;
                for (ExecutionCourse executionCourse : course.getAssociatedExecutionCoursesSet()) {
                    if (executionSemester != executionCourse.getExecutionPeriod()) continue;
                    result.add(executionCourse);
                }
            }
        }
        return result;
    }

    public List<ExecutionCourse> getExecutionCourses(AcademicInterval academicInterval) {
        ArrayList<ExecutionCourse> result = new ArrayList<ExecutionCourse>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
            for (CurricularCourse course : degreeCurricularPlan.getCurricularCoursesSet()) {
                for (ExecutionCourse executionCourse : course.getAssociatedExecutionCoursesSet()) {
                    if (!academicInterval.isEqualOrEquivalent(executionCourse.getAcademicInterval())) continue;
                    for (DegreeModuleScope scope : course.getDegreeModuleScopes()) {
                        if (!scope.isActiveForAcademicInterval(academicInterval) || scope.getCurricularSemester().intValue() != academicInterval.getAcademicSemesterOfAcademicYear()) continue;
                        result.add(executionCourse);
                    }
                }
            }
        }
        return result;
    }

    public List<ExecutionCourse> getExecutionCourses(Integer curricularYear, ExecutionSemester executionSemester) {
        ArrayList<ExecutionCourse> result = new ArrayList<ExecutionCourse>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
            for (CurricularCourse course : degreeCurricularPlan.getCurricularCoursesSet()) {
                for (ExecutionCourse executionCourse : course.getAssociatedExecutionCoursesSet()) {
                    if (executionSemester != executionCourse.getExecutionPeriod()) continue;
                    for (DegreeModuleScope scope : course.getDegreeModuleScopes()) {
                        if (!scope.isActiveForExecutionPeriod(executionSemester) || scope.getCurricularYear() != curricularYear || scope.getCurricularSemester() != executionSemester.getSemester()) continue;
                        result.add(executionCourse);
                    }
                }
            }
        }
        return result;
    }

    @Deprecated
    public MultiLanguageString getNameFor(ExecutionYear executionYear) {
        DegreeInfo degreeInfo = executionYear == null ? this.getMostRecentDegreeInfo() : this.getMostRecentDegreeInfo(executionYear);
        return degreeInfo == null ? new MultiLanguageString().with(MultiLanguageString.pt, super.getNome()).with(MultiLanguageString.en, super.getNameEn()) : degreeInfo.getName();
    }

    @Deprecated
    public MultiLanguageString getNameFor(ExecutionSemester executionSemester) {
        return this.getNameFor(executionSemester != null ? executionSemester.getExecutionYear() : null);
    }

    public MultiLanguageString getNameFor(AcademicInterval academicInterval) {
        DegreeInfo degreeInfo = academicInterval == null ? this.getMostRecentDegreeInfo() : this.getMostRecentDegreeInfo(academicInterval);
        return degreeInfo == null ? new MultiLanguageString().with(MultiLanguageString.pt, super.getNome()).with(MultiLanguageString.en, super.getNameEn()) : degreeInfo.getName();
    }

    @Deprecated
    public String getNome() {
        return this.getName();
    }

    @Deprecated
    public String getName() {
        DegreeInfo degreeInfo = this.getMostRecentDegreeInfo();
        return degreeInfo == null ? "" : degreeInfo.getName().getContent(MultiLanguageString.pt);
    }

    @Deprecated
    public String getNameEn() {
        DegreeInfo degreeInfo = this.getMostRecentDegreeInfo();
        return degreeInfo == null ? "" : degreeInfo.getName().getContent(MultiLanguageString.en);
    }

    public final MultiLanguageString getNameI18N() {
        return this.getNameFor(ExecutionYear.readCurrentExecutionYear());
    }

    public final MultiLanguageString getNameI18N(ExecutionYear executionYear) {
        return this.getNameFor(executionYear);
    }

    public LocalizedString getPresentationNameI18N() {
        return this.getPresentationNameI18N(ExecutionYear.readCurrentExecutionYear());
    }

    public LocalizedString getPresentationNameI18N(ExecutionYear executionYear) {
        LocalizedString result = new LocalizedString();
        for (Locale locale : CoreConfiguration.supportedLocales()) {
            result = result.with(locale, this.getPresentationName(executionYear, locale));
        }
        return result;
    }

    public final String getPresentationName() {
        return this.getPresentationName(ExecutionYear.readCurrentExecutionYear(), I18N.getLocale());
    }

    public String getPresentationName(ExecutionYear executionYear) {
        return this.getPresentationName(executionYear, I18N.getLocale());
    }

    protected String getPresentationName(ExecutionYear executionYear, Locale locale) {
        Locale language;
        MultiLanguageString mls;
        StringBuilder res = new StringBuilder();
        String degreeType = this.getDegreeType().getName().getContent(locale);
        if (!StringUtils.isEmpty((String)degreeType)) {
            res.append(degreeType).append(" ");
            res.append(BundleUtil.getString((String)"resources.ApplicationResources", (Locale)locale, (String)"label.in", (String[])new String[0]));
            res.append(" ");
        }
        res.append((mls = this.getNameFor(executionYear)).hasContent(language = locale) ? mls.getContent(language) : mls.getPreferedContent());
        return res.toString();
    }

    public final String getFilteredName() {
        return this.getFilteredName(ExecutionYear.readCurrentExecutionYear(), I18N.getLocale());
    }

    public final String getFilteredName(ExecutionYear executionYear) {
        return this.getFilteredName(executionYear, I18N.getLocale());
    }

    public String getFilteredName(ExecutionYear executionYear, Locale locale) {
        StringBuilder res = new StringBuilder(this.getNameFor(executionYear).getContent(locale));
        for (Space campus : Space.getAllCampus()) {
            String toRemove = " - " + campus.getName();
            if (!res.toString().contains(toRemove)) continue;
            res.replace(res.indexOf(toRemove), res.indexOf(toRemove) + toRemove.length(), "");
        }
        return res.toString();
    }

    public DegreeCurricularPlan getMostRecentDegreeCurricularPlan() {
        ExecutionDegree mostRecentExecutionDegree = null;
        boolean mustGetByInitialDate = false;
        for (DegreeCurricularPlan degreeCurricularPlan : this.getActiveDegreeCurricularPlans()) {
            ExecutionDegree executionDegree = degreeCurricularPlan.getMostRecentExecutionDegree();
            if (mostRecentExecutionDegree == null) {
                mostRecentExecutionDegree = executionDegree;
                continue;
            }
            if (mostRecentExecutionDegree.getExecutionYear().equals(executionDegree.getExecutionYear())) {
                mustGetByInitialDate = true;
                continue;
            }
            if (!mostRecentExecutionDegree.isBefore(executionDegree)) continue;
            mustGetByInitialDate = false;
            mostRecentExecutionDegree = executionDegree;
        }
        if (mustGetByInitialDate) {
            return this.getMostRecentDegreeCurricularPlanByInitialDate();
        }
        return mostRecentExecutionDegree != null ? mostRecentExecutionDegree.getDegreeCurricularPlan() : null;
    }

    private DegreeCurricularPlan getMostRecentDegreeCurricularPlanByInitialDate() {
        DegreeCurricularPlan mostRecentDegreeCurricularPlan = null;
        for (DegreeCurricularPlan degreeCurricularPlan : this.getActiveDegreeCurricularPlans()) {
            if (mostRecentDegreeCurricularPlan != null && !degreeCurricularPlan.getInitialDateYearMonthDay().isAfter((ReadablePartial)mostRecentDegreeCurricularPlan.getInitialDateYearMonthDay())) continue;
            mostRecentDegreeCurricularPlan = degreeCurricularPlan;
        }
        return mostRecentDegreeCurricularPlan;
    }

    public Collection<Registration> getActiveRegistrations() {
        HashSet<Registration> result = new HashSet<Registration>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getActiveDegreeCurricularPlans()) {
            result.addAll(degreeCurricularPlan.getActiveRegistrations());
        }
        return result;
    }

    public DegreeCurricularPlan getFirstDegreeCurricularPlan() {
        if (this.getDegreeCurricularPlansSet().isEmpty()) {
            return null;
        }
        DegreeCurricularPlan firstDCP = (DegreeCurricularPlan)((Object)this.getDegreeCurricularPlansSet().iterator().next());
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
            if (degreeCurricularPlan.getInitialDateYearMonthDay() == null || firstDCP.getInitialDateYearMonthDay() != null && !degreeCurricularPlan.getInitialDateYearMonthDay().isBefore((ReadablePartial)firstDCP.getInitialDateYearMonthDay())) continue;
            firstDCP = degreeCurricularPlan;
        }
        return firstDCP.getInitialDateYearMonthDay() == null ? null : firstDCP;
    }

    public DegreeCurricularPlan getLastActiveDegreeCurricularPlan() {
        DegreeCurricularPlan result = null;
        ExecutionDegree mostRecentExecutionDegree = null;
        for (DegreeCurricularPlan degreeCurricularPlan : this.getActiveDegreeCurricularPlans()) {
            ExecutionDegree executionDegree = degreeCurricularPlan.getMostRecentExecutionDegree();
            if (executionDegree == null) {
                result = degreeCurricularPlan;
                continue;
            }
            if (mostRecentExecutionDegree != null && !mostRecentExecutionDegree.isBefore(executionDegree)) continue;
            mostRecentExecutionDegree = executionDegree;
        }
        return mostRecentExecutionDegree == null ? result : mostRecentExecutionDegree.getDegreeCurricularPlan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCache() {
        Map<String, SoftReference<Degree>> map = degrees;
        synchronized (map) {
            degrees.clear();
            for (Degree degree : Degree.readNotEmptyDegrees()) {
                degrees.put(degree.getSigla().toLowerCase(), new SoftReference<Degree>(degree));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCache(Degree degree, String newLowerCaseSigla) {
        String currentLowerCaseSigla = degree.getSigla() != null ? degree.getSigla().toLowerCase() : "";
        Map<String, SoftReference<Degree>> map = degrees;
        synchronized (map) {
            degrees.remove(currentLowerCaseSigla);
            degrees.put(newLowerCaseSigla, new SoftReference<Degree>(degree));
        }
    }

    public void setSigla(String sigla) {
        Degree.updateCache(this, sigla.toLowerCase());
        super.setSigla(sigla);
    }

    public static Degree readBySigla(String sigla) {
        String lowerCaseString;
        SoftReference<Degree> degreeReference;
        if (degrees.isEmpty()) {
            Degree.loadCache();
        }
        if ((degreeReference = degrees.get(lowerCaseString = sigla.toLowerCase())) != null) {
            Degree otherDegree;
            Degree degree = degreeReference.get();
            if (degree != null && degree.getRootDomainObject() == Bennu.getInstance() && degree.getSigla().equalsIgnoreCase(lowerCaseString)) {
                return degree;
            }
            Degree.loadCache();
            SoftReference<Degree> otherDegreeReference = degrees.get(lowerCaseString);
            if (otherDegreeReference != null && (otherDegree = otherDegreeReference.get()) != null && otherDegree.getRootDomainObject() == Bennu.getInstance() && otherDegree.getSigla().equalsIgnoreCase(lowerCaseString)) {
                return otherDegree;
            }
        }
        return null;
    }

    public static List<Degree> readNotEmptyDegrees() {
        ArrayList<Degree> result = new ArrayList<Degree>(Bennu.getInstance().getDegreesSet());
        result.remove(Degree.readEmptyDegree());
        return result;
    }

    public static Degree readEmptyDegree() {
        return EmptyDegree.getInstance();
    }

    public static List<Degree> readOldDegrees() {
        ArrayList<Degree> result = new ArrayList<Degree>();
        for (Degree degree : Degree.readNotEmptyDegrees()) {
            if (degree.isBolonhaDegree()) continue;
            result.add(degree);
        }
        return result;
    }

    public static List<Degree> readBolonhaDegrees() {
        ArrayList<Degree> result = new ArrayList<Degree>();
        for (Degree degree : Degree.readNotEmptyDegrees()) {
            if (!degree.isBolonhaDegree()) continue;
            result.add(degree);
        }
        return result;
    }

    public static List<Degree> readAllMatching(Predicate<DegreeType> predicate) {
        return DegreeType.all().filter(predicate).flatMap(type -> type.getDegreeSet().stream()).collect(Collectors.toList());
    }

    public static List<Degree> readAllByDegreeCode(String degreeCode) {
        ArrayList<Degree> result = new ArrayList<Degree>();
        for (Degree degree : Degree.readNotEmptyDegrees()) {
            if (!degree.hasMinistryCode() || !degree.getMinistryCode().equals(degreeCode)) continue;
            result.add(degree);
        }
        return result;
    }

    private boolean hasMinistryCode() {
        return this.getMinistryCode() != null;
    }

    public MultiLanguageString getQualificationLevel(ExecutionYear executionYear) {
        return this.getMostRecentDegreeInfo(executionYear).getQualificationLevel();
    }

    public MultiLanguageString getProfessionalExits(ExecutionYear executionYear) {
        return this.getMostRecentDegreeInfo(executionYear).getProfessionalExits();
    }

    public DegreeInfo getMostRecentDegreeInfo() {
        return this.getMostRecentDegreeInfo(ExecutionYear.readCurrentExecutionYear());
    }

    public DegreeInfo getDegreeInfoFor(ExecutionYear executionYear) {
        return executionYear.getDegreeInfo(this);
    }

    @Deprecated
    public DegreeInfo getMostRecentDegreeInfo(ExecutionYear executionYear) {
        DegreeInfo result = null;
        for (DegreeInfo degreeInfo : this.getDegreeInfosSet()) {
            ExecutionYear executionYear2 = degreeInfo.getExecutionYear();
            if (executionYear == executionYear2) {
                return degreeInfo;
            }
            if (!executionYear2.isBefore(executionYear) || result != null && !executionYear2.isAfter(result.getExecutionYear())) continue;
            result = degreeInfo;
        }
        if (result == null && executionYear.hasNextExecutionYear()) {
            result = this.getMostRecentDegreeInfo(executionYear.getNextExecutionYear());
        }
        return result;
    }

    public DegreeInfo getMostRecentDegreeInfo(AcademicInterval academicInterval) {
        DegreeInfo result = null;
        for (DegreeInfo degreeInfo : this.getDegreeInfosSet()) {
            AcademicInterval academicInterval2 = degreeInfo.getAcademicInterval();
            if (academicInterval.equals(academicInterval2)) {
                return degreeInfo;
            }
            if (!academicInterval2.isBefore((ReadableInterval)academicInterval) || result != null && !academicInterval2.isAfter((ReadableInterval)result.getAcademicInterval())) continue;
            result = degreeInfo;
        }
        if (result == null && academicInterval.getNextAcademicInterval() != null) {
            result = this.getMostRecentDegreeInfo(academicInterval.getNextAcademicInterval());
        }
        return result;
    }

    private DegreeInfo createCurrentDegreeInfo(ExecutionYear executionYear) {
        DegreeInfo shouldBeThisOne = executionYear.getDegreeInfo(this);
        if (shouldBeThisOne != null) {
            return shouldBeThisOne;
        }
        return this.tryCreateUsingMostRecentInfo(executionYear);
    }

    private DegreeInfo tryCreateUsingMostRecentInfo(ExecutionYear executionYear) {
        DegreeInfo mostRecentDegreeInfo = this.getMostRecentDegreeInfo(executionYear);
        return mostRecentDegreeInfo != null ? new DegreeInfo(mostRecentDegreeInfo, executionYear) : new DegreeInfo(this, executionYear);
    }

    public DegreeInfo createCurrentDegreeInfo() {
        return this.createCurrentDegreeInfo(ExecutionYear.readCurrentExecutionYear());
    }

    @Deprecated
    public List<Integer> buildFullCurricularYearList() {
        DegreeCurricularPlan degreeCurricularPlan = this.getMostRecentDegreeCurricularPlan();
        if (degreeCurricularPlan == null) {
            throw new DomainException("error.degree.unable.to.find.degree.curricular.plan.to.calculate.duration", new String[0]);
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 1; i <= degreeCurricularPlan.getDurationInYears(); ++i) {
            result.add(i);
        }
        return result;
    }

    public ScientificCommission getMostRecentScientificCommission(Person person) {
        for (ExecutionYear ey = ExecutionYear.readCurrentExecutionYear(); ey != null; ey = ey.getPreviousExecutionYear()) {
            for (ScientificCommission member : this.getScientificCommissionMembers(ey)) {
                if (member.getPerson() != person) continue;
                return member;
            }
        }
        return null;
    }

    public boolean isMemberOfAnyScientificCommission(Person person) {
        return person != null && this.getMostRecentScientificCommission(person) != null;
    }

    public boolean isMemberOfCurrentScientificCommission(Person person) {
        for (ScientificCommission member : this.getCurrentScientificCommissionMembers()) {
            if (member.getPerson() != person) continue;
            return true;
        }
        return false;
    }

    public boolean isMemberOfCurrentScientificCommission(Person person, ExecutionYear executionYear) {
        if (person != null) {
            for (ScientificCommission member : this.getScientificCommissionMembers(executionYear)) {
                if (member.getPerson() != person) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<ScientificCommission> getCurrentScientificCommissionMembers() {
        for (ExecutionYear ey = ExecutionYear.readCurrentExecutionYear(); ey != null; ey = ey.getPreviousExecutionYear()) {
            Collection<ScientificCommission> members = this.getScientificCommissionMembers(ey);
            if (members.isEmpty()) continue;
            return members;
        }
        return Collections.emptyList();
    }

    public Collection<ScientificCommission> getScientificCommissionMembers(ExecutionYear executionYear) {
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansForYear(executionYear)) {
            ExecutionDegree executionDegree = degreeCurricularPlan.getExecutionDegreeByYear(executionYear);
            if (executionDegree == null) continue;
            return new ArrayList<ScientificCommission>(executionDegree.getScientificCommissionMembersSet());
        }
        return Collections.emptyList();
    }

    public boolean isCoordinator(Person person, ExecutionYear executionYear) {
        for (Coordinator coordinator : this.getCoordinators(executionYear, false)) {
            if (coordinator.getPerson() != person) continue;
            return true;
        }
        return false;
    }

    public final boolean isCurrentCoordinator(Person person) {
        for (Coordinator coordinator : this.getCurrentCoordinators(false)) {
            if (coordinator.getPerson() != person) continue;
            return true;
        }
        return false;
    }

    public final boolean isCoordinatorInSomeExecutionYear(Person person) {
        if (person != null) {
            for (Coordinator coordinator : person.getCoordinatorsSet()) {
                if (coordinator.getExecutionDegree().getDegree() != this) continue;
                return true;
            }
        }
        return false;
    }

    private final Collection<Coordinator> getCoordinators(ExecutionYear executionYear, boolean responsible) {
        HashSet<Coordinator> result = new HashSet<Coordinator>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
            ExecutionDegree executionDegree = degreeCurricularPlan.getExecutionDegreeByYear(executionYear);
            if (executionDegree == null) continue;
            result.addAll(responsible ? executionDegree.getResponsibleCoordinators() : executionDegree.getCoordinatorsListSet());
        }
        return result;
    }

    private final Collection<Coordinator> getCurrentCoordinators(boolean responsible) {
        TreeSet<ExecutionYear> years = new TreeSet<ExecutionYear>((Comparator<ExecutionYear>)new ReverseComparator(ExecutionYear.COMPARATOR_BY_YEAR));
        years.addAll(this.getDegreeCurricularPlansExecutionYears());
        ExecutionYear current = ExecutionYear.readCurrentExecutionYear();
        for (ExecutionYear year : years) {
            Collection<Coordinator> coordinators;
            if (year.isAfter(current) || (coordinators = this.getCoordinators(year, responsible)).isEmpty()) continue;
            return coordinators;
        }
        return Collections.emptyList();
    }

    public Collection<Coordinator> getResponsibleCoordinators(ExecutionYear executionYear) {
        return this.getCoordinators(executionYear, true);
    }

    public Collection<Coordinator> getCurrentCoordinators() {
        return this.getCurrentCoordinators(false);
    }

    public Collection<Coordinator> getCurrentResponsibleCoordinators() {
        return this.getCurrentCoordinators(true);
    }

    public Collection<Teacher> getResponsibleCoordinatorsTeachers(ExecutionYear executionYear) {
        TreeSet<Teacher> result = new TreeSet<Teacher>(Teacher.TEACHER_COMPARATOR_BY_CATEGORY_AND_NUMBER);
        this.collectCoordinatorsTeachers(result, this.getResponsibleCoordinators(executionYear));
        return result;
    }

    public Collection<Teacher> getCurrentResponsibleCoordinatorsTeachers() {
        TreeSet<Teacher> result = new TreeSet<Teacher>(Teacher.TEACHER_COMPARATOR_BY_CATEGORY_AND_NUMBER);
        this.collectCoordinatorsTeachers(result, this.getCurrentResponsibleCoordinators());
        return result;
    }

    private final void collectCoordinatorsTeachers(Collection<Teacher> result, Collection<Coordinator> coordinators) {
        for (Coordinator coordinator : coordinators) {
            Teacher teacher = coordinator.getTeacher();
            if (teacher == null) continue;
            result.add(teacher);
        }
    }

    public Collection<Space> getCampus(ExecutionYear executionYear) {
        HashSet<Space> result = new HashSet<Space>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
            ExecutionDegree executionDegree = degreeCurricularPlan.getExecutionDegreeByYear(executionYear);
            if (executionDegree == null || executionDegree.getCampus() == null) continue;
            result.add(executionDegree.getCampus());
        }
        return new ArrayList<Space>(result);
    }

    public Collection<Space> getCurrentCampus() {
        ExecutionYear executionYear = ExecutionYear.readCurrentExecutionYear();
        Collection<Space> result = this.getCampus(executionYear);
        if (!result.isEmpty()) {
            return result;
        }
        while (executionYear != null) {
            result = this.getCampus(executionYear);
            if (!result.isEmpty()) {
                return result;
            }
            executionYear = executionYear.getNextExecutionYear();
        }
        return new ArrayList<Space>();
    }

    public String constructSchoolClassPrefix(Integer curricularYear) {
        return this.isBolonhaDegree() ? this.getSigla() + "0" + curricularYear.toString() : "";
    }

    public List<StudentCurricularPlan> getLastStudentCurricularPlans() {
        ArrayList<StudentCurricularPlan> result = new ArrayList<StudentCurricularPlan>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansSet()) {
            for (StudentCurricularPlan studentCurricularPlan : degreeCurricularPlan.getStudentCurricularPlansSet()) {
                if (studentCurricularPlan.getRegistration() == null || result.contains((Object)studentCurricularPlan)) continue;
                result.add(studentCurricularPlan.getRegistration().getLastStudentDegreeCurricularPlansByDegree(this));
            }
        }
        return new ArrayList<StudentCurricularPlan>(result);
    }

    public List<StudentCurricularPlan> getStudentCurricularPlans(ExecutionYear executionYear) {
        ArrayList<StudentCurricularPlan> result = new ArrayList<StudentCurricularPlan>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegreeCurricularPlansForYear(executionYear)) {
            degreeCurricularPlan.getStudentsCurricularPlans(executionYear, result);
        }
        return result;
    }

    public boolean isFirstCycle() {
        return this.getDegreeType().isFirstCycle();
    }

    public boolean isSecondCycle() {
        return this.getDegreeType().isSecondCycle();
    }

    public boolean isThirdCycle() {
        return this.getDegreeType().isThirdCycle();
    }

    public boolean isAnyPublishedThesisAvailable() {
        for (DegreeCurricularPlan dcp : this.getDegreeCurricularPlansSet()) {
            for (CurricularCourse curricularCourse : dcp.getDissertationCurricularCourses(null)) {
                ArrayList<IEnrolment> enrolments = new ArrayList<IEnrolment>();
                for (CurriculumModule module : curricularCourse.getCurriculumModulesSet()) {
                    if (module.isEnrolment()) {
                        enrolments.add((IEnrolment)((Object)module));
                        continue;
                    }
                    if (!module.isDismissal()) continue;
                    Dismissal dismissal = (Dismissal)((Object)module);
                    enrolments.addAll(dismissal.getSourceIEnrolments());
                }
                for (IEnrolment enrolment : enrolments) {
                    Thesis thesis = enrolment.getThesis();
                    if (thesis == null || !thesis.getState().equals((Object)ThesisState.EVALUATED)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isAnyThesisAvailable() {
        return !this.getThesisSet().isEmpty();
    }

    public List<Student> getAllStudents() {
        ArrayList<Student> result = new ArrayList<Student>();
        for (Registration registration : this.getActiveRegistrations()) {
            result.add(registration.getStudent());
        }
        return result;
    }

    public List<Student> getStudentsFromGivenCurricularYear(int curricularYear, ExecutionYear executionYear) {
        ArrayList<Student> result = new ArrayList<Student>();
        for (Registration registration : this.getActiveRegistrations()) {
            if (registration.getCurricularYear(executionYear) != curricularYear) continue;
            result.add(registration.getStudent());
        }
        return result;
    }

    public Set<CurricularCourse> getAllCurricularCourses(ExecutionYear executionYear) {
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        for (DegreeCurricularPlan dcp : this.getActiveDegreeCurricularPlans()) {
            result.addAll(dcp.getCurricularCoursesWithExecutionIn(executionYear));
        }
        return result;
    }

    public Set<CurricularCourse> getCurricularCoursesFromGivenCurricularYear(int curricularYear, ExecutionYear executionYear) {
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        for (DegreeCurricularPlan dcp : this.getActiveDegreeCurricularPlans()) {
            result.addAll(dcp.getCurricularCoursesByExecutionYearAndCurricularYear(executionYear, curricularYear));
        }
        return result;
    }

    public Set<CurricularCourse> getFirstCycleCurricularCourses(ExecutionYear executionYear) {
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        for (DegreeCurricularPlan dcp : this.getActiveDegreeCurricularPlans()) {
            for (int i = 1; i <= 3; ++i) {
                result.addAll(dcp.getCurricularCoursesByExecutionYearAndCurricularYear(executionYear, i));
            }
        }
        return result;
    }

    public Set<CurricularCourse> getSecondCycleCurricularCourses(ExecutionYear executionYear) {
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        for (DegreeCurricularPlan dcp : this.getActiveDegreeCurricularPlans()) {
            for (int i = 4; i <= 5; ++i) {
                result.addAll(dcp.getCurricularCoursesByExecutionYearAndCurricularYear(executionYear, i));
            }
        }
        return result;
    }

    public boolean hasPendingThesis() {
        for (Thesis thesis : this.getThesisSet()) {
            if (thesis.isFinalThesis()) continue;
            return true;
        }
        return false;
    }

    public Double getEctsCredits() {
        Double ectsCredits = super.getEctsCredits();
        return ectsCredits != null ? ectsCredits : 0.0;
    }

    public boolean hasEctsCredits() {
        return super.getEctsCredits() != null;
    }

    public String getMinistryCode() {
        String ministryCode = super.getMinistryCode();
        if (!StringUtils.isEmpty((String)ministryCode)) {
            return ministryCode;
        }
        return DEFAULT_MINISTRY_CODE;
    }

    public void setMinistryCode(String ministryCode) {
        super.setMinistryCode(ministryCode == null || ministryCode.length() == 0 ? null : ministryCode);
    }

    public void setIdCardName(String idCardName) {
        super.setIdCardName(idCardName.toUpperCase());
    }

    public void setNome(String nome) {
        super.setNome(nome);
        this.setIdCardName(nome);
    }

    public boolean isActive() {
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        for (DegreeCurricularPlan curricularPlan : this.getDegreeCurricularPlansSet()) {
            if (curricularPlan.getExecutionDegreeByYear(currentExecutionYear) == null) continue;
            return true;
        }
        return false;
    }

    public boolean canCreateGratuityEvent() {
        return true;
    }

    public boolean isDEA() {
        return this.getDegreeType().isAdvancedSpecializationDiploma();
    }

    public DegreeOfficialPublication getOfficialPublication(DateTime when) {
        DegreeOfficialPublication found = null;
        for (DegreeOfficialPublication publication : this.getOfficialPublicationSet()) {
            DateTime publicationDate = publication.getPublication().toDateTimeAtStartOfDay();
            if (found == null && publicationDate.isBefore((ReadableInstant)when)) {
                found = publication;
                continue;
            }
            if (found == null || !publicationDate.isBefore((ReadableInstant)when) || !publication.getPublication().isAfter((ReadablePartial)found.getPublication())) continue;
            found = publication;
        }
        return found;
    }

    public List<Teacher> getAllTeachers(AcademicInterval academicInterval) {
        ArrayList<Teacher> teachers = new ArrayList<Teacher>();
        for (Department department : this.getDepartmentsSet()) {
            teachers.addAll(department.getAllTeachers(academicInterval));
        }
        return teachers;
    }

    public String getDegreeTypeName() {
        return this.getDegreeType().getName().getContent();
    }

    public void setCode(String code) {
        Degree existingDegree = Degree.find(code);
        if (existingDegree != null && existingDegree != this) {
            throw new DomainException("error.degree.already.exists.degree.with.same.code", new String[0]);
        }
        super.setCode(code);
    }

    private static class ComparatorByDegreeTypeAndNameAndId
    implements Serializable,
    Comparator<Degree> {
        private ComparatorByDegreeTypeAndNameAndId() {
        }

        @Override
        public int compare(Degree o1, Degree o2) {
            int typeResult = COMPARATOR_BY_DEGREE_TYPE_NAME.compare(o1, o2);
            return typeResult == 0 ? COMPARATOR_BY_NAME_AND_ID.compare(o1, o2) : typeResult;
        }
    }
}

