/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.teacher.executionCourse;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.BibliographicReference;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.dto.teacher.executionCourse.ImportContentBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.teacher.CreateBibliographicReference;
import org.fenixedu.academic.service.services.teacher.DeleteBibliographicReference;
import org.fenixedu.academic.service.services.teacher.EditBibliographicReference;
import org.fenixedu.academic.service.services.teacher.OrderBibliographicReferences;
import org.fenixedu.academic.ui.struts.action.teacher.ManageExecutionCourseDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Input;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(path="/manageBibliographicReference", module="teacher", functionality=ManageExecutionCourseDA.class, formBean="bibliographicReferenceForm")
@Forwards(value={@Forward(name="bibliographicReference", path="/teacher/executionCourse/bibliographicReference.jsp"), @Forward(name="createBibliographicReference", path="/teacher/executionCourse/createBibliographicReference.jsp"), @Forward(name="importBibliographicReferences", path="/teacher/executionCourse/importBibliographicReferences.jsp"), @Forward(name="orderBibliographicReferences", path="/teacher/executionCourse/orderBibliographicReferences.jsp"), @Forward(name="editBibliographicReference", path="/teacher/executionCourse/editBibliographicReference.jsp")})
public class ExecutionCourseBibliographyDA
extends ManageExecutionCourseDA {
    @Input
    public ActionForward bibliographicReference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("bibliographicReference");
    }

    public ActionForward prepareCreateBibliographicReference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("createBibliographicReference");
    }

    public ActionForward createBibliographicReference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String title = dynaActionForm.getString("title");
        String authors = dynaActionForm.getString("authors");
        String reference = dynaActionForm.getString("reference");
        String year = dynaActionForm.getString("year");
        String optional = dynaActionForm.getString("optional");
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        CreateBibliographicReference.runCreateBibliographicReference(executionCourse.getExternalId(), title, authors, reference, year, Boolean.valueOf(optional));
        return mapping.findForward("bibliographicReference");
    }

    public ActionForward prepareEditBibliographicReference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        String bibliographicReferenceIDString = request.getParameter("bibliographicReferenceID");
        if (executionCourse != null && bibliographicReferenceIDString != null && bibliographicReferenceIDString.length() > 0) {
            BibliographicReference bibliographicReference = this.findBibliographicReference(executionCourse, bibliographicReferenceIDString);
            if (bibliographicReference != null) {
                DynaActionForm dynaActionForm = (DynaActionForm)form;
                dynaActionForm.set("title", (Object)bibliographicReference.getTitle());
                dynaActionForm.set("authors", (Object)bibliographicReference.getAuthors());
                dynaActionForm.set("reference", (Object)bibliographicReference.getReference());
                dynaActionForm.set("year", (Object)bibliographicReference.getYear());
                dynaActionForm.set("optional", (Object)bibliographicReference.getOptional().toString());
            }
            request.setAttribute("bibliographicReference", (Object)bibliographicReference);
        }
        return mapping.findForward("editBibliographicReference");
    }

    public ActionForward editBibliographicReference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String bibliographicReferenceIDString = request.getParameter("bibliographicReferenceID");
        String title = dynaActionForm.getString("title");
        String authors = dynaActionForm.getString("authors");
        String reference = dynaActionForm.getString("reference");
        String year = dynaActionForm.getString("year");
        String optional = dynaActionForm.getString("optional");
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        BibliographicReference bibliographicReference = this.findBibliographicReference(executionCourse, bibliographicReferenceIDString);
        EditBibliographicReference.runEditBibliographicReference(bibliographicReference.getExternalId(), title, authors, reference, year, Boolean.valueOf(optional));
        return mapping.findForward("bibliographicReference");
    }

    public ActionForward deleteBibliographicReference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String bibliographicReferenceIDString = request.getParameter("bibliographicReferenceID");
        DeleteBibliographicReference.runDeleteBibliographicReference(bibliographicReferenceIDString);
        return mapping.findForward("bibliographicReference");
    }

    public ActionForward prepareImportBibliographicReferences(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("importContentBean", (Object)new ImportContentBean());
        return mapping.findForward("importBibliographicReferences");
    }

    public ActionForward prepareImportBibliographicReferencesPostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.prepareImportContentPostBack(request);
        return mapping.findForward("importBibliographicReferences");
    }

    public ActionForward prepareImportBibliographicReferencesInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.prepareImportContentInvalid(request);
        return mapping.findForward("importBibliographicReferences");
    }

    public ActionForward listExecutionCoursesToImportBibliographicReferences(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.listExecutionCoursesToImportContent(request);
        return mapping.findForward("importBibliographicReferences");
    }

    public ActionForward importBibliographicReferences(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        this.importContent(request, "ImportBibliographicReferences");
        return mapping.findForward("bibliographicReferences");
    }

    private BibliographicReference findBibliographicReference(ExecutionCourse executionCourse, String bibliographicReferenceID) {
        for (BibliographicReference bibliographicReference : executionCourse.getAssociatedBibliographicReferencesSet()) {
            if (!bibliographicReference.getExternalId().equals(bibliographicReferenceID)) continue;
            return bibliographicReference;
        }
        return null;
    }

    public ActionForward prepareSortBibliography(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionCourse executionCourse = this.getExecutionCourse(request);
        boolean optional = request.getParameter("optional") != null;
        List<BibliographicReference> references = optional ? this.getOptionalBibliographicReferences(executionCourse) : this.getMainBibliographicReferences(executionCourse);
        request.setAttribute("references", references);
        request.setAttribute("optional", (Object)optional);
        return mapping.findForward("orderBibliographicReferences");
    }

    private List<BibliographicReference> getMainBibliographicReferences(ExecutionCourse executionCourse) {
        ArrayList<BibliographicReference> references = new ArrayList<BibliographicReference>();
        for (BibliographicReference reference : executionCourse.getOrderedBibliographicReferences()) {
            if (reference.isOptional()) continue;
            references.add(reference);
        }
        return references;
    }

    private List<BibliographicReference> getOptionalBibliographicReferences(ExecutionCourse executionCourse) {
        ArrayList<BibliographicReference> references = new ArrayList<BibliographicReference>();
        for (BibliographicReference reference : executionCourse.getOrderedBibliographicReferences()) {
            if (!reference.isOptional()) continue;
            references.add(reference);
        }
        return references;
    }

    public ActionForward sortBibliographyReferences(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        List<Object> finalOrderedReferences;
        String[] nodes;
        ExecutionCourse executionCourse = this.getExecutionCourse(request);
        boolean optional = request.getParameter("optional") != null;
        String orderString = request.getParameter("referencesOrder");
        List<BibliographicReference> initialReferences = optional ? this.getOptionalBibliographicReferences(executionCourse) : this.getMainBibliographicReferences(executionCourse);
        ArrayList<BibliographicReference> orderedReferences = new ArrayList<BibliographicReference>();
        for (String node : nodes = orderString.split(",")) {
            String[] parts = node.split("-");
            Integer itemIndex = this.getId(parts[0]);
            orderedReferences.add(initialReferences.get(itemIndex - 1));
        }
        if (optional) {
            finalOrderedReferences = this.getMainBibliographicReferences(executionCourse);
            finalOrderedReferences.addAll(orderedReferences);
        } else {
            finalOrderedReferences = orderedReferences;
            finalOrderedReferences.addAll(this.getOptionalBibliographicReferences(executionCourse));
        }
        OrderBibliographicReferences.run(executionCourse, finalOrderedReferences);
        return mapping.findForward("bibliographicReferences");
    }

    private Integer getId(String id) {
        if (id == null) {
            return null;
        }
        try {
            return new Integer(id);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

