/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.scientificCouncil.curricularPlans;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.CoordinatorLog;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.OperationType;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.scientificCouncil.ScientificCouncilApplication;
import org.fenixedu.academic.ui.struts.action.scientificCouncil.curricularPlans.ExecutionDegreeCoordinatorsBean;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=ScientificCouncilApplication.ScientificBolonhaProcessApp.class, path="edit-degree-coordination", titleKey="navigation.manageCoordinationTeams")
@Mapping(path="/curricularPlans/editExecutionDegreeCoordination", module="scientificCouncil")
@Forwards(value={@Forward(name="presentCoordination", path="/scientificCouncil/curricularPlans/presentCoordination.jsp"), @Forward(name="editCoordination", path="/scientificCouncil/curricularPlans/editCoordination.jsp"), @Forward(name="selectYearAndDegree", path="/scientificCouncil/curricularPlans/selectYearAndDegree.jsp")})
public class EditExecutionDegreeCoordinationDA
extends FenixDispatchAction {
    public ActionForward prepareEditCoordination(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String degreeCurricularPlanId = request.getParameter("degreeCurricularPlanId");
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanId);
        Set executionDegrees = degreeCurricularPlan.getExecutionDegreesSet();
        request.setAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        request.setAttribute("executionDegreesSet", (Object)executionDegrees);
        return mapping.findForward("presentCoordination");
    }

    public ActionForward editCoordination(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String executionDegreeId = request.getParameter("executionDegreeId");
        ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)executionDegreeId);
        String backTo = String.valueOf(request.getParameter("from"));
        String backPath = backTo.equals("byYears") ? "/curricularPlans/editExecutionDegreeCoordination.do?method=editByYears&executionYearId=" + executionDegree.getExecutionYear().getExternalId().toString() : "/curricularPlans/editExecutionDegreeCoordination.do?method=prepareEditCoordination&degreeCurricularPlanId=" + executionDegree.getDegreeCurricularPlan().getExternalId().toString();
        ExecutionDegreeCoordinatorsBean coordsBean = new ExecutionDegreeCoordinatorsBean(executionDegree);
        coordsBean.setBackPath(backPath);
        request.setAttribute("coordsBean", (Object)coordsBean);
        RenderUtils.invalidateViewState((String)"coordsBean");
        return mapping.findForward("editCoordination");
    }

    public ActionForward addCoordinator(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String personId = request.getParameter("personId");
        Person personAdding = (Person)FenixFramework.getDomainObject((String)personId);
        ExecutionDegreeCoordinatorsBean coordsBean = (ExecutionDegreeCoordinatorsBean)this.getRenderedObject("coordsBean");
        Coordinator.makeCreation(personAdding, coordsBean.getExecutionDegree(), coordsBean.getNewCoordinator(), false);
        coordsBean.setNewCoordinator(null);
        request.setAttribute("coordsBean", (Object)coordsBean);
        RenderUtils.invalidateViewState((String)"coordsBean");
        request.setAttribute("startVisible", (Object)true);
        return mapping.findForward("editCoordination");
    }

    public ActionForward switchResponsability(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String coordinatorId = request.getParameter("coordinatorId");
        Coordinator coordinator = (Coordinator)FenixFramework.getDomainObject((String)coordinatorId);
        String executionDegreeId = request.getParameter("executionDegreeId");
        ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)executionDegreeId);
        String personId = request.getParameter("personId");
        Person personSwitching = (Person)FenixFramework.getDomainObject((String)personId);
        String backPath = request.getParameter("backPath");
        if (coordinator.isResponsible()) {
            coordinator.makeAction(OperationType.CHANGERESPONSIBLE_FALSE, personSwitching);
        } else {
            coordinator.makeAction(OperationType.CHANGERESPONSIBLE_TRUE, personSwitching);
        }
        ExecutionDegreeCoordinatorsBean coordsBean = new ExecutionDegreeCoordinatorsBean(executionDegree);
        coordsBean.setEscapedBackPath(backPath);
        request.setAttribute("coordsBean", (Object)coordsBean);
        RenderUtils.invalidateViewState((String)"coordsBean");
        return mapping.findForward("editCoordination");
    }

    public ActionForward deleteCoordinator(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String coordinatorId = request.getParameter("coordinatorId");
        Coordinator coordinator = (Coordinator)FenixFramework.getDomainObject((String)coordinatorId);
        String executionDegreeId = request.getParameter("executionDegreeId");
        ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)executionDegreeId);
        String personId = request.getParameter("personId");
        Person personDeleting = (Person)FenixFramework.getDomainObject((String)personId);
        String backPath = request.getParameter("backPath");
        coordinator.makeAction(OperationType.REMOVE, personDeleting);
        ExecutionDegreeCoordinatorsBean coordsBean = new ExecutionDegreeCoordinatorsBean(executionDegree);
        coordsBean.setEscapedBackPath(backPath);
        request.setAttribute("coordsBean", (Object)coordsBean);
        RenderUtils.invalidateViewState((String)"coordsBean");
        return mapping.findForward("editCoordination");
    }

    public ActionForward invalidAddCoordinator(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionDegreeCoordinatorsBean coordsBean = (ExecutionDegreeCoordinatorsBean)this.getRenderedObject("coordsBean");
        request.setAttribute("coordsBean", (Object)coordsBean);
        RenderUtils.invalidateViewState((String)"coordsBean");
        request.setAttribute("startVisible", (Object)true);
        return mapping.findForward("editCoordination");
    }

    @EntryPoint
    public ActionForward editByYears(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionDegreeCoordinatorsBean sessionBean = (ExecutionDegreeCoordinatorsBean)this.getRenderedObject("sessionBean");
        if (sessionBean == null) {
            sessionBean = new ExecutionDegreeCoordinatorsBean();
            String executionYearId = String.valueOf(request.getParameter("executionYearId"));
            if (!executionYearId.equals("null")) {
                ExecutionYear executionYear = (ExecutionYear)FenixFramework.getDomainObject((String)executionYearId);
                sessionBean.setExecutionYear(executionYear);
            } else {
                request.setAttribute("sessionBean", (Object)sessionBean);
                RenderUtils.invalidateViewState((String)"sessionBean");
                return mapping.findForward("selectYearAndDegree");
            }
        }
        List<ExecutionDegree> bachelors = sessionBean.getExecutionYear().getExecutionDegreesFor(DegreeType::isBolonhaDegree);
        request.setAttribute("bachelors", bachelors);
        List<ExecutionDegree> masters = sessionBean.getExecutionYear().getExecutionDegreesFor(DegreeType::isBolonhaMasterDegree);
        request.setAttribute("masters", masters);
        List<ExecutionDegree> integratedMasters = sessionBean.getExecutionYear().getExecutionDegreesFor(DegreeType::isIntegratedMasterDegree);
        request.setAttribute("integratedMasters", integratedMasters);
        ArrayList otherDegrees = new ArrayList(sessionBean.getExecutionYear().getExecutionDegreesSet());
        otherDegrees.removeAll(bachelors);
        otherDegrees.removeAll(masters);
        otherDegrees.removeAll(integratedMasters);
        request.setAttribute("otherDegrees", otherDegrees);
        boolean hasYearSelected = true;
        request.setAttribute("hasYearSelected", (Object)hasYearSelected);
        request.setAttribute("sessionBean", (Object)sessionBean);
        RenderUtils.invalidateViewState((String)"sessionBean");
        return mapping.findForward("selectYearAndDegree");
    }

    public List<CoordinatorLog> getCoordinatorLogsByExecDegree(ExecutionDegree executionDegree) {
        ArrayList<CoordinatorLog> finalCoordinatorLogs = new ArrayList<CoordinatorLog>();
        finalCoordinatorLogs.addAll(executionDegree.getCoordinatorLogSet());
        return finalCoordinatorLogs;
    }

    public ActionForward prepareCoordinatorLog(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String execDegId = request.getParameter("executionYearId");
        ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)execDegId);
        List<CoordinatorLog> coordinatorLogs = this.getCoordinatorLogsByExecDegree(executionDegree);
        request.setAttribute("coordinatorLogs", coordinatorLogs);
        String backPath = request.getParameter("backPath");
        ExecutionDegreeCoordinatorsBean coordsBean = new ExecutionDegreeCoordinatorsBean(executionDegree);
        coordsBean.setEscapedBackPath(backPath);
        request.setAttribute("coordsBean", (Object)coordsBean);
        RenderUtils.invalidateViewState((String)"coordsBean");
        return mapping.findForward("editCoordination");
    }
}

