/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.candidacy.coordinator.feedbackRequest;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestElementBean;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestProcess;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestProcessBean;
import org.fenixedu.academic.service.services.caseHandling.CreateNewProcess;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.academic.ui.struts.action.phd.PhdDocumentsZip;
import org.fenixedu.academic.ui.struts.action.phd.candidacy.CommonPhdCandidacyDA;
import org.fenixedu.academic.ui.struts.action.phd.coordinator.PhdIndividualProgramProcessDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyArrayConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/phdCandidacyFeedbackRequest", module="coordinator", functionality=PhdIndividualProgramProcessDA.class)
@Forwards(value={@Forward(name="manageFeedbackRequest", path="/phd/candidacy/coordinator/feedbackRequest/manageFeedbackRequest.jsp"), @Forward(name="uploadCandidacyFeedback", path="/phd/candidacy/coordinator/feedbackRequest/uploadCandidacyFeedback.jsp")})
public class PhdCandidacyFeedbackRequestDA
extends CommonPhdCandidacyDA {
    public ActionForward manageFeedbackRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addSharedDocumentTypeNames(request);
        return mapping.findForward("manageFeedbackRequest");
    }

    private void addSharedDocumentTypeNames(HttpServletRequest request) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        if (process2.getFeedbackRequest() != null) {
            StringBuilder builder = new StringBuilder();
            Iterator<PhdIndividualProgramDocumentType> iter = process2.getFeedbackRequest().getSortedSharedDocumentTypes().iterator();
            while (iter.hasNext()) {
                builder.append(iter.next().getLocalizedName()).append(iter.hasNext() ? ", " : "");
            }
            request.setAttribute("sharedDocumentTypes", (Object)builder.toString());
        }
    }

    public ActionForward downloadSubmittedCandidacyFeedbackDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        this.writeFile(response, this.getZipDocumentsFilename(process2.getIndividualProgramProcess()), PhdDocumentsZip.ZIP_MIME_TYPE, this.createZip(process2.getFeedbackRequest().getSubmittedCandidacyFeedbackDocuments()));
        return null;
    }

    public ActionForward prepareEditSharedDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("feedbackRequestBean", (Object)new PhdCandidacyFeedbackRequestProcessBean(this.getProcess(request)));
        return this.manageFeedbackRequest(mapping, actionForm, request, response);
    }

    public ActionForward prepareEditSharedDocumentsInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("feedbackRequestBean", this.getRenderedObject("feedbackRequestBean"));
        return this.manageFeedbackRequest(mapping, actionForm, request, response);
    }

    public ActionForward editSharedDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            PhdProgramCandidacyProcess process2 = this.getProcess(request);
            if (process2.getFeedbackRequest() == null) {
                CreateNewProcess.run(PhdCandidacyFeedbackRequestProcess.class, this.getRenderedObject("feedbackRequestBean"));
            } else {
                ExecuteProcessActivity.run((Process)((Object)this.getProcess(request).getFeedbackRequest()), PhdCandidacyFeedbackRequestProcess.EditSharedDocumentTypes.class, this.getRenderedObject("feedbackRequestBean"));
            }
            this.addSuccessMessage(request, "message.phd.candidacy.feedback.documents.edited.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.prepareEditSharedDocumentsInvalid(mapping, actionForm, request, response);
        }
        return this.manageFeedbackRequest(mapping, actionForm, request, response);
    }

    public ActionForward prepareAddCandidacyFeedbackRequestElement(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdCandidacyFeedbackRequestElementBean bean = new PhdCandidacyFeedbackRequestElementBean(this.getProcess(request));
        bean.updateWithExistingPhdParticipants();
        this.setDefaultMailInformation(bean);
        request.setAttribute("elementBean", (Object)bean);
        return this.manageFeedbackRequest(mapping, actionForm, request, response);
    }

    private void setDefaultMailInformation(PhdCandidacyFeedbackRequestElementBean bean) {
        bean.setMailSubject(AlertService.getSubjectPrefixed(bean.getIndividualProgramProcess(), "message.phd.candidacy.feedback.default.subject"));
        bean.setMailBody(AlertService.getBodyText(bean.getIndividualProgramProcess(), AlertService.AlertMessage.create("message.phd.candidacy.feedback.default.body", bean.getIndividualProgramProcess().getPerson().getName())));
    }

    public ActionForward addCandidacyFeedbackRequestElementInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("elementBean", this.getRenderedObject("elementBean"));
        return this.manageFeedbackRequest(mapping, actionForm, request, response);
    }

    public ActionForward addCandidacyFeedbackRequestElementPostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addCandidacyFeedbackRequestElementInvalid(mapping, actionForm, request, response);
        RenderUtils.invalidateViewState();
        return this.manageFeedbackRequest(mapping, actionForm, request, response);
    }

    public ActionForward addCandidacyFeedbackRequestElement(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            PhdCandidacyFeedbackRequestElementBean bean = (PhdCandidacyFeedbackRequestElementBean)this.getRenderedObject("elementBean");
            if (bean.isExistingElement() && !bean.hasAnyParticipants()) {
                this.addErrorMessage(request, "label.phd.candidacy.feedback.must.select.elements", new String[0]);
                return this.addCandidacyFeedbackRequestElementInvalid(mapping, actionForm, request, response);
            }
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request).getFeedbackRequest()), PhdCandidacyFeedbackRequestProcess.AddPhdCandidacyFeedbackRequestElements.class, (Object)bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.addCandidacyFeedbackRequestElementInvalid(mapping, actionForm, request, response);
        }
        return this.manageFeedbackRequest(mapping, actionForm, request, response);
    }

    public ActionForward deleteCandidacyFeedbackRequestElement(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request).getFeedbackRequest()), PhdCandidacyFeedbackRequestProcess.DeleteCandidacyFeedbackRequestElement.class, this.getDomainObject(request, "elementOid"));
            this.addSuccessMessage(request, "message.phd.candidacy.feedback.element.removed.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
        }
        return this.manageFeedbackRequest(mapping, actionForm, request, response);
    }

    public static class ExistingPhdParticipantsNotInCandidacyFeedbackRequestProcess
    implements DataProvider {
        public Converter getConverter() {
            return new DomainObjectKeyArrayConverter();
        }

        public Object provide(Object source, Object currentValue) {
            PhdCandidacyFeedbackRequestElementBean bean = (PhdCandidacyFeedbackRequestElementBean)source;
            return bean.getExistingParticipants();
        }
    }

    public static class AvailableDocumentsToShare
    implements DataProvider {
        public Converter getConverter() {
            return null;
        }

        public Object provide(Object source, Object currentValue) {
            PhdCandidacyFeedbackRequestProcessBean bean = (PhdCandidacyFeedbackRequestProcessBean)source;
            HashSet<PhdIndividualProgramDocumentType> documentTypes = new HashSet<PhdIndividualProgramDocumentType>();
            for (PhdProgramProcessDocument document : bean.getCandidacyProcess().getLatestDocumentVersions()) {
                documentTypes.add(document.getDocumentType());
            }
            return documentTypes;
        }
    }
}

