/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.academicAdminOffice.serviceRequests;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.domain.phd.serviceRequests.IPhdAcademicServiceRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdAcademicServiceRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdAcademicServiceRequestBean;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdAcademicServiceRequestCreateBean;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.ui.struts.action.phd.PhdDA;
import org.fenixedu.academic.ui.struts.action.phd.academicAdminOffice.PhdIndividualProgramProcessDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(path="/phdAcademicServiceRequestManagement", module="academicAdministration", functionality=PhdIndividualProgramProcessDA.class)
@Forwards(value={@Forward(name="prepareCreateNewRequest", path="/phd/academicAdminOffice/serviceRequests/prepareCreateNewRequest.jsp"), @Forward(name="viewPhdAcademicServiceRequestsHistoric", path="/phd/academicAdminOffice/serviceRequests/viewPhdAcademicServiceRequestsHistoric.jsp"), @Forward(name="viewRequest", path="/phd/academicAdminOffice/serviceRequests/viewRequest.jsp"), @Forward(name="prepareProcessNewState", path="/phd/academicAdminOffice/serviceRequests/prepareProcessNewState.jsp"), @Forward(name="processReceiveNewStateOnRectorate", path="/phd/academicAdminOffice/serviceRequests/document/diploma/rectorate/processReceiveNewState.jsp")})
public class PhdAcademicServiceRequestsManagementDA
extends PhdDA {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("phdAcademicServiceRequest", (Object)this.getPhdAcademicServiceRequest(request));
        request.setAttribute("phdIndividualProgramProcess", (Object)this.getPhdIndividualProgramProcess(request));
        if (this.getPhdAcademicServiceRequest(request) != null) {
            request.setAttribute("phdIndividualProgramProcess", (Object)this.getPhdAcademicServiceRequest(request).getPhdIndividualProgramProcess());
        }
        return super.execute(mapping, actionForm, request, response);
    }

    public ActionForward viewHistoric(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("viewPhdAcademicServiceRequestsHistoric");
    }

    public ActionForward viewAcademicServiceRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if ("true".equals(request.getParameter("fromHistory"))) {
            request.setAttribute("fromHistory", (Object)"true");
        }
        return mapping.findForward("viewRequest");
    }

    public ActionForward prepareCreateNewRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getPhdIndividualProgramProcess(request);
        PhdAcademicServiceRequestCreateBean academicServiceRequestCreateBean = new PhdAcademicServiceRequestCreateBean(process2);
        request.setAttribute("phdAcademicServiceRequestCreateBean", (Object)academicServiceRequestCreateBean);
        return mapping.findForward("prepareCreateNewRequest");
    }

    public ActionForward createNewRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdAcademicServiceRequestCreateBean academicServiceRequestCreateBean = this.getPhdAcademicServiceRequestCreateBean();
        try {
            academicServiceRequestCreateBean.createNewRequest();
        }
        catch (PhdDomainOperationException exception) {
            this.addErrorMessage(request, exception.getMessage(), new String[0]);
            return this.prepareCreateNewRequest(mapping, form, request, response);
        }
        ActionForward forward = this.viewPhdIndividualProgramProcess(request, academicServiceRequestCreateBean);
        return forward;
    }

    public ActionForward createNewRequestInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdAcademicServiceRequestCreateBean academicServiceRequestCreateBean = this.getPhdAcademicServiceRequestCreateBean();
        request.setAttribute("phdAcademicServiceRequestCreateBean", (Object)academicServiceRequestCreateBean);
        return mapping.findForward("prepareCreateNewRequest");
    }

    public ActionForward prepareProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareProcessNewState(mapping, form, request, response, AcademicServiceRequestSituationType.PROCESSING);
    }

    public ActionForward process(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.handleNewSituation(mapping, form, request, response);
    }

    public ActionForward prepareCancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareProcessNewState(mapping, form, request, response, AcademicServiceRequestSituationType.CANCELLED);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.handleNewSituation(mapping, form, request, response);
    }

    public ActionForward prepareReject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareProcessNewState(mapping, form, request, response, AcademicServiceRequestSituationType.REJECTED);
    }

    public ActionForward reject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.handleNewSituation(mapping, form, request, response);
    }

    public ActionForward prepareConclude(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareProcessNewState(mapping, form, request, response, AcademicServiceRequestSituationType.CONCLUDED);
    }

    public ActionForward conclude(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.handleNewSituation(mapping, form, request, response);
    }

    public ActionForward prepareReceive(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareProcessNewState(mapping, form, request, response, AcademicServiceRequestSituationType.RECEIVED_FROM_EXTERNAL_ENTITY);
    }

    public ActionForward receive(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.handleNewSituation(mapping, form, request, response);
    }

    public ActionForward receiveInRectorate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.handleNewSituation(mapping, form, request, response);
        String batchOid = request.getParameter("batchOid");
        return this.redirect("/rectorateDocumentSubmission.do?method=viewBatch&batchOid=" + batchOid, request);
    }

    public ActionForward prepareReceiveOnRectorate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.prepareProcessNewState(mapping, form, request, response, AcademicServiceRequestSituationType.RECEIVED_FROM_EXTERNAL_ENTITY);
        request.setAttribute("batchOid", (Object)request.getParameter("batchOid"));
        return mapping.findForward("processReceiveNewStateOnRectorate");
    }

    public ActionForward prepareDeliver(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareProcessNewState(mapping, form, request, response, AcademicServiceRequestSituationType.DELIVERED);
    }

    public ActionForward deliver(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.handleNewSituation(mapping, form, request, response);
    }

    public ActionForward downloadLastGeneratedDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PhdAcademicServiceRequest academicServiceRequest = this.getPhdAcademicServiceRequest(request);
        this.writeFile(response, academicServiceRequest.getLastGeneratedDocument().getFilename(), academicServiceRequest.getLastGeneratedDocument().getContentType(), academicServiceRequest.getLastGeneratedDocument().getContent());
        return null;
    }

    protected ActionForward prepareProcessNewState(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, AcademicServiceRequestSituationType situationType) {
        PhdAcademicServiceRequest academicServiceRequest = this.getPhdAcademicServiceRequest(request);
        PhdAcademicServiceRequestBean academicServiceRequestBean = new PhdAcademicServiceRequestBean(academicServiceRequest);
        academicServiceRequestBean.setSituationType(situationType);
        request.setAttribute("phdAcademicServiceRequestBean", (Object)academicServiceRequestBean);
        return mapping.findForward("prepareProcessNewState");
    }

    protected ActionForward handleNewSituation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdAcademicServiceRequestBean academicServiceRequestBean = this.getPhdAcademicServiceRequestBean();
        try {
            academicServiceRequestBean.handleNewSituation();
        }
        catch (DomainException e) {
            this.addActionMessage("academicAdminOfficeErrors", request, e.getKey(), e.getArgs());
            request.setAttribute("phdAcademicServiceRequestBean", (Object)this.getPhdAcademicServiceRequestBean());
            return mapping.findForward("prepareProcessNewState");
        }
        return this.viewPhdIndividualProgramProcess(request, academicServiceRequestBean);
    }

    public ActionForward processNewState(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdAcademicServiceRequestBean", (Object)this.getPhdAcademicServiceRequestBean());
        return mapping.findForward("prepareProcessNewState");
    }

    protected PhdAcademicServiceRequestBean getPhdAcademicServiceRequestBean() {
        return (PhdAcademicServiceRequestBean)this.getObjectFromViewState("phd-academic-service-request-bean");
    }

    protected PhdIndividualProgramProcess getPhdIndividualProgramProcess(HttpServletRequest request) {
        return (PhdIndividualProgramProcess)((Object)this.getDomainObject(request, "phdIndividualProgramProcessId"));
    }

    protected PhdAcademicServiceRequestCreateBean getPhdAcademicServiceRequestCreateBean() {
        return (PhdAcademicServiceRequestCreateBean)this.getObjectFromViewState("phd-academic-service-request-create-bean");
    }

    protected PhdAcademicServiceRequest getPhdAcademicServiceRequest(HttpServletRequest request) {
        return (PhdAcademicServiceRequest)((Object)this.getDomainObject(request, "phdAcademicServiceRequestId"));
    }

    private ActionForward viewPhdIndividualProgramProcess(HttpServletRequest request, IPhdAcademicServiceRequest phdAcademicServiceRequest) {
        ActionForward forward = this.redirect("/phdIndividualProgramProcess.do?method=viewProcess&processId=" + phdAcademicServiceRequest.getPhdIndividualProgramProcess().getExternalId(), request);
        return forward;
    }
}

