/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.departmentMember;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.messaging.DepartmentForum;
import org.fenixedu.academic.domain.messaging.Forum;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.departmentMember.DepartmentMemberApp;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.messaging.ForunsManagement;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=DepartmentMemberApp.DepartmentMemberDepartmentApp.class, path="forum", titleKey="link.foruns")
@Mapping(path="/departmentForum", module="departmentMember")
@Forwards(value={@Forward(name="viewDepartmentForum", path="/departmentMember/forum/viewDepartmentForum.jsp"), @Forward(name="viewForum", path="/commons/forums/viewForum.jsp"), @Forward(name="createThreadAndMessage", path="/commons/forums/createThreadAndMessage.jsp"), @Forward(name="viewThread", path="/commons/forums/viewThread.jsp")})
public class DepartmentForumDA
extends ForunsManagement {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("contextPrefix", (Object)"/departmentForum.do");
        request.setAttribute("module", (Object)"/departmentMember");
        return super.execute(mapping, actionForm, request, response);
    }

    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        ArrayList<DepartmentForum> foruns = new ArrayList<DepartmentForum>();
        Person loggedPerson = this.getLoggedPerson(request);
        for (Department department : rootDomainObject.getDepartmentsSet()) {
            if (!this.belongsPersonWithDepartment(loggedPerson, department)) continue;
            foruns.add(department.getDepartmentForum());
        }
        if (foruns.size() == 1) {
            request.setAttribute("forum", foruns.iterator().next());
            return this.viewForum(mapping, form, request, response);
        }
        request.setAttribute("foruns", foruns);
        return mapping.findForward("viewDepartmentForum");
    }

    @Override
    protected Forum getRequestedForum(HttpServletRequest request) {
        String forumId = request.getParameter("forumId");
        if (forumId == null) {
            return (Forum)((Object)request.getAttribute("forum"));
        }
        return super.getRequestedForum(request);
    }

    private boolean belongsPersonWithDepartment(Person person, Department department) {
        DepartmentForum departmentForum = department.getDepartmentForum();
        if (departmentForum != null) {
            return departmentForum.getDepartmentForumGroup().isMember(person.getUser());
        }
        return false;
    }
}

