/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator.candidacy.secondCycle;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacyProcess;
import org.fenixedu.academic.domain.period.SecondCycleCandidacyPeriod;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.ui.struts.action.candidacy.CandidacyProcessDA;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.fenixedu.commons.spreadsheet.SpreadsheetXLSExporter;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/caseHandlingSecondCycleCandidacyProcess", module="coordinator", formBeanClass=SecondCycleCandidacyProcessForm.class, functionality=DegreeCoordinatorIndex.class)
@Forwards(value={@Forward(name="intro", path="/coordinator/candidacy/secondCycle/mainCandidacyProcess.jsp")})
public class SecondCycleCandidacyProcessDA
extends CandidacyProcessDA {
    @Override
    protected Class getProcessType() {
        return SecondCycleCandidacyProcess.class;
    }

    @Override
    protected Class getChildProcessType() {
        return SecondCycleIndividualCandidacyProcess.class;
    }

    @Override
    protected Class getCandidacyPeriodType() {
        return SecondCycleCandidacyPeriod.class;
    }

    protected SecondCycleCandidacyProcess getProcess(HttpServletRequest request) {
        return (SecondCycleCandidacyProcess)((Object)super.getProcess(request));
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCoordinatorIndex.setCoordinatorContext(request);
        return super.execute(mapping, actionForm, request, response);
    }

    List<ExecutionInterval> readExecutionIntervalFilteredByCoordinatorTeam(HttpServletRequest request) {
        ArrayList<ExecutionInterval> returnExecutionIntervals = new ArrayList<ExecutionInterval>();
        List<ExecutionInterval> executionIntervals = ExecutionInterval.readExecutionIntervalsWithCandidacyPeriod(this.getCandidacyPeriodType());
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        block0: for (ExecutionInterval interval : executionIntervals) {
            ExecutionYear executionYear = interval instanceof ExecutionYear ? (ExecutionYear)((Object)interval) : ((ExecutionSemester)((Object)interval)).getExecutionYear();
            ExecutionDegree executionDegree = degreeCurricularPlan.getExecutionDegreeByYear(executionYear);
            if (executionDegree == null) continue;
            for (Coordinator coordinator : executionDegree.getCoordinatorsListSet()) {
                if (coordinator.getPerson() != AccessControl.getPerson()) continue;
                returnExecutionIntervals.add(interval);
                continue block0;
            }
        }
        return returnExecutionIntervals;
    }

    @Override
    protected void setStartInformation(ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        if (!this.hasExecutionInterval(request)) {
            ExecutionInterval executionInterval;
            List<SecondCycleCandidacyProcess> candidacyProcesses;
            List<ExecutionInterval> executionIntervals = this.readExecutionIntervalFilteredByCoordinatorTeam(request);
            request.setAttribute("executionIntervals", executionIntervals);
            if (executionIntervals.size() == 1 && (candidacyProcesses = this.getCandidacyProcesses(executionInterval = executionIntervals.iterator().next())).size() == 1) {
                this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)candidacyProcesses.iterator().next()));
                this.setCandidacyProcessInformation(actionForm, this.getProcess(request));
                request.setAttribute("candidacyProcesses", candidacyProcesses);
                return;
            }
            request.setAttribute("canCreateProcess", this.canCreateProcess(this.getProcessType().getName()));
            request.setAttribute("executionIntervals", executionIntervals);
        } else {
            ExecutionInterval executionInterval = this.getExecutionInterval(request);
            SecondCycleCandidacyProcess candidacyProcess = this.getCandidacyProcess(request, executionInterval);
            if (candidacyProcess != null) {
                this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)candidacyProcess));
                this.setCandidacyProcessInformation(actionForm, this.getProcess(request));
            } else {
                List<SecondCycleCandidacyProcess> candidacyProcesses = this.getCandidacyProcesses(executionInterval);
                if (candidacyProcesses.size() == 1) {
                    this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)candidacyProcesses.iterator().next()));
                    this.setCandidacyProcessInformation(actionForm, this.getProcess(request));
                    request.setAttribute("candidacyProcesses", candidacyProcesses);
                    return;
                }
                request.setAttribute("canCreateProcess", this.canCreateProcess(this.getProcessType().getName()));
                request.setAttribute("executionIntervals", this.readExecutionIntervalFilteredByCoordinatorTeam(request));
            }
            request.setAttribute("candidacyProcesses", this.getCandidacyProcesses(executionInterval));
        }
    }

    private List<ExecutionInterval> getExecutionIntervalsWithCandidacyPeriod() {
        return ExecutionInterval.readExecutionIntervalsWithCandidacyPeriod(this.getCandidacyPeriodType());
    }

    private List<SecondCycleCandidacyProcess> getCandidacyProcesses(ExecutionInterval executionInterval) {
        ArrayList<SecondCycleCandidacyProcess> result = new ArrayList<SecondCycleCandidacyProcess>();
        for (SecondCycleCandidacyPeriod period : executionInterval.getSecondCycleCandidacyPeriods()) {
            result.add(period.getSecondCycleCandidacyProcess());
        }
        return result;
    }

    @Override
    public ActionForward listProcessAllowedActivities(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)this.getProcess(request)));
        this.setCandidacyProcessInformation(form, this.getProcess(request));
        request.setAttribute("candidacyProcesses", this.getCandidacyProcesses((ExecutionInterval)((Object)this.getProcess(request).getCandidacyExecutionInterval())));
        return this.introForward(mapping);
    }

    private void setCandidacyProcessInformation(ActionForm actionForm, SecondCycleCandidacyProcess process2) {
        SecondCycleCandidacyProcessForm form = (SecondCycleCandidacyProcessForm)actionForm;
        form.setSelectedProcessId(process2.getExternalId());
        form.setExecutionIntervalId(process2.getCandidacyExecutionInterval().getExternalId());
    }

    @Override
    protected ActionForward introForward(ActionMapping mapping) {
        return mapping.findForward("intro");
    }

    protected SecondCycleCandidacyProcess getCandidacyProcess(HttpServletRequest request, ExecutionInterval executionInterval) {
        String selectedProcessId = this.getStringFromRequest(request, "selectedProcessId");
        if (selectedProcessId != null) {
            for (SecondCycleCandidacyPeriod candidacyPeriod : executionInterval.getSecondCycleCandidacyPeriods()) {
                if (!candidacyPeriod.getSecondCycleCandidacyProcess().getExternalId().equals(selectedProcessId)) continue;
                return candidacyPeriod.getSecondCycleCandidacyProcess();
            }
        }
        return null;
    }

    public ActionForward prepareExecutePrintCandidacies(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + this.getReportFilename());
        ServletOutputStream writer = response.getOutputStream();
        this.writeReport(this.getProcess(request), writer);
        writer.flush();
        response.flushBuffer();
        return null;
    }

    private void writeReport(SecondCycleCandidacyProcess process2, ServletOutputStream writer) throws IOException {
        ArrayList<Spreadsheet> spreadsheets = new ArrayList<Spreadsheet>();
        for (Map.Entry<Degree, SortedSet<SecondCycleIndividualCandidacyProcess>> entry : process2.getValidSecondCycleIndividualCandidaciesByDegree().entrySet()) {
            spreadsheets.add(this.buildReport(entry.getKey(), entry.getValue()));
        }
        new SpreadsheetXLSExporter().exportToXLSSheets((OutputStream)writer, spreadsheets);
    }

    private Spreadsheet buildReport(Degree degree, SortedSet<SecondCycleIndividualCandidacyProcess> name) {
        Spreadsheet spreadsheet = new Spreadsheet(degree.getSigla(), this.getHeader());
        for (SecondCycleIndividualCandidacyProcess process2 : name) {
            Spreadsheet.Row row = spreadsheet.addRow();
            row.setCell(process2.getPersonalDetails().getName());
            row.setCell(process2.getPrecedentDegreeInformation().getConclusionGrade());
            row.setCell(process2.getCandidacyProfessionalExperience());
            row.setCell(process2.getPrecedentDegreeInformation().getDegreeAndInstitutionName());
            row.setCell(process2.getCandidacyAffinity());
            row.setCell(process2.getCandidacyDegreeNature());
            row.setCell(process2.getCandidacyGrade());
            row.setCell(process2.getCandidacyInterviewGrade() != null ? process2.getCandidacyInterviewGrade() : " ");
            row.setCell(process2.getCandidacySeriesGrade());
            if (process2.isCandidacyAccepted() || process2.isCandidacyRejected()) {
                row.setCell(BundleUtil.getString((String)"resources.EnumerationResources", (String)process2.getCandidacyState().getQualifiedName(), (String[])new String[0]));
                continue;
            }
            row.setCell(" ");
        }
        return spreadsheet;
    }

    private List<Object> getHeader() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.name", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.mfc", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.professionalExperience", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.degree.and.school", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.affinity", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.degreeNature", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.grade", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.interviewGrade", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.seriesGrade", (String[])new String[0]));
        result.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.candidacy.result", (String[])new String[0]));
        return result;
    }

    @Override
    protected List<CandidacyProcessDA.CandidacyDegreeBean> createCandidacyDegreeBeans(HttpServletRequest request) {
        SecondCycleCandidacyProcess process2 = this.getProcess(request);
        ArrayList<CandidacyProcessDA.CandidacyDegreeBean> candidacyDegreeBeans = new ArrayList<CandidacyProcessDA.CandidacyDegreeBean>();
        for (SecondCycleIndividualCandidacyProcess child : process2.getAcceptedSecondCycleIndividualCandidacies()) {
            candidacyDegreeBeans.add(new SecondCycleCandidacyDegreeBean(child));
        }
        Collections.sort(candidacyDegreeBeans);
        return candidacyDegreeBeans;
    }

    protected List<IndividualCandidacyProcess> getChildProcesses(CandidacyProcess process2, HttpServletRequest request) {
        Set processes = process2.getChildProcessesSet();
        ArrayList<IndividualCandidacyProcess> selectedDegreesIndividualCandidacyProcesses = new ArrayList<IndividualCandidacyProcess>();
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        for (IndividualCandidacyProcess child : processes) {
            if (!((SecondCycleIndividualCandidacyProcess)((Object)child)).getSelectedDegrees().contains(degreeCurricularPlan.getDegree())) continue;
            selectedDegreesIndividualCandidacyProcesses.add(child);
        }
        return selectedDegreesIndividualCandidacyProcesses;
    }

    public DegreeCurricularPlan getDegreeCurricularPlan(HttpServletRequest request) {
        String degreeCurricularPlanOID = DegreeCoordinatorIndex.findDegreeCurricularPlanID(request);
        request.setAttribute("degreeCurricularPlanID", (Object)degreeCurricularPlanOID);
        if (degreeCurricularPlanOID != null) {
            return (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanOID);
        }
        return null;
    }

    @Override
    protected Spreadsheet buildIndividualCandidacyReport(Spreadsheet spreadsheet, IndividualCandidacyProcess individualCandidacyProcess) {
        SecondCycleIndividualCandidacyProcess secondCycleIndividualCandidacyProcess = (SecondCycleIndividualCandidacyProcess)((Object)individualCandidacyProcess);
        Spreadsheet.Row row = spreadsheet.addRow();
        row.setCell(secondCycleIndividualCandidacyProcess.getProcessCode());
        row.setCell(secondCycleIndividualCandidacyProcess.getPersonalDetails().getName());
        row.setCell(secondCycleIndividualCandidacyProcess.getPersonalDetails().getIdDocumentType().getLocalizedName());
        row.setCell(secondCycleIndividualCandidacyProcess.getPersonalDetails().getDocumentIdNumber());
        row.setCell(secondCycleIndividualCandidacyProcess.getPersonalDetails().getCountry() != null ? secondCycleIndividualCandidacyProcess.getPersonalDetails().getCountry().getCountryNationality().getContent() : "");
        row.setCell(secondCycleIndividualCandidacyProcess.getPrecedentDegreeInformation().getDegreeAndInstitutionName());
        row.setCell(secondCycleIndividualCandidacyProcess.getPrecedentDegreeInformation().getDegreeDesignation());
        row.setCell(secondCycleIndividualCandidacyProcess.getPrecedentDegreeInformation().getConclusionDate() != null ? secondCycleIndividualCandidacyProcess.getPrecedentDegreeInformation().getConclusionDate().toString(dateFormat) : "");
        row.setCell(secondCycleIndividualCandidacyProcess.getPrecedentDegreeInformation().getConclusionGrade());
        String degrees = String.join((CharSequence)"\n", secondCycleIndividualCandidacyProcess.getCandidacy().getSelectedDegreesSet().stream().map(d -> d.getNameI18N(secondCycleIndividualCandidacyProcess.getCandidacyExecutionInterval()).getContent()).collect(Collectors.toList()));
        row.setCell(degrees);
        row.setCell(BundleUtil.getString((String)"resources.EnumerationResources", (String)individualCandidacyProcess.getCandidacyState().getQualifiedName(), (String[])new String[0]));
        row.setCell(BundleUtil.getString((String)"resources.CandidateResources", (String)(secondCycleIndividualCandidacyProcess.getProcessChecked() != null && secondCycleIndividualCandidacyProcess.getProcessChecked() != false ? this.MESSAGE_YES : this.MESSAGE_NO), (String[])new String[0]));
        return spreadsheet;
    }

    @Override
    protected void setCandidacyProcessInformation(HttpServletRequest request, CandidacyProcess process2) {
        super.setCandidacyProcessInformation(request, process2);
        request.setAttribute("executionIntervals", this.readExecutionIntervalFilteredByCoordinatorTeam(request));
    }

    public static class SecondCycleCandidacyDegreeBean
    extends CandidacyProcessDA.CandidacyDegreeBean {
        private String notes;

        public SecondCycleCandidacyDegreeBean(SecondCycleIndividualCandidacyProcess process2) {
            this.setPersonalDetails(process2.getPersonalDetails());
            this.setDegree(process2.getCandidacySelectedDegree());
            this.setState(process2.getCandidacyState());
            this.setRegistrationCreated(process2.hasRegistrationForCandidacy());
            this.setNotes(process2.getCandidacyNotes());
        }

        public String getNotes() {
            return this.notes;
        }

        private void setNotes(String notes) {
            this.notes = notes;
        }
    }

    public static class SecondCycleCandidacyProcessForm
    extends CandidacyProcessDA.CandidacyProcessForm {
        private String selectedProcessId;

        public String getSelectedProcessId() {
            return this.selectedProcessId;
        }

        public void setSelectedProcessId(String selectedProcessId) {
            this.selectedProcessId = selectedProcessId;
        }
    }
}

