/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.DomainObject;

@Mapping(module="coordinator", path="/weeklyWorkLoad", formBean="weeklyWorkLoadForm", functionality=DegreeCoordinatorIndex.class)
@Forwards(value={@Forward(name="showWeeklyWorkLoad", path="/coordinator/weeklyWorkLoad.jsp")})
public class WeeklyWorkLoadDA
extends FenixDispatchAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCoordinatorIndex.setCoordinatorContext(request);
        return super.execute(mapping, actionForm, request, response);
    }

    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        Set executionSemesters = rootDomainObject.getExecutionPeriodsSet();
        TreeSet sortedExecutionPeriods = new TreeSet(executionSemesters);
        request.setAttribute("executionPeriods", sortedExecutionPeriods);
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String executionPeriodID = this.getExecutionPeriodID(dynaActionForm);
        ExecutionSemester selectedExecutionPeriod = this.findExecutionPeriod(executionSemesters, executionPeriodID);
        dynaActionForm.set("executionPeriodID", (Object)selectedExecutionPeriod.getExternalId().toString());
        ArrayList<ExecutionDegree> executionDegrees = new ArrayList<ExecutionDegree>();
        for (ExecutionDegree executionDegree : selectedExecutionPeriod.getExecutionYear().getExecutionDegreesSortedByDegreeName()) {
            if (!executionDegree.getDegreeCurricularPlan().getDegree().getDegreeType().isPreBolonhaDegree()) continue;
            executionDegrees.add(executionDegree);
        }
        request.setAttribute("executionDegrees", executionDegrees);
        TreeSet<CurricularYear> curricularYears = new TreeSet<CurricularYear>(rootDomainObject.getCurricularYearsSet());
        request.setAttribute("curricularYears", curricularYears);
        TreeSet<ExecutionCourse> executionCourses = new TreeSet<ExecutionCourse>(ExecutionCourse.EXECUTION_COURSE_NAME_COMPARATOR);
        request.setAttribute("executionCourses", executionCourses);
        ExecutionCourse selectedExecutionCourse = (ExecutionCourse)((Object)this.setDomainObjectInRequest(dynaActionForm, request, "executionCourseID", "executionCourse"));
        request.setAttribute("selectedExecutionCourse", (Object)selectedExecutionCourse);
        String curricularYearID = this.getCurricularYearID(dynaActionForm);
        CurricularYear selecctedCurricularYear = (CurricularYear)this.setDomainObjectInRequest(dynaActionForm, request, "curricularYearID", "selecctedCurricularYear");
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)((Object)this.setDomainObjectInRequest(dynaActionForm, request, "degreeCurricularPlanID", "executionCourse"));
        if (degreeCurricularPlan != null) {
            request.setAttribute("degreeCurricularPlanID", (Object)degreeCurricularPlan.getExternalId());
            for (CurricularCourse curricularCourse : degreeCurricularPlan.getCurricularCoursesSet()) {
                for (DegreeModuleScope degreeCourseScope : curricularCourse.getDegreeModuleScopes()) {
                    CurricularYear curricularYear = CurricularYear.readByYear(degreeCourseScope.getCurricularYear());
                    curricularYears.add(curricularYear);
                    if (curricularYearID != null && !curricularYear.getExternalId().equals(curricularYearID)) continue;
                    for (ExecutionCourse executionCourse : curricularCourse.getExecutionCoursesByExecutionPeriod(selectedExecutionPeriod)) {
                        executionCourses.add(executionCourse);
                    }
                }
            }
        }
        if (selecctedCurricularYear != null && degreeCurricularPlan != null) {
            request.setAttribute("curricularYearWeeklyWorkLoadView", (Object)new CurricularYearWeeklyWorkLoadView(degreeCurricularPlan, selectedExecutionPeriod, executionCourses));
        }
        return mapping.findForward("showWeeklyWorkLoad");
    }

    private <T extends DomainObject> T setDomainObjectInRequest(DynaActionForm dynaActionForm, HttpServletRequest request, String formAttributeName, String requestAttributeName) {
        Object domainObject = this.getDomainObject(dynaActionForm, formAttributeName);
        request.setAttribute(requestAttributeName, domainObject);
        return domainObject;
    }

    private String getCurricularYearID(DynaActionForm dynaActionForm) {
        String curricularYearIDString = dynaActionForm.getString("curricularYearID");
        return curricularYearIDString == null || curricularYearIDString.length() == 0 ? null : curricularYearIDString;
    }

    private String getExecutionPeriodID(DynaActionForm dynaActionForm) {
        String exeutionPeriodIDString = dynaActionForm.getString("executionPeriodID");
        return exeutionPeriodIDString == null || exeutionPeriodIDString.length() == 0 ? null : exeutionPeriodIDString;
    }

    private ExecutionSemester findExecutionPeriod(Collection<ExecutionSemester> executionSemesters, String executionPeriodID) {
        for (ExecutionSemester executionSemester : executionSemesters) {
            if (executionPeriodID == null && executionSemester.getState().equals(PeriodState.CURRENT)) {
                return executionSemester;
            }
            if (executionPeriodID == null || !executionSemester.getExternalId().equals(executionPeriodID)) continue;
            return executionSemester;
        }
        return null;
    }

    public static class CurricularYearWeeklyWorkLoadView {
        Interval interval;
        int numberOfWeeks;
        Interval[] intervals;
        final Set<ExecutionCourse> executionCourses = new TreeSet<ExecutionCourse>(ExecutionCourse.EXECUTION_COURSE_NAME_COMPARATOR);

        public CurricularYearWeeklyWorkLoadView(DegreeCurricularPlan degreeCurricularPlan, ExecutionSemester executionSemester, Set<ExecutionCourse> executionCourses) {
            ExecutionDegree executionDegree = this.findExecutionDegree(executionSemester, degreeCurricularPlan);
            if (executionDegree != null) {
                this.interval = new Interval((ReadableInstant)new DateMidnight((Object)this.getBegginingOfLessonPeriod(executionSemester, executionDegree)), (ReadableInstant)new DateMidnight((Object)this.getEndOfExamsPeriod(executionSemester, executionDegree)));
                Period period = this.interval.toPeriod();
                int extraWeek = period.getDays() > 0 ? 1 : 0;
                this.numberOfWeeks = (period.getYears() * 12 + period.getMonths()) * 4 + period.getWeeks() + extraWeek + 1;
                this.intervals = new Interval[this.numberOfWeeks];
                for (int i = 0; i < this.numberOfWeeks; ++i) {
                    DateTime start = this.interval.getStart().plusWeeks(i);
                    DateTime end = start.plusWeeks(1);
                    this.intervals[i] = new Interval((ReadableInstant)start, (ReadableInstant)end);
                }
                this.executionCourses.addAll(executionCourses);
            }
        }

        private ExecutionDegree findExecutionDegree(ExecutionSemester executionSemester, DegreeCurricularPlan degreeCurricularPlan) {
            return degreeCurricularPlan.getExecutionDegreeByAcademicInterval(executionSemester.getExecutionYear().getAcademicInterval());
        }

        public Date getBegginingOfLessonPeriod(ExecutionSemester executionSemester, ExecutionDegree executionDegree) {
            if (executionSemester != null) {
                OccupationPeriod op = executionDegree.getPeriodLessons(executionSemester);
                return op.getStartYearMonthDay().toDateMidnight().toDate();
            }
            throw new DomainException("unsupported.execution.period.semester", new String[0]);
        }

        public Date getEndOfExamsPeriod(ExecutionSemester executionSemester, ExecutionDegree executionDegree) {
            if (executionSemester != null) {
                OccupationPeriod op = executionDegree.getPeriodLessons(executionSemester);
                return op.getEndYearMonthDay().toDateMidnight().toDate();
            }
            throw new DomainException("unsupported.execution.period.semester", new String[0]);
        }

        public Interval[] getIntervals() {
            return this.intervals;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public Set<ExecutionCourse> getExecutionCourses() {
            return this.executionCourses;
        }
    }
}

