/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.studentEnrolment;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.administrativeOffice.studentEnrolment.StudentEnrolmentBean;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/studentEnrolments", module="academicAdministration", functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="prepareChooseExecutionPeriod", path="/academicAdminOffice/chooseStudentEnrolmentExecutionPeriod.jsp"), @Forward(name="visualizeRegistration", path="/academicAdministration/student.do?method=visualizeRegistration")})
public class StudentEnrolmentsDA
extends FenixDispatchAction {
    public ActionForward prepare(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        StudentCurricularPlan plan = (StudentCurricularPlan)((Object)this.getDomainObject(request, "scpID"));
        StudentEnrolmentBean studentEnrolmentBean = new StudentEnrolmentBean();
        if (plan != null) {
            studentEnrolmentBean.setStudentCurricularPlan(plan);
            studentEnrolmentBean.setExecutionPeriod(ExecutionSemester.readActualExecutionSemester());
            return this.showExecutionPeriodEnrolments(studentEnrolmentBean, mapping, actionForm, request, response);
        }
        throw new FenixActionException();
    }

    public ActionForward prepareFromExtraEnrolment(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        StudentEnrolmentBean studentEnrolmentBean = (StudentEnrolmentBean)request.getAttribute("studentEnrolmentBean");
        return this.showExecutionPeriodEnrolments(studentEnrolmentBean, mapping, actionForm, request, response);
    }

    public ActionForward prepareFromStudentEnrollmentWithRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        StudentEnrolmentBean studentEnrolmentBean = new StudentEnrolmentBean();
        studentEnrolmentBean.setExecutionPeriod((ExecutionSemester)request.getAttribute("executionPeriod"));
        studentEnrolmentBean.setStudentCurricularPlan((StudentCurricularPlan)((Object)request.getAttribute("studentCurricularPlan")));
        return this.showExecutionPeriodEnrolments(studentEnrolmentBean, mapping, form, request, response);
    }

    private ActionForward showExecutionPeriodEnrolments(StudentEnrolmentBean studentEnrolmentBean, ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studentEnrolmentBean", (Object)studentEnrolmentBean);
        if (studentEnrolmentBean.getExecutionPeriod() != null) {
            request.setAttribute("studentEnrolments", studentEnrolmentBean.getStudentCurricularPlan().getEnrolmentsByExecutionPeriod(studentEnrolmentBean.getExecutionPeriod()));
            request.setAttribute("studentImprovementEnrolments", studentEnrolmentBean.getStudentCurricularPlan().getEnroledImprovements(studentEnrolmentBean.getExecutionPeriod()));
            request.setAttribute("studentSpecialSeasonEnrolments", studentEnrolmentBean.getStudentCurricularPlan().getEnroledSpecialSeasons(studentEnrolmentBean.getExecutionPeriod()));
        }
        return mapping.findForward("prepareChooseExecutionPeriod");
    }

    public ActionForward postBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        StudentEnrolmentBean enrolmentBean = (StudentEnrolmentBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        return this.showExecutionPeriodEnrolments(enrolmentBean, mapping, actionForm, request, response);
    }

    public ActionForward backViewRegistration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        StudentEnrolmentBean studentEnrolmentBean = (StudentEnrolmentBean)this.getRenderedObject();
        request.setAttribute("registrationId", (Object)studentEnrolmentBean.getStudentCurricularPlan().getRegistration().getExternalId());
        return mapping.findForward("visualizeRegistration");
    }

    public ActionForward annulEnrolment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Enrolment enrolment = (Enrolment)this.getDomainObject(request, "enrolmentId");
        try {
            this.atomic(enrolment::annul);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
        }
        StudentEnrolmentBean studentEnrolmentBean = new StudentEnrolmentBean();
        studentEnrolmentBean.setExecutionPeriod((ExecutionSemester)this.getDomainObject(request, "executionPeriodId"));
        studentEnrolmentBean.setStudentCurricularPlan((StudentCurricularPlan)((Object)this.getDomainObject(request, "scpID")));
        return this.showExecutionPeriodEnrolments(studentEnrolmentBean, mapping, form, request, response);
    }

    public ActionForward activateEnrolment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.atomic(() -> {
                Enrolment enrolment = (Enrolment)this.getDomainObject(request, "enrolmentId");
                enrolment.activate();
            });
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
        }
        StudentEnrolmentBean studentEnrolmentBean = new StudentEnrolmentBean();
        studentEnrolmentBean.setExecutionPeriod((ExecutionSemester)this.getDomainObject(request, "executionPeriodId"));
        studentEnrolmentBean.setStudentCurricularPlan((StudentCurricularPlan)((Object)this.getDomainObject(request, "scpID")));
        return this.showExecutionPeriodEnrolments(studentEnrolmentBean, mapping, form, request, response);
    }
}

