/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import java.util.Collection;
import java.util.List;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.ui.renderers.AbstractContactRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class ContactTableRenderer
extends AbstractContactRenderer {
    private String label;
    private String rowClasses;
    private String leftColumnClasses;
    private String rightColumnClasses;
    private String leftLineStyle;
    private String rightLineStyle;

    protected Layout getLayout(Object unfiltered, Class type) {
        return new Layout(){

            public HtmlComponent createComponent(Object unfiltered, Class type) {
                List<MetaObject> contacts = ContactTableRenderer.this.getFilteredContacts((Collection)unfiltered);
                if (contacts.isEmpty()) {
                    return new HtmlText();
                }
                HtmlInlineContainer span = new HtmlInlineContainer();
                int rowIndex = 0;
                for (MetaObject meta : contacts) {
                    HtmlTableRow row = new HtmlTableRow();
                    row.setClasses(ContactTableRenderer.this.getRowClasses());
                    if (rowIndex == 0) {
                        HtmlTableCell left = row.createCell(HtmlTableCell.CellType.HEADER);
                        left.setClasses(ContactTableRenderer.this.getLeftColumnClasses());
                        left.setStyle(ContactTableRenderer.this.getLeftLineStyle());
                        left.setRowspan(Integer.valueOf(contacts.size()));
                        left.setBody((HtmlComponent)new HtmlText(RenderUtils.getResourceString((String)ContactTableRenderer.this.getBundle(), (String)ContactTableRenderer.this.getLabel()) + ":"));
                    }
                    HtmlTableCell right = row.createCell();
                    right.setClasses(ContactTableRenderer.this.getRightColumnClasses());
                    right.setStyle(ContactTableRenderer.this.getRightLineStyle());
                    right.setBody(ContactTableRenderer.this.getValue((PartyContact)((Object)meta.getObject())));
                    span.addChild((HtmlComponent)row);
                    ++rowIndex;
                }
                return span;
            }
        };
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getRowClasses() {
        return this.rowClasses;
    }

    public void setRowClasses(String rowClasses) {
        this.rowClasses = rowClasses;
    }

    public String getLeftColumnClasses() {
        return this.leftColumnClasses;
    }

    public void setLeftColumnClasses(String leftColumnClasses) {
        this.leftColumnClasses = leftColumnClasses;
    }

    public String getRightColumnClasses() {
        return this.rightColumnClasses;
    }

    public void setRightColumnClasses(String rightColumnClasses) {
        this.rightColumnClasses = rightColumnClasses;
    }

    public String getLeftLineStyle() {
        return this.leftLineStyle;
    }

    public void setLeftLineStyle(String leftLineStyle) {
        this.leftLineStyle = leftLineStyle;
    }

    public String getRightLineStyle() {
        return this.rightLineStyle;
    }

    public void setRightLineStyle(String rightLineStyle) {
        this.rightLineStyle = rightLineStyle;
    }
}

