/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.resourceAllocationManager;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.dto.InfoClass;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.service.services.resourceAllocationManager.ReadAvailableClassesForShift$callable$run;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ReadAvailableClassesForShift {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static List run(String string) {
        return (List)advice$run.perform((Callable)new ReadAvailableClassesForShift$callable$run(string));
    }

    static /* synthetic */ List advised$run(String shiftOID) {
        AccessControl.check(RolePredicates.RESOURCE_ALLOCATION_MANAGER_PREDICATE);
        Shift shift = (Shift)FenixFramework.getDomainObject((String)shiftOID);
        ExecutionCourse executionCourse = shift.getDisciplinaExecucao();
        ExecutionSemester executionSemester = executionCourse.getExecutionPeriod();
        ExecutionYear executionYear = executionSemester.getExecutionYear();
        HashSet<SchoolClass> availableSchoolClasses = new HashSet<SchoolClass>();
        for (DegreeCurricularPlan degreeCurricularPlan : executionCourse.getAssociatedDegreeCurricularPlans()) {
            for (SchoolClass schoolClass : degreeCurricularPlan.getExecutionDegreeByAcademicInterval(executionCourse.getAcademicInterval()).getSchoolClassesSet()) {
                if (!schoolClass.getAcademicInterval().equals(executionCourse.getAcademicInterval()) || shift.getAssociatedClassesSet().contains((Object)schoolClass)) continue;
                availableSchoolClasses.add(schoolClass);
            }
        }
        ArrayList<InfoClass> infoClasses = new ArrayList<InfoClass>(availableSchoolClasses.size());
        for (SchoolClass schoolClass : availableSchoolClasses) {
            InfoClass infoClass = InfoClass.newInfoFromDomain(schoolClass);
            infoClasses.add(infoClass);
        }
        return infoClasses;
    }
}

