/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.person;

import com.google.common.io.BaseEncoding;
import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.service.services.exceptions.PasswordInitializationException;
import org.fenixedu.bennu.core.domain.User;

public class InitializePassword {
    private static final Client HTTP_CLIENT = ClientBuilder.newClient();
    private static final String ALREADY_INITIALIZED = "internationalRegistration.error.alreadyInitialized";
    private static final String ERROR_REGISTERING = "internationalRegistration.error.registering";

    public static void run(User user, String password) throws PasswordInitializationException {
        Form form = new Form().param("istid", user.getUsername()).param("password", password);
        Response post = HTTP_CLIENT.target(FenixEduAcademicConfiguration.getConfiguration().getWebServicesInternationalRegistrationUrl()).request(new String[]{"application/json"}).header("Authorization", (Object)InitializePassword.getServiceAuth()).post(Entity.form((Form)form));
        OutputBean output = null;
        if (post.getStatus() == 200) {
            String entity = (String)post.readEntity(String.class);
            output = (OutputBean)new Gson().fromJson(entity, OutputBean.class);
        }
        if (output == null || output.getErrno() != 0) {
            String errorMessage = output.getErrno() == 1 ? ERROR_REGISTERING : ALREADY_INITIALIZED;
            System.out.println(output.getErrno() + " : " + output.getError());
            throw new PasswordInitializationException(errorMessage);
        }
    }

    private static String getServiceAuth() {
        FenixEduAcademicConfiguration.ConfigurationProperties config = FenixEduAcademicConfiguration.getConfiguration();
        String userpass = config.getWebServicesInternationalRegistrationUsername() + ":" + config.getWebServicesInternationalRegistrationPassword();
        String encoding = new String(BaseEncoding.base64().encode(userpass.getBytes(StandardCharsets.UTF_8)));
        return "Basic " + encoding;
    }

    static class OutputBean {
        private Integer errno;
        private String error;

        OutputBean() {
        }

        public Integer getErrno() {
            return this.errno;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public void setErrno(Integer errno) {
            this.errno = errno;
        }
    }
}

