/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.manager;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.service.services.manager.CreateExecutionCoursesForDegreeCurricularPlansAndExecutionPeriod$callable$run;
import org.fenixedu.academic.util.Pair;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreateExecutionCoursesForDegreeCurricularPlansAndExecutionPeriod {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static HashMap<String, Pair<Integer, String>> run(String[] stringArray, String string) {
        return (HashMap)advice$run.perform((Callable)new CreateExecutionCoursesForDegreeCurricularPlansAndExecutionPeriod$callable$run(stringArray, string));
    }

    static /* synthetic */ HashMap<String, Pair<Integer, String>> advised$run(String[] degreeCurricularPlansIDs, String executionPeriodID) {
        ExecutionSemester executionSemester = (ExecutionSemester)FenixFramework.getDomainObject((String)executionPeriodID);
        if (executionSemester == null) {
            throw new DomainException("error.selection.noPeriod", new String[0]);
        }
        Set<String> existentsExecutionCoursesSiglas = CreateExecutionCoursesForDegreeCurricularPlansAndExecutionPeriod.readExistingExecutionCoursesSiglas(executionSemester);
        if (degreeCurricularPlansIDs.length == 0) {
            throw new DomainException("error.selection.noDegree", new String[0]);
        }
        HashMap<String, Pair<Integer, String>> numberExecutionCoursesPerDCP = new HashMap<String, Pair<Integer, String>>();
        for (String degreeCurricularPlanID : degreeCurricularPlansIDs) {
            int numberExecutionCourses = 0;
            StringBuilder curricularCodes = new StringBuilder();
            DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanID);
            Set<CurricularCourse> curricularCourses = degreeCurricularPlan.getCurricularCoursesSet();
            for (CurricularCourse curricularCourse : curricularCourses) {
                String originalCode;
                if (curricularCourse.isOptionalCurricularCourse() || curricularCourse.getActiveDegreeModuleScopesInExecutionPeriod(executionSemester).isEmpty() || !curricularCourse.getExecutionCoursesByExecutionPeriod(executionSemester).isEmpty() || (originalCode = CreateExecutionCoursesForDegreeCurricularPlansAndExecutionPeriod.getCodeForCurricularCourse(curricularCourse)) == null) continue;
                String sigla = CreateExecutionCoursesForDegreeCurricularPlansAndExecutionPeriod.getUniqueSigla(existentsExecutionCoursesSiglas, originalCode);
                ExecutionCourse executionCourse = new ExecutionCourse(curricularCourse.getName(), sigla, executionSemester, null);
                curricularCourse.addAssociatedExecutionCourses(executionCourse);
                ++numberExecutionCourses;
                curricularCodes.append(curricularCourse.getAcronym() + ", ");
            }
            if (curricularCodes.length() > 0) {
                curricularCodes.setLength(curricularCodes.length() - 2);
            }
            numberExecutionCoursesPerDCP.put(degreeCurricularPlanID, new Pair<Integer, String>(numberExecutionCourses, curricularCodes.toString()));
        }
        return numberExecutionCoursesPerDCP;
    }

    private static String getCodeForCurricularCourse(CurricularCourse curricularCourse) {
        if (curricularCourse.getAcronym() != null) {
            return curricularCourse.getAcronym();
        }
        CompetenceCourse competenceCourse = curricularCourse.getCompetenceCourse();
        if (competenceCourse != null) {
            return competenceCourse.getCode();
        }
        if (curricularCourse.getCode() != null) {
            return curricularCourse.getCode();
        }
        return null;
    }

    public static String getUniqueSigla(Set<String> existentsExecutionCoursesSiglas, String sigla) {
        if (existentsExecutionCoursesSiglas.contains(sigla.toUpperCase())) {
            int suffix = 1;
            while (existentsExecutionCoursesSiglas.contains((sigla + "-" + ++suffix).toUpperCase())) {
            }
            sigla = sigla + "-" + suffix;
        }
        existentsExecutionCoursesSiglas.add(sigla.toUpperCase());
        return sigla;
    }

    private static Set<String> readExistingExecutionCoursesSiglas(ExecutionSemester executionSemester) {
        HashSet<String> existingExecutionCoursesSiglas = new HashSet<String>();
        for (ExecutionCourse executionCourse : executionSemester.getAssociatedExecutionCoursesSet()) {
            existingExecutionCoursesSiglas.add(executionCourse.getSigla().toUpperCase());
        }
        return existingExecutionCoursesSiglas;
    }
}

