/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.factoryExecutors;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.CustomServiceRequestRequest;
import org.fenixedu.academic.domain.serviceRequests.Under23TransportsDeclarationRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.CertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DeclarationRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DiplomaSupplementRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.RegistryDiplomaRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.fenixedu.academic.service.factoryExecutors.DocumentRequestCreator$callable$execute;
import org.fenixedu.academic.service.services.commons.FactoryExecutor;
import org.fenixedu.academic.service.services.serviceRequests.documentRequests.CreatePastDiplomaRequest;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public final class DocumentRequestCreator
extends DocumentRequestCreateBean
implements FactoryExecutor {
    private static final long serialVersionUID = 1L;
    public static final Advice advice$execute = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public DocumentRequestCreator(Registration registration) {
        super(registration);
    }

    @Override
    public Object execute() {
        return advice$execute.perform((Callable)new DocumentRequestCreator$callable$execute(this));
    }

    static /* synthetic */ Object advised$execute(DocumentRequestCreator this_) {
        Object academicServiceRequest = null;
        if (!this_.getChosenServiceRequestType().isLegacy()) {
            academicServiceRequest = CustomServiceRequestRequest.create(this_);
        } else {
            DocumentRequestType requestType = this_.getChosenServiceRequestType().getDocumentRequestType();
            if (requestType.isCertificate()) {
                academicServiceRequest = CertificateRequest.create(this_);
            } else if (requestType.isDeclaration()) {
                if (this_.getExecutionYear() == null) {
                    this_.setExecutionYear(ExecutionYear.readCurrentExecutionYear());
                }
                academicServiceRequest = DeclarationRequest.create(this_);
            } else if (requestType.isDiploma()) {
                academicServiceRequest = new DiplomaRequest(this_);
            } else if (requestType.isRegistryDiploma()) {
                academicServiceRequest = new RegistryDiplomaRequest(this_);
            } else if (requestType.isPastDiploma()) {
                academicServiceRequest = CreatePastDiplomaRequest.create(this_);
            } else if (requestType.isDiplomaSupplement()) {
                academicServiceRequest = new DiplomaSupplementRequest(this_);
            } else if (requestType == DocumentRequestType.UNDER_23_TRANSPORTS_REQUEST) {
                academicServiceRequest = new Under23TransportsDeclarationRequest(this_);
            }
        }
        if (academicServiceRequest == null) {
            throw new DomainException("error.DocumentRequestCreator.unexpected.document.request.type", new String[0]);
        }
        Signal.emit((String)"ACADEMIC_SERVICE_REQUEST_NEW_SITUATION_EVENT", (Object)new DomainObjectEvent((DomainObject)academicServiceRequest));
        return academicServiceRequest;
    }
}

