/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.residenceManagement;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fenixedu.academic.domain.accounting.ResidenceEvent;
import org.fenixedu.academic.domain.residence.ResidenceMonth;
import org.fenixedu.academic.dto.residenceManagement.ResidenceEventBean;
import org.fenixedu.academic.util.Money;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class ResidenceDebtEventBean
extends ResidenceEventBean {
    private Money roomValuePaid;
    private String paidDate;
    private YearMonthDay paidDateObject;
    private ResidenceEvent eventObject;
    private ResidenceMonth month;

    public ResidenceDebtEventBean(String userName, String fiscalNumber, String name, Double roomValue, String room, String paidDate, Double roomValuePaid) {
        super(userName, fiscalNumber, name, roomValue, room);
        this.setPaidDate(paidDate);
        this.setRoomValuePaid(new Money(roomValuePaid));
    }

    public void setRoomValuePaid(Money roomValuePaid) {
        this.roomValuePaid = roomValuePaid;
    }

    public Money getRoomValuePaid() {
        return this.roomValuePaid;
    }

    public void setPaidDate(String paidDate) {
        this.paidDate = paidDate;
    }

    public String getPaidDate() {
        return this.paidDate;
    }

    @Override
    public boolean getStatus() {
        if (!super.getStatus()) {
            return false;
        }
        String date = this.getPaidDate();
        Pattern p = Pattern.compile("^(\\d\\d).(\\d\\d).((\\d\\d){1,2})$");
        Matcher m = p.matcher(date);
        if (!m.matches()) {
            this.setStatusMessage("label.error.invalid.date");
            return false;
        }
        int day = Integer.valueOf(m.group(1));
        int month = Integer.valueOf(m.group(2));
        int year = m.group(3).length() == 2 ? 2000 + Integer.valueOf(m.group(3)) : Integer.valueOf(m.group(3));
        this.setPaidDateObject(new YearMonthDay(year, month, day));
        if (this.getPaidDate() == null) {
            this.setStatusMessage("label.error.invalid.date");
            return false;
        }
        if (this.getRoomValuePaid() == null) {
            this.setStatusMessage("label.error.invalid.payment.amount");
            return false;
        }
        for (ResidenceEvent residenceEvent : this.getMonth().getEventsSet()) {
            if (residenceEvent.getPerson() != this.getStudent().getPerson()) continue;
            if (!residenceEvent.isOpen()) {
                this.setStatusMessage("label.error.already.paid");
                return false;
            }
            if (this.getPaidDateObject().isAfter((ReadablePartial)new YearMonthDay())) {
                this.setStatusMessage("label.error.invalid.date");
                return false;
            }
            if (!residenceEvent.getAmountToPay().equals(this.getRoomValuePaid())) {
                this.setStatusMessage("label.error.invalid.payment.amount");
                return false;
            }
            this.setEventObject(residenceEvent);
            this.setPaidDateObject(new YearMonthDay(year, month, day));
            break;
        }
        if (this.getEventObject() == null) {
            this.setStatusMessage("label.error.invalid.payment.amount");
            return false;
        }
        return true;
    }

    public YearMonthDay getPaidDateObject() {
        return this.paidDateObject;
    }

    public void setPaidDateObject(YearMonthDay paidDateObject) {
        this.paidDateObject = paidDateObject;
    }

    public ResidenceEvent getEventObject() {
        return this.eventObject;
    }

    public void setEventObject(ResidenceEvent eventObject) {
        this.eventObject = eventObject;
    }

    public ResidenceMonth getMonth() {
        return this.month;
    }

    public void setMonth(ResidenceMonth month) {
        this.month = month;
    }
}

