/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.StatuteType$callable$delete;
import org.fenixedu.academic.domain.student.StatuteType_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class StatuteType
extends StatuteType_Base {
    public static Comparator<StatuteType> COMPARATOR_BY_NAME;
    public static final Advice advice$delete;

    private StatuteType() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public StatuteType(String code, LocalizedString name, boolean workingStudentStatute, boolean associativeLeaderStatute, boolean specialSeasonGrantedByRequest, boolean grantOwnerStatute, boolean seniorStatute, boolean handicappedStatute, boolean active, boolean explicitCreation, boolean visible, boolean specialSeasonGranted, boolean appliedOnRegistration) {
        this(code, name, workingStudentStatute, associativeLeaderStatute, specialSeasonGrantedByRequest, grantOwnerStatute, seniorStatute, handicappedStatute, active, explicitCreation, visible, specialSeasonGranted);
        this.setAppliedOnRegistration(appliedOnRegistration);
        this.checkRules();
    }

    @Deprecated
    public StatuteType(String code, LocalizedString name, boolean workingStudentStatute, boolean associativeLeaderStatute, boolean specialSeasonGrantedByRequest, boolean grantOwnerStatute, boolean seniorStatute, boolean handicappedStatute, boolean active, boolean explicitCreation, boolean visible, boolean specialSeasonGranted) {
        this();
        this.setCode(code);
        this.setName(name);
        this.setWorkingStudentStatute(workingStudentStatute);
        this.setAssociativeLeaderStatute(associativeLeaderStatute);
        this.setSpecialSeasonGrantedByRequest(specialSeasonGrantedByRequest);
        this.setGrantOwnerStatute(grantOwnerStatute);
        this.setSeniorStatute(seniorStatute);
        this.setHandicappedStatute(handicappedStatute);
        this.setActive(active);
        this.setExplicitCreation(explicitCreation);
        this.setVisible(visible);
        this.setSpecialSeasonGranted(specialSeasonGranted);
        this.checkRules();
    }

    public void setCode(String code) {
        if (code == null || code.trim().isEmpty()) {
            super.setCode(null);
        } else {
            if (StatuteType.readAll(new Predicate[0]).filter(statute -> code.equals(statute.getCode()) && statute != this).findAny().isPresent()) {
                throw new DomainException("error.StatuteType.code.alreadyUsed", new String[0]);
            }
            super.setCode(code);
        }
    }

    protected void checkRules() {
        StatuteType.check(this.getName(), "error.StatuteType.name.required", new String[0]);
    }

    private static void check(Object obj, String message, String ... args) {
        if (obj == null) {
            throw new DomainException(message, args);
        }
    }

    public boolean isWorkingStudentStatute() {
        return this.getWorkingStudentStatute();
    }

    @Deprecated
    public boolean isAssociativeLeaderStatute() {
        return this.getAssociativeLeaderStatute();
    }

    @Deprecated
    public boolean isSpecialSeasonGrantedByRequest() {
        return this.getSpecialSeasonGrantedByRequest();
    }

    public boolean isGrantOwnerStatute() {
        return this.getGrantOwnerStatute();
    }

    public boolean isSeniorStatute() {
        return this.getSeniorStatute();
    }

    public boolean isHandicappedStatute() {
        return this.getHandicappedStatute();
    }

    public boolean isAppliedOnRegistration() {
        return this.getAppliedOnRegistration();
    }

    @Deprecated
    public boolean isActive() {
        return this.getActive();
    }

    public boolean isDeletable() {
        return this.getStudentStatutesSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new StatuteType$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(StatuteType this_) {
        if (!this_.isDeletable()) {
            throw new DomainException("error.StatuteType.deletion.not.possible", new String[0]);
        }
        this_.setRootDomainObject(null);
        this_.deleteDomainObject();
    }

    @SafeVarargs
    public static Stream<StatuteType> readAll(Predicate<StatuteType> ... predicates) {
        Stream<StatuteType> statuteTypes = Bennu.getInstance().getStatuteTypesSet().stream();
        for (Predicate<StatuteType> predicate : predicates) {
            statuteTypes = statuteTypes.filter(predicate);
        }
        return statuteTypes;
    }

    public static Optional<StatuteType> findSpecialSeasonGrantedByRequestStatuteType() {
        return StatuteType.readAll(StatuteType::isSpecialSeasonGrantedByRequest).findFirst();
    }

    public static Optional<StatuteType> findSeniorStatuteType() {
        return StatuteType.readAll(StatuteType::isSeniorStatute).findFirst();
    }

    public static Optional<StatuteType> findHandicappedStatuteType() {
        return StatuteType.readAll(StatuteType::isHandicappedStatute).findFirst();
    }

    @Deprecated
    public boolean isExplicitCreation() {
        return this.getExplicitCreation();
    }

    public boolean isVisible() {
        return this.getVisible();
    }

    public boolean isSpecialSeasonGranted() {
        return this.getSpecialSeasonGranted();
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_NAME = Comparator.comparing(StatuteType_Base::getName).thenComparing(DomainObjectUtil.COMPARATOR_BY_ID);
    }
}

