/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.phd.InternalPhdParticipant;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.PhdProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.debts.PhdThesisRequestFee;
import org.fenixedu.academic.domain.phd.migration.activities.SkipThesisJuryActivities;
import org.fenixedu.academic.domain.phd.thesis.PhdJuryElementsRatificationEntity;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisJuryElementBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess$callable$createRequestFee;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessState;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess_Base;
import org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement;
import org.fenixedu.academic.domain.phd.thesis.activities.AddJuryElement;
import org.fenixedu.academic.domain.phd.thesis.activities.AddPresidentJuryElement;
import org.fenixedu.academic.domain.phd.thesis.activities.AddState;
import org.fenixedu.academic.domain.phd.thesis.activities.ConcludePhdProcess;
import org.fenixedu.academic.domain.phd.thesis.activities.DeleteDocument;
import org.fenixedu.academic.domain.phd.thesis.activities.DeleteJuryElement;
import org.fenixedu.academic.domain.phd.thesis.activities.DownloadFinalThesisDocument;
import org.fenixedu.academic.domain.phd.thesis.activities.DownloadProvisionalThesisDocument;
import org.fenixedu.academic.domain.phd.thesis.activities.DownloadThesisRequirement;
import org.fenixedu.academic.domain.phd.thesis.activities.EditJuryElement;
import org.fenixedu.academic.domain.phd.thesis.activities.EditPhdThesisProcessInformation;
import org.fenixedu.academic.domain.phd.thesis.activities.JuryDocumentsDownload;
import org.fenixedu.academic.domain.phd.thesis.activities.JuryReporterFeedbackExternalUpload;
import org.fenixedu.academic.domain.phd.thesis.activities.JuryReporterFeedbackUpload;
import org.fenixedu.academic.domain.phd.thesis.activities.JuryReviewDocumentsDownload;
import org.fenixedu.academic.domain.phd.thesis.activities.MoveJuryElementOrder;
import org.fenixedu.academic.domain.phd.thesis.activities.PhdThesisActivity;
import org.fenixedu.academic.domain.phd.thesis.activities.PrintJuryElementsDocument;
import org.fenixedu.academic.domain.phd.thesis.activities.RatifyFinalThesis;
import org.fenixedu.academic.domain.phd.thesis.activities.RejectJuryElements;
import org.fenixedu.academic.domain.phd.thesis.activities.RejectJuryElementsDocuments;
import org.fenixedu.academic.domain.phd.thesis.activities.RemindJuryReviewToReporters;
import org.fenixedu.academic.domain.phd.thesis.activities.RemoveLastState;
import org.fenixedu.academic.domain.phd.thesis.activities.ReplaceDocument;
import org.fenixedu.academic.domain.phd.thesis.activities.RequestJuryElements;
import org.fenixedu.academic.domain.phd.thesis.activities.RequestJuryReviews;
import org.fenixedu.academic.domain.phd.thesis.activities.ScheduleThesisDiscussion;
import org.fenixedu.academic.domain.phd.thesis.activities.SetFinalGrade;
import org.fenixedu.academic.domain.phd.thesis.activities.SetPhdJuryElementRatificationEntity;
import org.fenixedu.academic.domain.phd.thesis.activities.SkipScheduleThesisDiscussion;
import org.fenixedu.academic.domain.phd.thesis.activities.SubmitJuryElementsDocuments;
import org.fenixedu.academic.domain.phd.thesis.activities.SubmitThesis;
import org.fenixedu.academic.domain.phd.thesis.activities.SwapJuryElementsOrder;
import org.fenixedu.academic.domain.phd.thesis.activities.UploadDocuments;
import org.fenixedu.academic.domain.phd.thesis.activities.ValidateJury;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcessStateType;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdThesisProcess
extends PhdThesisProcess_Base {
    private static List<Activity> activities;
    public static final Advice advice$createRequestFee;

    public boolean isAllowedToManageProcess(User userView) {
        return this.getIndividualProgramProcess().isAllowedToManageProcess(userView);
    }

    private PhdThesisProcess() {
    }

    public boolean isJuryValidated() {
        return this.getWhenJuryValidated() != null;
    }

    public boolean isFinalThesisRatified() {
        return this.getWhenFinalThesisRatified() != null;
    }

    public void swapJuryElementsOrder(ThesisJuryElement e1, ThesisJuryElement e2) {
        if (this.getThesisJuryElementsSet().contains((Object)e1) && this.getThesisJuryElementsSet().contains((Object)e2)) {
            Integer order1 = e1.getElementOrder();
            Integer order2 = e2.getElementOrder();
            e1.setElementOrder(order2);
            e2.setElementOrder(order1);
        }
    }

    public void deleteJuryElement(ThesisJuryElement element) {
        if (this.getThesisJuryElementsSet().contains((Object)element)) {
            Integer elementOrder = element.getElementOrder();
            element.delete();
            this.reorderJuryElements(elementOrder);
        }
    }

    private void reorderJuryElements(Integer removedElementOrder) {
        for (ThesisJuryElement element : this.getOrderedThesisJuryElements()) {
            if (element.getElementOrder().compareTo(removedElementOrder) <= 0) continue;
            element.setElementOrder(element.getElementOrder() - 1);
        }
    }

    public TreeSet<ThesisJuryElement> getOrderedThesisJuryElements() {
        TreeSet<ThesisJuryElement> result = new TreeSet<ThesisJuryElement>(ThesisJuryElement.COMPARATOR_BY_ELEMENT_ORDER);
        result.addAll(this.getThesisJuryElementsSet());
        return result;
    }

    public void createState(PhdThesisProcessStateType type, Person person, String remarks) {
        PhdThesisProcessState.createWithInferredStateDate(this, type, person, remarks);
    }

    public Person getPerson() {
        return this.getIndividualProgramProcess().getPerson();
    }

    public boolean canExecuteActivity(User userView) {
        return false;
    }

    public List<Activity> getActivities() {
        return activities;
    }

    public String getDisplayName() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)((Object)((Object)this)).getClass().getSimpleName(), (String[])new String[0]);
    }

    public PhdThesisProcessState getMostRecentState() {
        return (PhdThesisProcessState)((Object)super.getMostRecentState());
    }

    public PhdThesisProcessStateType getActiveState() {
        return (PhdThesisProcessStateType)super.getActiveState();
    }

    public PhdProgramProcessDocument getProvisionalThesisDocument() {
        return this.getLatestDocumentVersionFor(PhdIndividualProgramDocumentType.PROVISIONAL_THESIS);
    }

    public boolean hasProvisionalThesisDocument() {
        return this.getProvisionalThesisDocument() != null;
    }

    public PhdProgramProcessDocument getFinalThesisDocument() {
        return this.getLatestDocumentVersionFor(PhdIndividualProgramDocumentType.FINAL_THESIS);
    }

    public boolean hasFinalThesisDocument() {
        return this.getFinalThesisDocument() != null;
    }

    public PhdProgramProcessDocument getThesisRequirementDocument() {
        return this.getLatestDocumentVersionFor(PhdIndividualProgramDocumentType.THESIS_REQUIREMENT);
    }

    public boolean hasThesisRequirementDocument() {
        return this.getThesisRequirementDocument() != null;
    }

    public boolean isConcluded() {
        return this.getActiveState() == PhdThesisProcessStateType.CONCLUDED;
    }

    public PhdProgramProcessDocument getJuryElementsDocument() {
        return this.getLatestDocumentVersionFor(PhdIndividualProgramDocumentType.JURY_ELEMENTS);
    }

    public Boolean hasJuryElementsDocument() {
        return this.getJuryElementsDocument() != null;
    }

    public PhdProgramProcessDocument getJuryPresidentDocument() {
        return this.getLatestDocumentVersionFor(PhdIndividualProgramDocumentType.JURY_PRESIDENT_ELEMENT);
    }

    public Boolean hasJuryPresidentDocument() {
        return this.getJuryPresidentDocument() != null;
    }

    public DateTime getWhenRequestJury() {
        if (this.getWhenJuryRequired() == null) {
            return null;
        }
        return this.getWhenJuryRequired().toDateTimeAtStartOfDay();
    }

    public DateTime getWhenReceivedJury() {
        return this.getLastExecutionDateOf(SubmitJuryElementsDocuments.class);
    }

    public DateTime getWhenRequestedJuryReviews() {
        return this.getLastExecutionDateOf(RequestJuryReviews.class);
    }

    public PhdParticipant getParticipant(Person person) {
        return this.getIndividualProgramProcess().getParticipant(person);
    }

    public boolean isParticipant(Person person) {
        return this.getIndividualProgramProcess().isParticipant(person);
    }

    public ThesisJuryElement getThesisJuryElement(Person person) {
        for (ThesisJuryElement element : this.getThesisJuryElementsSet()) {
            if (!element.isFor(person)) continue;
            return element;
        }
        return null;
    }

    public boolean isPresidentJuryElement(Person person) {
        return this.getPresidentJuryElement() != null && this.getPresidentJuryElement().isFor(person);
    }

    public List<PhdProgramProcessDocument> getThesisDocumentsToFeedback() {
        ArrayList<PhdProgramProcessDocument> documents = new ArrayList<PhdProgramProcessDocument>(3);
        this.addDocument(documents, this.getLatestDocumentVersionFor(PhdIndividualProgramDocumentType.THESIS_REQUIREMENT));
        this.addDocument(documents, this.getLatestDocumentVersionFor(PhdIndividualProgramDocumentType.THESIS_ABSTRACT));
        this.addDocument(documents, this.getLatestDocumentVersionFor(PhdIndividualProgramDocumentType.PROVISIONAL_THESIS));
        this.addDocument(documents, this.getCV());
        return documents;
    }

    private void addDocument(List<PhdProgramProcessDocument> documents, PhdProgramProcessDocument document) {
        if (document != null) {
            documents.add(document);
        }
    }

    private PhdProgramProcessDocument getCV() {
        PhdProgramProcessDocument cv = this.getLatestDocumentVersionFor(PhdIndividualProgramDocumentType.CV);
        return cv != null ? cv : this.getCandidacyProcess().getLatestDocumentVersionFor(PhdIndividualProgramDocumentType.CV);
    }

    private PhdProgramProcess getCandidacyProcess() {
        return this.getIndividualProgramProcess().getCandidacyProcess();
    }

    public String getProcessNumber() {
        return this.getIndividualProgramProcess().getProcessNumber();
    }

    public Collection<ThesisJuryElement> getReportThesisJuryElements() {
        ArrayList<ThesisJuryElement> result = new ArrayList<ThesisJuryElement>();
        for (ThesisJuryElement element : this.getThesisJuryElementsSet()) {
            if (!element.getReporter().booleanValue()) continue;
            result.add(element);
        }
        return result;
    }

    public boolean isWaitingForJuryReporterFeedback() {
        return this.getActiveState() == PhdThesisProcessStateType.WAITING_FOR_JURY_REPORTER_FEEDBACK;
    }

    public boolean isAnyDocumentToValidate() {
        for (ThesisJuryElement element : this.getThesisJuryElementsSet()) {
            if (!element.getReporter().booleanValue() || element.isDocumentValidated()) continue;
            return true;
        }
        return false;
    }

    public Collection<PhdProgramProcessDocument> getReportThesisJuryElementDocuments() {
        HashSet<PhdProgramProcessDocument> result = new HashSet<PhdProgramProcessDocument>();
        for (ThesisJuryElement element : this.getThesisJuryElementsSet()) {
            if (!element.getReporter().booleanValue() || !element.isDocumentValidated()) continue;
            result.add((PhdProgramProcessDocument)((Object)element.getLastFeedbackDocument()));
        }
        return result;
    }

    public PhdProgramProcessDocument getJuryMeetingMinutesDocument() {
        return this.getLatestDocumentVersionFor(PhdIndividualProgramDocumentType.JURY_MEETING_MINUTES);
    }

    protected void addDocuments(List<PhdProgramDocumentUploadBean> documents, Person responsible) {
        for (PhdProgramDocumentUploadBean each : documents) {
            if (each.isRequired() && !each.hasAnyInformation()) {
                throw new DomainException("error.PhdThesisProcess.document.is.required.and.no.information.given", each.getType().getLocalizedName());
            }
            if (!each.hasAnyInformation()) continue;
            this.addDocument(each, responsible);
        }
    }

    public void rejectJuryElementsDocuments() {
        if (this.hasJuryElementsDocument().booleanValue()) {
            this.getJuryElementsDocument().setDocumentAccepted(false);
        }
        if (this.hasJuryPresidentDocument().booleanValue()) {
            this.getJuryPresidentDocument().setDocumentAccepted(false);
        }
    }

    public void deleteLastState() {
        if (this.getStates().size() <= 1) {
            throw new DomainException("error.PhdThesisProcess.states.size.is.one", new String[0]);
        }
        this.getMostRecentState().delete();
    }

    public void checkJuryPresidentNotGuider(PhdThesisJuryElementBean bean) {
        PhdIndividualProgramProcess process2 = this.getIndividualProgramProcess();
        for (PhdParticipant processParticipant : process2.getParticipantsSet()) {
            if (processParticipant == bean.getParticipant()) {
                if (!process2.isGuider(processParticipant) && !process2.isAssistantGuider(processParticipant)) break;
                throw new DomainException("error.PhdThesisProcess.president.cannot.be.guider.or.assistantguider", new String[0]);
            }
            if (!processParticipant.isFor(this.retrievePersonFromParticipantBean(bean)) || !process2.isGuider(processParticipant) && !process2.isAssistantGuider(processParticipant)) continue;
            throw new DomainException("error.PhdThesisProcess.president.cannot.be.guider.or.assistantguider", new String[0]);
        }
    }

    public void checkJuryReporterNotGuider(PhdThesisJuryElementBean bean) {
        if (!bean.isReporter()) {
            return;
        }
        PhdIndividualProgramProcess process2 = this.getIndividualProgramProcess();
        for (PhdParticipant processParticipant : process2.getParticipantsSet()) {
            if (processParticipant == bean.getParticipant()) {
                if (!process2.isGuider(processParticipant) && !process2.isAssistantGuider(processParticipant)) break;
                throw new DomainException("error.PhdThesisProcess.reporter.cannot.be.guider.or.assistantguider", new String[0]);
            }
            if (!processParticipant.isFor(this.retrievePersonFromParticipantBean(bean)) || !process2.isGuider(processParticipant) && !process2.isAssistantGuider(processParticipant)) continue;
            throw new DomainException("error.PhdThesisProcess.reporter.cannot.be.guider.or.assistantguider", new String[0]);
        }
    }

    private Person retrievePersonFromParticipantBean(PhdThesisJuryElementBean participantBean) {
        if (participantBean.getParticipant() == null) {
            return participantBean.getPerson();
        }
        if (participantBean.getParticipant() != null && participantBean.getParticipant().isInternal()) {
            return ((InternalPhdParticipant)((Object)participantBean.getParticipant())).getPerson();
        }
        return null;
    }

    public PhdMeetingSchedulingProcessStateType getPhdMeetingSchedulingActiveState() {
        if (this.getMeetingProcess() == null) {
            return null;
        }
        return this.getMeetingProcess().getActiveState();
    }

    public List<PhdThesisProcessStateType> getPossibleNextStates() {
        PhdThesisProcessStateType currentState = this.getActiveState();
        if (currentState == null) {
            return Collections.singletonList(PhdThesisProcessStateType.NEW);
        }
        switch (currentState) {
            case NEW: {
                return Arrays.asList(PhdThesisProcessStateType.WAITING_FOR_JURY_CONSTITUTION, PhdThesisProcessStateType.WAITING_FOR_JURY_REPORTER_FEEDBACK);
            }
            case WAITING_FOR_JURY_CONSTITUTION: {
                return Arrays.asList(PhdThesisProcessStateType.JURY_WAITING_FOR_VALIDATION, PhdThesisProcessStateType.JURY_VALIDATED, PhdThesisProcessStateType.WAITING_FOR_JURY_REPORTER_FEEDBACK);
            }
            case JURY_WAITING_FOR_VALIDATION: {
                return Arrays.asList(PhdThesisProcessStateType.JURY_VALIDATED, PhdThesisProcessStateType.WAITING_FOR_JURY_REPORTER_FEEDBACK);
            }
            case JURY_VALIDATED: {
                return Collections.singletonList(PhdThesisProcessStateType.WAITING_FOR_JURY_REPORTER_FEEDBACK);
            }
            case WAITING_FOR_JURY_REPORTER_FEEDBACK: {
                return Collections.singletonList(PhdThesisProcessStateType.WAITING_FOR_THESIS_MEETING_SCHEDULING);
            }
            case WAITING_FOR_THESIS_MEETING_SCHEDULING: {
                return Collections.singletonList(PhdThesisProcessStateType.WAITING_FOR_THESIS_DISCUSSION_DATE_SCHEDULING);
            }
            case WAITING_FOR_THESIS_DISCUSSION_DATE_SCHEDULING: {
                return Collections.singletonList(PhdThesisProcessStateType.THESIS_DISCUSSION_DATE_SCHECULED);
            }
            case THESIS_DISCUSSION_DATE_SCHECULED: {
                return Collections.singletonList(PhdThesisProcessStateType.WAITING_FOR_THESIS_RATIFICATION);
            }
            case WAITING_FOR_THESIS_RATIFICATION: {
                return Collections.singletonList(PhdThesisProcessStateType.WAITING_FOR_FINAL_GRADE);
            }
            case WAITING_FOR_FINAL_GRADE: {
                return Collections.singletonList(PhdThesisProcessStateType.CONCLUDED);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public void removeLastState() {
        if (this.getStatesSet().size() <= 1) {
            throw new DomainException("phd.thesis.PhdThesisProcess.cannot.remove.state", new String[0]);
        }
        this.getMostRecentState().delete();
    }

    public PhdThesisProcess edit(User userView, PhdThesisProcessBean bean) {
        this.setWhenThesisDiscussionRequired(bean.getWhenThesisDiscussionRequired());
        this.setWhenJuryRequired(bean.getWhenJuryRequested());
        this.setWhenJuryValidated(bean.getWhenJuryValidated());
        this.setWhenJuryDesignated(bean.getWhenJuryDesignated());
        this.setWhenFinalThesisRatified(bean.getWhenFinalThesisRatified());
        this.setConclusionDate(bean.getConclusionDate());
        this.setFinalGrade(bean.getFinalGrade());
        return this;
    }

    public PhdJuryElementsRatificationEntity getPhdJuryElementsRatificationEntity() {
        if (super.getPhdJuryElementsRatificationEntity() == null) {
            return PhdJuryElementsRatificationEntity.BY_COORDINATOR;
        }
        return super.getPhdJuryElementsRatificationEntity();
    }

    public void createRequestFee() {
        Object object = advice$createRequestFee.perform((Callable)new PhdThesisProcess$callable$createRequestFee(this));
    }

    static /* synthetic */ void advised$createRequestFee(PhdThesisProcess this_) {
        new PhdThesisRequestFee(this_.getIndividualProgramProcess());
    }

    @Deprecated
    public Set<PhdThesisProcessState> getStates() {
        return this.getStatesSet();
    }

    public boolean hasAnyStates() {
        return !this.getStatesSet().isEmpty();
    }

    static {
        advice$createRequestFee = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        activities = new ArrayList<Activity>();
        activities.add(new RequestJuryElements());
        activities.add(new SubmitJuryElementsDocuments());
        activities.add(new AddJuryElement());
        activities.add(new EditJuryElement());
        activities.add(new DeleteJuryElement());
        activities.add(new SwapJuryElementsOrder());
        activities.add(new MoveJuryElementOrder());
        activities.add(new AddPresidentJuryElement());
        activities.add(new ValidateJury());
        activities.add(new PrintJuryElementsDocument());
        activities.add(new RejectJuryElements());
        activities.add(new SubmitThesis());
        activities.add(new DownloadProvisionalThesisDocument());
        activities.add(new DownloadFinalThesisDocument());
        activities.add(new DownloadThesisRequirement());
        activities.add(new RequestJuryReviews());
        activities.add(new RemindJuryReviewToReporters());
        activities.add(new JuryDocumentsDownload());
        activities.add(new JuryReporterFeedbackUpload());
        activities.add(new JuryReporterFeedbackExternalUpload());
        activities.add(new JuryReviewDocumentsDownload());
        activities.add(new ScheduleThesisDiscussion());
        activities.add(new RatifyFinalThesis());
        activities.add(new SetFinalGrade());
        activities.add(new RejectJuryElementsDocuments());
        activities.add(new ReplaceDocument());
        activities.add(new AddState());
        activities.add(new RemoveLastState());
        activities.add(new SkipThesisJuryActivities());
        activities.add(new SkipScheduleThesisDiscussion());
        activities.add(new EditPhdThesisProcessInformation());
        activities.add(new ConcludePhdProcess());
        activities.add(new SetPhdJuryElementRatificationEntity());
        activities.add(new UploadDocuments());
        activities.add(new DeleteDocument());
    }

    @StartActivity
    public static class RequestThesis
    extends PhdThesisActivity {
        @Override
        public void activityPreConditions(PhdThesisProcess process2, User userView) {
        }

        @Override
        protected PhdThesisProcess executeActivity(PhdThesisProcess process2, User userView, Object object) {
            PhdThesisProcessBean bean = (PhdThesisProcessBean)object;
            LocalDate whenThesisDiscussionRequired = bean.getWhenThesisDiscussionRequired();
            PhdThesisProcess result = new PhdThesisProcess();
            result.setIndividualProgramProcess(bean.getProcess());
            result.addDocuments(bean.getDocuments(), userView.getPerson());
            result.setWhenThesisDiscussionRequired(whenThesisDiscussionRequired);
            result.setWhenJuryRequired(bean.getWhenThesisDiscussionRequired());
            String presidentTitlePt = MessageFormat.format(BundleUtil.getString((String)"resources.PhdResources", (Locale)new Locale("pt", "PT"), (String)"message.phd.thesis.president.title.default", (String[])new String[0]), Unit.getInstitutionAcronym());
            String presidentTitleEn = MessageFormat.format(BundleUtil.getString((String)"resources.PhdResources", (Locale)new Locale("en", "EN"), (String)"message.phd.thesis.president.title.default", (String[])new String[0]), Unit.getInstitutionAcronym());
            result.setPresidentTitle(new MultiLanguageString(MultiLanguageString.pt, presidentTitlePt).with(MultiLanguageString.en, presidentTitleEn));
            if (!result.getIndividualProgramProcess().isMigratedProcess()) {
                new PhdThesisRequestFee(bean.getProcess());
            }
            result.createState(PhdThesisProcessStateType.NEW, userView.getPerson(), bean.getRemarks());
            return result;
        }
    }
}

