/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.mobility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.QueueJob;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessState;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyPersonalDetails;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusApplyForSemesterType;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusCoordinatorBean;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusVacancyBean;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ReceptionEmailExecutedAction;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.SendReceptionEmailBean;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.reports.ErasmusCandidacyProcessReport;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcess_Base;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityCoordinator;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplate;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplateType;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityQuota;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacyProcess;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.MobilityApplicationPeriod;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class MobilityApplicationProcess
extends MobilityApplicationProcess_Base {
    public static final Comparator<IndividualCandidacyProcess> COMPARATOR_BY_CANDIDACY_PERSON = new Comparator<IndividualCandidacyProcess>(){

        @Override
        public int compare(IndividualCandidacyProcess o1, IndividualCandidacyProcess o2) {
            return IndividualCandidacyPersonalDetails.COMPARATOR_BY_NAME_AND_ID.compare(o1.getPersonalDetails(), o2.getPersonalDetails());
        }
    };
    private static List<Activity> activities = new ArrayList<Activity>();
    private static final java.util.function.Predicate<DegreeType> ALLOWED_DEGREE_TYPES;

    public MobilityApplicationProcess() {
    }

    private MobilityApplicationProcess(ExecutionYear executionYear, DateTime start, DateTime end, ErasmusApplyForSemesterType forSemester) {
        this();
        this.checkParameters((ExecutionInterval)((Object)executionYear), start, end);
        this.setState(CandidacyProcessState.STAND_BY);
        this.setForSemester(forSemester);
        new MobilityApplicationPeriod(this, executionYear, start, end);
    }

    public void delete() {
        if (this.getChildProcessesSet().size() > 0) {
            throw new DomainException("error.mobiliy.application.proccess.cant.be.deleted.it.has.individual.application", new String[0]);
        }
        if (this.getCoordinatorsSet().size() > 0) {
            throw new DomainException("error.mobiliy.application.proccess.cant.be.deleted.it.has.coordinators", new String[0]);
        }
        if (this.getCandidacyPeriod() != null) {
            throw new DomainException("error.mobiliy.application.proccess.cant.be.deleted.it.defined.period", new String[0]);
        }
        if (this.getErasmusCandidacyProcessExecutedActionSet().size() > 0) {
            throw new DomainException("error.mobiliy.application.proccess.cant.be.deleted.it.has.executed.actions", new String[0]);
        }
        if (this.getErasmusCandidacyProcessReportsSet().size() > 0) {
            throw new DomainException("error.mobiliy.application.proccess.cant.be.deleted.it.has.reports", new String[0]);
        }
        if (this.getProcessLogsSet().size() > 0) {
            throw new DomainException("error.mobiliy.application.proccess.cant.be.deleted.it.has.logs", new String[0]);
        }
        this.setForSemester(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public void resetConfigurations() {
        if (this.getChildProcessesSet().size() > 0) {
            throw new DomainException("error.mobility.application.process.cant.delete.configurations.it.has.applications", new String[0]);
        }
        for (MobilityQuota quota : this.getCandidacyPeriod().getMobilityQuotasSet()) {
            quota.delete();
        }
        for (MobilityCoordinator coord : this.getCoordinatorsSet()) {
            coord.delete();
        }
        for (MobilityEmailTemplate template : this.getApplicationPeriod().getEmailTemplatesSet()) {
            template.delete();
        }
    }

    public void preLoadLastConfigurations() {
        MobilityApplicationProcess lastProcess = this.getLastSeasonProcess(null);
        Set lastSeasonQuotas = lastProcess.getCandidacyPeriod().getMobilityQuotasSet();
        for (MobilityQuota quota : lastSeasonQuotas) {
            new MobilityQuota(this.getApplicationPeriod(), quota.getDegree(), quota.getMobilityAgreement(), quota.getNumberOfOpenings());
        }
        Set lastSeasonCoordinators = lastProcess.getCoordinatorsSet();
        for (MobilityCoordinator coord : lastSeasonCoordinators) {
            new MobilityCoordinator(this, coord.getTeacher(), coord.getDegree());
        }
        for (MobilityEmailTemplate template : lastProcess.getApplicationPeriod().getEmailTemplatesSet()) {
            MobilityEmailTemplate.create(this.getApplicationPeriod(), template.getMobilityProgram(), template.getType(), template.getSubject(), template.getBody());
        }
    }

    private MobilityApplicationProcess getLastSeasonProcess(ErasmusApplyForSemesterType forSemester) {
        MobilityApplicationProcess lastProcess = null;
        Boolean lookForSameSeasonType = forSemester != null;
        for (Process proc : Bennu.getInstance().getProcessesSet()) {
            MobilityApplicationProcess mobAppProc;
            if (!(proc instanceof MobilityApplicationProcess) || (mobAppProc = (MobilityApplicationProcess)((Object)proc)) == this || lookForSameSeasonType.booleanValue() && mobAppProc.getForSemester() != forSemester) continue;
            if (lastProcess == null) {
                lastProcess = mobAppProc;
                continue;
            }
            if (!mobAppProc.getCandidacyStart().isAfter((ReadableInstant)lastProcess.getCandidacyEnd())) continue;
            lastProcess = mobAppProc;
        }
        return lastProcess;
    }

    public List<MobilityIndividualApplicationProcess> getValidErasmusIndividualCandidacies() {
        ArrayList<MobilityIndividualApplicationProcess> result = new ArrayList<MobilityIndividualApplicationProcess>();
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            MobilityIndividualApplicationProcess process2 = (MobilityIndividualApplicationProcess)((Object)child);
            if (!process2.isCandidacyValid()) continue;
            result.add(process2);
        }
        return result;
    }

    public List<MobilityIndividualApplicationProcess> getValidMobilityIndividualCandidacies(MobilityProgram mobilityProgram) {
        ArrayList<MobilityIndividualApplicationProcess> result = new ArrayList<MobilityIndividualApplicationProcess>();
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            MobilityIndividualApplicationProcess process2 = (MobilityIndividualApplicationProcess)((Object)child);
            if (!process2.isCandidacyValid() || process2.getMobilityProgram() != mobilityProgram) continue;
            result.add(process2);
        }
        return result;
    }

    public List<MobilityIndividualApplicationProcess> getValidErasmusIndividualCandidacies(Degree degree) {
        if (degree == null) {
            return Collections.emptyList();
        }
        ArrayList<MobilityIndividualApplicationProcess> result = new ArrayList<MobilityIndividualApplicationProcess>();
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            MobilityIndividualApplicationProcess process2 = (MobilityIndividualApplicationProcess)((Object)child);
            if (!process2.isCandidacyValid() || !process2.hasCandidacyForSelectedDegree(degree)) continue;
            result.add(process2);
        }
        return result;
    }

    public Map<Degree, SortedSet<MobilityIndividualApplicationProcess>> getValidErasmusIndividualCandidaciesByDegree() {
        TreeMap<Degree, SortedSet<MobilityIndividualApplicationProcess>> result = new TreeMap<Degree, SortedSet<MobilityIndividualApplicationProcess>>(Degree.COMPARATOR_BY_NAME_AND_ID);
        for (IndividualCandidacyProcess child : this.getChildProcessesSet()) {
            MobilityIndividualApplicationProcess process2 = (MobilityIndividualApplicationProcess)((Object)child);
            if (!process2.isCandidacyValid()) continue;
            TreeSet<MobilityIndividualApplicationProcess> values = (TreeSet<MobilityIndividualApplicationProcess>)result.get(process2.getCandidacySelectedDegree());
            if (values == null) {
                values = new TreeSet<MobilityIndividualApplicationProcess>(SecondCycleIndividualCandidacyProcess.COMPARATOR_BY_CANDIDACY_PERSON);
                result.put(process2.getCandidacySelectedDegree(), values);
            }
            values.add(process2);
        }
        return result;
    }

    private void addCandidacy(Map<Degree, SortedSet<SecondCycleIndividualCandidacyProcess>> result, SecondCycleIndividualCandidacyProcess process2) {
        SortedSet<SecondCycleIndividualCandidacyProcess> values = result.get(process2.getCandidacySelectedDegree());
        if (values == null) {
            values = new TreeSet<SecondCycleIndividualCandidacyProcess>(SecondCycleIndividualCandidacyProcess.COMPARATOR_BY_CANDIDACY_PERSON);
            result.put(process2.getCandidacySelectedDegree(), values);
        }
        values.add(process2);
    }

    private void checkParameters(ExecutionInterval executionInterval, DateTime start, DateTime end) {
        if (executionInterval == null) {
            throw new DomainException("error.SecondCycleCandidacyProcess.invalid.executionInterval", new String[0]);
        }
        if (start == null || end == null || start.isAfter((ReadableInstant)end)) {
            throw new DomainException("error.SecondCycleCandidacyProcess.invalid.interval", new String[0]);
        }
    }

    public boolean canExecuteActivity(User userView) {
        return MobilityApplicationProcess.isAllowedToManageProcess(userView) || RoleType.INTERNATIONAL_RELATION_OFFICE.isMember(userView.getPerson().getUser()) || RoleType.COORDINATOR.isMember(userView.getPerson().getUser());
    }

    private static boolean isAllowedToManageProcess(User userView) {
        for (AcademicProgram program : AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_CANDIDACY_PROCESSES, userView.getPerson().getUser()).collect(Collectors.toSet())) {
            if (!ALLOWED_DEGREE_TYPES.test(program.getDegreeType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isInternationalRelationsOfficer(User userView) {
        return RoleType.INTERNATIONAL_RELATION_OFFICE.isMember(userView.getPerson().getUser());
    }

    private static boolean isManager(User userView) {
        return RoleType.MANAGER.isMember(userView.getPerson().getUser());
    }

    public List<Activity> getActivities() {
        return activities;
    }

    public ExecutionYear getCandidacyExecutionInterval() {
        return (ExecutionYear)((Object)super.getCandidacyExecutionInterval());
    }

    private void edit(DateTime start, DateTime end) {
        this.checkParameters((ExecutionInterval)((Object)this.getCandidacyPeriod().getExecutionInterval()), start, end);
        this.getCandidacyPeriod().edit(start, end);
    }

    public String getDisplayName() {
        return BundleUtil.getString((String)"resources.CaseHandlingResources", (String)((Object)((Object)this)).getClass().getSimpleName(), (String[])new String[0]);
    }

    public MobilityIndividualApplicationProcess getProcessByEIdentifier(String eIdentifier) {
        ArrayList childProcesses = new ArrayList((List)((Object)this.getChildProcessesSet()));
        for (MobilityIndividualApplicationProcess process2 : childProcesses) {
            if (!eIdentifier.equals(process2.getPersonalDetails().getPerson().getEidentifier())) continue;
            return process2;
        }
        return null;
    }

    public MobilityIndividualApplicationProcess getOpenProcessByEIdentifier(String eIdentifier) {
        ArrayList childProcesses = new ArrayList((List)((Object)this.getChildProcessesSet()));
        for (MobilityIndividualApplicationProcess process2 : childProcesses) {
            if (process2.isCandidacyCancelled() || StringUtils.isEmpty((String)process2.getPersonalDetails().getEidentifier()) || !eIdentifier.equals(process2.getPersonalDetails().getEidentifier())) continue;
            return process2;
        }
        return null;
    }

    public MobilityApplicationPeriod getCandidacyPeriod() {
        return (MobilityApplicationPeriod)((Object)super.getCandidacyPeriod());
    }

    public MobilityApplicationPeriod getApplicationPeriod() {
        return this.getCandidacyPeriod();
    }

    public List<MobilityCoordinator> getErasmusCoordinatorForTeacher(final Teacher teacher) {
        return new ArrayList<MobilityCoordinator>(CollectionUtils.select((Collection)this.getCoordinatorsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((MobilityCoordinator)((Object)arg0)).getTeacher() == teacher;
            }
        }));
    }

    public MobilityCoordinator getCoordinatorForTeacherAndDegree(Teacher teacher, final Degree degree) {
        List<MobilityCoordinator> coordinators = this.getErasmusCoordinatorForTeacher(teacher);
        return (MobilityCoordinator)((Object)CollectionUtils.find(coordinators, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                MobilityCoordinator coordinator = (MobilityCoordinator)((Object)arg0);
                return coordinator.getDegree() == degree;
            }
        }));
    }

    public List<Degree> getDegreesAssociatedToTeacherAsCoordinator(Teacher teacher) {
        List<MobilityCoordinator> coordinators = this.getErasmusCoordinatorForTeacher(teacher);
        return new ArrayList<Degree>(CollectionUtils.collect(coordinators, (Transformer)new Transformer(){

            public Object transform(Object arg0) {
                return ((MobilityCoordinator)((Object)arg0)).getDegree();
            }
        }));
    }

    public boolean isTeacherErasmusCoordinatorForDegree(Teacher teacher, Degree degree) {
        return this.getCoordinatorForTeacherAndDegree(teacher, degree) != null;
    }

    public List<MobilityIndividualApplicationProcess> getProcessesWithNotViewedApprovedLearningAgreements() {
        ArrayList<MobilityIndividualApplicationProcess> processList = new ArrayList<MobilityIndividualApplicationProcess>();
        CollectionUtils.select((Collection)this.getChildProcessesSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                MobilityIndividualApplicationProcess individualProcess = (MobilityIndividualApplicationProcess)((Object)arg0);
                return !individualProcess.isCandidacyCancelled() && individualProcess.getCandidacy().isMostRecentApprovedLearningAgreementNotViewed();
            }
        }, processList);
        return processList;
    }

    public List<MobilityIndividualApplicationProcess> getProcessesWithNotViewedAlerts() {
        ArrayList<MobilityIndividualApplicationProcess> processList = new ArrayList<MobilityIndividualApplicationProcess>();
        CollectionUtils.select((Collection)this.getChildProcessesSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                MobilityIndividualApplicationProcess process2 = (MobilityIndividualApplicationProcess)((Object)arg0);
                return process2.isProcessWithMostRecentAlertMessageNotViewed();
            }
        }, processList);
        return processList;
    }

    public List<ErasmusCandidacyProcessReport> getDoneReports() {
        ArrayList<ErasmusCandidacyProcessReport> jobList = new ArrayList<ErasmusCandidacyProcessReport>();
        CollectionUtils.select((Collection)this.getErasmusCandidacyProcessReportsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((QueueJob)((Object)arg0)).getDone();
            }
        }, jobList);
        return jobList;
    }

    public List<ErasmusCandidacyProcessReport> getUndoneReports() {
        return new ArrayList<ErasmusCandidacyProcessReport>(CollectionUtils.subtract((Collection)this.getErasmusCandidacyProcessReportsSet(), this.getDoneReports()));
    }

    public List<ErasmusCandidacyProcessReport> getPendingReports() {
        ArrayList<ErasmusCandidacyProcessReport> jobList = new ArrayList<ErasmusCandidacyProcessReport>();
        CollectionUtils.select((Collection)this.getErasmusCandidacyProcessReportsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((QueueJob)((Object)arg0)).getIsNotDoneAndNotCancelled();
            }
        }, jobList);
        return jobList;
    }

    public boolean isAbleToLaunchReportGenerationJob() {
        return this.getPendingReports().isEmpty();
    }

    public void editReceptionEmailMessage(SendReceptionEmailBean sendReceptionEmailBean) {
        if (StringUtils.isEmpty((String)sendReceptionEmailBean.getEmailSubject()) || StringUtils.isEmpty((String)sendReceptionEmailBean.getEmailBody())) {
            throw new DomainException("error.reception.email.subject.and.body.must.not.be.empty", new String[0]);
        }
        this.setReceptionEmailSubject(sendReceptionEmailBean.getEmailSubject());
        this.setReceptionEmailBody(sendReceptionEmailBean.getEmailBody());
    }

    public boolean isReceptionEmailMessageDefined() {
        MobilityEmailTemplate template = this.getCandidacyPeriod().getEmailTemplateFor(MobilityEmailTemplateType.IST_RECEPTION);
        return !StringUtils.isEmpty((String)template.getSubject()) && !StringUtils.isEmpty((String)template.getBody());
    }

    public boolean isMobility() {
        return true;
    }

    public List<MobilityIndividualApplicationProcess> getProcessesMissingDocuments() {
        ArrayList<MobilityIndividualApplicationProcess> results = new ArrayList<MobilityIndividualApplicationProcess>();
        for (IndividualCandidacyProcess icp : this.getChildsWithMissingRequiredDocuments()) {
            if (!(icp instanceof MobilityIndividualApplicationProcess)) continue;
            MobilityIndividualApplicationProcess miap = (MobilityIndividualApplicationProcess)((Object)icp);
            results.add(miap);
        }
        return results;
    }

    public List<MobilityIndividualApplicationProcess> getProcessesMissingShifts() {
        ArrayList<MobilityIndividualApplicationProcess> results = new ArrayList<MobilityIndividualApplicationProcess>();
        for (IndividualCandidacyProcess icp : this.getChildsWithMissingShifts()) {
            if (!(icp instanceof MobilityIndividualApplicationProcess)) continue;
            MobilityIndividualApplicationProcess miap = (MobilityIndividualApplicationProcess)((Object)icp);
            results.add(miap);
        }
        return results;
    }

    static {
        activities.add(new ViewMobilityQuota());
        activities.add(new InsertMobilityQuota());
        activities.add(new RemoveMobilityQuota());
        activities.add(new ViewErasmusCoordinators());
        activities.add(new AssignCoordinator());
        activities.add(new RemoveTeacherFromCoordinators());
        activities.add(new ViewChildProcessWithMissingRequiredDocumentFiles());
        activities.add(new SendEmailToMissingRequiredDocumentsProcesses());
        activities.add(new SendEmailToMissingShiftsProcesses());
        activities.add(new EditCandidacyPeriod());
        activities.add(new SendReceptionEmail());
        activities.add(new EditReceptionEmailMessage());
        ALLOWED_DEGREE_TYPES = DegreeType.oneOf(DegreeType::isBolonhaMasterDegree, DegreeType::isIntegratedMasterDegree);
    }

    private static class EditReceptionEmailMessage
    extends Activity<MobilityApplicationProcess> {
        private EditReceptionEmailMessage() {
        }

        @Override
        public void checkPreConditions(MobilityApplicationProcess process2, User userView) {
            if (MobilityApplicationProcess.isManager(userView)) {
                return;
            }
            if (MobilityApplicationProcess.isInternationalRelationsOfficer(userView)) {
                return;
            }
            throw new PreConditionNotValidException();
        }

        @Override
        protected MobilityApplicationProcess executeActivity(MobilityApplicationProcess process2, User userView, Object object) {
            process2.editReceptionEmailMessage((SendReceptionEmailBean)object);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }
    }

    private static class SendReceptionEmail
    extends Activity<MobilityApplicationProcess> {
        private SendReceptionEmail() {
        }

        @Override
        public void checkPreConditions(MobilityApplicationProcess process2, User userView) {
            if (MobilityApplicationProcess.isManager(userView)) {
                return;
            }
            if (MobilityApplicationProcess.isInternationalRelationsOfficer(userView)) {
                return;
            }
            throw new PreConditionNotValidException();
        }

        @Override
        protected MobilityApplicationProcess executeActivity(MobilityApplicationProcess process2, User userView, Object object) {
            SendReceptionEmailBean sendBean = (SendReceptionEmailBean)object;
            ReceptionEmailExecutedAction.createAction(process2, sendBean);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return true;
        }
    }

    private static class SendEmailToMissingShiftsProcesses
    extends Activity<MobilityApplicationProcess> {
        private SendEmailToMissingShiftsProcesses() {
        }

        @Override
        public void checkPreConditions(MobilityApplicationProcess process2, User userView) {
            if (!MobilityApplicationProcess.isManager(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityApplicationProcess executeActivity(MobilityApplicationProcess process2, User userView, Object object) {
            MobilityApplicationPeriod candidacyPeriod = process2.getCandidacyPeriod();
            MobilityEmailTemplate emailTemplateFor = candidacyPeriod.getEmailTemplateFor(MobilityEmailTemplateType.MISSING_SHIFTS);
            if (emailTemplateFor == null) {
                for (MobilityProgram mobilityProgram : candidacyPeriod.getMobilityPrograms()) {
                    for (MobilityEmailTemplate mobilityEmailTemplate : mobilityProgram.getEmailTemplatesSet()) {
                        if (!mobilityEmailTemplate.getType().equals((Object)MobilityEmailTemplateType.MISSING_SHIFTS)) continue;
                        throw new DomainException("error.missing.shifts.template.not.found", mobilityProgram.getName().getContent());
                    }
                }
            }
            emailTemplateFor.sendMultiEmailFor(process2.getProcessesMissingShifts());
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }
    }

    private static class SendEmailToMissingRequiredDocumentsProcesses
    extends Activity<MobilityApplicationProcess> {
        private SendEmailToMissingRequiredDocumentsProcesses() {
        }

        @Override
        public void checkPreConditions(MobilityApplicationProcess process2, User userView) {
            if (!MobilityApplicationProcess.isManager(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityApplicationProcess executeActivity(MobilityApplicationProcess process2, User userView, Object object) {
            MobilityApplicationPeriod candidacyPeriod = process2.getCandidacyPeriod();
            MobilityEmailTemplate emailTemplateFor = candidacyPeriod.getEmailTemplateFor(MobilityEmailTemplateType.MISSING_DOCUMENTS);
            emailTemplateFor.sendMultiEmailFor(process2.getProcessesMissingDocuments());
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }
    }

    private static class ViewChildProcessWithMissingRequiredDocumentFiles
    extends Activity<MobilityApplicationProcess> {
        private ViewChildProcessWithMissingRequiredDocumentFiles() {
        }

        @Override
        public void checkPreConditions(MobilityApplicationProcess process2, User userView) {
            if (!MobilityApplicationProcess.isInternationalRelationsOfficer(userView) && !MobilityApplicationProcess.isManager(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityApplicationProcess executeActivity(MobilityApplicationProcess process2, User userView, Object object) {
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return true;
        }
    }

    private static class RemoveTeacherFromCoordinators
    extends Activity<MobilityApplicationProcess> {
        private RemoveTeacherFromCoordinators() {
        }

        @Override
        public void checkPreConditions(MobilityApplicationProcess process2, User userView) {
            if (!MobilityApplicationProcess.isInternationalRelationsOfficer(userView) && !MobilityApplicationProcess.isManager(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityApplicationProcess executeActivity(MobilityApplicationProcess process2, User userView, Object object) {
            ErasmusCoordinatorBean bean = (ErasmusCoordinatorBean)object;
            if (bean.getErasmusCoordinator() != null) {
                bean.getErasmusCoordinator().delete();
            }
            bean.setErasmusCoordinator(null);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }
    }

    private static class AssignCoordinator
    extends Activity<MobilityApplicationProcess> {
        private AssignCoordinator() {
        }

        @Override
        public void checkPreConditions(MobilityApplicationProcess process2, User userView) {
            if (!MobilityApplicationProcess.isInternationalRelationsOfficer(userView) && !MobilityApplicationProcess.isManager(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityApplicationProcess executeActivity(MobilityApplicationProcess process2, User userView, Object object) {
            ErasmusCoordinatorBean bean = (ErasmusCoordinatorBean)object;
            new MobilityCoordinator(process2, bean);
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }
    }

    private static class ViewErasmusCoordinators
    extends Activity<MobilityApplicationProcess> {
        private ViewErasmusCoordinators() {
        }

        @Override
        public void checkPreConditions(MobilityApplicationProcess process2, User userView) {
            if (!MobilityApplicationProcess.isInternationalRelationsOfficer(userView) && !MobilityApplicationProcess.isManager(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityApplicationProcess executeActivity(MobilityApplicationProcess process2, User userView, Object object) {
            return process2;
        }
    }

    private static class RemoveMobilityQuota
    extends Activity<MobilityApplicationProcess> {
        private RemoveMobilityQuota() {
        }

        @Override
        public void checkPreConditions(MobilityApplicationProcess process2, User userView) {
            if (!MobilityApplicationProcess.isInternationalRelationsOfficer(userView) && !MobilityApplicationProcess.isManager(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityApplicationProcess executeActivity(MobilityApplicationProcess process2, User userView, Object object) {
            ErasmusVacancyBean bean = (ErasmusVacancyBean)object;
            MobilityQuota quota = bean.getQuota();
            if (quota.isQuotaAssociatedWithAnyApplication()) {
                throw new DomainException("error.mobility.quota.is.associated.with.applications", new String[0]);
            }
            quota.delete();
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }
    }

    private static class InsertMobilityQuota
    extends Activity<MobilityApplicationProcess> {
        private InsertMobilityQuota() {
        }

        @Override
        public void checkPreConditions(MobilityApplicationProcess process2, User userView) {
            if (!MobilityApplicationProcess.isInternationalRelationsOfficer(userView) && !MobilityApplicationProcess.isManager(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityApplicationProcess executeActivity(MobilityApplicationProcess process2, User userView, Object object) {
            ErasmusVacancyBean bean = (ErasmusVacancyBean)object;
            for (Degree degree : bean.getDegrees()) {
                MobilityQuota.createVacancy(process2.getCandidacyPeriod(), degree, bean.getMobilityProgram(), bean.getUniversity(), bean.getNumberOfVacancies());
            }
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return false;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }
    }

    private static class ViewMobilityQuota
    extends Activity<MobilityApplicationProcess> {
        private ViewMobilityQuota() {
        }

        @Override
        public void checkPreConditions(MobilityApplicationProcess process2, User userView) {
            if (!MobilityApplicationProcess.isInternationalRelationsOfficer(userView) && !MobilityApplicationProcess.isManager(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityApplicationProcess executeActivity(MobilityApplicationProcess process2, User userView, Object object) {
            return process2;
        }
    }

    private static class EditCandidacyPeriod
    extends Activity<MobilityApplicationProcess> {
        private EditCandidacyPeriod() {
        }

        @Override
        public void checkPreConditions(MobilityApplicationProcess process2, User userView) {
            if (!MobilityApplicationProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityApplicationProcess executeActivity(MobilityApplicationProcess process2, User userView, Object object) {
            CandidacyProcessBean bean = (CandidacyProcessBean)object;
            process2.edit(bean.getStart(), bean.getEnd());
            return process2;
        }

        @Override
        public Boolean isVisibleForAdminOffice() {
            return true;
        }

        @Override
        public Boolean isVisibleForCoordinator() {
            return false;
        }

        @Override
        public Boolean isVisibleForGriOffice() {
            return false;
        }
    }

    @StartActivity
    public static class CreateCandidacyPeriod
    extends Activity<MobilityApplicationProcess> {
        @Override
        public void checkPreConditions(MobilityApplicationProcess process2, User userView) {
            if (!MobilityApplicationProcess.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected MobilityApplicationProcess executeActivity(MobilityApplicationProcess process2, User userView, Object object) {
            MobilityApplicationProcessBean bean = (MobilityApplicationProcessBean)object;
            return new MobilityApplicationProcess((ExecutionYear)((Object)bean.getExecutionInterval()), bean.getStart(), bean.getEnd(), bean.getForSemester());
        }
    }
}

