/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.candidacy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.events.candidacy.DegreeTransferIndividualCandidacyEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOfficeType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferIndividualCandidacy;
import org.fenixedu.academic.domain.exceptions.DomainException;

public class DegreeTransferIndividualCandidacyEvent
extends DegreeTransferIndividualCandidacyEvent_Base {
    private static final List<EventType> COMPATIBLE_TYPES = Arrays.asList(EventType.DEGREE_TRANSFER_INDIVIDUAL_CANDIDACY, EventType.DEGREE_CHANGE_INDIVIDUAL_CANDIDACY);

    private DegreeTransferIndividualCandidacyEvent() {
    }

    public DegreeTransferIndividualCandidacyEvent(DegreeTransferIndividualCandidacy candidacy, Person person) {
        this();
        super.init((IndividualCandidacy)((Object)candidacy), EventType.DEGREE_TRANSFER_INDIVIDUAL_CANDIDACY, person);
        this.attachAvailablePaymentCode(person);
    }

    protected AdministrativeOffice readAdministrativeOffice() {
        return AdministrativeOffice.readByAdministrativeOfficeType(AdministrativeOfficeType.DEGREE);
    }

    protected void checkConditionsToTransferPaymentsAndCancel(Event targetEvent) {
        if (!COMPATIBLE_TYPES.contains((Object)targetEvent.getEventType())) {
            throw new DomainException("error.accounting.Event.events.must.be.compatible", new String[0]);
        }
        if (this.isCancelled()) {
            throw new DomainException("error.accounting.Event.cannot.transfer.payments.from.cancelled.events", new String[0]);
        }
        if (this == targetEvent) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.Event.target.event.must.be.different.from.source", new String[0]);
        }
    }

    public Set<EntryType> getPossibleEntryTypesForDeposit() {
        return Collections.singleton(EntryType.DEGREE_TRANSFER_INDIVIDUAL_CANDIDACY_FEE);
    }

    public DegreeTransferIndividualCandidacy getIndividualCandidacy() {
        return (DegreeTransferIndividualCandidacy)((Object)super.getIndividualCandidacy());
    }

    public Degree getCandidacyDegree() {
        return this.getIndividualCandidacy().getSelectedDegree();
    }

    protected EntryType getEntryType() {
        return EntryType.DEGREE_TRANSFER_INDIVIDUAL_CANDIDACY_FEE;
    }
}

