/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.math.BigDecimal;
import java.util.Collection;
import jvstm.cps.ConsistencyPredicate;
import org.fenixedu.academic.domain.CourseLoad_Base;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLoad;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class CourseLoad
extends CourseLoad_Base {
    public CourseLoad(ExecutionCourse executionCourse, ShiftType type, BigDecimal unitQuantity, BigDecimal totalQuantity) {
        if (executionCourse != null && type != null && executionCourse.getCourseLoadByShiftType(type) != null) {
            throw new DomainException("error.CourseLoad.executionCourse.already.contains.type", new String[0]);
        }
        this.setRootDomainObject(Bennu.getInstance());
        this.setUnitQuantity(unitQuantity);
        this.setTotalQuantity(totalQuantity);
        this.setExecutionCourse(executionCourse);
        this.setType(type);
        this.checkQuantities();
    }

    public void edit(BigDecimal unitQuantity, BigDecimal totalQuantity) {
        this.setUnitQuantity(unitQuantity);
        this.setTotalQuantity(totalQuantity);
        this.checkQuantities();
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        super.setExecutionCourse(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public void setExecutionCourse(ExecutionCourse executionCourse) {
        if (executionCourse == null) {
            throw new DomainException("error.CourseLoad.empty.executionCourse", new String[0]);
        }
        super.setExecutionCourse(executionCourse);
    }

    public void setType(ShiftType type) {
        if (type == null) {
            throw new DomainException("error.CourseLoad.empty.type", new String[0]);
        }
        super.setType(type);
    }

    public boolean isEmpty() {
        return this.getTotalQuantity().signum() == 0;
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getLessonInstancesSet().isEmpty() || !this.getShiftsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ResourceAllocationManagerResources", (String)"error.CourseLoad.cannot.be.deleted", (String[])new String[0]));
        }
    }

    public BigDecimal getWeeklyHours() {
        return this.getTotalQuantity().divide(BigDecimal.valueOf(CompetenceCourseLoad.NUMBER_OF_WEEKS), 2, 4);
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        if (totalQuantity == null || totalQuantity.signum() == -1) {
            throw new DomainException("error.CourseLoad.empty.totalQuantity", new String[0]);
        }
        super.setTotalQuantity(totalQuantity);
    }

    public void setUnitQuantity(BigDecimal unitQuantity) {
        if (unitQuantity != null && unitQuantity.signum() == -1) {
            throw new DomainException("error.CourseLoad.empty.unitQuantity", new String[0]);
        }
        super.setUnitQuantity(unitQuantity);
    }

    @ConsistencyPredicate
    protected boolean checkRequiredParameters() {
        return !this.isEmpty() && this.isTotalQuantityValid() && this.getType() != null;
    }

    private void checkQuantities() {
        if (!this.isTotalQuantityValid()) {
            throw new DomainException("error.CourseLoad.totalQuantity.less.than.unitQuantity", new String[0]);
        }
    }

    private boolean isTotalQuantityValid() {
        return this.getUnitQuantity() == null || this.getTotalQuantity().compareTo(this.getUnitQuantity()) != -1;
    }
}

