/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.teacher;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Mark;
import org.fenixedu.academic.service.filter.ExecutionCourseLecturingTeacherAuthorizationFilter;
import org.fenixedu.academic.service.services.ExcepcaoInexistente;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.teacher.PublishMarks$callable$runPublishMarks;
import org.fenixedu.bennu.signals.Signal;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PublishMarks {
    public static final String MARKS_PUBLISHED_SIGNAL = "academic.PublishMarks.marks.published";
    private static final PublishMarks serviceInstance;
    public static final Advice advice$runPublishMarks;

    protected Object run(String executionCourseCode, String evaluationCode, String publishmentMessage, String announcementTitle) throws ExcepcaoInexistente, FenixServiceException {
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseCode);
        Evaluation evaluation = (Evaluation)FenixFramework.getDomainObject((String)evaluationCode);
        if (publishmentMessage == null || publishmentMessage.length() == 0) {
            evaluation.setPublishmentMessage(" ");
        } else {
            evaluation.setPublishmentMessage(publishmentMessage);
        }
        Signal.emit((String)MARKS_PUBLISHED_SIGNAL, (Object)new MarkPublishingBean(executionCourse, evaluation, announcementTitle));
        for (Mark mark : evaluation.getMarksSet()) {
            if (mark.getMark().equals(mark.getPublishedMark())) continue;
            mark.setPublishedMark(mark.getMark());
        }
        return Boolean.TRUE;
    }

    public static Object runPublishMarks(String string, String string2, String string3, Boolean bl, String string4) throws ExcepcaoInexistente, FenixServiceException, NotAuthorizedException {
        return advice$runPublishMarks.perform((Callable)new PublishMarks$callable$runPublishMarks(string, string2, string3, bl, string4));
    }

    static /* synthetic */ Object advised$runPublishMarks(String executionCourseCode, String evaluationCode, String publishmentMessage, Boolean sendSMS, String announcementTitle) throws ExcepcaoInexistente, FenixServiceException, NotAuthorizedException {
        ExecutionCourseLecturingTeacherAuthorizationFilter.instance.execute(executionCourseCode);
        return serviceInstance.run(executionCourseCode, evaluationCode, publishmentMessage, announcementTitle);
    }

    static {
        advice$runPublishMarks = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new PublishMarks();
    }

    public static class MarkPublishingBean {
        private final ExecutionCourse course;
        private final Evaluation evaluation;
        private final String title;

        public MarkPublishingBean(ExecutionCourse course, Evaluation evaluation, String title) {
            this.course = course;
            this.evaluation = evaluation;
            this.title = title;
        }

        public ExecutionCourse getCourse() {
            return this.course;
        }

        public Evaluation getEvaluation() {
            return this.evaluation;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

