/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.administrativeOffice.student;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.administrativeOffice.student.RegistrationConclusionProcess$callable$revert;
import org.fenixedu.academic.service.services.administrativeOffice.student.RegistrationConclusionProcess$callable$run;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class RegistrationConclusionProcess {
    public static final Advice advice$revert = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void revert(RegistrationConclusionBean registrationConclusionBean) {
        Object object = advice$revert.perform((Callable)new RegistrationConclusionProcess$callable$revert(registrationConclusionBean));
    }

    static /* synthetic */ void advised$revert(RegistrationConclusionBean conclusionBean) {
        conclusionBean.getConclusionProcess().disableLastVersion();
    }

    public static void run(RegistrationConclusionBean registrationConclusionBean) {
        Object object = advice$run.perform((Callable)new RegistrationConclusionProcess$callable$run(registrationConclusionBean));
    }

    static /* synthetic */ void advised$run(RegistrationConclusionBean conclusionBean) {
        Registration registration = conclusionBean.getRegistration();
        CurriculumGroup curriculumGroup = conclusionBean.getCurriculumGroup();
        registration.conclude(curriculumGroup);
        if (conclusionBean.hasEnteredConclusionDate() || conclusionBean.hasEnteredFinalAverageGrade() || conclusionBean.hasEnteredAverageGrade() || conclusionBean.hasEnteredDescriptiveGrade()) {
            GradeScale gradeScale = registration.getDegree().getGradeScale();
            YearMonthDay conclusionDate = conclusionBean.getConclusionDate();
            Grade finalGrade = curriculumGroup.getFinalGrade();
            Grade rawGrade = curriculumGroup.getRawGrade();
            Grade descriptiveGrade = null;
            if (conclusionBean.hasEnteredConclusionDate()) {
                RegistrationConclusionProcess.checkEnteredConclusionDate(conclusionBean);
                conclusionDate = new YearMonthDay((Object)conclusionBean.getEnteredConclusionDate());
            }
            if (conclusionBean.hasEnteredFinalAverageGrade()) {
                RegistrationConclusionProcess.checkGrade(conclusionBean.getEnteredFinalAverageGrade(), gradeScale);
                finalGrade = Grade.createGrade(conclusionBean.getEnteredFinalAverageGrade(), gradeScale);
            }
            if (conclusionBean.hasEnteredAverageGrade()) {
                RegistrationConclusionProcess.checkGrade(conclusionBean.getEnteredAverageGrade(), gradeScale);
                rawGrade = Grade.createGrade(new BigDecimal(conclusionBean.getEnteredAverageGrade()).setScale(2, RoundingMode.HALF_UP).toString(), gradeScale);
            }
            if (conclusionBean.hasEnteredDescriptiveGrade()) {
                RegistrationConclusionProcess.checkGrade(conclusionBean.getEnteredDescriptiveGrade(), GradeScale.TYPEQUALITATIVE);
                descriptiveGrade = Grade.createGrade(conclusionBean.getEnteredDescriptiveGrade(), GradeScale.TYPEQUALITATIVE);
            }
            curriculumGroup.editConclusionInformation(AccessControl.getPerson(), finalGrade, rawGrade, descriptiveGrade, conclusionDate, conclusionBean.getObservations());
        }
    }

    private static void checkGrade(String value, GradeScale gradeScale) {
        if (!gradeScale.belongsTo(value)) {
            throw new DomainException("error.RegistrationConclusionProcess.final.average.is.invalid", value, BundleUtil.getLocalizedString((String)"resources.EnumerationResources", (String)gradeScale.name(), (String[])new String[0]).getContent());
        }
    }

    private static void checkEnteredConclusionDate(RegistrationConclusionBean conclusionBean) {
        YearMonthDay startDate = conclusionBean.getRegistration().getStartDate();
        if (startDate.isAfter((ReadablePartial)conclusionBean.getEnteredConclusionDate())) {
            throw new DomainException("error.RegistrationConclusionProcess.start.date.is.after.entered.date", new String[0]);
        }
    }
}

