/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.academicAdministration;

import java.io.Serializable;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;

public class SearchStudentsByCurricularCourseParametersBean
implements Serializable {
    private ExecutionYear executionYear;
    private DegreeCurricularPlan degreeCurricularPlan;
    private CurricularCourse curricularCourse;
    private Set<Degree> administratedDegrees;

    public SearchStudentsByCurricularCourseParametersBean() {
    }

    public SearchStudentsByCurricularCourseParametersBean(Set<Degree> administratedDegrees) {
        this.administratedDegrees = administratedDegrees;
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.degreeCurricularPlan;
    }

    public void setDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
        this.degreeCurricularPlan = degreeCurricularPlan;
    }

    public CurricularCourse getCurricularCourse() {
        return this.curricularCourse;
    }

    public void setCurricularCourse(CurricularCourse curricularCourse) {
        this.curricularCourse = curricularCourse;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public SortedSet<Degree> getAdministratedDegrees() {
        TreeSet<Degree> result = new TreeSet<Degree>(Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID);
        result.addAll(this.administratedDegrees);
        return result;
    }

    public SortedSet<DegreeCurricularPlan> getAvailableDegreeCurricularPlans() {
        TreeSet<DegreeCurricularPlan> result = new TreeSet<DegreeCurricularPlan>(DegreeCurricularPlan.DEGREE_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_TYPE_AND_EXECUTION_DEGREE_AND_DEGREE_CODE);
        if (this.executionYear != null) {
            Set<Degree> degrees = this.administratedDegrees;
            for (DegreeCurricularPlan plan : this.executionYear.getDegreeCurricularPlans()) {
                if (!degrees.contains(plan.getDegree())) continue;
                result.add(plan);
            }
        }
        return result;
    }
}

