/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.util;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.util.MessageTask$callable$deleteOldSenders;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Task(englishTitle="Message Task", readOnly=true)
public class MessageTask
extends CronTask {
    public static final Advice advice$deleteOldSenders = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    public void runTask() {
        I18N.setLocale((Locale)Locale.getDefault());
        this.deleteOldSenders();
        this.dispatchMessages();
    }

    private void deleteOldSenders() {
        Object object = advice$deleteOldSenders.perform((Callable)new MessageTask$callable$deleteOldSenders(this));
    }

    static /* synthetic */ void advised$deleteOldSenders(MessageTask this_) {
        int deletedCounter = 0;
        HashSet<Sender> senders = new HashSet<Sender>();
        for (Message message : Bennu.getInstance().getPendingUtilEmailMessagesSet()) {
            senders.add(message.getSender());
        }
        for (Sender sender : senders) {
            deletedCounter += sender.deleteOldMessages();
        }
        if (deletedCounter > 0) {
            this_.taskLog("Deleted %s old messages using a sender threshold of %d\n", new Object[]{deletedCounter, 500});
        }
    }

    private void dispatchMessages() {
        int dispatchCounter = 0;
        for (Message message : Bennu.getInstance().getPendingUtilEmailMessagesSet()) {
            long start = System.currentTimeMillis();
            int emails = message.dispatch();
            this.getLogger().info("Dispatched message: {} in {}ms for {} emails", new Object[]{message.getExternalId(), System.currentTimeMillis() - start, emails});
            ++dispatchCounter;
        }
        if (dispatchCounter > 0) {
            this.taskLog("Dispatched %d messages\n", new Object[]{dispatchCounter});
        }
    }
}

