/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.time.calendarStructure;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicYearCE_Base;
import org.fenixedu.academic.domain.time.chronologies.AcademicChronology;
import org.fenixedu.academic.util.MultiLanguageString;
import org.joda.time.DateTime;

public class AcademicYearCE
extends AcademicYearCE_Base {
    public AcademicYearCE(AcademicCalendarEntry parentEntry, MultiLanguageString title, MultiLanguageString description, DateTime begin, DateTime end, AcademicCalendarRootEntry rootEntry) {
        super.initEntry(parentEntry, title, description, begin, end, rootEntry);
        this.createExecutionYear();
    }

    private AcademicYearCE(AcademicCalendarEntry parentEntry, AcademicYearCE academicYearCE) {
        super.initVirtualEntry(parentEntry, (AcademicCalendarEntry)((Object)academicYearCE));
    }

    public void delete(AcademicCalendarRootEntry rootEntry) {
        if (!this.isVirtual()) {
            ExecutionYear executionYear = ExecutionYear.getExecutionYear(this);
            executionYear.delete();
        }
        super.delete(rootEntry);
    }

    protected void beforeRedefineEntry() {
        throw new DomainException("error.unsupported.operation", new String[0]);
    }

    protected void afterRedefineEntry() {
        throw new DomainException("error.unsupported.operation", new String[0]);
    }

    public boolean isOfType(AcademicPeriod period) {
        return period.equals((Object)AcademicPeriod.YEAR);
    }

    public boolean isAcademicYear() {
        return true;
    }

    protected boolean isParentEntryInvalid(AcademicCalendarEntry parentEntry) {
        return !parentEntry.isRoot();
    }

    protected boolean exceededNumberOfChildEntries(AcademicCalendarEntry childEntry) {
        if (childEntry.isAcademicSemester()) {
            return this.getChildEntriesWithTemplateEntries(childEntry.getClass()).size() >= 2;
        }
        if (childEntry.isAcademicTrimester()) {
            return this.getChildEntriesWithTemplateEntries(childEntry.getClass()).size() >= 4;
        }
        return false;
    }

    protected boolean areIntersectionsPossible(AcademicCalendarEntry entryToAdd) {
        return entryToAdd.isAcademicSemester();
    }

    protected boolean isPossibleToChangeTimeInterval() {
        return true;
    }

    protected AcademicCalendarEntry createVirtualEntry(AcademicCalendarEntry parentEntry) {
        return new AcademicYearCE(parentEntry, this);
    }

    private void createExecutionYear() {
        ExecutionYear executionYear = ExecutionYear.readBy(this.getBegin().toYearMonthDay(), this.getEnd().toYearMonthDay());
        if (executionYear == null) {
            new ExecutionYear(new AcademicInterval((AcademicCalendarEntry)((Object)this), this.getRootEntry()), this.getTitle().getContent());
        }
    }

    public int getAcademicSemesterOfAcademicYear(AcademicChronology academicChronology) {
        throw new DomainException("error.unsupported.operation", new String[0]);
    }

    protected boolean associatedWithDomainEntities() {
        return true;
    }
}

