/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IRSDeclarationRequest_Base;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class IRSDeclarationRequest
extends IRSDeclarationRequest_Base {
    private static final int FIRST_VALID_YEAR = 2006;

    protected IRSDeclarationRequest() {
    }

    public IRSDeclarationRequest(DocumentRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        super.setYear(bean.getYear());
    }

    protected void checkParameters(DocumentRequestCreateBean bean) {
        if (bean.getYear() == null) {
            throw new DomainException("error.serviceRequests.documentRequests.SchoolRegistrationDeclarationRequest.year.cannot.be.null", new String[0]);
        }
        if (new YearMonthDay(bean.getYear().intValue(), 1, 1).isBefore((ReadablePartial)new YearMonthDay(2006, 1, 1))) {
            throw new DomainException("IRSDeclarationRequest.only.available.after.first.valid.year", new String[0]);
        }
    }

    public final DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.IRS_DECLARATION;
    }

    public final String getDocumentTemplateKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void setYear(Integer year) {
        throw new DomainException("error.serviceRequests.documentRequests.IRSDeclarationRequest.cannot.modify.year", new String[0]);
    }

    public final EventType getEventType() {
        return null;
    }

    protected boolean hasFreeDeclarationRequests() {
        return false;
    }
}

