/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.migration;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationIndividualProcessData;
import org.fenixedu.academic.domain.phd.migration.common.ConversionUtilities;
import org.fenixedu.academic.domain.phd.migration.common.FinalGradeTranslator;
import org.fenixedu.academic.domain.phd.migration.common.PhdProgramTranslator;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.IncompleteFieldsException;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisFinalGrade;
import org.joda.time.LocalDate;

public class PhdMigrationIndividualProcessDataBean
implements Serializable {
    private static final long serialVersionUID = 5633491871349165600L;
    private String data;
    private PhdMigrationIndividualProcessData processData;
    private Integer processNumber;
    private PhdProgram phdProgram;
    private String title;
    private String guiderId;
    private String assistantGuiderId;
    private LocalDate startProcessDate;
    private LocalDate startDevelopmentDate;
    private LocalDate requirementDate;
    private LocalDate meetingDate;
    private LocalDate firstDiscussionDate;
    private LocalDate secondDiscussionDate;
    private LocalDate edictDate;
    private PhdThesisFinalGrade classification;
    private LocalDate ratificationDate;
    private LocalDate annulmentDate;
    private LocalDate limitToFinishDate;

    public PhdMigrationIndividualProcessDataBean(PhdMigrationIndividualProcessData processData) {
        this.setProcessData(processData);
        this.setData(processData.getData());
        this.parse();
    }

    public void parse() {
        try {
            String[] fields = this.getData().split("\t");
            try {
                this.processNumber = Integer.valueOf(fields[0].trim());
            }
            catch (NumberFormatException e) {
                throw new IncompleteFieldsException("processNumber");
            }
            try {
                this.phdProgram = PhdProgramTranslator.translate(fields[1].trim());
            }
            catch (NumberFormatException e) {
                throw new IncompleteFieldsException("phdProgram");
            }
            this.title = fields[2].trim();
            this.guiderId = fields[3].trim();
            this.assistantGuiderId = fields[4].trim();
            this.startProcessDate = ConversionUtilities.parseDate(fields[5].trim());
            this.startDevelopmentDate = ConversionUtilities.parseDate(fields[6].trim());
            this.requirementDate = ConversionUtilities.parseDate(fields[7].trim());
            this.meetingDate = ConversionUtilities.parseDate(fields[8].trim());
            this.firstDiscussionDate = ConversionUtilities.parseDate(fields[9].trim());
            this.secondDiscussionDate = ConversionUtilities.parseDate(fields[10].trim());
            this.edictDate = ConversionUtilities.parseDate(fields[11].trim());
            this.classification = FinalGradeTranslator.translate(fields[13].trim());
            this.ratificationDate = ConversionUtilities.parseDate(fields[14].trim());
            this.annulmentDate = ConversionUtilities.parseDate(fields[15].trim());
            this.limitToFinishDate = ConversionUtilities.parseDate(fields[16].trim());
        }
        catch (NoSuchElementException e) {
            throw new IncompleteFieldsException("Not enough fields");
        }
    }

    public PhdMigrationIndividualProcessData getProcessData() {
        return this.processData;
    }

    public void setProcessData(PhdMigrationIndividualProcessData processData) {
        this.processData = processData;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Integer getProcessNumber() {
        return this.processNumber;
    }

    public void setProcessNumber(Integer processNumber) {
        this.processNumber = processNumber;
    }

    public PhdProgram getPhdProgram() {
        return this.phdProgram;
    }

    public void setPhdProgram(PhdProgram phdProgram) {
        this.phdProgram = phdProgram;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getGuiderId() {
        return this.guiderId;
    }

    public void setGuiderId(String guiderId) {
        this.guiderId = guiderId;
    }

    public String getAssistantGuiderId() {
        return this.assistantGuiderId;
    }

    public void setAssistantGuiderId(String assistantGuiderId) {
        this.assistantGuiderId = assistantGuiderId;
    }

    public LocalDate getStartProcessDate() {
        return this.startProcessDate;
    }

    public void setStartProcessDate(LocalDate startProcessDate) {
        this.startProcessDate = startProcessDate;
    }

    public LocalDate getStartDevelopmentDate() {
        return this.startDevelopmentDate;
    }

    public void setStartDevelopmentDate(LocalDate startDevelopmentDate) {
        this.startDevelopmentDate = startDevelopmentDate;
    }

    public LocalDate getRequirementDate() {
        return this.requirementDate;
    }

    public void setRequirementDate(LocalDate requirementDate) {
        this.requirementDate = requirementDate;
    }

    public LocalDate getMeetingDate() {
        return this.meetingDate;
    }

    public void setMeetingDate(LocalDate meetingDate) {
        this.meetingDate = meetingDate;
    }

    public LocalDate getFirstDiscussionDate() {
        return this.firstDiscussionDate;
    }

    public void setFirstDiscussionDate(LocalDate firstDiscussionDate) {
        this.firstDiscussionDate = firstDiscussionDate;
    }

    public LocalDate getSecondDiscussionDate() {
        return this.secondDiscussionDate;
    }

    public void setSecondDiscussionDate(LocalDate secondDiscussionDate) {
        this.secondDiscussionDate = secondDiscussionDate;
    }

    public LocalDate getEdictDate() {
        return this.edictDate;
    }

    public void setEdictDate(LocalDate edictDate) {
        this.edictDate = edictDate;
    }

    public PhdThesisFinalGrade getClassification() {
        return this.classification;
    }

    public void setClassification(PhdThesisFinalGrade classification) {
        this.classification = classification;
    }

    public LocalDate getRatificationDate() {
        return this.ratificationDate;
    }

    public void setRatificationDate(LocalDate ratificationDate) {
        this.ratificationDate = ratificationDate;
    }

    public LocalDate getAnnulmentDate() {
        return this.annulmentDate;
    }

    public void setAnnulmentDate(LocalDate annulmentDate) {
        this.annulmentDate = annulmentDate;
    }

    public LocalDate getLimitToFinishDate() {
        return this.limitToFinishDate;
    }

    public void setLimitToFinishDate(LocalDate limitToFinishDate) {
        this.limitToFinishDate = limitToFinishDate;
    }

    public boolean hasPhdProgram() {
        return this.phdProgram != null;
    }
}

