/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.Alert;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Job;
import org.fenixedu.academic.domain.JobBean;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Qualification;
import org.fenixedu.academic.domain.QualificationBean;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceEvent;
import org.fenixedu.academic.domain.accounting.events.insurance.InsuranceEvent;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.candidacy.PersonalInformationBean;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.InternalPhdStudyPlanEntry;
import org.fenixedu.academic.domain.phd.PhdConfigurationIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramCollaborationType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessNumber;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess_Base;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdParticipantBean;
import org.fenixedu.academic.domain.phd.PhdProcessState;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.PhdProgramProcessState;
import org.fenixedu.academic.domain.phd.PhdStudyPlanEntry;
import org.fenixedu.academic.domain.phd.ThesisSubjectOrder;
import org.fenixedu.academic.domain.phd.alert.PhdAlert;
import org.fenixedu.academic.domain.phd.alert.PhdAlertMessage;
import org.fenixedu.academic.domain.phd.alert.PhdFinalProofRequestAlert;
import org.fenixedu.academic.domain.phd.alert.PhdPublicPresentationSeminarAlert;
import org.fenixedu.academic.domain.phd.alert.PhdRegistrationFormalizationAlert;
import org.fenixedu.academic.domain.phd.alert.PublicPhdMissingCandidacyValidationAlert;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcessBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramPublicCandidacyHashCode;
import org.fenixedu.academic.domain.phd.candidacy.PhdThesisSubjectOrderBean;
import org.fenixedu.academic.domain.phd.candidacy.activities.EditCandidacyDate;
import org.fenixedu.academic.domain.phd.conclusion.PhdConclusionProcess;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityEvent;
import org.fenixedu.academic.domain.phd.guidance.PhdGuidanceDocument;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AbandonIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AcceptEnrolments;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ActivatePhdProgramProcessInCandidacyState;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ActivatePhdProgramProcessInThesisDiscussionState;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ActivatePhdProgramProcessInWorkDevelopmentState;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddAssistantGuidingInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddCandidacyReferees;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddCustomAlert;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddGuidingInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddGuidingsInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddJobInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddQualification;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddQualifications;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddStudyPlan;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddStudyPlanEntry;
import org.fenixedu.academic.domain.phd.individualProcess.activities.CancelPhdProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ConcludeIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ConfigurePhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteAssistantGuiding;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteCustomAlert;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteGuidanceDocument;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteGuiding;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteJobInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteQualification;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteStudyPlan;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteStudyPlanEntry;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DissociateRegistration;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditIndividualProcessInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditPersonalInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditPhdParticipant;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditQualificationExams;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditStudyPlan;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditWhenStartedStudies;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ExemptPublicPresentationSeminarComission;
import org.fenixedu.academic.domain.phd.individualProcess.activities.FlunkedPhdProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.NotAdmittedPhdProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.PhdIndividualProgramProcessActivity;
import org.fenixedu.academic.domain.phd.individualProcess.activities.RejectEnrolments;
import org.fenixedu.academic.domain.phd.individualProcess.activities.RemoveCandidacyReferee;
import org.fenixedu.academic.domain.phd.individualProcess.activities.RemoveLastStateOnPhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.RequestPublicPresentationSeminarComission;
import org.fenixedu.academic.domain.phd.individualProcess.activities.RequestPublicThesisPresentation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.SendPhdEmail;
import org.fenixedu.academic.domain.phd.individualProcess.activities.SuspendPhdProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.TransferToAnotherProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.UploadDocuments;
import org.fenixedu.academic.domain.phd.individualProcess.activities.UploadGuidanceAcceptanceLetter;
import org.fenixedu.academic.domain.phd.individualProcess.activities.UploadGuidanceDocument;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ValidatedByCandidate;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationGuiding;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationIndividualProcessData;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationIndividualProcessDataBean;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationProcess;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdAcademicServiceRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdDiplomaRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdDiplomaSupplementRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdRegistryDiplomaRequest;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisFinalGrade;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class PhdIndividualProgramProcess
extends PhdIndividualProgramProcess_Base {
    protected static List<Activity> activities = new ArrayList<Activity>();

    public boolean isAllowedToManageProcess(User userView) {
        if (userView != null) {
            Set programs = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_PHD_PROCESSES, userView.getPerson().getUser()).collect(Collectors.toSet());
            return programs.contains((Object)this.getPhdProgram());
        }
        return false;
    }

    public boolean isCurrentUserAllowedToManageProcess() {
        return this.isAllowedToManageProcess(Authenticate.getUser());
    }

    public boolean isAllowedToManageProcessState(User userView) {
        if (!this.isAllowedToManageProcess(userView)) {
            return false;
        }
        Set programs = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_PHD_PROCESS_STATE, userView.getPerson().getUser()).collect(Collectors.toSet());
        return programs.contains((Object)this.getPhdProgram());
    }

    public boolean isCurrentUserAllowedToManageProcessState() {
        return this.isAllowedToManageProcessState(Authenticate.getUser());
    }

    private PhdIndividualProgramProcess(PhdProgramCandidacyProcessBean bean, Person person) {
        this.checkParameters(person, bean.getExecutionYear());
        this.setPerson(person);
        this.setPhdProgramFocusArea(bean.getFocusArea());
        this.setPhdProgram(bean.getProgram());
        this.setExternalPhdProgram(bean.getExternalPhdProgram());
        this.setExecutionYear(bean.getExecutionYear());
        this.setCollaborationType(bean);
        this.setThesisTitle(bean.getThesisTitle());
        if (bean.getMigratedProcess().booleanValue()) {
            this.setPhdIndividualProcessNumber(PhdIndividualProgramProcessNumber.generateNextForYear(bean.getCandidacyDate().getYear(), bean.getPhdStudentNumber()));
            this.setPhdConfigurationIndividualProgramProcess(PhdConfigurationIndividualProgramProcess.createMigratedProcessConfiguration());
        } else {
            this.setPhdIndividualProcessNumber(PhdIndividualProgramProcessNumber.generateNextForYear(bean.getCandidacyDate().getYear(), null));
            this.setPhdConfigurationIndividualProgramProcess(PhdConfigurationIndividualProgramProcess.createDefault());
        }
        this.updatePhdParticipantsWithCoordinators();
    }

    public void removeLastState() {
        if (this.getStatesSet().size() == 1) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess.has.only.one.state", new String[0]);
        }
        this.getMostRecentState().delete();
    }

    private void updatePhdParticipantsWithCoordinators() {
        for (Person person : this.getCoordinatorsFor(this.getExecutionYear())) {
            if (this.getParticipant(person) != null) continue;
            PhdParticipant.getUpdatedOrCreate(this, new PhdParticipantBean().setInternalParticipant(person));
        }
    }

    public void createState(PhdIndividualProgramProcessState state, Person person, String remarks) {
        PhdProgramProcessState.createWithInferredStateDate(this, state, person, remarks);
    }

    private void setCollaborationType(PhdProgramCandidacyProcessBean bean) {
        if (bean.getCollaborationType() != null) {
            this.setCollaborationType(bean.getCollaborationType());
        } else {
            this.setCollaborationType(PhdIndividualProgramCollaborationType.NONE);
        }
    }

    private void checkParameters(Person person, ExecutionYear executionYear) {
        String[] args = new String[]{};
        if (person == null) {
            throw new DomainException("error.phd.PhdIndividualProgramProcess.person.cannot.be.null", args);
        }
        String[] args1 = new String[]{};
        if (executionYear == null) {
            throw new DomainException("error.phd.PhdIndividualProgramProcess.executionYear.cannot.be.null", args1);
        }
    }

    public boolean canExecuteActivity(User userView) {
        return true;
    }

    public List<Activity> getActivities() {
        return activities;
    }

    public String getDisplayName() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)((Object)((Object)this)).getClass().getSimpleName(), (String[])new String[0]);
    }

    public String getCollaborationTypeName() {
        return this.getCollaborationType().getLocalizedName() + (this.isOtherCollaborationType() ? " (" + this.getOtherCollaborationType() + ")" : "");
    }

    private boolean isOtherCollaborationType() {
        return this.getCollaborationType() == PhdIndividualProgramCollaborationType.OTHER;
    }

    public PhdIndividualProgramProcess addQualification(Person person, QualificationBean bean) {
        Qualification qualification = new Qualification(this.getPerson(), bean);
        qualification.setCreator(person);
        return this;
    }

    public PhdIndividualProgramProcess addJobInformation(Person person, JobBean bean) {
        Job job = new Job(this.getPerson(), bean);
        job.setCreator(person);
        return this;
    }

    public PhdParticipant addGuiding(PhdParticipantBean bean) {
        PhdParticipant phdParticipant = bean.hasParticipant() ? bean.getParticipant() : this.createPhdParticipant(bean);
        this.addGuidings(phdParticipant);
        return phdParticipant;
    }

    public PhdIndividualProgramProcess deleteGuiding(PhdParticipant guiding) {
        if (this.getGuidingsSet().contains((Object)guiding)) {
            this.removeGuidings(guiding);
            guiding.tryDelete();
        }
        return this;
    }

    public PhdParticipant addAssistantGuiding(PhdParticipantBean bean) {
        PhdParticipant phdParticipant = bean.hasParticipant() ? bean.getParticipant() : this.createPhdParticipant(bean);
        this.addAssistantGuidings(phdParticipant);
        return phdParticipant;
    }

    private PhdParticipant createPhdParticipant(PhdParticipantBean bean) {
        return PhdParticipant.getUpdatedOrCreate(this, bean);
    }

    public PhdIndividualProgramProcess deleteAssistantGuiding(PhdParticipant assistant) {
        if (this.getAssistantGuidingsSet().contains((Object)assistant)) {
            this.removeAssistantGuidings(assistant);
            assistant.tryDelete();
        }
        return this;
    }

    public String getProcessNumber() {
        return this.getPhdIndividualProcessNumber().getFullProcessNumber();
    }

    public PhdIndividualProgramProcess edit(User userView, PhdIndividualProgramProcessBean bean) {
        this.checkParameters(this.getPerson(), this.getExecutionYear());
        if (this.getCandidacyProcess() != null && !this.getCandidacyDate().equals((Object)bean.getCandidacyDate())) {
            this.getCandidacyProcess().executeActivity(userView, EditCandidacyDate.class.getSimpleName(), bean.getCandidacyDate());
        }
        this.setPhdProgram(bean.getPhdProgram());
        this.setPhdProgramFocusArea(bean.getFocusArea());
        this.setExternalPhdProgram(bean.getExternalPhdProgram());
        for (ThesisSubjectOrder subjectOrder : this.getThesisSubjectOrdersSet()) {
            subjectOrder.delete();
        }
        for (PhdThesisSubjectOrderBean subjectOrderBean : bean.getThesisSubjectBeans()) {
            new ThesisSubjectOrder(subjectOrderBean.getThesisSubject(), this, subjectOrderBean.getOrder());
        }
        this.setThesisTitle(bean.getThesisTitle());
        this.setThesisTitleEn(bean.getThesisTitleEn());
        this.setCollaborationType(bean.getCollaborationType());
        if (bean.getCollaborationType().needExtraInformation()) {
            String obj = bean.getOtherCollaborationType();
            String[] args = new String[]{};
            if (obj == null || obj.isEmpty()) {
                throw new DomainException("error.PhdIndividualProgramProcess.invalid.other.collaboration.type", args);
            }
            this.setOtherCollaborationType(bean.getOtherCollaborationType());
        }
        this.setQualificationExamsRequired(bean.getQualificationExamsRequiredBooleanValue());
        this.setQualificationExamsPerformed(bean.getQualificationExamsPerformedBooleanValue());
        if (this.getHasStartedStudies()) {
            this.getCandidacyProcess().setWhenRatified(bean.getWhenRatified());
            this.setWhenFormalizedRegistration(bean.getWhenFormalizedRegistration());
            this.setWhenStartedStudies(bean.getWhenStartedStudies());
        }
        this.getPhdIndividualProcessNumber().edit(bean);
        return this;
    }

    public LocalDate getCandidacyDate() {
        return this.getCandidacyProcess().getCandidacyDate();
    }

    public boolean isCancelled() {
        return this.getActiveState() == PhdIndividualProgramProcessState.CANCELLED;
    }

    public Collection<PhdCandidacyReferee> getPhdCandidacyReferees() {
        return this.getCandidacyProcess().getCandidacyRefereesSet();
    }

    public Collection<Qualification> getQualifications() {
        return this.getPerson().getAssociatedQualificationsSet();
    }

    public List<Qualification> getQualificationsSortedByAttendedEndDate() {
        ArrayList<Qualification> result = new ArrayList<Qualification>(this.getQualifications());
        Collections.sort(result, Qualification.COMPARATOR_BY_MOST_RECENT_ATTENDED_END);
        return result;
    }

    public List<PhdProgramProcessDocument> getCandidacyProcessDocuments() {
        return new ArrayList<PhdProgramProcessDocument>(this.getCandidacyProcess().getLatestDocumentVersions());
    }

    public boolean hasCandidacyProcessDocument(PhdIndividualProgramDocumentType type) {
        return this.getCandidacyProcess().getLatestDocumentVersionFor(type) != null;
    }

    public int getCandidacyProcessDocumentsCount(PhdIndividualProgramDocumentType type) {
        return this.getCandidacyProcess().getDocumentsCount(type);
    }

    public PhdProgramPublicCandidacyHashCode getCandidacyProcessHashCode() {
        return this.getCandidacyProcess().getCandidacyHashCode();
    }

    public static List<PhdIndividualProgramProcess> search(java.util.function.Predicate<PhdIndividualProgramProcess> searchPredicate) {
        return PhdIndividualProgramProcess.search(null, searchPredicate);
    }

    public static List<PhdIndividualProgramProcess> search(ExecutionYear year, java.util.function.Predicate<PhdIndividualProgramProcess> searchPredicate) {
        HashSet<PhdIndividualProgramProcess> processesToSearch = new HashSet<PhdIndividualProgramProcess>();
        for (PhdIndividualProgramProcessNumber phdIndividualProgramProcessNumber : Bennu.getInstance().getPhdIndividualProcessNumbersSet()) {
            if (year != null && !phdIndividualProgramProcessNumber.getProcess().getExecutionYear().equals(year)) continue;
            processesToSearch.add(phdIndividualProgramProcessNumber.getProcess());
        }
        return PhdIndividualProgramProcess.filter(processesToSearch, searchPredicate);
    }

    private static <T> List<T> filter(Collection<T> collection, java.util.function.Predicate<T> predicate) {
        ArrayList<T> result = new ArrayList<T>();
        for (T each : collection) {
            if (!predicate.test(each)) continue;
            result.add(each);
        }
        return result;
    }

    public Set<PhdAlert> getActiveAlerts() {
        HashSet<PhdAlert> result = new HashSet<PhdAlert>();
        for (PhdAlert each : this.getAlertsSet()) {
            if (!each.isActive()) continue;
            result.add(each);
        }
        return result;
    }

    public Set<PhdAlertMessage> getUnreadAlertMessagesForLoggedPerson() {
        return this.getUnreadedAlertMessagesFor(AccessControl.getPerson());
    }

    public Set<PhdAlertMessage> getUnreadedAlertMessagesFor(Person person) {
        HashSet<PhdAlertMessage> result = new HashSet<PhdAlertMessage>();
        for (PhdAlertMessage each : this.getAlertMessagesSet()) {
            if (each.isReaded() || !each.isFor(person)) continue;
            result.add(each);
        }
        return result;
    }

    public Set<PhdAlertMessage> getAlertMessagesForLoggedPerson() {
        return this.getAlertMessagesFor(AccessControl.getPerson());
    }

    public Set<PhdAlertMessage> getAlertMessagesFor(Person person) {
        HashSet<PhdAlertMessage> result = new HashSet<PhdAlertMessage>();
        for (PhdAlertMessage each : this.getAlertMessagesSet()) {
            if (!each.isFor(person)) continue;
            result.add(each);
        }
        return result;
    }

    public boolean isValidatedByCandidate() {
        return this.getCandidacyProcess().isValidatedByCandidate();
    }

    public Set<PhdProgramProcessDocument> getStudyPlanRelevantDocuments() {
        return this.getCandidacyProcess().getStudyPlanRelevantDocuments();
    }

    public boolean isRegistrationFormalized() {
        return this.getWhenFormalizedRegistration() != null;
    }

    private boolean hasAnyActiveAlertFor(Class<? extends PhdAlert> type) {
        for (Alert alert : this.getActiveAlerts()) {
            if (!((Object)((Object)alert)).getClass().equals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyRegistrationFormalizationActiveAlert() {
        return this.hasAnyActiveAlertFor(PhdRegistrationFormalizationAlert.class);
    }

    public boolean hasMissingPersonalInformation(ExecutionYear executionYear) {
        return this.getPrecedentDegreeInformation(executionYear) == null || !this.getPersonalInformationBean(executionYear).isValid();
    }

    public PrecedentDegreeInformation getPrecedentDegreeInformation(ExecutionYear executionYear) {
        PrecedentDegreeInformation result = null;
        for (PrecedentDegreeInformation precedentDegreeInfo : this.getPrecedentDegreeInformationsSet()) {
            if (!precedentDegreeInfo.getPersonalIngressionData().getExecutionYear().equals(executionYear) || result != null && !result.getLastModifiedDate().isBefore((ReadableInstant)precedentDegreeInfo.getLastModifiedDate())) continue;
            result = precedentDegreeInfo;
        }
        return result;
    }

    public PersonalInformationBean getPersonalInformationBean(ExecutionYear executionYear) {
        PrecedentDegreeInformation precedentInformation = this.getPrecedentDegreeInformation(executionYear);
        if (precedentInformation == null) {
            precedentInformation = this.getLatestPrecedentDegreeInformation();
        }
        if (precedentInformation == null) {
            return new PersonalInformationBean(this);
        }
        return new PersonalInformationBean(precedentInformation);
    }

    public PrecedentDegreeInformation getLatestPrecedentDegreeInformation() {
        TreeSet<PrecedentDegreeInformation> degreeInformations = new TreeSet<PrecedentDegreeInformation>(Collections.reverseOrder(PrecedentDegreeInformation.COMPARATOR_BY_EXECUTION_YEAR));
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        for (PrecedentDegreeInformation pdi : this.getPrecedentDegreeInformationsSet()) {
            if (pdi.getExecutionYear().isAfter(currentExecutionYear)) continue;
            degreeInformations.add(pdi);
        }
        degreeInformations.addAll(this.getPrecedentDegreeInformationsSet());
        return degreeInformations.iterator().hasNext() ? degreeInformations.iterator().next() : null;
    }

    public PhdProgramProcessState getMostRecentState() {
        return (PhdProgramProcessState)((Object)super.getMostRecentState());
    }

    public PhdIndividualProgramProcessState getActiveState() {
        return (PhdIndividualProgramProcessState)super.getActiveState();
    }

    public boolean isActive(Interval interval) {
        ArrayList<Interval> activeStatesIntervals = new ArrayList<Interval>();
        TreeSet<PhdProcessState> states = new TreeSet<PhdProcessState>(new Comparator<PhdProcessState>(){

            @Override
            public int compare(PhdProcessState o1, PhdProcessState o2) {
                DateTime o1StateDate = o1.getStateDate() == null ? o1.getWhenCreated() : o1.getStateDate();
                DateTime o2StateDate = o2.getStateDate() == null ? o2.getWhenCreated() : o2.getStateDate();
                int result = o1StateDate.compareTo((ReadableInstant)o2StateDate);
                return result != 0 ? result : o1.getExternalId().compareTo(o2.getExternalId());
            }
        });
        states.addAll(this.getStates());
        DateTime beginActiveDate = null;
        for (PhdProgramProcessState phdProgramProcessState : states) {
            if (phdProgramProcessState.getType().isActive() && beginActiveDate == null) {
                DateTime dateTime = beginActiveDate = phdProgramProcessState.getStateDate() == null ? phdProgramProcessState.getWhenCreated() : phdProgramProcessState.getStateDate();
            }
            if (phdProgramProcessState.getType().isActive() || beginActiveDate == null) continue;
            activeStatesIntervals.add(new Interval((ReadableInstant)beginActiveDate, (ReadableInstant)(phdProgramProcessState.getStateDate() == null ? phdProgramProcessState.getWhenCreated() : phdProgramProcessState.getStateDate())));
            beginActiveDate = null;
        }
        for (Interval interval2 : activeStatesIntervals) {
            if (!interval.overlaps((ReadableInterval)interval2)) continue;
            return true;
        }
        return activeStatesIntervals.size() == 0 && beginActiveDate != null;
    }

    public Student getStudent() {
        return this.getPerson().getStudent();
    }

    public boolean isCoordinatorForPhdProgram(Person person) {
        if (this.getPhdProgram().getDegree() == null) {
            return false;
        }
        ExecutionDegree executionDegree = this.getPhdProgram().getDegree().getLastActiveDegreeCurricularPlan().getExecutionDegreeByAcademicInterval(ExecutionYear.readCurrentExecutionYear().getAcademicInterval());
        if (executionDegree != null) {
            for (Coordinator coordinator : executionDegree.getCoordinatorsListSet()) {
                if (coordinator.getPerson() != person) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isGuiderOrAssistentGuider(Person person) {
        return this.isGuider(person) || this.isAssistantGuider(person);
    }

    public boolean isGuider(Person person) {
        for (PhdParticipant guiding : this.getGuidingsSet()) {
            if (!guiding.isFor(person)) continue;
            return true;
        }
        return false;
    }

    public boolean isGuider(PhdParticipant participant) {
        return this.getGuidingsSet().contains((Object)participant);
    }

    public boolean isAssistantGuider(Person person) {
        for (PhdParticipant guiding : this.getAssistantGuidingsSet()) {
            if (!guiding.isFor(person)) continue;
            return true;
        }
        return false;
    }

    public boolean isAssistantGuider(PhdParticipant participant) {
        return this.getAssistantGuidingsSet().contains((Object)participant);
    }

    public boolean isRegistrationAvailable() {
        return this.getRegistration() != null && AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_REGISTRATIONS, Authenticate.getUser()).collect(Collectors.toSet()).contains(this.getRegistration().getDegree());
    }

    protected PhdIndividualProgramProcess getIndividualProgramProcess() {
        return this;
    }

    public Set<PhdParticipant> getGuidingsAndAssistantGuidings() {
        HashSet<PhdParticipant> result = new HashSet<PhdParticipant>();
        result.addAll(this.getAssistantGuidingsSet());
        result.addAll(this.getGuidingsSet());
        return result;
    }

    public void cancelDebts(Person person) {
        if (this.getCandidacyProcess() != null && !this.getCandidacyProcess().hasAnyPayments()) {
            this.getCandidacyProcess().cancelDebt(person);
        }
        if (this.getRegistrationFee() != null && !this.getRegistrationFee().hasAnyPayments() && this.getRegistrationFee().isOpen()) {
            this.getRegistrationFee().cancel(person);
        }
    }

    public boolean hasSchoolPartConcluded() {
        boolean concluded = this.getRegistration() != null && (this.getRegistration().isSchoolPartConcluded() || this.getRegistration().isConcluded());
        return this.getStudyPlan() != null && this.getStudyPlan().isExempted() || concluded;
    }

    public boolean hasQualificationExamsToPerform() {
        return this.isQualificationExamsRequired() && !this.isQualificationExamsPerformed();
    }

    private boolean isQualificationExamsPerformed() {
        return this.getQualificationExamsPerformed() != null && this.getQualificationExamsPerformed() != false;
    }

    private boolean isQualificationExamsRequired() {
        return this.getQualificationExamsRequired() != null && this.getQualificationExamsRequired() != false;
    }

    public boolean hasSeminarReportDocument() {
        return this.getSeminarProcess() != null && this.getSeminarProcess().hasReportDocument();
    }

    public Set<Person> getCoordinatorsFor(ExecutionYear executionYear) {
        return this.getPhdProgram().getCoordinatorsFor(executionYear);
    }

    public Set<Person> getResponsibleCoordinatorsFor(ExecutionYear executionYear) {
        return this.getPhdProgram().getResponsibleCoordinatorsFor(executionYear);
    }

    public boolean hasPhdPublicPresentationSeminarAlert() {
        return this.hasPhdAlert(PhdPublicPresentationSeminarAlert.class);
    }

    public boolean hasPhdFinalProofRequestAlert() {
        return this.hasPhdAlert(PhdFinalProofRequestAlert.class);
    }

    protected boolean hasPhdAlert(Class<? extends PhdAlert> clazz) {
        for (Alert alert : this.getAlertsSet()) {
            if (!clazz.isAssignableFrom(((Object)((Object)alert)).getClass())) continue;
            return true;
        }
        return false;
    }

    public PhdParticipant getParticipant(Person person) {
        for (PhdParticipant participant : this.getParticipantsSet()) {
            if (!participant.isFor(person)) continue;
            return participant;
        }
        return null;
    }

    public boolean isParticipant(Person person) {
        return this.getParticipant(person) != null;
    }

    public Collection<PhdProcessStateType> getAllPhdProcessStateTypes() {
        HashSet<PhdProcessStateType> result = new HashSet<PhdProcessStateType>();
        if (this.getCandidacyProcess() != null) {
            result.add(this.getCandidacyProcess().getActiveState());
            if (this.getCandidacyProcess().getFeedbackRequest() != null) {
                result.add(this.getCandidacyProcess().getFeedbackRequest().getActiveState());
            }
        }
        if (this.getSeminarProcess() != null) {
            result.add(this.getSeminarProcess().getActiveState());
        }
        if (this.getThesisProcess() != null) {
            result.add(this.getThesisProcess().getActiveState());
        }
        return result;
    }

    public Collection<CompetenceCourse> getCompetenceCoursesAvailableToEnrol() {
        if (this.getStudyPlan() == null) {
            return Collections.emptySet();
        }
        HashSet<CompetenceCourse> result = new HashSet<CompetenceCourse>();
        for (PhdStudyPlanEntry entry : this.getStudyPlan().getEntriesSet()) {
            if (!entry.isInternalEntry()) continue;
            result.add(((InternalPhdStudyPlanEntry)((Object)entry)).getCompetenceCourse());
        }
        return result;
    }

    public LocalDate getConclusionDate() {
        if (this.isConclusionProcessed()) {
            return this.getLastConclusionProcess().getConclusionDate();
        }
        return this.getThesisProcess() != null ? this.getThesisProcess().getConclusionDate() : null;
    }

    public ExecutionYear getConclusionYear() {
        LocalDate conclusionDate = this.getConclusionDate();
        if (conclusionDate == null) {
            return null;
        }
        int year = conclusionDate.getYear();
        String executionYearName = String.format("%s/%s", year - 1, year);
        return ExecutionYear.readExecutionYearByName(executionYearName);
    }

    public boolean hasCurricularCoursesToEnrol() {
        return this.getStudyPlan() != null && !this.getStudyPlan().isExempted() && this.getStudyPlan().isToEnrolInCurricularCourses();
    }

    public boolean hasPropaeudeuticsOrExtraEntriesApproved() {
        if (this.getStudyPlan() == null || this.getRegistration() == null) {
            return false;
        }
        return this.getStudyPlan().isExempted() || this.getStudyPlan().hasPropaeudeuticsOrExtraEntriesApproved();
    }

    public boolean isFlunked() {
        return this.getMostRecentState().isFlunked();
    }

    public boolean isSuspended() {
        return this.getMostRecentState().isSuspended();
    }

    protected List<PhdProgramProcessState> getActiveStates() {
        ArrayList<PhdProgramProcessState> result = new ArrayList<PhdProgramProcessState>();
        CollectionUtils.select((Collection)this.getStates(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((PhdProgramProcessState)((Object)arg0)).getType().isActive();
            }
        }, result);
        return result;
    }

    protected boolean hasActiveStates() {
        return !this.getActiveStates().isEmpty();
    }

    public PhdProgramProcessState getLastActiveState() {
        return this.hasActiveStates() ? (PhdProgramProcessState)((Object)Collections.max(this.getActiveStates(), PhdProcessState.COMPARATOR_BY_DATE)) : null;
    }

    public boolean isMigratedProcess() {
        return this.getPhdConfigurationIndividualProgramProcess().isMigratedProcess();
    }

    public Integer getPhdStudentNumber() {
        return this.getPhdIndividualProcessNumber().getPhdStudentNumber();
    }

    public boolean isProcessIndividualProgram() {
        return true;
    }

    public boolean isConcluded() {
        return this.getThesisProcess() != null && this.getThesisProcess().isConcluded();
    }

    public boolean getHasStartedStudies() {
        for (PhdProgramProcessState state : this.getActiveStates()) {
            if (!state.getType().equals(PhdIndividualProgramProcessState.WORK_DEVELOPMENT)) continue;
            return true;
        }
        return false;
    }

    public boolean isProcessActive() {
        PhdProgramProcessState mostRecentState = this.getMostRecentState();
        return mostRecentState != null ? mostRecentState.getType().equals(PhdIndividualProgramProcessState.WORK_DEVELOPMENT) || mostRecentState.getType().equals(PhdIndividualProgramProcessState.THESIS_DISCUSSION) : false;
    }

    public PhdThesisFinalGrade getFinalGrade() {
        if (!this.isConcluded()) {
            return null;
        }
        if (this.isConclusionProcessed()) {
            return this.getLastConclusionProcess().getFinalGrade();
        }
        return this.getThesisProcess().getFinalGrade();
    }

    public Set<PhdGuidanceDocument> getLatestGuidanceDocumentVersions() {
        HashSet<PhdGuidanceDocument> documents = new HashSet<PhdGuidanceDocument>();
        CollectionUtils.select((Collection)this.getLatestDocumentVersions(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((PhdProgramProcessDocument)((Object)arg0)).getDocumentType().isForGuidance();
            }
        }, documents);
        return documents;
    }

    public boolean hasAssociatedMigrationProcess() {
        return this.getAssociatedMigrationProcess() != null;
    }

    public PhdMigrationIndividualProcessData getAssociatedMigrationProcess() {
        if (!this.isMigratedProcess() || this.getPhdStudentNumber() == null) {
            return null;
        }
        for (PhdMigrationProcess migrationProcess : Bennu.getInstance().getPhdMigrationProcessesSet()) {
            for (PhdMigrationIndividualProcessData processData : migrationProcess.getPhdMigrationIndividualProcessDataSet()) {
                if (!processData.getNumber().equals(this.getPhdStudentNumber())) continue;
                return processData;
            }
        }
        return null;
    }

    public PhdMigrationGuiding getAssociatedMigrationGuiding() {
        if (!this.hasAssociatedMigrationProcess()) {
            return null;
        }
        PhdMigrationIndividualProcessDataBean processDataBean = this.getAssociatedMigrationProcess().getProcessBean();
        return this.getAssociatedMigrationgGuidingOrAssistant(processDataBean.getGuiderId());
    }

    public PhdMigrationGuiding getAssociatedMigrationAssistantGuiding() {
        if (!this.hasAssociatedMigrationProcess()) {
            return null;
        }
        PhdMigrationIndividualProcessDataBean processDataBean = this.getAssociatedMigrationProcess().getProcessBean();
        return this.getAssociatedMigrationgGuidingOrAssistant(processDataBean.getAssistantGuiderId());
    }

    private PhdMigrationGuiding getAssociatedMigrationgGuidingOrAssistant(String guiderId) {
        for (PhdMigrationProcess migrationProcess : Bennu.getInstance().getPhdMigrationProcessesSet()) {
            for (PhdMigrationGuiding guidingData : migrationProcess.getPhdMigrationGuidingSet()) {
                if (!guidingData.getTeacherId().equals(guiderId)) continue;
                return guidingData;
            }
        }
        return null;
    }

    public static List<PhdMigrationIndividualProcessData> searchMigrationProcesses(ExecutionYear year, java.util.function.Predicate<PhdMigrationIndividualProcessData> searchPredicate) {
        ArrayList<PhdMigrationIndividualProcessData> processDataList = new ArrayList<PhdMigrationIndividualProcessData>();
        for (PhdMigrationProcess migrationProcess : Bennu.getInstance().getPhdMigrationProcessesSet()) {
            for (PhdMigrationIndividualProcessData processData : migrationProcess.getPhdMigrationIndividualProcessDataSet()) {
                ExecutionYear processYear = processData.getExecutionYear();
                if (processYear != null && year != null && !processYear.equals(year)) continue;
                processDataList.add(processData);
            }
        }
        return PhdIndividualProgramProcess.filter(processDataList, searchPredicate);
    }

    public static Collection<PhdMigrationProcess> getMigrationProcesses() {
        return Bennu.getInstance().getPhdMigrationProcessesSet();
    }

    public boolean isTransferable() {
        return this.getHasStartedStudies() && this.getDestiny() == null;
    }

    public boolean isTransferred() {
        return PhdIndividualProgramProcessState.TRANSFERRED.equals(this.getActiveState());
    }

    public boolean isFromTransferredProcess() {
        return this.getSource() != null;
    }

    public void transferToAnotherProcess(PhdIndividualProgramProcess destiny, Person responsible, String remarks) {
        if (!this.isTransferable()) {
            throw new DomainException("phd.PhdIndividualProgramProcess.cannot.be.transferred", new String[0]);
        }
        if (this.getRegistration() != null && this.getRegistration().isConcluded()) {
            throw new DomainException("phd.PhdIndividualProgramProcess.source.registration.is.concluded", new String[0]);
        }
        this.createState(PhdIndividualProgramProcessState.TRANSFERRED, this.getPerson(), remarks);
        if (this.getRegistration() != null && this.getRegistration().isActive()) {
            RegistrationState.createRegistrationState(this.getRegistration(), responsible, new DateTime(), RegistrationStateType.INTERNAL_ABANDON);
        }
        super.setDestiny(destiny);
        destiny.assignSource(this);
    }

    private void assignSource(PhdIndividualProgramProcess source) {
        if (source.getDestiny() != this) {
            throw new DomainException("phdIndividualProgramProcess.source.has.different.destiny", new String[0]);
        }
        super.setSource(source);
    }

    public void setSource(PhdIndividualProgramProcess source) {
        throw new DomainException("phd.PhdIndividualProgramProcess.cannot.modify.source", new String[0]);
    }

    public void setDestiny(PhdIndividualProgramProcess destiny) {
        throw new DomainException("phd.PhdIndividualProgramProcess.cannot.modify.destiny", new String[0]);
    }

    public final boolean hasInsuranceDebts(ExecutionYear executionYear) {
        return this.hasAnyNotPayedInsuranceEventUntil(executionYear);
    }

    public final boolean hasAdministrativeOfficeFeeAndInsuranceDebts(AdministrativeOffice office, ExecutionYear executionYear) {
        return this.hasAnyNotPayedAdministrativeOfficeFeeAndInsuranceEventUntil(office, executionYear);
    }

    private boolean hasAnyNotPayedInsuranceEventUntil(ExecutionYear executionYear) {
        for (InsuranceEvent event : this.getPerson().getNotCancelledInsuranceEventsUntil(executionYear)) {
            if (!event.isInDebt()) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyNotPayedAdministrativeOfficeFeeAndInsuranceEventUntil(AdministrativeOffice office, ExecutionYear executionYear) {
        for (AdministrativeOfficeFeeAndInsuranceEvent event : this.getPerson().getNotCancelledAdministrativeOfficeFeeAndInsuranceEventsUntil(office, executionYear)) {
            if (!event.isInDebt()) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyNotPayedInsuranceEvents() {
        for (InsuranceEvent event : this.getPerson().getNotCancelledInsuranceEvents()) {
            if (!event.isInDebt()) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyNotPayedAdministrativeOfficeFeeAndInsuranceEvents(AdministrativeOffice office) {
        for (AdministrativeOfficeFeeAndInsuranceEvent event : this.getPerson().getNotCancelledAdministrativeOfficeFeeAndInsuranceEvents(office)) {
            if (!event.isInDebt()) continue;
            return true;
        }
        return false;
    }

    public final boolean hasInsuranceDebtsCurrently() {
        return this.hasAnyNotPayedInsuranceEvents();
    }

    public final boolean hasAdministrativeOfficeFeeAndInsuranceDebtsCurrently(AdministrativeOffice administrativeOffice) {
        return this.hasAnyNotPayedAdministrativeOfficeFeeAndInsuranceEvents(administrativeOffice);
    }

    public boolean hasDiplomaRequest() {
        for (PhdAcademicServiceRequest academicServiceRequest : this.getPhdAcademicServiceRequestsSet()) {
            if (!academicServiceRequest.isDiploma() || academicServiceRequest.isCancelled() || academicServiceRequest.isRejected()) continue;
            return true;
        }
        return false;
    }

    public PhdRegistryDiplomaRequest getRegistryDiplomaRequest() {
        for (PhdAcademicServiceRequest academicServiceRequest : this.getPhdAcademicServiceRequestsSet()) {
            if (!academicServiceRequest.isRegistryDiploma() || academicServiceRequest.isCancelled() || academicServiceRequest.isRejected()) continue;
            return (PhdRegistryDiplomaRequest)((Object)academicServiceRequest);
        }
        return null;
    }

    public boolean hasRegistryDiplomaRequest() {
        return this.getRegistryDiplomaRequest() != null;
    }

    public PhdDiplomaRequest getDiplomaRequest() {
        for (PhdAcademicServiceRequest academicServiceRequest : this.getPhdAcademicServiceRequestsSet()) {
            if (!academicServiceRequest.isDiploma() || academicServiceRequest.isCancelled() || academicServiceRequest.isRejected()) continue;
            return (PhdDiplomaRequest)((Object)academicServiceRequest);
        }
        return null;
    }

    public PhdDiplomaSupplementRequest getDiplomaSupplementRequest() {
        if (!this.hasRegistryDiplomaRequest()) {
            return null;
        }
        return this.getRegistryDiplomaRequest().getDiplomaSupplement();
    }

    public PhdConclusionProcess getLastConclusionProcess() {
        if (this.getPhdConclusionProcessesSet().isEmpty()) {
            return null;
        }
        TreeSet<PhdConclusionProcess> conclusionProcessSet = new TreeSet<PhdConclusionProcess>(PhdConclusionProcess.VERSION_COMPARATOR);
        conclusionProcessSet.addAll(this.getPhdConclusionProcessesSet());
        return (PhdConclusionProcess)((Object)conclusionProcessSet.iterator().next());
    }

    public boolean isConclusionProcessed() {
        return !this.getPhdConclusionProcessesSet().isEmpty();
    }

    public String getGraduateTitle(Locale locale) {
        StringBuilder stringBuilder = new StringBuilder(BundleUtil.getString((String)"resources.PhdResources", (Locale)locale, (String)"label.phd.graduated.title.in", (String[])new String[0])).append(" ");
        stringBuilder.append(this.getPhdProgram().getName().getContent(locale));
        return stringBuilder.toString();
    }

    public Boolean isBolonha() {
        return this.getPhdConfigurationIndividualProgramProcess().getIsBolonha() != null && this.getPhdConfigurationIndividualProgramProcess().getIsBolonha() != false;
    }

    public List<PhdAcademicServiceRequest> getNewAcademicServiceRequests() {
        ArrayList<PhdAcademicServiceRequest> result = new ArrayList<PhdAcademicServiceRequest>();
        for (PhdAcademicServiceRequest request : this.getPhdAcademicServiceRequestsSet()) {
            if (!request.isNewRequest()) continue;
            result.add(request);
        }
        return result;
    }

    public List<PhdAcademicServiceRequest> getProcessingAcademicServiceRequests() {
        ArrayList<PhdAcademicServiceRequest> result = new ArrayList<PhdAcademicServiceRequest>();
        for (PhdAcademicServiceRequest request : this.getPhdAcademicServiceRequestsSet()) {
            if (request.isNewRequest() || request.isDelivered() || request.isDeliveredSituationAccepted() || request.isCancelled() || request.isRejected()) continue;
            result.add(request);
        }
        return result;
    }

    public List<PhdAcademicServiceRequest> getToDeliverAcademicServiceRequests() {
        ArrayList<PhdAcademicServiceRequest> result = new ArrayList<PhdAcademicServiceRequest>();
        for (PhdAcademicServiceRequest request : this.getPhdAcademicServiceRequestsSet()) {
            if (!request.isDeliveredSituationAccepted()) continue;
            result.add(request);
        }
        return result;
    }

    public List<PhdAcademicServiceRequest> getHistoricalAcademicServiceRequests() {
        ArrayList<PhdAcademicServiceRequest> result = new ArrayList<PhdAcademicServiceRequest>();
        for (PhdAcademicServiceRequest request : this.getPhdAcademicServiceRequestsSet()) {
            if (!request.isDelivered() && !request.isCancelled() && !request.isRejected()) continue;
            result.add(request);
        }
        return result;
    }

    public String getThesisTitleForCertificateGeneration() {
        return this.getThesisTitle();
    }

    public Collection<ThesisSubjectOrder> getThesisSubjectOrdersSorted() {
        TreeSet<ThesisSubjectOrder> subjectOrders = new TreeSet<ThesisSubjectOrder>(ThesisSubjectOrder.COMPARATOR_BY_ORDER);
        subjectOrders.addAll(this.getThesisSubjectOrdersSet());
        return subjectOrders;
    }

    public int getHighestThesisSubjectOrder() {
        int highestOrder = 0;
        for (ThesisSubjectOrder order : this.getThesisSubjectOrdersSet()) {
            if (order.getSubjectOrder() <= highestOrder) continue;
            highestOrder = order.getSubjectOrder();
        }
        return highestOrder;
    }

    public boolean hasPhdGratuityEventForYear(int year) {
        for (PhdGratuityEvent event : this.getPhdGratuityEventsSet()) {
            if (event.getYear() != year || event.isCancelled()) continue;
            return true;
        }
        return false;
    }

    public AdministrativeOffice getAdministrativeOffice() {
        return this.getPhdProgram() != null ? this.getPhdProgram().getAdministrativeOffice() : null;
    }

    @Deprecated
    public Set<PhdProgramProcessState> getStates() {
        return this.getStatesSet();
    }

    public boolean hasAnyStates() {
        return !this.getStatesSet().isEmpty();
    }

    static {
        activities.add(new EditPersonalInformation());
        activities.add(new AddQualification());
        activities.add(new AddQualifications());
        activities.add(new DeleteQualification());
        activities.add(new AddJobInformation());
        activities.add(new DeleteJobInformation());
        activities.add(new EditIndividualProcessInformation());
        activities.add(new AddGuidingInformation());
        activities.add(new AddGuidingsInformation());
        activities.add(new DeleteGuiding());
        activities.add(new AddAssistantGuidingInformation());
        activities.add(new DeleteAssistantGuiding());
        activities.add(new CancelPhdProgramProcess());
        activities.add(new NotAdmittedPhdProgramProcess());
        activities.add(new SuspendPhdProgramProcess());
        activities.add(new FlunkedPhdProgramProcess());
        activities.add(new AddCandidacyReferees());
        activities.add(new RemoveCandidacyReferee());
        activities.add(new UploadDocuments());
        activities.add(new AddCustomAlert());
        activities.add(new DeleteCustomAlert());
        activities.add(new ValidatedByCandidate());
        activities.add(new AddStudyPlan());
        activities.add(new EditStudyPlan());
        activities.add(new AddStudyPlanEntry());
        activities.add(new DeleteStudyPlanEntry());
        activities.add(new DeleteStudyPlan());
        activities.add(new EditQualificationExams());
        activities.add(new RequestPublicPresentationSeminarComission());
        activities.add(new ExemptPublicPresentationSeminarComission());
        activities.add(new RequestPublicThesisPresentation());
        activities.add(new AcceptEnrolments());
        activities.add(new RejectEnrolments());
        activities.add(new EditWhenStartedStudies());
        activities.add(new ActivatePhdProgramProcessInCandidacyState());
        activities.add(new ActivatePhdProgramProcessInWorkDevelopmentState());
        activities.add(new ActivatePhdProgramProcessInThesisDiscussionState());
        activities.add(new ConcludeIndividualProgramProcess());
        activities.add(new ConfigurePhdIndividualProgramProcess());
        activities.add(new RemoveLastStateOnPhdIndividualProgramProcess());
        activities.add(new SendPhdEmail());
        activities.add(new DeleteGuidanceDocument());
        activities.add(new UploadGuidanceDocument());
        activities.add(new EditPhdParticipant());
        activities.add(new TransferToAnotherProcess());
        activities.add(new DissociateRegistration());
        activities.add(new UploadGuidanceAcceptanceLetter());
        activities.add(new AbandonIndividualProgramProcess());
    }

    public static class PublicPhdIndividualProgramProcess
    extends PhdIndividualProgramProcess {
        private PublicPhdIndividualProgramProcess() {
            super(null, null);
        }

        static {
            activities.add(new CreatePublicCandidacy());
        }

        @StartActivity
        public static class CreatePublicCandidacy
        extends CreateCandidacy {
            @Override
            protected void activityPreConditions(PhdIndividualProgramProcess process2, User userView) {
            }

            @Override
            protected Person getOrCreatePerson(PhdProgramCandidacyProcessBean bean) {
                Person result = !bean.getPersonBean().hasPerson() ? new Person(bean.getPersonBean()) : (bean.getPersonBean().getPerson().getUser() != null ? bean.getPersonBean().getPerson() : bean.getPersonBean().getPerson().editByPublicCandidate(bean.getPersonBean()));
                return result;
            }

            @Override
            protected PhdIndividualProgramProcess executeActivity(PhdIndividualProgramProcess noProcess, User userView, Object object) {
                PhdProgramCandidacyProcessBean bean = (PhdProgramCandidacyProcessBean)object;
                if (bean.getPersonBean().hasPerson() && PhdProgramCandidacyProcess.hasOnlineApplicationForPeriod(bean.getPersonBean().getPerson(), bean.getPhdCandidacyPeriod())) {
                    throw new DomainException("error.phd.public.candidacy.fill.personal.information.and.institution.id", new String[0]);
                }
                return super.executeActivity(noProcess, userView, object);
            }
        }
    }

    @StartActivity
    public static class CreateCandidacy
    extends PhdIndividualProgramProcessActivity {
        @Override
        protected void activityPreConditions(PhdIndividualProgramProcess process2, User userView) {
        }

        @Override
        protected PhdIndividualProgramProcess executeActivity(PhdIndividualProgramProcess noProcess, User userView, Object object) {
            PhdProgramCandidacyProcessBean bean = (PhdProgramCandidacyProcessBean)object;
            Person person = this.getOrCreatePerson(bean);
            PhdIndividualProgramProcess createdProcess = new PhdIndividualProgramProcess(bean, person);
            for (PhdThesisSubjectOrderBean thesisSubjectBean : bean.getThesisSubjectBeans()) {
                new ThesisSubjectOrder(thesisSubjectBean.getThesisSubject(), createdProcess, thesisSubjectBean.getOrder());
            }
            Process.createNewProcess(userView, PhdProgramCandidacyProcess.class, (Object)new Object[]{bean, person, createdProcess});
            if (bean.hasCandidacyHashCode()) {
                new PublicPhdMissingCandidacyValidationAlert(createdProcess);
            }
            createdProcess.createState(PhdIndividualProgramProcessState.CANDIDACY, person, "");
            return createdProcess;
        }

        protected Person getOrCreatePerson(PhdProgramCandidacyProcessBean bean) {
            Person result = !bean.getPersonBean().hasPerson() ? new Person(bean.getPersonBean()) : (bean.getPersonBean().getPerson().getUser() != null ? bean.getPersonBean().getPerson() : bean.getPersonBean().save());
            return result;
        }
    }
}

