/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.mobility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ApprovedLearningAgreementDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.NationalIdCardAvoidanceQuestion;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplication_Base;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityQuota;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityStudentData;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.enrolment.DegreeModuleToEnrol;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroupType;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class MobilityIndividualApplication
extends MobilityIndividualApplication_Base {
    public MobilityIndividualApplication() {
    }

    MobilityIndividualApplication(MobilityIndividualApplicationProcess process2, MobilityIndividualApplicationProcessBean bean) {
        this();
        Person person = this.init(bean, (IndividualCandidacyProcess)((Object)process2));
        this.createEramusStudentData(bean);
        this.associateCurricularCourses(bean.getSelectedCurricularCourses());
    }

    private void associateCurricularCourses(Set<CurricularCourse> selectedCurricularCourses) {
        for (CurricularCourse curricularCourse : selectedCurricularCourses) {
            this.addCurricularCourses(curricularCourse);
        }
    }

    private void createEramusStudentData(MobilityIndividualApplicationProcessBean bean) {
        this.setMobilityStudentData(new MobilityStudentData(this, bean.getMobilityStudentDataBean(), bean.determineMobilityQuota()));
    }

    protected void createDebt(Person person) {
    }

    protected void checkParameters(Person person, IndividualCandidacyProcess process2, IndividualCandidacyProcessBean bean) {
        MobilityIndividualApplicationProcess erasmusIndividualCandidacyProcess = (MobilityIndividualApplicationProcess)((Object)process2);
        MobilityIndividualApplicationProcessBean secondCandidacyProcessBean = (MobilityIndividualApplicationProcessBean)bean;
        LocalDate candidacyDate = bean.getCandidacyDate();
        this.checkParameters(person, erasmusIndividualCandidacyProcess, candidacyDate, null);
    }

    private void checkParameters(Person person, MobilityIndividualApplicationProcess process2, LocalDate candidacyDate, Object dummy) {
        this.checkParameters(person, (IndividualCandidacyProcess)((Object)process2), candidacyDate);
    }

    void editDegreeAndCoursesInformation(MobilityIndividualApplicationProcessBean bean) {
        HashSet<CurricularCourse> setOne = new HashSet<CurricularCourse>(this.getCurricularCoursesSet());
        setOne.addAll(bean.getSelectedCurricularCourses());
        this.getMobilityStudentData().setSelectedOpening(bean.determineMobilityQuota());
        for (CurricularCourse curricularCourse : setOne) {
            if (this.getCurricularCoursesSet().contains((Object)curricularCourse) && !bean.getSelectedCurricularCourses().contains((Object)curricularCourse)) {
                this.removeCurricularCourses(curricularCourse);
                continue;
            }
            if (this.getCurricularCoursesSet().contains((Object)curricularCourse) || !bean.getSelectedCurricularCourses().contains((Object)curricularCourse)) continue;
            this.addCurricularCourses(curricularCourse);
        }
    }

    public Degree getSelectedDegree() {
        return this.getMobilityStudentData().getSelectedOpening().getDegree();
    }

    protected boolean hasSelectedDegree() {
        return this.getSelectedDegree() != null;
    }

    public Collection<Degree> getAllDegrees() {
        ArrayList<Degree> result = new ArrayList<Degree>();
        result.add(this.getSelectedDegree());
        return result;
    }

    public String getDescription() {
        return this.getCandidacyProcess().getDisplayName() + (this.hasSelectedDegree() ? ": " + this.getSelectedDegree().getNameI18N() : "");
    }

    public MobilityIndividualApplicationProcess getCandidacyProcess() {
        return (MobilityIndividualApplicationProcess)((Object)super.getCandidacyProcess());
    }

    public ApprovedLearningAgreementDocumentFile getMostRecentApprovedLearningAgreement() {
        if (!this.hasAnyActiveApprovedLearningAgreements()) {
            return null;
        }
        ArrayList<ApprovedLearningAgreementDocumentFile> approvedLearningAgreement = new ArrayList<ApprovedLearningAgreementDocumentFile>(this.getActiveApprovedLearningAgreements());
        Collections.sort(approvedLearningAgreement, Collections.reverseOrder(ApprovedLearningAgreementDocumentFile.SUBMISSION_DATE_COMPARATOR));
        return (ApprovedLearningAgreementDocumentFile)((Object)approvedLearningAgreement.iterator().next());
    }

    public boolean isMostRecentApprovedLearningAgreementNotViewed() {
        if (!this.hasAnyActiveApprovedLearningAgreements()) {
            return false;
        }
        return !this.getMostRecentApprovedLearningAgreement().isApprovedLearningAgreementViewed();
    }

    boolean hasProcessWithAcceptNotification() {
        return this.hasProcessWithAcceptNotificationAtDate(new DateTime());
    }

    boolean hasProcessWithAcceptNotificationAtDate(DateTime dateTime) {
        return this.getMostRecentApprovedLearningAgreement() == null || this.getMostRecentApprovedLearningAgreement().getMostRecentSentEmailAcceptedStudentAction() != null && this.getMostRecentApprovedLearningAgreement().getMostRecentSentEmailAcceptedStudentAction().getWhenOccured().isBefore((ReadableInstant)dateTime);
    }

    public List<ApprovedLearningAgreementDocumentFile> getActiveApprovedLearningAgreements() {
        ArrayList<ApprovedLearningAgreementDocumentFile> activeDocuments = new ArrayList<ApprovedLearningAgreementDocumentFile>();
        CollectionUtils.select((Collection)this.getApprovedLearningAgreementsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                ApprovedLearningAgreementDocumentFile document = (ApprovedLearningAgreementDocumentFile)((Object)arg0);
                return document.getCandidacyFileActive();
            }
        }, activeDocuments);
        return activeDocuments;
    }

    public boolean hasAnyActiveApprovedLearningAgreements() {
        return !this.getActiveApprovedLearningAgreements().isEmpty();
    }

    public Registration createRegistration(DegreeCurricularPlan degreeCurricularPlan, CycleType cycleType, IngressionType ingressionType) {
        if (this.getRegistration() != null) {
            throw new DomainException("error.IndividualCandidacy.person.with.registration", degreeCurricularPlan.getPresentationName());
        }
        if (this.hasActiveRegistration(degreeCurricularPlan)) {
            Registration registration = this.getStudent().getActiveRegistrationFor(degreeCurricularPlan);
            this.setRegistration(registration);
            ExecutionYear currentYear = ExecutionYear.readCurrentExecutionYear();
            PersonalIngressionData pid = this.getStudent().getPersonalIngressionDataByExecutionYear(currentYear);
            pid.setCountryOfResidence(this.getPersonalDetails().getCountryOfResidence());
            PrecedentDegreeInformation pdi = registration.getPrecedentDegreeInformation(currentYear);
            pdi.setSchoolLevel(this.getMobilityStudentData().getSchoolLevel());
            pdi.setOtherSchoolLevel(this.getMobilityStudentData().getOtherSchoolLevel());
            return registration;
        }
        this.getPersonalDetails().ensurePersonInternalization();
        return this.createRegistration(this.getPersonalDetails().getPerson(), degreeCurricularPlan, cycleType, ingressionType);
    }

    protected Registration createRegistration(Person person, DegreeCurricularPlan degreeCurricularPlan, CycleType cycleType, IngressionType ingressionType) {
        Registration registration = new Registration(person, degreeCurricularPlan, this.getMobilityProgram().getRegistrationProtocol(), cycleType, (ExecutionYear)((Object)this.getCandidacyExecutionInterval()));
        NoCourseGroupCurriculumGroup.create(NoCourseGroupCurriculumGroupType.STANDALONE, registration.getActiveStudentCurricularPlan().getRoot());
        registration.editStartDates(this.getStartDate(), registration.getHomologationDate(), registration.getStudiesStartDate());
        this.setRegistration(registration);
        this.createRaidesInformation(registration);
        PersonalIngressionData pid = this.getStudent().getPersonalIngressionDataByExecutionYear(registration.getStartExecutionYear());
        pid.setCountryOfResidence(this.getPersonalDetails().getCountryOfResidence());
        PrecedentDegreeInformation pdi = registration.getPrecedentDegreeInformation(registration.getStartExecutionYear());
        pdi.setSchoolLevel(this.getMobilityStudentData().getSchoolLevel());
        pdi.setOtherSchoolLevel(this.getMobilityStudentData().getOtherSchoolLevel());
        return registration;
    }

    void enrol() {
        Registration registration = this.getRegistration();
        ExecutionYear executionYear = (ExecutionYear)((Object)this.getCandidacyExecutionInterval());
        ExecutionSemester semesterToEnrol = executionYear.getFirstExecutionPeriod();
        HashSet<IDegreeModuleToEvaluate> degreeModulesToEnrol = new HashSet<IDegreeModuleToEvaluate>();
        degreeModulesToEnrol.addAll(this.getModulesToEnrolForFirstSemester());
        registration.getActiveStudentCurricularPlan().enrol(semesterToEnrol, degreeModulesToEnrol, Collections.EMPTY_LIST, CurricularRuleLevel.ENROLMENT_NO_RULES);
    }

    public Collection<DegreeModuleToEnrol> getModulesToEnrolForFirstSemester() {
        Registration registration = this.getRegistration();
        ExecutionYear executionYear = (ExecutionYear)((Object)this.getCandidacyExecutionInterval());
        ExecutionSemester semesterToEnrol = executionYear.getFirstExecutionPeriod();
        StudentCurricularPlan studentCurricularPlan = registration.getActiveStudentCurricularPlan();
        DegreeCurricularPlan degreeCurricularPlan = registration.getLastDegreeCurricularPlan();
        HashSet<DegreeModuleToEnrol> degreeModulesToEnrol = new HashSet<DegreeModuleToEnrol>();
        for (CurricularCourse selectedCurricularCourse : this.getCurricularCoursesSet()) {
            List contextList = selectedCurricularCourse.getParentContextsByExecutionSemester(semesterToEnrol);
            if (contextList.isEmpty()) continue;
            Context selectedContext = (Context)contextList.iterator().next();
            Object curriculumGroup = null;
            curriculumGroup = selectedCurricularCourse.getDegreeCurricularPlan().equals((Object)degreeCurricularPlan) ? studentCurricularPlan.getRoot().findCurriculumGroupFor(selectedContext.getParentCourseGroup()) : studentCurricularPlan.getStandaloneCurriculumGroup();
            if (curriculumGroup == null) continue;
            DegreeModuleToEnrol toEnrol = new DegreeModuleToEnrol((CurriculumGroup)((Object)curriculumGroup), selectedContext, semesterToEnrol);
            degreeModulesToEnrol.add(toEnrol);
        }
        return degreeModulesToEnrol;
    }

    public void answerNationalIdCardAvoidanceOnSubmission(MobilityIndividualApplicationProcessBean bean) {
        NationalIdCardAvoidanceQuestion question = bean.getNationalIdCardAvoidanceQuestion();
        this.setNationalIdCardAvoidanceQuestion(question);
        this.setNationalIdCardAvoidanceAnswerDate(new DateTime());
        this.setIdCardAvoidanceOtherReason(bean.getIdCardAvoidanceOtherReason());
    }

    public boolean isErasmus() {
        return true;
    }

    public MobilityProgram getMobilityProgram() {
        MobilityQuota selectedOpening = this.getMobilityStudentData().getSelectedOpening();
        return selectedOpening.getMobilityAgreement().getMobilityProgram();
    }
}

