/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.paymentPlans;

import java.util.Collection;
import java.util.Collections;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.Installment;
import org.fenixedu.academic.domain.accounting.PaymentPlan;
import org.fenixedu.academic.domain.accounting.ServiceAgreement;
import org.fenixedu.academic.domain.accounting.ServiceAgreementPaymentPlan;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEventWithPaymentPlan;
import org.fenixedu.academic.domain.accounting.paymentPlanRules.PaymentPlanRule;
import org.fenixedu.academic.domain.accounting.paymentPlans.CustomGratuityPaymentPlan_Base;
import org.fenixedu.academic.domain.accounting.serviceAgreements.DegreeCurricularPlanServiceAgreement;
import org.fenixedu.academic.domain.exceptions.DomainException;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class CustomGratuityPaymentPlan
extends CustomGratuityPaymentPlan_Base {
    private CustomGratuityPaymentPlan() {
    }

    public CustomGratuityPaymentPlan(ExecutionYear executionYear, DegreeCurricularPlanServiceAgreement serviceAgreement) {
        this();
        super.init(executionYear, (ServiceAgreement)((Object)serviceAgreement), Boolean.FALSE);
    }

    public boolean isGratuityPaymentPlan() {
        return true;
    }

    public boolean isCustomGratuityPaymentPlan() {
        return true;
    }

    public void delete() {
        while (!this.getInstallmentsSet().isEmpty()) {
            ((Installment)((Object)this.getInstallmentsSet().iterator().next())).delete();
        }
        this.getGratuityEventsWithPaymentPlanSet().clear();
        this.removeParameters();
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    protected Collection<PaymentPlanRule> getSpecificPaymentPlanRules() {
        return Collections.emptyList();
    }

    static {
        CustomGratuityPaymentPlan.getRelationServiceAgreementServiceAgreementPaymentPlan().addListener((RelationListener)new RelationAdapter<ServiceAgreement, ServiceAgreementPaymentPlan>(){

            public void beforeAdd(ServiceAgreement serviceAgreement, ServiceAgreementPaymentPlan paymentPlanToAdd) {
                if (paymentPlanToAdd != null && paymentPlanToAdd.isCustomGratuityPaymentPlan() && serviceAgreement.hasCustomGratuityPaymentPlan(paymentPlanToAdd.getExecutionYear())) {
                    throw new DomainException("error.domain.accounting.ServiceAgreement.already.has.a.customGratuity.payment.plan.for.execution.year", new String[0]);
                }
            }
        });
        CustomGratuityPaymentPlan.getRelationGratuityPaymentPlanGratuityEventWithPaymentPlan().addListener((RelationListener)new RelationAdapter<PaymentPlan, GratuityEventWithPaymentPlan>(){

            public void beforeAdd(PaymentPlan paymentPlan, GratuityEventWithPaymentPlan event) {
                if (paymentPlan != null && event != null && paymentPlan.isCustomGratuityPaymentPlan() && !paymentPlan.getGratuityEventsWithPaymentPlanSet().isEmpty()) {
                    throw new DomainException("error.domain.accounting.PaymentPlan.already.has.gratuityEvent", new String[0]);
                }
            }
        });
    }
}

