/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.Alumni;
import org.fenixedu.academic.domain.Formation;
import org.fenixedu.academic.domain.Job;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentNotUpdatedAlumniInfoForSpecificDaysGroup;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.MobilePhone;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;

@GroupOperator(value="notUpdatedAlumniInfoForSpecificDays")
public class NotUpdatedAlumniInfoForSpecificDaysGroup
extends FenixGroup {
    private static final long serialVersionUID = -2553217955281571304L;
    @GroupArgument
    private Integer daysNotUpdated;
    @GroupArgument
    private Boolean checkJobNotUpdated;
    @GroupArgument
    private Boolean checkFormationNotUpdated;
    @GroupArgument
    private Boolean checkPersonalDataNotUpdated;

    private NotUpdatedAlumniInfoForSpecificDaysGroup() {
    }

    private NotUpdatedAlumniInfoForSpecificDaysGroup(Integer daysNotUpdated, Boolean checkJobNotUpdated, Boolean checkFormationNotUpdated, Boolean checkPersonalDataNotUpdated) {
        this();
        this.daysNotUpdated = daysNotUpdated;
        this.checkJobNotUpdated = checkJobNotUpdated;
        this.checkFormationNotUpdated = checkFormationNotUpdated;
        this.checkPersonalDataNotUpdated = checkPersonalDataNotUpdated;
    }

    public static NotUpdatedAlumniInfoForSpecificDaysGroup get(Integer daysNotUpdated, Boolean checkJobNotUpdated, Boolean checkFormationNotUpdated, Boolean checkPersonalDataNotUpdated) {
        return new NotUpdatedAlumniInfoForSpecificDaysGroup(daysNotUpdated, checkJobNotUpdated, checkFormationNotUpdated, checkPersonalDataNotUpdated);
    }

    @Override
    public String getPresentationName() {
        String[] args = new String[4];
        String key = "label.name.alumniInfoNotUpdated.oneItem";
        int iter = 0;
        if (this.checkFormationNotUpdated.booleanValue()) {
            args[iter] = BundleUtil.getString((String)this.getPresentationNameBundle(), (String)"label.name.alumni.formationInfo", (String[])new String[0]);
            ++iter;
        }
        if (this.checkJobNotUpdated.booleanValue()) {
            args[iter] = BundleUtil.getString((String)this.getPresentationNameBundle(), (String)"label.name.alumni.jobInfo", (String[])new String[0]);
            ++iter;
        }
        if (this.checkPersonalDataNotUpdated.booleanValue()) {
            args[iter] = BundleUtil.getString((String)this.getPresentationNameBundle(), (String)"label.name.alumni.personalDataInfo", (String[])new String[0]);
            ++iter;
        }
        if (iter == 2) {
            key = "label.name.alumniInfoNotUpdated.twoItems";
        } else if (iter == 3) {
            key = "label.name.alumniInfoNotUpdated.threeItems";
        }
        args[iter] = Integer.toString(this.daysNotUpdated);
        return BundleUtil.getString((String)this.getPresentationNameBundle(), (String)key, (String[])args);
    }

    public Set<User> getMembers() {
        HashSet<User> users = new HashSet<User>();
        DateTime now = new DateTime();
        boolean continueCicle = false;
        block0: for (Alumni alumni : Bennu.getInstance().getAlumnisSet()) {
            User user;
            if (this.checkJobNotUpdated.booleanValue()) {
                for (Job job : alumni.getJobs()) {
                    if (job.getLastModifiedDate() != null && (job.getLastModifiedDate() == null || !this.notRecentlyUpdated(now, job.getLastModifiedDate())) || (user = alumni.getStudent().getPerson().getUser()) == null) continue;
                    users.add(user);
                    continueCicle = true;
                    break;
                }
            }
            if (continueCicle) {
                continueCicle = false;
                continue;
            }
            if (this.checkPersonalDataNotUpdated.booleanValue()) {
                boolean areMailContactsRecent = alumni.getStudent().getPerson().areContactsRecent(EmailAddress.class, this.daysNotUpdated);
                boolean areMobileContactsRecent = alumni.getStudent().getPerson().areContactsRecent(MobilePhone.class, this.daysNotUpdated);
                if (!(areMailContactsRecent && areMobileContactsRecent || (user = alumni.getStudent().getPerson().getUser()) == null)) {
                    users.add(user);
                    continue;
                }
            }
            if (!this.checkFormationNotUpdated.booleanValue()) continue;
            for (Formation formation : alumni.getFormations()) {
                if (formation.getLastModificationDateDateTime() != null && (formation.getLastModificationDateDateTime() == null || !this.notRecentlyUpdated(now, formation.getLastModificationDateDateTime())) || (user = alumni.getStudent().getPerson().getUser()) == null) continue;
                users.add(user);
                continue block0;
            }
        }
        return users;
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        if (user == null || user.getPerson().getStudent() == null || user.getPerson().getStudent().getAlumni() == null) {
            return false;
        }
        DateTime now = new DateTime();
        if (this.checkJobNotUpdated.booleanValue()) {
            for (Job job : user.getPerson().getJobsSet()) {
                if (job.getLastModifiedDate() != null && (job.getLastModifiedDate() == null || !this.notRecentlyUpdated(now, job.getLastModifiedDate()))) continue;
                return true;
            }
        }
        if (this.checkFormationNotUpdated.booleanValue()) {
            for (Formation formation : user.getPerson().getFormations()) {
                if (formation.getLastModificationDateDateTime() != null && (formation.getLastModificationDateDateTime() == null || !this.notRecentlyUpdated(now, formation.getLastModificationDateDateTime()))) continue;
                return true;
            }
        }
        if (this.checkPersonalDataNotUpdated.booleanValue()) {
            boolean areMailContactsRecent = user.getPerson().areContactsRecent(EmailAddress.class, this.daysNotUpdated);
            boolean areMobileContactsRecent = user.getPerson().areContactsRecent(MobilePhone.class, this.daysNotUpdated);
            if (!areMailContactsRecent || !areMobileContactsRecent) {
                return true;
            }
        }
        return false;
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    private boolean notRecentlyUpdated(DateTime now, DateTime lastModifiedDate) {
        Days days = Days.daysBetween((ReadableInstant)lastModifiedDate, (ReadableInstant)now);
        return days.getDays() > this.daysNotUpdated;
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentNotUpdatedAlumniInfoForSpecificDaysGroup.getInstance(this.daysNotUpdated, this.checkJobNotUpdated, this.checkFormationNotUpdated, this.checkPersonalDataNotUpdated);
    }

    public boolean equals(Object object) {
        if (object instanceof NotUpdatedAlumniInfoForSpecificDaysGroup) {
            NotUpdatedAlumniInfoForSpecificDaysGroup other = (NotUpdatedAlumniInfoForSpecificDaysGroup)((Object)object);
            return Objects.equal((Object)this.daysNotUpdated, (Object)other.daysNotUpdated) && Objects.equal((Object)this.checkJobNotUpdated, (Object)other.checkJobNotUpdated) && Objects.equal((Object)this.checkFormationNotUpdated, (Object)other.checkFormationNotUpdated) && Objects.equal((Object)this.checkPersonalDataNotUpdated, (Object)other.checkPersonalDataNotUpdated);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.daysNotUpdated, this.checkJobNotUpdated, this.checkFormationNotUpdated, this.checkPersonalDataNotUpdated});
    }
}

