/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import java.util.ArrayList;
import java.util.Collection;

public class CollectionPager<T> {
    private final Collection<T> collection;
    private final int maxElementsPerPage;

    public CollectionPager(Collection<T> collection, int maxElementsPerPage) {
        this.collection = collection;
        this.maxElementsPerPage = maxElementsPerPage;
    }

    public Collection<T> getCollection() {
        return this.collection;
    }

    public int getMaxElementsPerPage() {
        return this.maxElementsPerPage;
    }

    public Collection<T> getPage(int pageNumber) {
        if (pageNumber < 1) {
            throw new IllegalArgumentException("Page number must be a positive integer.");
        }
        int startIndex = (pageNumber - 1) * this.maxElementsPerPage;
        int endIndex = pageNumber * this.maxElementsPerPage;
        ArrayList<T> page = new ArrayList<T>(this.maxElementsPerPage);
        int counter = 0;
        for (T t : this.collection) {
            if (startIndex <= counter && counter < endIndex) {
                page.add(t);
            }
            ++counter;
        }
        return page;
    }

    public int getNumberOfPages() {
        int size = this.collection.size();
        int numberOfPages = size / this.maxElementsPerPage;
        if (numberOfPages * this.maxElementsPerPage == size) {
            return numberOfPages;
        }
        return numberOfPages + 1;
    }
}

