/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.LabelValueBean;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.dto.InfoClass;
import org.fenixedu.academic.dto.InfoCurricularYear;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.dto.InfoExecutionPeriod;
import org.fenixedu.academic.dto.InfoLesson;
import org.fenixedu.academic.dto.InfoShift;
import org.fenixedu.academic.dto.resourceAllocationManager.ContextSelectionBean;
import org.fenixedu.academic.service.services.commons.ReadCurrentExecutionPeriod;
import org.fenixedu.academic.service.services.commons.ReadCurricularYearByOID;
import org.fenixedu.academic.service.services.commons.ReadExecutionCourseByOID;
import org.fenixedu.academic.service.services.commons.ReadExecutionDegreeByOID;
import org.fenixedu.academic.service.services.commons.ReadExecutionPeriodByOID;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.resourceAllocationManager.ReadClassByOID;
import org.fenixedu.academic.service.services.resourceAllocationManager.ReadLessonByOID;
import org.fenixedu.academic.service.services.resourceAllocationManager.ReadShiftByOID;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

public class ContextUtils {
    private static final Logger logger = LoggerFactory.getLogger(ContextUtils.class);

    @Deprecated
    public static final void setExecutionPeriodContext(HttpServletRequest request) throws FenixServiceException {
        String executionPeriodOIDString = (String)request.getAttribute("executionPeriodOID");
        if (executionPeriodOIDString == null) {
            executionPeriodOIDString = request.getParameter("executionPeriodOID");
        }
        String executionPeriodOID = null;
        if (executionPeriodOIDString != null && !executionPeriodOIDString.equals("") && !executionPeriodOIDString.equals("null")) {
            executionPeriodOID = executionPeriodOIDString;
        }
        InfoExecutionPeriod infoExecutionPeriod = null;
        infoExecutionPeriod = executionPeriodOID != null ? ReadExecutionPeriodByOID.run(executionPeriodOID) : ReadCurrentExecutionPeriod.run();
        if (infoExecutionPeriod != null) {
            request.setAttribute("execution_period", (Object)infoExecutionPeriod);
            request.setAttribute("executionPeriodOID", (Object)infoExecutionPeriod.getExternalId().toString());
            if (infoExecutionPeriod.getInfoExecutionYear() != null) {
                request.setAttribute("schoolYear", (Object)infoExecutionPeriod.getInfoExecutionYear().getYear());
            }
        }
    }

    public static void setExecutionDegreeContext(HttpServletRequest request) throws FenixServiceException {
        String executionDegreeOIDString = (String)request.getAttribute("execution_degree_oid");
        if (!(executionDegreeOIDString != null && executionDegreeOIDString.length() != 0 || (executionDegreeOIDString = request.getParameter("execution_degree_oid")) != null && executionDegreeOIDString.length() != 0)) {
            request.setAttribute("execution_degree", null);
        }
        InfoExecutionDegree infoExecutionDegree = null;
        if (executionDegreeOIDString != null && (infoExecutionDegree = ReadExecutionDegreeByOID.run(executionDegreeOIDString)) != null) {
            request.setAttribute("execution_degree", (Object)infoExecutionDegree);
            request.setAttribute("execution_degree_oid", (Object)infoExecutionDegree.getExternalId().toString());
        }
    }

    public static void setCurricularYearContext(HttpServletRequest request) {
        String curricularYearOIDString = (String)request.getAttribute("curricular_year_oid");
        if (curricularYearOIDString == null) {
            curricularYearOIDString = request.getParameter("curricular_year_oid");
        }
        String curricularYearOID = null;
        if (curricularYearOIDString != null && !curricularYearOIDString.equals("null")) {
            curricularYearOID = curricularYearOIDString;
        }
        InfoCurricularYear infoCurricularYear = null;
        if (curricularYearOID != null) {
            try {
                infoCurricularYear = ReadCurricularYearByOID.run(curricularYearOID);
            }
            catch (FenixServiceException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (infoCurricularYear != null) {
                request.setAttribute("curricular_year", (Object)infoCurricularYear);
                request.setAttribute("curricular_year_oid", (Object)infoCurricularYear.getExternalId().toString());
            }
        }
    }

    public static void setExecutionCourseContext(HttpServletRequest request) {
        String executionCourseOIDString = (String)request.getAttribute("execution_course_oid");
        if (executionCourseOIDString == null) {
            executionCourseOIDString = request.getParameter("execution_course_oid");
        }
        String executionCourseOID = null;
        if (executionCourseOIDString != null && !executionCourseOIDString.equals("") && !executionCourseOIDString.equals("null")) {
            executionCourseOID = executionCourseOIDString;
        }
        InfoExecutionCourse infoExecutionCourse = null;
        if (executionCourseOID != null && (infoExecutionCourse = ReadExecutionCourseByOID.run(executionCourseOID)) != null) {
            request.setAttribute("execution_course", (Object)infoExecutionCourse);
        }
    }

    public static void setShiftContext(HttpServletRequest request) {
        String shiftOIDString = (String)request.getAttribute("shift_oid");
        if (shiftOIDString == null) {
            shiftOIDString = request.getParameter("shift_oid");
        }
        InfoShift infoShift = null;
        if (shiftOIDString != null && (infoShift = ReadShiftByOID.run(shiftOIDString)) != null) {
            request.setAttribute("shift", (Object)infoShift);
        }
    }

    public static void setClassContext(HttpServletRequest request) {
        String classOIDString = (String)request.getAttribute("class_oid");
        if (classOIDString == null) {
            classOIDString = request.getParameter("class_oid");
        }
        InfoClass infoClass = null;
        if (classOIDString != null) {
            try {
                infoClass = ReadClassByOID.run(classOIDString);
            }
            catch (FenixServiceException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            request.setAttribute("context.classView", (Object)infoClass);
        }
    }

    public static void setLessonContext(HttpServletRequest request) {
        String lessonOIDString = (String)request.getAttribute("lessonOID");
        if (lessonOIDString == null) {
            lessonOIDString = request.getParameter("lessonOID");
        }
        InfoLesson infoLesson = null;
        if (lessonOIDString != null) {
            infoLesson = ReadLessonByOID.run(lessonOIDString);
            request.setAttribute("lesson_", (Object)infoLesson);
        }
    }

    @Deprecated
    public static void prepareChangeExecutionDegreeAndCurricularYear(HttpServletRequest request) {
        LabelValueBean labelValueBean;
        CharSequence name;
        InfoExecutionPeriod infoExecutionPeriod = (InfoExecutionPeriod)request.getAttribute("execution_period");
        List labelListOfCurricularYears = ContextUtils.getLabelListOfCurricularYears();
        request.setAttribute("anosCurriculares", (Object)labelListOfCurricularYears);
        ExecutionYear executionYear = infoExecutionPeriod.getExecutionPeriod().getExecutionYear();
        Set executionDegrees = executionYear.getExecutionDegreesSet();
        ArrayList<LabelValueBean> labelListOfExecutionDegrees = new ArrayList<LabelValueBean>();
        ArrayList<InfoExecutionDegree> infoExecutionDegrees = new ArrayList<InfoExecutionDegree>();
        for (ExecutionDegree executionDegree : executionDegrees) {
            infoExecutionDegrees.add(InfoExecutionDegree.newInfoFromDomain(executionDegree));
            DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
            Degree degree = degreeCurricularPlan.getDegree();
            String degreeTypeString = degree.getDegreeType().getName().getContent();
            name = new StringBuilder();
            ((StringBuilder)name).append(degreeTypeString);
            ((StringBuilder)name).append(" ").append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.in", (String[])new String[0])).append(" ");
            ((StringBuilder)name).append(degree.getNameFor(executionDegree.getExecutionYear()).getContent());
            if (ContextUtils.duplicateDegreeInList(degree, executionYear)) {
                ((StringBuilder)name).append(" - ");
                ((StringBuilder)name).append(degreeCurricularPlan.getName());
            }
            labelValueBean = new LabelValueBean(((StringBuilder)name).toString(), executionDegree.getExternalId().toString());
            labelListOfExecutionDegrees.add(labelValueBean);
        }
        Collections.sort(labelListOfExecutionDegrees);
        request.setAttribute("licenciaturas", labelListOfExecutionDegrees);
        Collections.sort(infoExecutionDegrees, InfoExecutionDegree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME);
        request.setAttribute("executionDegrees", infoExecutionDegrees);
        List<ExecutionSemester> executionSemesters = ExecutionSemester.readNotClosedExecutionPeriods();
        Collections.sort(executionSemesters);
        ArrayList<InfoExecutionPeriod> infoExecutionPeriods = new ArrayList<InfoExecutionPeriod>();
        ArrayList<LabelValueBean> executionPeriodLabelValueBeans = new ArrayList<LabelValueBean>();
        for (ExecutionSemester executionSemester : executionSemesters) {
            infoExecutionPeriods.add(InfoExecutionPeriod.newInfoFromDomain(executionSemester));
            name = executionSemester.getName() + " - " + executionSemester.getExecutionYear().getYear();
            labelValueBean = new LabelValueBean((String)name, executionSemester.getExternalId().toString());
            executionPeriodLabelValueBeans.add(labelValueBean);
        }
        request.setAttribute("infoExecutionPeriodList", infoExecutionPeriods);
        request.setAttribute("executionPeriodLabelList", executionPeriodLabelValueBeans);
    }

    private static boolean duplicateDegreeInList(Degree degree, ExecutionYear executionYear) {
        boolean foundOne = false;
        for (DegreeCurricularPlan degreeCurricularPlan : degree.getDegreeCurricularPlansSet()) {
            for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
                if (executionYear != executionDegree.getExecutionYear()) continue;
                if (foundOne) {
                    return true;
                }
                foundOne = true;
            }
        }
        return false;
    }

    public static List getLabelListOfCurricularYears() {
        ArrayList<LabelValueBean> labelListOfCurricularYears = new ArrayList<LabelValueBean>();
        labelListOfCurricularYears.add(new LabelValueBean("escolher", ""));
        labelListOfCurricularYears.add(new LabelValueBean("1 \u00ba", "1"));
        labelListOfCurricularYears.add(new LabelValueBean("2 \u00ba", "2"));
        labelListOfCurricularYears.add(new LabelValueBean("3 \u00ba", "3"));
        labelListOfCurricularYears.add(new LabelValueBean("4 \u00ba", "4"));
        labelListOfCurricularYears.add(new LabelValueBean("5 \u00ba", "5"));
        return labelListOfCurricularYears;
    }

    public static List getLabelListOfOptionalCurricularYears() {
        ArrayList<LabelValueBean> labelListOfCurricularYears = new ArrayList<LabelValueBean>();
        labelListOfCurricularYears.add(new LabelValueBean("todos", ""));
        labelListOfCurricularYears.add(new LabelValueBean("1 \u00ba", "1"));
        labelListOfCurricularYears.add(new LabelValueBean("2 \u00ba", "2"));
        labelListOfCurricularYears.add(new LabelValueBean("3 \u00ba", "3"));
        labelListOfCurricularYears.add(new LabelValueBean("4 \u00ba", "4"));
        labelListOfCurricularYears.add(new LabelValueBean("5 \u00ba", "5"));
        return labelListOfCurricularYears;
    }

    public static void setContextSelectionBean(HttpServletRequest request, Object renderedObject) {
        ContextSelectionBean context = null;
        if (renderedObject != null && renderedObject instanceof ContextSelectionBean) {
            RenderUtils.invalidateViewState();
            context = (ContextSelectionBean)renderedObject;
        } else if (request.getAttribute("context_selection_bean") != null) {
            context = (ContextSelectionBean)request.getAttribute("context_selection_bean");
        } else {
            String academicIntervalStr;
            AcademicInterval academicInterval = null;
            ExecutionDegree executionDegree = null;
            CurricularYear curricularYear = null;
            String courseName = null;
            if (request.getAttribute("academicInterval") != null) {
                String academicIntervalStr2 = (String)request.getAttribute("academicInterval");
                academicInterval = AcademicInterval.getAcademicIntervalFromResumedString(academicIntervalStr2);
            } else if (request.getParameter("academicInterval") != null && (academicIntervalStr = request.getParameter("academicInterval")) != null && !academicIntervalStr.equals("null")) {
                academicInterval = AcademicInterval.getAcademicIntervalFromResumedString(academicIntervalStr);
            }
            if (academicInterval == null) {
                academicInterval = AcademicInterval.readDefaultAcademicInterval(AcademicPeriod.SEMESTER);
            }
            if (request.getAttribute("execution_degree_oid") != null) {
                executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)((String)request.getAttribute("execution_degree_oid")));
            } else if (request.getParameter("execution_degree_oid") != null) {
                executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)request.getParameter("execution_degree_oid"));
            }
            if (request.getAttribute("curricular_year_oid") != null && !request.getParameter("curricular_year_oid").equals("null")) {
                curricularYear = (CurricularYear)FenixFramework.getDomainObject((String)((String)request.getAttribute("curricular_year_oid")));
            } else if (request.getParameter("curricular_year_oid") != null && !request.getParameter("curricular_year_oid").equals("null")) {
                curricularYear = (CurricularYear)FenixFramework.getDomainObject((String)request.getParameter("curricular_year_oid"));
            }
            if (request.getAttribute("execution_course_name") != null) {
                courseName = (String)request.getAttribute("execution_course_name");
            } else if (request.getParameter("execution_course_name") != null) {
                courseName = request.getParameter("execution_course_name");
            }
            context = new ContextSelectionBean(academicInterval, executionDegree, curricularYear);
            context.setCourseName(courseName);
        }
        request.setAttribute("context_selection_bean", (Object)context);
        request.setAttribute("academicInterval", (Object)context.getAcademicInterval().getResumedRepresentationInStringFormat());
        if (context.getExecutionDegree() != null) {
            request.setAttribute("execution_degree", (Object)new InfoExecutionDegree(context.getExecutionDegree()));
        }
        request.setAttribute("curricular_year", (Object)new InfoCurricularYear(context.getCurricularYear()));
    }
}

