/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.scientificCouncil.thesis;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.ScientificCommission;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.interfaces.HasExecutionYear;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisEvaluationParticipant;
import org.fenixedu.academic.domain.thesis.ThesisFile;
import org.fenixedu.academic.domain.thesis.ThesisParticipationType;
import org.fenixedu.academic.domain.thesis.ThesisVisibilityType;
import org.fenixedu.academic.dto.VariantBean;
import org.fenixedu.academic.service.services.commons.FactoryExecutor;
import org.fenixedu.academic.service.services.scientificCouncil.thesis.ApproveThesisDiscussion;
import org.fenixedu.academic.service.services.scientificCouncil.thesis.ApproveThesisProposal;
import org.fenixedu.academic.service.services.thesis.ChangeThesisPerson;
import org.fenixedu.academic.service.services.thesis.CreateThesisAbstractFile;
import org.fenixedu.academic.service.services.thesis.CreateThesisDissertationFile;
import org.fenixedu.academic.ui.renderers.providers.ExecutionDegreesWithDissertationByExecutionYearProvider;
import org.fenixedu.academic.ui.struts.action.commons.AbstractManageThesisDA;
import org.fenixedu.academic.ui.struts.action.coordinator.thesis.ThesisBean;
import org.fenixedu.academic.ui.struts.action.coordinator.thesis.ThesisPresentationState;
import org.fenixedu.academic.ui.struts.action.scientificCouncil.ScientificCouncilApplication;
import org.fenixedu.academic.ui.struts.action.scientificCouncil.thesis.ScientificCouncilManageThesisDA$callable$addScientificCommissionFromExecutionDegree;
import org.fenixedu.academic.ui.struts.action.scientificCouncil.thesis.ScientificCouncilManageThesisDA$callable$changeThesisFilesVisibility;
import org.fenixedu.academic.ui.struts.action.scientificCouncil.thesis.ScientificCouncilManageThesisDA$callable$removeScientificCommissionFromExecutionDegree;
import org.fenixedu.academic.ui.struts.action.scientificCouncil.thesis.ThesisContextBean;
import org.fenixedu.academic.ui.struts.action.student.thesis.ThesisFileBean;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=ScientificCouncilApplication.ScientificDisserationsApp.class, path="list", titleKey="navigation.list.jury.proposals")
@Mapping(path="/scientificCouncilManageThesis", module="scientificCouncil")
@Forwards(value={@Forward(name="list-thesis", path="/scientificCouncil/thesis/listThesis.jsp"), @Forward(name="review-proposal", path="/scientificCouncil/thesis/reviewProposal.jsp"), @Forward(name="review-thesis", path="/scientificCouncil/thesis/reviewThesis.jsp"), @Forward(name="view-thesis", path="/scientificCouncil/thesis/viewThesis.jsp"), @Forward(name="list-scientific-comission", path="/scientificCouncil/thesis/listScientificComission.jsp"), @Forward(name="list-thesis-creation-periods", path="/scientificCouncil/thesis/listThesisCreationPeriods.jsp"), @Forward(name="viewOperationsThesis", path="/student/thesis/viewOperationsThesis.jsp"), @Forward(name="showDissertationsInfo", path="/scientificCouncil/thesis/showDissertationsInfo.jsp"), @Forward(name="editParticipant", path="/scientificCouncil/thesis/editParticipant.jsp"), @Forward(name="select-person", path="/scientificCouncil/thesis/selectPerson.jsp"), @Forward(name="select-external", path="/scientificCouncil/thesis/selectExternal.jsp"), @Forward(name="change-information-with-docs", path="/scientificCouncil/thesis/changeInformationWithDocs.jsp"), @Forward(name="search-student", path="/scientificCouncil/thesis/searchStudent.jsp")})
public class ScientificCouncilManageThesisDA
extends AbstractManageThesisDA {
    public static final Advice advice$removeScientificCommissionFromExecutionDegree = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$addScientificCommissionFromExecutionDegree = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$changeThesisFilesVisibility = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        request.setAttribute("thesis", (Object)thesis);
        if (thesis != null) {
            ThesisPresentationState thesisPresentationState = ThesisPresentationState.getThesisPresentationState(thesis);
            request.setAttribute("thesisPresentationState", (Object)thesisPresentationState);
            request.setAttribute("degreeID", (Object)thesis.getDegree().getExternalId());
            request.setAttribute("executionYearID", (Object)thesis.getExecutionYear().getExternalId());
        }
        Degree degree = this.getDegree(request);
        ExecutionYear executionYear = this.getExecutionYear(request);
        this.setFilterContext(request, degree, executionYear);
        return super.execute(mapping, actionForm, request, response);
    }

    public ActionForward dissertations(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DissertationsContextBean dissertationsContextBean = this.getDissertationsContextBean(request);
        if (dissertationsContextBean.getExecutionDegree() != null) {
            request.setAttribute("executionDegree", (Object)dissertationsContextBean.getExecutionDegree());
        }
        request.setAttribute("dissertationsContextBean", (Object)dissertationsContextBean);
        return mapping.findForward("showDissertationsInfo");
    }

    private void setFilterContext(HttpServletRequest request, Degree degree, ExecutionYear executionYear) {
        request.setAttribute("degree", (Object)degree);
        request.setAttribute("degreeId", (Object)(degree == null ? "" : degree.getExternalId()));
        request.setAttribute("executionYear", (Object)executionYear);
        request.setAttribute("executionYearId", (Object)(executionYear == null ? "" : executionYear.getExternalId()));
    }

    private Degree getDegree(HttpServletRequest request) {
        return (Degree)this.getDomainObject(request, "degreeID");
    }

    private ExecutionDegree getExecutionDegree(HttpServletRequest request) {
        return (ExecutionDegree)this.getDomainObject(request, "executionDegreeOID");
    }

    private ExecutionYear getExecutionYear(HttpServletRequest request) {
        return (ExecutionYear)this.getDomainObject(request, "executionYearID");
    }

    @EntryPoint
    public ActionForward listThesis(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisContextBean bean = this.getContextBean(request);
        Degree degree = bean.getDegree();
        ExecutionYear executionYear = bean.getExecutionYear();
        this.setFilterContext(request, degree, executionYear);
        ArrayList<Thesis> theses = new ArrayList<Thesis>();
        theses.addAll(Thesis.getSubmittedThesis(degree, executionYear));
        theses.addAll(Thesis.getApprovedThesis(degree, executionYear));
        theses.addAll(Thesis.getConfirmedThesis(degree, executionYear));
        theses.addAll(Thesis.getEvaluatedThesis(degree, executionYear));
        request.setAttribute("contextBean", (Object)bean);
        request.setAttribute("theses", theses);
        return mapping.findForward("list-thesis");
    }

    public ActionForward listScientificComission(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Degree degree = (Degree)this.getDomainObject(request, "degreeId");
        request.setAttribute("degree", (Object)degree);
        ExecutionYear executionYear = (ExecutionYear)this.getDomainObject(request, "executionYearId");
        request.setAttribute("executionYear", (Object)executionYear);
        if (degree == null || executionYear == null) {
            return this.listThesis(mapping, actionForm, request, response);
        }
        HashSet<ExecutionDegree> executionDegrees = new HashSet<ExecutionDegree>();
        for (DegreeCurricularPlan degreeCurricularPlan : degree.getDegreeCurricularPlansSet()) {
            for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
                if (executionDegree.getExecutionYear() != executionYear) continue;
                executionDegrees.add(executionDegree);
            }
        }
        request.setAttribute("executionDegrees", executionDegrees);
        request.setAttribute("usernameBean", (Object)new VariantBean());
        return mapping.findForward("list-scientific-comission");
    }

    public ActionForward removeScientificCommission(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ScientificCommission scientificCommission = (ScientificCommission)((Object)this.getDomainObject(request, "commissionID"));
        this.removeScientificCommissionFromExecutionDegree(scientificCommission, scientificCommission.getExecutionDegree());
        return this.listScientificComission(mapping, actionForm, request, response);
    }

    public void removeScientificCommissionFromExecutionDegree(ScientificCommission scientificCommission, ExecutionDegree executionDegree) {
        Object object = advice$removeScientificCommissionFromExecutionDegree.perform((Callable)new ScientificCouncilManageThesisDA$callable$removeScientificCommissionFromExecutionDegree(this, scientificCommission, executionDegree));
    }

    static /* synthetic */ void advised$removeScientificCommissionFromExecutionDegree(ScientificCouncilManageThesisDA this_, ScientificCommission scientificCommission, ExecutionDegree executionDegree) {
        scientificCommission.delete();
    }

    public ActionForward addScientificCommission(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VariantBean bean = (VariantBean)this.getRenderedObject("usernameChoice");
        if (bean != null) {
            ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)request.getParameter("executionDegreeID"));
            Person person = Person.readPersonByUsername(bean.getString());
            if (person == null || executionDegree.isPersonInScientificCommission(person)) {
                this.addActionMessage("addError", request, "error.scientificComission.person");
            } else {
                this.addScientificCommissionFromExecutionDegree(executionDegree, person);
                RenderUtils.invalidateViewState((String)"usernameChoice");
            }
        }
        return this.listScientificComission(mapping, actionForm, request, response);
    }

    public void addScientificCommissionFromExecutionDegree(ExecutionDegree executionDegree, Person person) {
        Object object = advice$addScientificCommissionFromExecutionDegree.perform((Callable)new ScientificCouncilManageThesisDA$callable$addScientificCommissionFromExecutionDegree(this, executionDegree, person));
    }

    static /* synthetic */ void advised$addScientificCommissionFromExecutionDegree(ScientificCouncilManageThesisDA this_, ExecutionDegree executionDegree, Person person) {
        new ScientificCommission(executionDegree, person);
    }

    private ThesisContextBean getContextBean(HttpServletRequest request) {
        ThesisContextBean bean = (ThesisContextBean)this.getRenderedObject("contextBean");
        RenderUtils.invalidateViewState((String)"contextBean");
        if (bean != null) {
            return bean;
        }
        Degree degree = this.getDegree(request);
        ExecutionYear executionYear = this.getExecutionYear(request);
        if (executionYear == null) {
            executionYear = ExecutionYear.readCurrentExecutionYear();
        }
        return new ThesisContextBean(degree, executionYear);
    }

    private DissertationsContextBean getDissertationsContextBean(HttpServletRequest request) {
        DissertationsContextBean bean = (DissertationsContextBean)this.getRenderedObject("dissertationsContextBean");
        RenderUtils.invalidateViewState((String)"dissertationsContextBean");
        if (bean != null) {
            return bean;
        }
        ExecutionDegree degree = this.getExecutionDegree(request);
        ExecutionYear executionYear = this.getExecutionYear(request);
        if (executionYear == null) {
            executionYear = ExecutionYear.readCurrentExecutionYear();
        }
        return new DissertationsContextBean(degree, executionYear);
    }

    public ActionForward reviewProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("review-proposal");
    }

    public ActionForward approveProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        if (thesis != null) {
            try {
                ApproveThesisProposal.runApproveThesisProposal(thesis);
                ThesisPresentationState thesisPresentationState = ThesisPresentationState.getThesisPresentationState(thesis);
                request.setAttribute("thesisPresentationState", (Object)thesisPresentationState);
            }
            catch (DomainException e) {
                this.addActionMessage("error", request, e.getKey(), e.getArgs());
                return this.reviewProposal(mapping, actionForm, request, response);
            }
            this.addActionMessage("mail", request, "thesis.approved.mail.sent");
        }
        return this.viewThesis(mapping, actionForm, request, response);
    }

    public ActionForward confirmRejectProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("confirmReject", (Object)true);
        return this.reviewProposal(mapping, actionForm, request, response);
    }

    public ActionForward reviewThesis(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("review-thesis");
    }

    public ActionForward confirmApprove(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("confirmApprove", (Object)true);
        return this.reviewThesis(mapping, actionForm, request, response);
    }

    public ActionForward confirmDisapprove(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("confirmDisapprove", (Object)true);
        return this.reviewThesis(mapping, actionForm, request, response);
    }

    public ActionForward approveThesis(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        if (thesis != null) {
            try {
                ApproveThesisDiscussion.runApproveThesisDiscussion(thesis);
                this.addActionMessage("mail", request, "thesis.evaluated.mail.sent");
                ThesisPresentationState thesisPresentationState = ThesisPresentationState.getThesisPresentationState(thesis);
                request.setAttribute("thesisPresentationState", (Object)thesisPresentationState);
            }
            catch (DomainException e) {
                this.addActionMessage("error", request, e.getKey(), e.getArgs());
                return this.reviewThesis(mapping, actionForm, request, response);
            }
        }
        return this.viewThesis(mapping, actionForm, request, response);
    }

    public ActionForward changeThesisFilesVisibility(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        return (ActionForward)advice$changeThesisFilesVisibility.perform((Callable)new ScientificCouncilManageThesisDA$callable$changeThesisFilesVisibility(this, actionMapping, actionForm, httpServletRequest, httpServletResponse));
    }

    static /* synthetic */ ActionForward advised$changeThesisFilesVisibility(ScientificCouncilManageThesisDA this_, ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this_.getThesis(request).swapFilesVisibility();
        return this_.viewThesis(mapping, actionForm, request, response);
    }

    public ActionForward viewThesis(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setDocumentAvailability(request);
        return mapping.findForward("view-thesis");
    }

    private void setDocumentAvailability(HttpServletRequest request) {
        Thesis thesis = this.getThesis(request);
        if (thesis.areThesisFilesReadable()) {
            request.setAttribute("containsThesisFileReadersGroup", (Object)Boolean.TRUE);
        }
    }

    public ActionForward showMakeDocumentUnavailablePage(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("showMakeDocumentUnavailablePage", (Object)Boolean.TRUE);
        return this.viewThesis(mapping, actionForm, request, response);
    }

    public ActionForward showMakeDocumentsAvailablePage(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("showMakeDocumentsAvailablePage", (Object)Boolean.TRUE);
        return this.viewThesis(mapping, actionForm, request, response);
    }

    public ActionForward editThesisAbstract(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("editThesisAbstract", (Object)Boolean.TRUE);
        return this.viewThesis(mapping, actionForm, request, response);
    }

    public ActionForward showSubstituteDocumentsPage(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        ThesisFile thesisFile = thesis.getDissertation();
        ThesisFileBean thesisFileBean = new ThesisFileBean();
        thesisFileBean.setTitle(thesisFile.getTitle());
        thesisFileBean.setSubTitle(thesisFile.getSubTitle());
        thesisFileBean.setLanguage(thesisFile.getLanguage());
        request.setAttribute("fileBean", (Object)thesisFileBean);
        request.setAttribute("showSubstituteDocumentsPage", (Object)Boolean.TRUE);
        return this.viewThesis(mapping, actionForm, request, response);
    }

    public ActionForward showSubstituteExtendedAbstractPage(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisFileBean thesisFileBean = new ThesisFileBean();
        request.setAttribute("fileBean", (Object)thesisFileBean);
        request.setAttribute("showSubstituteExtendedAbstractPage", (Object)Boolean.TRUE);
        return this.viewThesis(mapping, actionForm, request, response);
    }

    public ActionForward makeDocumentUnavailablePage(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        FenixFramework.atomic(() -> thesis.setVisibility(null));
        return this.viewThesis(mapping, actionForm, request, response);
    }

    public ActionForward makeDocumentAvailablePage(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        FenixFramework.atomic(() -> thesis.setVisibility(ThesisVisibilityType.INTRANET));
        return this.viewThesis(mapping, actionForm, request, response);
    }

    public ActionForward substituteDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisFileBean bean = (ThesisFileBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        if (bean != null && bean.getFile() != null) {
            byte[] bytes = ByteStreams.toByteArray((InputStream)bean.getFile());
            CreateThesisDissertationFile.runCreateThesisDissertationFile(this.getThesis(request), bytes, bean.getSimpleFileName(), bean.getTitle(), bean.getSubTitle(), bean.getLanguage());
        }
        return this.viewThesis(mapping, actionForm, request, response);
    }

    public ActionForward substituteExtendedAbstract(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisFileBean bean = (ThesisFileBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        if (bean != null && bean.getFile() != null) {
            byte[] bytes = ByteStreams.toByteArray((InputStream)bean.getFile());
            CreateThesisAbstractFile.runCreateThesisAbstractFile(this.getThesis(request), bytes, bean.getSimpleFileName(), bean.getTitle(), bean.getSubTitle(), bean.getLanguage());
        }
        return this.viewThesis(mapping, actionForm, request, response);
    }

    public ActionForward listThesisCreationPeriods(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisCreationPeriodFactoryExecutor thesisCreationPeriodFactoryExecutor = this.getThesisCreationPeriodFactoryExecutor(request);
        return this.forwardToListThesisCreationPeriodsPage(mapping, request, thesisCreationPeriodFactoryExecutor);
    }

    private ActionForward forwardToListThesisCreationPeriodsPage(ActionMapping mapping, HttpServletRequest request, ThesisCreationPeriodFactoryExecutor thesisCreationPeriodFactoryExecutor) {
        if (thesisCreationPeriodFactoryExecutor.getExecutionDegree() == null) {
            ExecutionDegreesWithDissertationByExecutionYearProvider provider = new ExecutionDegreesWithDissertationByExecutionYearProvider();
            request.setAttribute("executionDegrees", provider.provide(thesisCreationPeriodFactoryExecutor, null));
        }
        return mapping.findForward("list-thesis-creation-periods");
    }

    private ThesisCreationPeriodFactoryExecutor getThesisCreationPeriodFactoryExecutor(HttpServletRequest request) {
        return this.getThesisCreationPeriodFactoryExecutor(request, true);
    }

    private ThesisCreationPeriodFactoryExecutor getThesisCreationPeriodFactoryExecutor(HttpServletRequest request, boolean invalidateViewState) {
        ThesisCreationPeriodFactoryExecutor thesisCreationPeriodFactoryExecutor = (ThesisCreationPeriodFactoryExecutor)this.getRenderedObject("thesisCreationPeriodFactoryExecutor");
        if (thesisCreationPeriodFactoryExecutor == null) {
            thesisCreationPeriodFactoryExecutor = new ThesisCreationPeriodFactoryExecutor();
            String executionYearIdString = request.getParameter("executionYearId");
            ExecutionYear executionYear = executionYearIdString == null ? (thesisCreationPeriodFactoryExecutor.hasExecutionYear() ? thesisCreationPeriodFactoryExecutor.getExecutionYear() : ExecutionYear.readCurrentExecutionYear()) : (ExecutionYear)FenixFramework.getDomainObject((String)executionYearIdString);
            thesisCreationPeriodFactoryExecutor.setExecutionYear(executionYear);
            String executionDegreeIdString = request.getParameter("executionDegreeId");
            if (executionDegreeIdString != null) {
                ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)executionDegreeIdString);
                thesisCreationPeriodFactoryExecutor.setExecutionDegree(executionDegree);
            }
        }
        if (invalidateViewState) {
            RenderUtils.invalidateViewState();
        }
        request.setAttribute("thesisCreationPeriodFactoryExecutor", (Object)thesisCreationPeriodFactoryExecutor);
        return thesisCreationPeriodFactoryExecutor;
    }

    public ActionForward prepareDefineCreationPeriods(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisCreationPeriodFactoryExecutor thesisCreationPeriodFactoryExecutor = this.getThesisCreationPeriodFactoryExecutor(request);
        ExecutionDegree executionDegree = thesisCreationPeriodFactoryExecutor.getExecutionDegree();
        if (executionDegree == null) {
            ExecutionYear executionYear = thesisCreationPeriodFactoryExecutor.getExecutionYear();
            if (executionYear != null) {
                for (ExecutionDegree otherExecutionDegree : executionYear.getExecutionDegreesSet()) {
                    YearMonthDay beginThesisCreationPeriod = otherExecutionDegree.getBeginThesisCreationPeriod();
                    YearMonthDay endThesisCreationPeriod = otherExecutionDegree.getEndThesisCreationPeriod();
                    if (beginThesisCreationPeriod != null) {
                        thesisCreationPeriodFactoryExecutor.setBeginThesisCreationPeriod(beginThesisCreationPeriod);
                    }
                    if (endThesisCreationPeriod != null) {
                        thesisCreationPeriodFactoryExecutor.setEndThesisCreationPeriod(endThesisCreationPeriod);
                    }
                    if (thesisCreationPeriodFactoryExecutor.getBeginThesisCreationPeriod() == null || thesisCreationPeriodFactoryExecutor.getEndThesisCreationPeriod() == null) continue;
                    break;
                }
            }
        } else {
            thesisCreationPeriodFactoryExecutor.setBeginThesisCreationPeriod(executionDegree.getBeginThesisCreationPeriod());
            thesisCreationPeriodFactoryExecutor.setEndThesisCreationPeriod(executionDegree.getEndThesisCreationPeriod());
        }
        request.setAttribute("prepareDefineCreationPeriods", (Object)Boolean.TRUE);
        return mapping.findForward("list-thesis-creation-periods");
    }

    public ActionForward defineCreationPeriods(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisCreationPeriodFactoryExecutor thesisCreationPeriodFactoryExecutor = this.getThesisCreationPeriodFactoryExecutor(request);
        this.executeFactoryMethod(thesisCreationPeriodFactoryExecutor);
        thesisCreationPeriodFactoryExecutor.setExecutionDegree(null);
        return this.forwardToListThesisCreationPeriodsPage(mapping, request, thesisCreationPeriodFactoryExecutor);
    }

    public ActionForward defineCreationPeriodsInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisCreationPeriodFactoryExecutor thesisCreationPeriodFactoryExecutor = this.getThesisCreationPeriodFactoryExecutor(request, false);
        request.setAttribute("prepareDefineCreationPeriods", (Object)Boolean.TRUE);
        return this.forwardToListThesisCreationPeriodsPage(mapping, request, thesisCreationPeriodFactoryExecutor);
    }

    public ActionForward downloadDissertationsList(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String executionYearIdString = request.getParameter("executionYearId");
        ExecutionYear executionYear = (ExecutionYear)FenixFramework.getDomainObject((String)executionYearIdString);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=dissertacoes" + executionYear.getYear().replace("/", "") + ".xls");
        ServletOutputStream writer = response.getOutputStream();
        this.exportDissertations(writer, executionYear);
        writer.flush();
        response.flushBuffer();
        return null;
    }

    private void exportDissertations(ServletOutputStream writer, ExecutionYear executionYear) throws IOException {
        Spreadsheet spreadsheet = new Spreadsheet("Dissertacoes " + executionYear.getYear().replace("/", ""));
        spreadsheet.setHeader("Numero aluno");
        spreadsheet.setHeader("Nome aluno");
        spreadsheet.setHeader("Tipo Curso");
        spreadsheet.setHeader("Curso");
        spreadsheet.setHeader("Sigla Curso");
        spreadsheet.setHeader("Tese");
        spreadsheet.setHeader("Estado da tese");
        spreadsheet.setHeader("Data da Discuss\u00e3o");
        spreadsheet.setHeader("Resumo");
        spreadsheet.setHeader("Abstract");
        spreadsheet.setHeader("Numero Orientador");
        spreadsheet.setHeader("Nome Orientador");
        spreadsheet.setHeader("Affiliacao Orientador");
        spreadsheet.setHeader("Distribuicao Creditos Orientador");
        spreadsheet.setHeader("Numero Corientador");
        spreadsheet.setHeader("Nome Corientador");
        spreadsheet.setHeader("Affiliacao Corientador");
        spreadsheet.setHeader("Distribuicao Creditos Corientador");
        spreadsheet.setHeader("Numero Presidente");
        spreadsheet.setHeader("Nome Presidente");
        spreadsheet.setHeader("Afilia\u00e7\u00e3o Presidente");
        spreadsheet.setHeader("Nota Disserta\u00e7\u00e3o");
        for (Thesis thesis : rootDomainObject.getThesesSet()) {
            Enrolment enrolment = thesis.getEnrolment();
            ExecutionSemester executionSemester = enrolment.getExecutionPeriod();
            if (executionSemester.getExecutionYear() != executionYear) continue;
            ThesisPresentationState thesisPresentationState = ThesisPresentationState.getThesisPresentationState(thesis);
            Degree degree = enrolment.getStudentCurricularPlan().getDegree();
            DegreeType degreeType = degree.getDegreeType();
            Spreadsheet.Row row = spreadsheet.addRow();
            row.setCell(thesis.getStudent().getNumber().toString());
            row.setCell(thesis.getStudent().getPerson().getName());
            row.setCell(degreeType.getName().getContent());
            row.setCell(degree.getPresentationName(executionYear));
            row.setCell(degree.getSigla());
            row.setCell(thesis.getTitle().getContent());
            row.setCell(thesisPresentationState.getName());
            if (thesis.getDiscussed() != null) {
                row.setCell(thesis.getDiscussed().toDate().toString());
            }
            row.setCell(thesis.getThesisAbstractPt());
            row.setCell(thesis.getThesisAbstractEn());
            this.addTeacherRows(thesis, row, ThesisParticipationType.ORIENTATOR);
            this.addTeacherRows(thesis, row, ThesisParticipationType.COORIENTATOR);
            this.addTeacherRows(thesis, row, ThesisParticipationType.PRESIDENT);
            row.setCell(thesis.getMark());
        }
        spreadsheet.exportToXLSSheet((OutputStream)writer);
    }

    protected void addTeacherRows(Thesis thesis, Spreadsheet.Row row, ThesisParticipationType thesisParticipationType) {
        StringBuilder numbers = new StringBuilder();
        StringBuilder names = new StringBuilder();
        StringBuilder oasb = new StringBuilder();
        StringBuilder odsb = new StringBuilder();
        for (ThesisEvaluationParticipant thesisEvaluationParticipant : thesis.getAllParticipants(thesisParticipationType)) {
            String affiliation;
            if (numbers.length() > 0) {
                numbers.append(" ");
            }
            numbers.append(thesisEvaluationParticipant.getPerson().getUsername());
            if (names.length() > 0) {
                names.append(" ");
            }
            names.append(thesisEvaluationParticipant.getPerson().getName());
            if (oasb.length() > 0) {
                oasb.append(" ");
            }
            if ((affiliation = thesisEvaluationParticipant.getAffiliation()) != null) {
                oasb.append(affiliation);
            } else {
                oasb.append("--");
            }
            if (thesisParticipationType != ThesisParticipationType.ORIENTATOR && thesisParticipationType != ThesisParticipationType.COORIENTATOR) continue;
            if (odsb.length() > 0) {
                odsb.append(" ");
            }
            double credistDistribution = this.getCreditsDistribution(thesisEvaluationParticipant);
            odsb.append(Double.toString(credistDistribution));
        }
        row.setCell(numbers.toString());
        row.setCell(names.toString());
        row.setCell(oasb.toString());
        if (thesisParticipationType == ThesisParticipationType.ORIENTATOR || thesisParticipationType == ThesisParticipationType.COORIENTATOR) {
            row.setCell(odsb.toString());
        }
    }

    public ActionForward changeParticipationInfo(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String target = request.getParameter("target");
        if (target == null) {
            return this.editProposal(mapping, actionForm, request, response);
        }
        Thesis thesis = this.getThesis(request);
        ThesisEvaluationParticipant participant = (ThesisEvaluationParticipant)FenixFramework.getDomainObject((String)target);
        ChangeThesisPerson.PersonTarget targetType = this.getPersonTarget(participant.getType());
        request.setAttribute("targetType", (Object)targetType);
        request.setAttribute("participant", (Object)participant);
        return mapping.findForward("editParticipant");
    }

    public ActionForward deleteParticipant(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String target = request.getParameter("target");
        ThesisEvaluationParticipant participant = (ThesisEvaluationParticipant)FenixFramework.getDomainObject((String)target);
        ChangeThesisPerson.remove(participant);
        return this.editProposal(mapping, actionForm, request, response);
    }

    private ChangeThesisPerson.PersonTarget getPersonTarget(ThesisParticipationType type) {
        if (type.equals((Object)ThesisParticipationType.ORIENTATOR)) {
            return ChangeThesisPerson.PersonTarget.orientator;
        }
        if (type.equals((Object)ThesisParticipationType.COORIENTATOR)) {
            return ChangeThesisPerson.PersonTarget.coorientator;
        }
        if (type.equals((Object)ThesisParticipationType.PRESIDENT)) {
            return ChangeThesisPerson.PersonTarget.president;
        }
        if (type.equals((Object)ThesisParticipationType.VOWEL)) {
            return ChangeThesisPerson.PersonTarget.vowel;
        }
        return null;
    }

    @Override
    public ActionForward editProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        request.setAttribute("conditions", thesis.getConditions());
        return this.viewThesis(mapping, actionForm, request, response);
    }

    private ThesisEvaluationParticipant getVowel(HttpServletRequest request) {
        String parameter = request.getParameter("vowelID");
        if (parameter == null) {
            return null;
        }
        Thesis thesis = this.getThesis(request);
        for (ThesisEvaluationParticipant participant : thesis.getVowels()) {
            if (!participant.getExternalId().equals(parameter)) continue;
            return participant;
        }
        return null;
    }

    public ActionForward changePerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean remove2;
        String target = request.getParameter("target");
        boolean bl = remove2 = request.getParameter("remove") != null;
        if (target == null) {
            return this.editProposal(mapping, actionForm, request, response);
        }
        Thesis thesis = this.getThesis(request);
        ThesisBean bean = new ThesisBean(thesis);
        Degree degree = this.getDegree(request);
        bean.setDegree(degree);
        ChangeThesisPerson.PersonTarget targetType = ChangeThesisPerson.PersonTarget.valueOf(target);
        bean.setTargetType(targetType);
        if (targetType.equals((Object)ChangeThesisPerson.PersonTarget.vowel)) {
            ThesisEvaluationParticipant targetVowel = this.getVowel(request);
            if (targetVowel != null) {
                bean.setTarget(targetVowel);
            } else {
                bean.setTarget(null);
            }
        }
        if (remove2) {
            DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
            ChangeThesisPerson.run(degreeCurricularPlan, thesis, new ChangeThesisPerson.PersonChange(bean.getTargetType(), null, bean.getTarget()));
            return this.editProposal(mapping, actionForm, request, response);
        }
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("select-person");
    }

    public ActionForward changeExternal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean remove2;
        String target = request.getParameter("target");
        boolean bl = remove2 = request.getParameter("remove") != null;
        if (target == null) {
            return this.editProposal(mapping, actionForm, request, response);
        }
        Thesis thesis = this.getThesis(request);
        ThesisBean bean = new ThesisBean(thesis);
        Degree degree = this.getDegree(request);
        bean.setDegree(degree);
        ChangeThesisPerson.PersonTarget targetType = ChangeThesisPerson.PersonTarget.valueOf(target);
        bean.setTargetType(targetType);
        if (targetType.equals((Object)ChangeThesisPerson.PersonTarget.vowel)) {
            ThesisEvaluationParticipant targetVowel = this.getVowel(request);
            if (targetVowel != null) {
                bean.setTarget(targetVowel);
            } else {
                bean.setTarget(null);
            }
        }
        if (remove2) {
            DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
            ChangeThesisPerson.run(degreeCurricularPlan, thesis, new ChangeThesisPerson.PersonChange(bean.getTargetType(), null, bean.getTarget()));
            return this.editProposal(mapping, actionForm, request, response);
        }
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("select-external");
    }

    @Override
    protected DegreeCurricularPlan getDegreeCurricularPlan(HttpServletRequest request) {
        Degree degree = (Degree)this.getDomainObject(request, "degreeID");
        return degree.getMostRecentDegreeCurricularPlan();
    }

    public ActionForward changeCredits(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String target = request.getParameter("target");
        if (target == null) {
            return this.editProposal(mapping, actionForm, request, response);
        }
        request.setAttribute("editOrientatorCreditsDistribution", (Object)target);
        return this.editProposal(mapping, actionForm, request, response);
    }

    @Override
    public ActionForward selectPerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisBean bean = (ThesisBean)this.getRenderedObject("bean");
        if (bean == null) {
            return this.editProposal(mapping, actionForm, request, response);
        }
        request.setAttribute("bean", (Object)bean);
        Person selectedPerson = bean.getPerson();
        if (selectedPerson == null) {
            this.addActionMessage("info", request, "thesis.selectPerson.internal.required");
            return mapping.findForward("select-person");
        }
        Degree degree = this.getDegree(request);
        ExecutionYear executionYear = this.getExecutionYear(request);
        List<DegreeCurricularPlan> degreeCurricularPlansForYear = degree.getDegreeCurricularPlansForYear(executionYear);
        DegreeCurricularPlan degreeCurricularPlan = degreeCurricularPlansForYear.iterator().next();
        Thesis thesis = this.getThesis(request);
        ChangeThesisPerson.PersonTarget personTarget = bean.getTargetType();
        if (!(personTarget != ChangeThesisPerson.PersonTarget.president || selectedPerson != null && degreeCurricularPlan.isScientificCommissionMember(executionYear, selectedPerson))) {
            this.addActionMessage("info", request, "thesis.selectPerson.president.required.scientific.commission");
            return mapping.findForward("select-person");
        }
        ChangeThesisPerson.run(degreeCurricularPlan, thesis, new ChangeThesisPerson.PersonChange(bean.getTargetType(), selectedPerson, bean.getTarget()));
        return this.editProposal(mapping, actionForm, request, response);
    }

    public ActionForward changeInformationWithDocs(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("change-information-with-docs");
    }

    public ActionForward editProposalWithDocs(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        if (thesis == null) {
            return this.listThesis(mapping, actionForm, request, response);
        }
        return this.viewThesis(mapping, actionForm, request, response);
    }

    private double getCreditsDistribution(ThesisEvaluationParticipant thesisEvaluationParticipant) {
        Thesis thesis = thesisEvaluationParticipant.getThesis();
        if (!thesis.hasCredits()) {
            return 0.0;
        }
        return thesisEvaluationParticipant.getPercentageDistribution().intValue();
    }

    public static class ThesisCreationPeriodFactoryExecutor
    implements FactoryExecutor,
    HasExecutionYear,
    Serializable {
        private ExecutionYear executionYear;
        private ExecutionDegree executionDegree;
        private YearMonthDay beginThesisCreationPeriod;
        private YearMonthDay endThesisCreationPeriod;

        @Override
        public Object execute() {
            ExecutionDegree executionDegree = this.getExecutionDegree();
            if (executionDegree == null) {
                ExecutionYear executionYear = this.getExecutionYear();
                if (executionYear != null) {
                    for (ExecutionDegree otherExecutionDegree : executionYear.getExecutionDegreesSet()) {
                        this.execute(otherExecutionDegree);
                    }
                }
            } else {
                this.execute(executionDegree);
            }
            return null;
        }

        private void execute(ExecutionDegree executionDegree) {
            executionDegree.setBeginThesisCreationPeriod(this.beginThesisCreationPeriod);
            executionDegree.setEndThesisCreationPeriod(this.endThesisCreationPeriod);
        }

        @Override
        public ExecutionYear getExecutionYear() {
            return this.executionYear;
        }

        public void setExecutionYear(ExecutionYear executionYear) {
            this.executionYear = executionYear;
        }

        public ExecutionDegree getExecutionDegree() {
            return this.executionDegree;
        }

        public void setExecutionDegree(ExecutionDegree executionDegree) {
            this.executionDegree = executionDegree;
        }

        public YearMonthDay getBeginThesisCreationPeriod() {
            return this.beginThesisCreationPeriod;
        }

        public void setBeginThesisCreationPeriod(YearMonthDay beginThesisCreationPeriod) {
            this.beginThesisCreationPeriod = beginThesisCreationPeriod;
        }

        public YearMonthDay getEndThesisCreationPeriod() {
            return this.endThesisCreationPeriod;
        }

        public void setEndThesisCreationPeriod(YearMonthDay endThesisCreationPeriod) {
            this.endThesisCreationPeriod = endThesisCreationPeriod;
        }

        public boolean hasExecutionYear() {
            return this.getExecutionYear() != null;
        }
    }

    public static class DissertationsContextBean
    implements Serializable,
    HasExecutionYear {
        ExecutionDegree executionDegree;
        ExecutionYear executionYear;

        public DissertationsContextBean(ExecutionDegree executionDegree, ExecutionYear executionYear) {
            this.executionDegree = executionDegree;
            this.executionYear = executionYear;
        }

        public ExecutionDegree getExecutionDegree() {
            return this.executionDegree;
        }

        public void setExecutionDegree(ExecutionDegree executionDegree) {
            this.executionDegree = executionDegree;
        }

        @Override
        public ExecutionYear getExecutionYear() {
            return this.executionYear;
        }

        public void setExecutionYear(ExecutionYear executionYear) {
            this.executionYear = executionYear;
        }
    }

    @StrutsFunctionality(app=ScientificCouncilApplication.ScientificDisserationsApp.class, path="define-periods", titleKey="navigation.list.thesis.creation.periods")
    @Mapping(path="/defineDissertationPeriods", module="scientificCouncil")
    public static class DefineDissertationPeriods
    extends ScientificCouncilManageThesisDA {
        @Override
        @EntryPoint
        public ActionForward listThesisCreationPeriods(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
            return super.listThesisCreationPeriods(mapping, actionForm, request, response);
        }
    }

    @StrutsFunctionality(app=ScientificCouncilApplication.ScientificDisserationsApp.class, path="define-rules", titleKey="navigation.thesis.info")
    @Mapping(path="/defineDissertationRules", module="scientificCouncil")
    public static class DefineDissertationRules
    extends ScientificCouncilManageThesisDA {
        @Override
        @EntryPoint
        public ActionForward dissertations(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
            return super.dissertations(mapping, actionForm, request, response);
        }
    }
}

