/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.academicAdminOffice;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Alert;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.EnrolmentPeriod;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCourses;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.JobBean;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.QualificationBean;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.ManageEnrolmentsBean;
import org.fenixedu.academic.domain.phd.PhdConfigurationIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdParticipantBean;
import org.fenixedu.academic.domain.phd.PhdProcessState;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.PhdStudyPlanBean;
import org.fenixedu.academic.domain.phd.PhdStudyPlanEntry;
import org.fenixedu.academic.domain.phd.PhdStudyPlanEntryBean;
import org.fenixedu.academic.domain.phd.SearchPhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.alert.PhdAlert;
import org.fenixedu.academic.domain.phd.alert.PhdAlertMessage;
import org.fenixedu.academic.domain.phd.alert.PhdCustomAlertBean;
import org.fenixedu.academic.domain.phd.candidacy.RegistrationFormalizationBean;
import org.fenixedu.academic.domain.phd.email.PhdEmailBean;
import org.fenixedu.academic.domain.phd.email.PhdIndividualProgramProcessEmail;
import org.fenixedu.academic.domain.phd.email.PhdIndividualProgramProcessEmailBean;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AbandonIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ActivatePhdProgramProcessInCandidacyState;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ActivatePhdProgramProcessInThesisDiscussionState;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ActivatePhdProgramProcessInWorkDevelopmentState;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddAssistantGuidingInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddCustomAlert;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddGuidingInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddJobInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddQualification;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddStudyPlan;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddStudyPlanEntry;
import org.fenixedu.academic.domain.phd.individualProcess.activities.CancelPhdProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ConcludeIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ConfigurePhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteAssistantGuiding;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteCustomAlert;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteGuiding;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteJobInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteQualification;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteStudyPlan;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteStudyPlanEntry;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DissociateRegistration;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditIndividualProcessInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditPersonalInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditPhdParticipant;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditQualificationExams;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditStudyPlan;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditWhenStartedStudies;
import org.fenixedu.academic.domain.phd.individualProcess.activities.FlunkedPhdProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.NotAdmittedPhdProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.RemoveLastStateOnPhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.RequestPublicThesisPresentation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.SendPhdEmail;
import org.fenixedu.academic.domain.phd.individualProcess.activities.SuspendPhdProgramProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.TransferToAnotherProcess;
import org.fenixedu.academic.domain.phd.individualProcess.activities.UploadGuidanceAcceptanceLetter;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationGuiding;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationIndividualPersonalDataBean;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationIndividualProcessData;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationIndividualProcessDataBean;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationProcess;
import org.fenixedu.academic.domain.phd.migration.PhdMigrationProcessStateType;
import org.fenixedu.academic.domain.phd.migration.SearchPhdMigrationProcessBean;
import org.fenixedu.academic.domain.phd.migration.common.exceptions.PhdMigrationException;
import org.fenixedu.academic.domain.phd.reports.EPFLCandidatesReport;
import org.fenixedu.academic.domain.phd.reports.PhdGuidersReport;
import org.fenixedu.academic.domain.phd.reports.PhdIndividualProgramProcessesReport;
import org.fenixedu.academic.domain.phd.reports.RecommendationLetterReport;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.dto.person.PhotographUploadBean;
import org.fenixedu.academic.report.phd.registration.PhdSchoolRegistrationDeclarationDocument;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.academic.service.services.fileManager.StorePersonalPhoto;
import org.fenixedu.academic.service.services.phd.CreateEnrolmentPeriods;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.phd.CommonPhdIndividualProgramProcessDA;
import org.fenixedu.academic.ui.struts.action.phd.PhdInactivePredicateContainer;
import org.fenixedu.academic.ui.struts.action.phd.PhdProcessStateBean;
import org.fenixedu.academic.util.ContentType;
import org.fenixedu.academic.util.predicates.AndPredicate;
import org.fenixedu.academic.util.predicates.PredicateContainer;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminPhdApp.class, path="phd-processes", titleKey="label.phd.manageProcesses", accessGroup="academic(MANAGE_PHD_PROCESSES)")
@Mapping(path="/phdIndividualProgramProcess", module="academicAdministration")
@Forwards(value={@Forward(name="manageProcesses", path="/phd/academicAdminOffice/manageProcesses.jsp"), @Forward(name="viewProcess", path="/phd/academicAdminOffice/viewProcess.jsp"), @Forward(name="editPersonalInformation", path="/phd/academicAdminOffice/editPersonalInformation.jsp"), @Forward(name="editQualificationsAndJobsInformation", path="/phd/academicAdminOffice/editQualificationsAndJobsInformation.jsp"), @Forward(name="editPhdIndividualProgramProcessInformation", path="/phd/academicAdminOffice/editPhdIndividualProgramProcessInformation.jsp"), @Forward(name="manageGuidingInformation", path="/phd/academicAdminOffice/manageGuidingInformation.jsp"), @Forward(name="managePhdIndividualProgramProcessState", path="/phd/academicAdminOffice/managePhdIndividualProgramProcessState.jsp"), @Forward(name="manageAlerts", path="/phd/academicAdminOffice/manageAlerts.jsp"), @Forward(name="createCustomAlert", path="/phd/academicAdminOffice/createCustomAlert.jsp"), @Forward(name="viewAlertMessages", path="/phd/academicAdminOffice/viewAlertMessages.jsp"), @Forward(name="viewAlertMessageArchive", path="/phd/academicAdminOffice/viewAlertMessageArchive.jsp"), @Forward(name="viewAlertMessage", path="/phd/academicAdminOffice/viewAlertMessage.jsp"), @Forward(name="viewProcessAlertMessages", path="/phd/academicAdminOffice/viewProcessAlertMessages.jsp"), @Forward(name="viewProcessAlertMessageArchive", path="/phd/academicAdminOffice/viewProcessAlertMessageArchive.jsp"), @Forward(name="manageStudyPlan", path="/phd/academicAdminOffice/manageStudyPlan.jsp"), @Forward(name="createStudyPlan", path="/phd/academicAdminOffice/createStudyPlan.jsp"), @Forward(name="editStudyPlan", path="/phd/academicAdminOffice/editStudyPlan.jsp"), @Forward(name="createStudyPlanEntry", path="/phd/academicAdminOffice/createStudyPlanEntry.jsp"), @Forward(name="editQualificationExams", path="/phd/academicAdminOffice/editQualificationExams.jsp"), @Forward(name="uploadPhoto", path="/phd/academicAdminOffice/uploadPhoto.jsp"), @Forward(name="requestPublicPresentationSeminarComission", path="/phd/academicAdminOffice/requestPublicPresentationSeminarComission.jsp"), @Forward(name="exemptPublicPresentationSeminarComission", path="/phd/academicAdminOffice/exemptPublicPresentationSeminarComission.jsp"), @Forward(name="requestPublicThesisPresentation", path="/phd/academicAdminOffice/requestPublicThesisPresentation.jsp"), @Forward(name="viewCurriculum", path="/phd/academicAdminOffice/viewCurriculum.jsp"), @Forward(name="manageEnrolmentPeriods", path="/phd/academicAdminOffice/periods/manageEnrolmentPeriods.jsp"), @Forward(name="createEnrolmentPeriod", path="/phd/academicAdminOffice/periods/createEnrolmentPeriod.jsp"), @Forward(name="editEnrolmentPeriod", path="/phd/academicAdminOffice/periods/editEnrolmentPeriod.jsp"), @Forward(name="editWhenStartedStudies", path="/phd/academicAdminOffice/editWhenStartedStudies.jsp"), @Forward(name="managePhdIndividualProcessConfiguration", path="/phd/academicAdminOffice/configuration/managePhdIndividualProcessConfiguration.jsp"), @Forward(name="managePhdIndividualProcessEmails", path="/phd/academicAdminOffice/viewProcessEmails.jsp"), @Forward(name="sendPhdIndividualProcessEmail", path="/phd/academicAdminOffice/sendPhdEmail.jsp"), @Forward(name="viewPhdIndividualProcessEmail", path="/phd/academicAdminOffice/viewPhdEmail.jsp"), @Forward(name="viewMigrationProcess", path="/phd/academicAdminOffice/viewMigrationProcess.jsp"), @Forward(name="viewAllMigratedProcesses", path="/phd/academicAdminOffice/viewAllMigratedProcesses.jsp"), @Forward(name="viewPhdParticipants", path="/phd/academicAdminOffice/participant/viewPhdParticipants.jsp"), @Forward(name="editPhdParticipant", path="/phd/academicAdminOffice/participant/editPhdParticipant.jsp"), @Forward(name="chooseProcessToTransfer", path="/phd/academicAdminOffice/transfer/chooseProcessToTransfer.jsp"), @Forward(name="fillRemarksOnTransfer", path="/phd/academicAdminOffice/transfer/fillRemarksOnTransfer.jsp"), @Forward(name="editCandidacyProcessData", path="/phd/academicAdminOffice/manualMigration/editCandidacyProcessData.jsp"), @Forward(name="editPersonalData", path="/phd/academicAdminOffice/manualMigration/editPersonalData.jsp"), @Forward(name="verifyChosenCandidate", path="/phd/academicAdminOffice/manualMigration/verifyChosenCandidate.jsp"), @Forward(name="createManualMigrationCandidacy", path="/phd/academicAdminOffice/manualMigration/createManualMigrationCandidacy.jsp"), @Forward(name="concludeManualMigration", path="/phd/academicAdminOffice/manualMigration/concludeManualMigration.jsp"), @Forward(name="dissociateRegistration", path="/phd/academicAdminOffice/dissociateRegistration.jsp"), @Forward(name="uploadGuidanceAcceptanceDocument", path="/phd/academicAdminOffice/participant/guidance/uploadGuidanceAcceptanceDocument.jsp"), @Forward(name="editPhdProcessState", path="/phd/academicAdminOffice/editState.jsp"), @Forward(name="viewAllAlertMessages", path="/phd/academicAdminOffice/alerts/viewAllAlertMessages.jsp"), @Forward(name="viewAlertMessageFromAllAlertMessages", path="/phd/academicAdminOffice/alerts/viewAlertMessage.jsp"), @Forward(name="viewLogs", path="/phd/academicAdminOffice/logs/viewLogs.jsp")})
public class PhdIndividualProgramProcessDA
extends CommonPhdIndividualProgramProcessDA {
    @Override
    protected PhdInactivePredicateContainer getConcludedContainer() {
        return null;
    }

    @Override
    protected List<PredicateContainer<?>> getThesisCategory() {
        return null;
    }

    @Override
    protected List<PredicateContainer<?>> getSeminarCategory() {
        return null;
    }

    @Override
    protected List<PredicateContainer<?>> getCandidacyCategory() {
        return null;
    }

    @Override
    protected SearchPhdIndividualProgramProcessBean initializeSearchBean(HttpServletRequest request) {
        SearchPhdIndividualProgramProcessBean searchBean = new SearchPhdIndividualProgramProcessBean();
        searchBean.setExecutionYear(ExecutionYear.readCurrentExecutionYear());
        searchBean.setFilterPhdPrograms(false);
        searchBean.setFilterPhdProcesses(false);
        return searchBean;
    }

    @Override
    @EntryPoint
    public ActionForward manageProcesses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SearchPhdIndividualProgramProcessBean searchBean = (SearchPhdIndividualProgramProcessBean)this.getObjectFromViewState("searchProcessBean");
        if (searchBean == null) {
            searchBean = this.initializeSearchBean(request);
        }
        AndPredicate<PhdIndividualProgramProcess> predicate = searchBean.getPredicates();
        predicate.add((Predicate)new Predicate<PhdIndividualProgramProcess>(){

            @Override
            public boolean test(PhdIndividualProgramProcess process2) {
                return process2.isAllowedToManageProcess(Authenticate.getUser());
            }
        });
        request.setAttribute("searchProcessBean", (Object)searchBean);
        request.setAttribute("processes", PhdIndividualProgramProcess.search(searchBean.getExecutionYear(), predicate));
        RenderUtils.invalidateViewState();
        return mapping.findForward("manageProcesses");
    }

    public ActionForward prepareEditPersonalInformation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Person person = this.getProcess(request).getPerson();
        PersonBean personBean = new PersonBean(person);
        this.initPersonBeanUglyHack(personBean, person);
        request.setAttribute("editPersonalInformationBean", (Object)personBean);
        return mapping.findForward("editPersonalInformation");
    }

    public ActionForward prepareEditPersonalInformationInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("editPersonalInformationBean", (Object)this.getEditPersonalInformationBean());
        return mapping.findForward("editPersonalInformation");
    }

    private PersonBean getEditPersonalInformationBean() {
        return (PersonBean)this.getRenderedObject("editPersonalInformationBean");
    }

    public ActionForward editPersonalInformation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (!this.validateAreaCodeAndAreaOfAreaCode(request, this.getEditPersonalInformationBean().getPerson(), this.getEditPersonalInformationBean().getCountryOfResidence(), this.getEditPersonalInformationBean().getAreaCode(), this.getEditPersonalInformationBean().getAreaOfAreaCode())) {
            request.setAttribute("editPersonalInformationBean", (Object)this.getEditPersonalInformationBean());
            return mapping.findForward("editPersonalInformation");
        }
        request.setAttribute("editPersonalInformationBean", (Object)this.getEditPersonalInformationBean());
        return this.executeActivity(EditPersonalInformation.class, this.getEditPersonalInformationBean(), request, mapping, "editPersonalInformation", "viewProcess", "message.personal.data.edited.with.success", new String[0]);
    }

    public ActionForward cancelEditPersonalInformation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("viewProcess");
    }

    private void addQualificationsAndJobsContextInformation(HttpServletRequest request) {
        Person person = this.getProcess(request).getPerson();
        request.setAttribute("qualifications", (Object)person.getAssociatedQualificationsSet());
        request.setAttribute("jobs", (Object)person.getJobsSet());
    }

    public ActionForward prepareEditQualificationsAndJobsInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addQualificationsAndJobsContextInformation(request);
        return mapping.findForward("editQualificationsAndJobsInformation");
    }

    public ActionForward prepareAddQualification(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addQualificationsAndJobsContextInformation(request);
        request.setAttribute("qualification", (Object)new QualificationBean());
        return mapping.findForward("editQualificationsAndJobsInformation");
    }

    public ActionForward addQualification(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addQualificationsAndJobsContextInformation(request);
        Object bean = this.getRenderedObject("qualification");
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), AddQualification.class.getSimpleName(), bean);
            this.addSuccessMessage(request, "message.qualification.information.create.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("qualification", bean);
        }
        return mapping.findForward("editQualificationsAndJobsInformation");
    }

    public ActionForward addQualificationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addQualificationsAndJobsContextInformation(request);
        request.setAttribute("qualification", this.getRenderedObject("qualification"));
        return mapping.findForward("editQualificationsAndJobsInformation");
    }

    public ActionForward deleteQualification(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addQualificationsAndJobsContextInformation(request);
        return this.executeActivity(DeleteQualification.class, this.getDomainObject(request, "qualificationId"), request, mapping, "editQualificationsAndJobsInformation", "editQualificationsAndJobsInformation", "message.qualification.information.delete.success", new String[0]);
    }

    public ActionForward prepareAddJobInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addQualificationsAndJobsContextInformation(request);
        JobBean bean = new JobBean();
        bean.setCountry(Country.readDefault());
        request.setAttribute("job", (Object)bean);
        return mapping.findForward("editQualificationsAndJobsInformation");
    }

    public ActionForward addJobInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addQualificationsAndJobsContextInformation(request);
        Object bean = this.getRenderedObject("job");
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), AddJobInformation.class.getSimpleName(), bean);
            this.addSuccessMessage(request, "message.job.information.create.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("job", bean);
        }
        return mapping.findForward("editQualificationsAndJobsInformation");
    }

    public ActionForward addJobInformationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addQualificationsAndJobsContextInformation(request);
        request.setAttribute("job", this.getRenderedObject("job"));
        return mapping.findForward("editQualificationsAndJobsInformation");
    }

    public ActionForward addJobInformationPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addQualificationsAndJobsContextInformation(request);
        request.setAttribute("job", this.getRenderedObject("job"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("editQualificationsAndJobsInformation");
    }

    public ActionForward deleteJobInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addQualificationsAndJobsContextInformation(request);
        return this.executeActivity(DeleteJobInformation.class, this.getDomainObject(request, "jobId"), request, mapping, "editQualificationsAndJobsInformation", "editQualificationsAndJobsInformation", "message.job.information.delete.success", new String[0]);
    }

    public ActionForward prepareEditPhdIndividualProgramProcessInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdIndividualProgramProcessBean", (Object)new PhdIndividualProgramProcessBean(this.getProcess(request)));
        return mapping.findForward("editPhdIndividualProgramProcessInformation");
    }

    public ActionForward editPhdIndividualProgramProcessInformationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdIndividualProgramProcessBean", this.getRenderedObject("phdIndividualProgramProcessBean"));
        return mapping.findForward("editPhdIndividualProgramProcessInformation");
    }

    public ActionForward editPhdIndividualProgramProcessInformationPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdIndividualProgramProcessBean", this.getRenderedObject("phdIndividualProgramProcessBean"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("editPhdIndividualProgramProcessInformation");
    }

    public ActionForward editPhdIndividualProgramProcessInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcessBean bean = (PhdIndividualProgramProcessBean)this.getRenderedObject("phdIndividualProgramProcessBean");
        request.setAttribute("phdIndividualProgramProcessBean", (Object)bean);
        if (!bean.isCollaborationInformationCorrect()) {
            this.addErrorMessage(request, "message.phdIndividualProgramProcessInformation.invalid.collaboration", new String[0]);
            return mapping.findForward("editPhdIndividualProgramProcessInformation");
        }
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), EditIndividualProcessInformation.class.getSimpleName(), (Object)bean);
            this.addSuccessMessage(request, "message.phdIndividualProgramProcessInformation.edit.success", new String[0]);
            return this.viewProcess(mapping, actionForm, request, response);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return mapping.findForward("editPhdIndividualProgramProcessInformation");
        }
    }

    private void addGuidingsContextInformation(ActionMapping mapping, HttpServletRequest request) {
        request.setAttribute("guidings", (Object)this.getProcess(request).getGuidingsSet());
        request.setAttribute("assistantGuidings", (Object)this.getProcess(request).getAssistantGuidingsSet());
    }

    public ActionForward prepareManageGuidingInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addGuidingsContextInformation(mapping, request);
        return mapping.findForward("manageGuidingInformation");
    }

    public ActionForward prepareAddGuidingInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addGuidingsContextInformation(mapping, request);
        request.setAttribute("guidingBean", (Object)new PhdParticipantBean(this.getProcess(request)));
        return mapping.findForward("manageGuidingInformation");
    }

    public ActionForward prepareAddGuidingInformationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addGuidingsContextInformation(mapping, request);
        request.setAttribute("guidingBean", this.getRenderedObject("guidingBean"));
        return mapping.findForward("manageGuidingInformation");
    }

    public ActionForward prepareAddGuidingInformationSelectType(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addGuidingsContextInformation(mapping, request);
        request.setAttribute("guidingBean", this.getRenderedObject("guidingBean"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("manageGuidingInformation");
    }

    public ActionForward addGuidingInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdParticipantBean bean = (PhdParticipantBean)this.getRenderedObject("guidingBean");
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), AddGuidingInformation.class.getSimpleName(), (Object)bean);
            this.addSuccessMessage(request, "message.guiding.created.with.success", new String[0]);
        }
        catch (DomainException e) {
            request.setAttribute("guidingBean", (Object)bean);
            this.addErrorMessage(request, e.getKey(), e.getArgs());
        }
        this.addGuidingsContextInformation(mapping, request);
        return mapping.findForward("manageGuidingInformation");
    }

    public ActionForward deleteGuiding(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), DeleteGuiding.class.getSimpleName(), this.getDomainObject(request, "guidingId"));
            this.addSuccessMessage(request, "message.guiding.deleted.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
        }
        this.addGuidingsContextInformation(mapping, request);
        return mapping.findForward("manageGuidingInformation");
    }

    public ActionForward prepareAddAssistantGuidingInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addGuidingsContextInformation(mapping, request);
        request.setAttribute("assistantGuidingBean", (Object)new PhdParticipantBean(this.getProcess(request)));
        return mapping.findForward("manageGuidingInformation");
    }

    public ActionForward prepareAddAssistantGuidingInformationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addGuidingsContextInformation(mapping, request);
        request.setAttribute("assistantGuidingBean", this.getRenderedObject("assistantGuidingBean"));
        return mapping.findForward("manageGuidingInformation");
    }

    public ActionForward prepareAddAssistantGuidingInformationSelectType(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.addGuidingsContextInformation(mapping, request);
        request.setAttribute("assistantGuidingBean", this.getRenderedObject("assistantGuidingBean"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("manageGuidingInformation");
    }

    public ActionForward addAssistantGuidingInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdParticipantBean bean = (PhdParticipantBean)this.getRenderedObject("assistantGuidingBean");
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), AddAssistantGuidingInformation.class.getSimpleName(), (Object)bean);
            this.addSuccessMessage(request, "message.assistant.guiding.created.with.success", new String[0]);
        }
        catch (DomainException e) {
            request.setAttribute("assistantGuidingBean", (Object)bean);
            this.addErrorMessage(request, e.getKey(), e.getArgs());
        }
        this.addGuidingsContextInformation(mapping, request);
        return mapping.findForward("manageGuidingInformation");
    }

    public ActionForward deleteAssistantGuiding(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), DeleteAssistantGuiding.class.getSimpleName(), this.getDomainObject(request, "assistantGuidingId"));
            this.addSuccessMessage(request, "message.assistant.guiding.deleted.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
        }
        this.addGuidingsContextInformation(mapping, request);
        return mapping.findForward("manageGuidingInformation");
    }

    public ActionForward managePhdIndividualProgramProcessState(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcessBean bean = new PhdIndividualProgramProcessBean();
        bean.setIndividualProgramProcess(this.getProcess(request));
        request.setAttribute("processBean", (Object)bean);
        return mapping.findForward("managePhdIndividualProgramProcessState");
    }

    public ActionForward managePhdIndividualProgramProcessStateInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("processBean", this.getRenderedObject("processBean"));
        return mapping.findForward("managePhdIndividualProgramProcessState");
    }

    public ActionForward changePhdIndividualProgramProcessState(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        PhdIndividualProgramProcessBean bean = (PhdIndividualProgramProcessBean)this.getRenderedObject("processBean");
        try {
            switch (bean.getProcessState()) {
                case CANCELLED: {
                    ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), CancelPhdProgramProcess.class.getSimpleName(), (Object)bean);
                    break;
                }
                case FLUNKED: {
                    ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), FlunkedPhdProgramProcess.class.getSimpleName(), (Object)bean);
                    break;
                }
                case NOT_ADMITTED: {
                    ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), NotAdmittedPhdProgramProcess.class.getSimpleName(), (Object)bean);
                    break;
                }
                case SUSPENDED: {
                    ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), SuspendPhdProgramProcess.class.getSimpleName(), (Object)bean);
                    break;
                }
                case CANDIDACY: {
                    ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), ActivatePhdProgramProcessInCandidacyState.class.getSimpleName(), (Object)bean);
                    break;
                }
                case THESIS_DISCUSSION: {
                    ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), ActivatePhdProgramProcessInThesisDiscussionState.class.getSimpleName(), (Object)bean);
                    break;
                }
                case WORK_DEVELOPMENT: {
                    ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), ActivatePhdProgramProcessInWorkDevelopmentState.class.getSimpleName(), (Object)bean);
                    break;
                }
                case CONCLUDED: {
                    ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), ConcludeIndividualProgramProcess.class.getSimpleName(), (Object)bean);
                    break;
                }
                case ABANDON: {
                    ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), AbandonIndividualProgramProcess.class.getSimpleName(), (Object)bean);
                    break;
                }
                default: {
                    throw new FenixActionException();
                }
            }
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.managePhdIndividualProgramProcessState(mapping, actionForm, request, response);
        }
        RenderUtils.invalidateViewState();
        return this.managePhdIndividualProgramProcessState(mapping, actionForm, request, response);
    }

    public ActionForward manageAlerts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("alerts", this.getAlertsToShow(request));
        return mapping.findForward("manageAlerts");
    }

    public ActionForward prepareCreateCustomAlert(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createCustomAlertBean", (Object)new PhdCustomAlertBean(this.getProcess(request)));
        return mapping.findForward("createCustomAlert");
    }

    public ActionForward prepareCreateCustomAlertInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createCustomAlert", (Object)this.getCreateCustomAlertBean());
        return mapping.findForward("createCustomAlert");
    }

    public ActionForward createCustomAlert(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdCustomAlertBean bean = this.getCreateCustomAlertBean();
        request.setAttribute("createCustomAlertBean", (Object)bean);
        ActionForward result = this.executeActivity(AddCustomAlert.class, bean, request, mapping, "createCustomAlert", "manageAlerts", "message.alert.create.with.success", new String[0]);
        request.setAttribute("alerts", this.getAlertsToShow(request));
        return result;
    }

    private Set<PhdAlert> getAlertsToShow(HttpServletRequest request) {
        return this.getProcess(request).getActiveAlerts();
    }

    public ActionForward deleteCustomAlert(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward result = this.executeActivity(DeleteCustomAlert.class, (Object)this.getAlert(request), request, mapping, "manageAlerts", "manageAlerts", "message.alert.deleted.with.success", new String[0]);
        request.setAttribute("alerts", this.getAlertsToShow(request));
        return result;
    }

    private Alert getAlert(HttpServletRequest request) {
        return (Alert)((Object)this.getDomainObject(request, "alertId"));
    }

    private PhdCustomAlertBean getCreateCustomAlertBean() {
        return (PhdCustomAlertBean)this.getRenderedObject("createCustomAlertBean");
    }

    public ActionForward manageStudyPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("manageStudyPlan");
    }

    public ActionForward prepareCreateStudyPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studyPlanBean", (Object)new PhdStudyPlanBean(this.getProcess(request)));
        return mapping.findForward("createStudyPlan");
    }

    public ActionForward prepareCreateStudyPlanInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studyPlanBean", this.getRenderedObject("studyPlanBean"));
        return mapping.findForward("createStudyPlan");
    }

    public ActionForward prepareCreateStudyPlanPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studyPlanBean", this.getRenderedObject("studyPlanBean"));
        RenderUtils.invalidateViewState((String)"studyPlanBean");
        return mapping.findForward("createStudyPlan");
    }

    public ActionForward createStudyPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.executeActivity(AddStudyPlan.class, this.getRenderedObject("studyPlanBean"), request, mapping, "createStudyPlan", "manageStudyPlan", "message.study.plan.created.with.success", new String[0]);
    }

    public ActionForward prepareEditStudyPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studyPlanBean", (Object)new PhdStudyPlanBean(this.getProcess(request).getStudyPlan()));
        return mapping.findForward("editStudyPlan");
    }

    public ActionForward prepareEditStudyPlanInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studyPlanBean", this.getRenderedObject("studyPlanBean"));
        return mapping.findForward("editStudyPlan");
    }

    public ActionForward prepareEditStudyPlanPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studyPlanBean", this.getRenderedObject("studyPlanBean"));
        RenderUtils.invalidateViewState((String)"studyPlanBean");
        return mapping.findForward("editStudyPlan");
    }

    public ActionForward editStudyPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.executeActivity(EditStudyPlan.class, this.getRenderedObject("studyPlanBean"), request, mapping, "editStudyPlan", "manageStudyPlan", "message.study.plan.edited.with.success", new String[0]);
    }

    public ActionForward prepareCreateStudyPlanEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studyPlanEntryBean", (Object)new PhdStudyPlanEntryBean(this.getProcess(request).getStudyPlan()));
        return mapping.findForward("createStudyPlanEntry");
    }

    public ActionForward prepareCreateStudyPlanEntryInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studyPlanEntryBean", this.getStudyPlanEntryBean());
        return mapping.findForward("createStudyPlanEntry");
    }

    public ActionForward createStudyPlanEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studyPlanEntryBean", this.getStudyPlanEntryBean());
        return this.executeActivity(AddStudyPlanEntry.class, this.getStudyPlanEntryBean(), request, mapping, "createStudyPlanEntry", "manageStudyPlan", "message.study.plan.entry.created.with.success", new String[0]);
    }

    private Object getStudyPlanEntryBean() {
        return this.getRenderedObject("studyPlanEntryBean");
    }

    public ActionForward studyPlanEntryPostBack(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studyPlanEntryBean", this.getStudyPlanEntryBean());
        RenderUtils.invalidateViewState((String)"studyPlanEntryBean");
        return mapping.findForward("createStudyPlanEntry");
    }

    public ActionForward deleteStudyPlanEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.executeActivity(DeleteStudyPlanEntry.class, (Object)this.getStudyPlanEntry(request), request, mapping, "manageStudyPlan", "manageStudyPlan", "message.study.plan.entry.deleted.successfuly", new String[0]);
    }

    private PhdStudyPlanEntry getStudyPlanEntry(HttpServletRequest request) {
        return (PhdStudyPlanEntry)((Object)this.getDomainObject(request, "studyPlanEntryId"));
    }

    public ActionForward deleteStudyPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.executeActivity(DeleteStudyPlan.class, (Object)this.getProcess(request).getStudyPlan(), request, mapping, "manageStudyPlan", "manageStudyPlan", "message.study.plan.deleted.successfuly", new String[0]);
    }

    public ActionForward prepareEditQualificationExams(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("editQualificationExamsBean", (Object)new PhdIndividualProgramProcessBean(this.getProcess(request)));
        return mapping.findForward("editQualificationExams");
    }

    public ActionForward prepareEditQualificationExamsInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("editQualificationExamsBean", this.getRenderedObject("editQualificationExamsBean"));
        return mapping.findForward("editQualificationExams");
    }

    public ActionForward editQualificationExams(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("editQualificationExamsBean", this.getRenderedObject("editQualificationExamsBean"));
        return this.executeActivity(EditQualificationExams.class, this.getRenderedObject("editQualificationExamsBean"), request, mapping, "editQualificationExams", "manageStudyPlan");
    }

    public ActionForward prepareUploadPhoto(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("uploadPhotoBean", (Object)new PhotographUploadBean());
        return mapping.findForward("uploadPhoto");
    }

    public ActionForward uploadPhoto(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PhotographUploadBean photo = (PhotographUploadBean)this.getRenderedObject("uploadPhotoBean");
        if (!RenderUtils.getViewState((String)"uploadPhotoBean").isValid()) {
            this.addErrorMessage(request, "error.photo.upload.invalid.information", new String[0]);
            return this.uploadPhotoInvalid(mapping, actionForm, request, response);
        }
        if (ContentType.getContentType(photo.getContentType()) == null) {
            this.addErrorMessage(request, "error.photo.upload.unsupported.file", new String[0]);
            return this.uploadPhotoInvalid(mapping, actionForm, request, response);
        }
        try {
            photo.processImage();
            StorePersonalPhoto.uploadPhoto(photo, this.getProcess(request).getPerson());
            this.addSuccessMessage(request, "message.photo.updated.with.success", new String[0]);
        }
        catch (PhotographUploadBean.UnableToProcessTheImage e) {
            this.addErrorMessage(request, "error.photo.upload.unable.to.process.image", new String[0]);
            photo.deleteTemporaryFiles();
            return this.uploadPhotoInvalid(mapping, actionForm, request, response);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            photo.deleteTemporaryFiles();
            return this.uploadPhotoInvalid(mapping, actionForm, request, response);
        }
        return this.viewProcess(mapping, actionForm, request, response);
    }

    public ActionForward uploadPhotoInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("uploadPhotoBean", this.getRenderedObject("uploadPhotoBean"));
        RenderUtils.invalidateViewState((String)"uploadPhotoBean");
        return mapping.findForward("uploadPhoto");
    }

    public ActionForward prepareRequestPublicThesisPresentation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean(this.getProcess(request));
        PhdIndividualProgramProcess individualProcess = this.getProcess(request);
        if (individualProcess.isMigratedProcess()) {
            bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.PROVISIONAL_THESIS));
            bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.THESIS_ABSTRACT));
        } else {
            bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.PROVISIONAL_THESIS).required());
            bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.THESIS_ABSTRACT).required());
        }
        bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.THESIS_REQUIREMENT));
        bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.CV));
        bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.CANDIDACY_REVIEW));
        bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.OTHER));
        request.setAttribute("requestPublicThesisPresentation", (Object)bean);
        this.addThesisPreConditionsInformation(request, individualProcess);
        return mapping.findForward("requestPublicThesisPresentation");
    }

    private void addThesisPreConditionsInformation(HttpServletRequest request, PhdIndividualProgramProcess process2) {
        request.setAttribute("hasPublicPresentationSeminar", (Object)(process2.getSeminarProcess() != null ? 1 : 0));
        if (process2.getSeminarProcess() != null && !process2.getSeminarProcess().isExempted()) {
            request.setAttribute("hasPublicPresentationSeminarReport", (Object)process2.hasSeminarReportDocument());
        }
        request.setAttribute("hasSchoolPartConcluded", (Object)process2.hasSchoolPartConcluded());
        request.setAttribute("hasQualificationExamsToPerform", (Object)process2.hasQualificationExamsToPerform());
        if (process2.getRegistration() != null && process2.getStudyPlan() != null && process2.getStudyPlan().hasAnyPropaeudeuticsOrExtraEntries()) {
            request.setAttribute("hasPropaeudeuticsOrExtraEntriesApproved", (Object)process2.hasPropaeudeuticsOrExtraEntriesApproved());
        }
    }

    public ActionForward prepareRequestPublicThesisPresentationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("requestPublicThesisPresentation", this.getRenderedObject("requestPublicThesisPresentation"));
        this.addThesisPreConditionsInformation(request, this.getProcess(request));
        RenderUtils.invalidateViewState((String)"requestPublicThesisPresentation.edit.documents");
        return mapping.findForward("requestPublicThesisPresentation");
    }

    public ActionForward requestPublicThesisPresentation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)this.getRenderedObject("requestPublicThesisPresentation");
        request.setAttribute("requestPublicThesisPresentation", (Object)bean);
        RenderUtils.invalidateViewState((String)"requestPublicThesisPresentation.edit.documents");
        this.addThesisPreConditionsInformation(request, this.getProcess(request));
        return this.executeActivity(RequestPublicThesisPresentation.class, bean, request, mapping, "requestPublicThesisPresentation", "viewProcess");
    }

    public ActionForward manageEnrolmentPeriods(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ManageEnrolmentsBean bean = (ManageEnrolmentsBean)this.getRenderedObject("manageEnrolmentsBean");
        if (bean == null) {
            bean = new ManageEnrolmentsBean();
            bean.setSemester(ExecutionSemester.readActualExecutionSemester());
        }
        this.filterEnrolmentPeriods(bean);
        request.setAttribute("manageEnrolmentsBean", (Object)bean);
        return mapping.findForward("manageEnrolmentPeriods");
    }

    private void filterEnrolmentPeriods(ManageEnrolmentsBean bean) {
        bean.setEnrolmentPeriods(this.getPhdEnrolmentPeriods(bean));
    }

    private List<EnrolmentPeriod> getPhdEnrolmentPeriods(ManageEnrolmentsBean bean) {
        ArrayList<EnrolmentPeriod> result = new ArrayList<EnrolmentPeriod>();
        for (EnrolmentPeriod period : bean.getSemester().getEnrolmentPeriodSet()) {
            if (!((Object)((Object)period)).getClass().equals(EnrolmentPeriodInCurricularCourses.class) || !period.getDegree().isDEA()) continue;
            result.add(period);
        }
        return result;
    }

    public ActionForward prepareCreateEnrolmentPeriod(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ManageEnrolmentsBean bean = new ManageEnrolmentsBean();
        bean.setSemester((ExecutionSemester)this.getDomainObject(request, "executionIntervalId"));
        request.setAttribute("createBean", (Object)bean);
        return mapping.findForward("createEnrolmentPeriod");
    }

    public ActionForward createEnrolmentPeriodInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createBean", this.getRenderedObject("createBean"));
        return mapping.findForward("createEnrolmentPeriod");
    }

    public ActionForward createEnrolmentPeriod(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ManageEnrolmentsBean bean = (ManageEnrolmentsBean)this.getRenderedObject("createBean");
            CreateEnrolmentPeriods.create(bean.getDegreeCurricularPlans(), bean.getSemester(), bean.getStartDate(), bean.getEndDate());
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.createEnrolmentPeriodInvalid(mapping, actionForm, request, response);
        }
        return this.redirect("/phdIndividualProgramProcess.do?method=manageEnrolmentPeriods", request);
    }

    public ActionForward prepareEditEnrolmentPeriod(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("enrolmentPeriod", this.getDomainObject(request, "periodId"));
        return mapping.findForward("editEnrolmentPeriod");
    }

    public ActionForward deleteEnrolmentPeriod(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ((EnrolmentPeriod)((Object)this.getDomainObject(request, "periodId"))).delete();
            return this.redirect("/phdIndividualProgramProcess.do?method=manageEnrolmentPeriods", request);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.manageEnrolmentPeriods(mapping, actionForm, request, response);
        }
    }

    public ActionForward prepareEditWhenStartedStudies(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RegistrationFormalizationBean bean = new RegistrationFormalizationBean();
        bean.setWhenStartedStudies(this.getProcess(request).getWhenStartedStudies());
        request.setAttribute("registrationFormalizationBean", (Object)bean);
        return mapping.findForward("editWhenStartedStudies");
    }

    public ActionForward editWhenStartedStudies(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        RegistrationFormalizationBean bean = (RegistrationFormalizationBean)this.getRenderedObject("registrationFormalizationBean");
        try {
            ExecuteProcessActivity.run((Process)((Object)process2), EditWhenStartedStudies.class.getSimpleName(), (Object)bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return mapping.findForward("editWhenStartedStudies");
        }
        return this.redirect(String.format("/phdIndividualProgramProcess.do?method=viewProcess&processId=%s", process2.getExternalId()), request);
    }

    public ActionForward printSchoolRegistrationDeclaration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PhdSchoolRegistrationDeclarationDocument report = new PhdSchoolRegistrationDeclarationDocument(this.getProcess(request));
        this.writeFile(response, report.getReportFileName() + ".pdf", "application/pdf", ReportsUtils.generateReport(report).getData());
        return null;
    }

    public ActionForward preparePhdConfigurationManagement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        PhdConfigurationIndividualProgramProcessBean bean = new PhdConfigurationIndividualProgramProcessBean(process2);
        request.setAttribute("phdConfigurationIndividualProgramProcessBean", (Object)bean);
        return mapping.findForward("managePhdIndividualProcessConfiguration");
    }

    public ActionForward savePhdConfiguration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        PhdConfigurationIndividualProgramProcessBean bean = (PhdConfigurationIndividualProgramProcessBean)this.getObjectFromViewState("phdConfigurationIndividualProgramProcessBean");
        ExecuteProcessActivity.run((Process)((Object)process2), ConfigurePhdIndividualProgramProcess.class, (Object)bean);
        return this.viewProcess(mapping, form, request, response);
    }

    public ActionForward savePhdConfigurationInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        PhdConfigurationIndividualProgramProcessBean bean = new PhdConfigurationIndividualProgramProcessBean(process2);
        request.setAttribute("phdConfigurationIndividualProgramProcessBean", (Object)bean);
        return mapping.findForward("managePhdIndividualProcessConfiguration");
    }

    public ActionForward preparePhdEmailsManagement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("managePhdIndividualProcessEmails");
    }

    public ActionForward prepareSendPhdEmail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        PhdIndividualProgramProcessEmailBean emailBean = new PhdIndividualProgramProcessEmailBean();
        emailBean.setProcess(process2);
        request.setAttribute("emailBean", (Object)emailBean);
        return mapping.findForward("sendPhdIndividualProcessEmail");
    }

    public ActionForward sendPhdEmail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        PhdEmailBean bean = (PhdEmailBean)this.getRenderedObject("emailBean");
        try {
            ExecuteProcessActivity.run((Process)((Object)process2), SendPhdEmail.class, (Object)bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute("emailBean", (Object)bean);
            return mapping.findForward("sendPhdIndividualProcessEmail");
        }
        return this.preparePhdEmailsManagement(mapping, form, request, response);
    }

    public ActionForward sendEmailPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcessEmailBean emailBean = (PhdIndividualProgramProcessEmailBean)this.getRenderedObject("emailBean");
        emailBean.refreshTemplateInUse();
        request.setAttribute("emailBean", (Object)emailBean);
        RenderUtils.invalidateViewState((String)"emailBean.create");
        for (PhdIndividualProgramProcessEmailBean.PhdEmailParticipantsGroup group : emailBean.getPossibleParticipantsGroups()) {
            RenderUtils.invalidateViewState((String)("emailBean.groups.edit." + group.toString()));
        }
        RenderUtils.invalidateViewState((String)"emailBean.individuals");
        RenderUtils.invalidateViewState((String)"emailBean.template");
        return mapping.findForward("sendPhdIndividualProcessEmail");
    }

    public ActionForward viewPhdEmail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        PhdIndividualProgramProcessEmailBean bean = new PhdIndividualProgramProcessEmailBean(this.getPhdEmail(request));
        bean.setProcess(process2);
        request.setAttribute("emailBean", (Object)bean);
        return mapping.findForward("viewPhdIndividualProcessEmail");
    }

    private PhdIndividualProgramProcessEmail getPhdEmail(HttpServletRequest request) {
        return (PhdIndividualProgramProcessEmail)((Object)this.getDomainObject(request, "phdEmailId"));
    }

    public ActionForward removeLastState(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        try {
            ExecuteProcessActivity.run((Process)((Object)process2), RemoveLastStateOnPhdIndividualProgramProcess.class, null);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
        }
        return this.managePhdIndividualProgramProcessState(mapping, form, request, response);
    }

    public ActionForward viewAssociatedMigrationProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        PhdMigrationIndividualProcessData processData = process2.getAssociatedMigrationProcess();
        if (processData != null) {
            request.setAttribute("processDataBean", (Object)processData.getProcessBean());
            if (processData.getPhdMigrationIndividualPersonalData() != null) {
                request.setAttribute("personalDataBean", (Object)processData.getPhdMigrationIndividualPersonalData().getPersonalBean());
            }
        }
        PhdMigrationGuiding guidingData = process2.getAssociatedMigrationGuiding();
        PhdMigrationGuiding assistantGuidingData = process2.getAssociatedMigrationAssistantGuiding();
        if (guidingData != null) {
            request.setAttribute("migrationGuidingBean", (Object)guidingData.getGuidingBean());
        }
        if (assistantGuidingData != null) {
            request.setAttribute("migrationAssistantGuidingBean", (Object)assistantGuidingData.getGuidingBean());
        }
        return mapping.findForward("viewMigrationProcess");
    }

    public ActionForward viewMigrationProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.fetchMigrationBeans(request);
        return mapping.findForward("viewMigrationProcess");
    }

    private PhdMigrationIndividualProcessData fetchMigrationBeans(HttpServletRequest request) {
        Integer migrationId = this.getMigrationProcessId(request);
        PhdMigrationIndividualProcessData processData = this.getMigrationProcessData(migrationId);
        if (processData != null) {
            PhdMigrationGuiding assistantGuiderData;
            PhdMigrationGuiding guiderData;
            request.setAttribute("processDataBean", (Object)processData.getProcessBean());
            if (processData.getPhdMigrationIndividualPersonalData() != null) {
                request.setAttribute("personalDataBean", (Object)processData.getPhdMigrationIndividualPersonalData().getPersonalBean());
            }
            String guiderCode = processData.getProcessBean().getGuiderId();
            String assistantGuiderCode = processData.getProcessBean().getAssistantGuiderId();
            if (guiderCode != null && (guiderData = this.getMigrationGuidingData(guiderCode)) != null) {
                request.setAttribute("migrationGuidingBean", (Object)guiderData.getGuidingBean());
            }
            if (assistantGuiderCode != null && (assistantGuiderData = this.getMigrationGuidingData(assistantGuiderCode)) != null) {
                request.setAttribute("migrationAssistantGuidingBean", (Object)assistantGuiderData.getGuidingBean());
            }
        }
        return processData;
    }

    private Integer getMigrationProcessId(HttpServletRequest request) {
        String attribute = (String)request.getAttribute("migrationProcessId");
        String parameter = request.getParameter("migrationProcessId");
        if (attribute != null) {
            return Integer.valueOf(attribute);
        }
        return Integer.valueOf(parameter);
    }

    private PhdMigrationIndividualProcessData getMigrationProcessData(Integer migrationId) {
        for (PhdMigrationProcess migrationProcess : Bennu.getInstance().getPhdMigrationProcessesSet()) {
            for (PhdMigrationIndividualProcessData processData : migrationProcess.getPhdMigrationIndividualProcessDataSet()) {
                if (!processData.getNumber().equals(migrationId)) continue;
                return processData;
            }
        }
        return null;
    }

    private PhdMigrationGuiding getMigrationGuidingData(String teacherId) {
        for (PhdMigrationProcess migrationProcess : Bennu.getInstance().getPhdMigrationProcessesSet()) {
            for (PhdMigrationGuiding guidingData : migrationProcess.getPhdMigrationGuidingSet()) {
                if (!guidingData.getTeacherId().equals(teacherId)) continue;
                return guidingData;
            }
        }
        return null;
    }

    public ActionForward viewMigratedProcesses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SearchPhdMigrationProcessBean searchBean = (SearchPhdMigrationProcessBean)this.getObjectFromViewState("searchMigrationProcessBean");
        if (searchBean == null) {
            searchBean = this.initializeMigrationSearchBean(request);
        }
        AndPredicate<PhdMigrationIndividualProcessData> predicate = searchBean.getPredicates();
        predicate.add((Predicate)new Predicate<PhdMigrationIndividualProcessData>(){

            @Override
            public boolean test(PhdMigrationIndividualProcessData process2) {
                return AcademicAccessRule.getPhdProgramsAccessibleToFunction(AcademicOperationType.MANAGE_PHD_PROCESSES, Authenticate.getUser()).collect(Collectors.toSet()).contains((Object)process2.getProcessBean().getPhdProgram());
            }
        });
        request.setAttribute("searchMigrationProcessBean", (Object)searchBean);
        request.setAttribute("migrationProcesses", PhdIndividualProgramProcess.searchMigrationProcesses(searchBean.getExecutionYear(), predicate));
        return mapping.findForward("viewAllMigratedProcesses");
    }

    protected SearchPhdMigrationProcessBean initializeMigrationSearchBean(HttpServletRequest request) {
        SearchPhdMigrationProcessBean searchBean = new SearchPhdMigrationProcessBean();
        searchBean.setFilterPhdPrograms(false);
        searchBean.setFilterPhdProcesses(false);
        searchBean.setProcessState(PhdMigrationProcessStateType.CONCLUDED);
        return searchBean;
    }

    public ActionForward prepareManualMigration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Integer migrationId = this.getMigrationProcessId(request);
        PhdMigrationIndividualProcessData processData = this.getMigrationProcessData(migrationId);
        request.setAttribute("processData", (Object)processData);
        return mapping.findForward("editCandidacyProcessData");
    }

    public ActionForward editMigrationPersonalData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Integer migrationId = this.getMigrationProcessId(request);
        PhdMigrationIndividualProcessData processData = this.getMigrationProcessData(migrationId);
        PhdMigrationIndividualProcessDataBean processDataBean = (PhdMigrationIndividualProcessDataBean)this.getRenderedObject("processDataBean");
        request.setAttribute("processData", (Object)processData);
        request.setAttribute("processDataBean", (Object)processDataBean);
        return mapping.findForward("editPersonalData");
    }

    public ActionForward verifyChosenCandidate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Integer migrationId = this.getMigrationProcessId(request);
        PhdMigrationIndividualProcessData processData = this.getMigrationProcessData(migrationId);
        PhdMigrationIndividualProcessDataBean processDataBean = (PhdMigrationIndividualProcessDataBean)this.getRenderedObject("processDataBean");
        PhdMigrationIndividualPersonalDataBean personalDataBean = (PhdMigrationIndividualPersonalDataBean)this.getRenderedObject("personalDataBean");
        request.setAttribute("processData", (Object)processData);
        request.setAttribute("processDataBean", (Object)processDataBean);
        request.setAttribute("personalDataBean", (Object)personalDataBean);
        return mapping.findForward("verifyChosenCandidate");
    }

    public ActionForward createCandidacyManualMigration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Integer migrationId = this.getMigrationProcessId(request);
        PhdMigrationIndividualProcessData processData = this.getMigrationProcessData(migrationId);
        PhdMigrationIndividualProcessDataBean processDataBean = (PhdMigrationIndividualProcessDataBean)this.getRenderedObject("processDataBean");
        PhdMigrationIndividualPersonalDataBean personalDataBean = (PhdMigrationIndividualPersonalDataBean)this.getRenderedObject("personalDataBean");
        try {
            processData.proceedWithMigration(Authenticate.getUser());
            this.addSuccessMessage(request, "message.migration.manual.candidacy.success", new String[0]);
        }
        catch (PhdMigrationException e) {
            this.addErrorMessage(request, e.getKey(), new String[0]);
            request.setAttribute("processData", (Object)processData);
            request.setAttribute("processDataBean", (Object)processDataBean);
            request.setAttribute("personalDataBean", (Object)processData.getPhdMigrationIndividualPersonalData().getPersonalBean());
            return mapping.findForward("editPersonalData");
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("processData", (Object)processData);
            request.setAttribute("processDataBean", (Object)processDataBean);
            request.setAttribute("personalDataBean", (Object)personalDataBean);
            return mapping.findForward("editPersonalData");
        }
        request.setAttribute("migratedProcess", (Object)processData.getPhdIndividualProgramProcess());
        return mapping.findForward("concludeManualMigration");
    }

    public ActionForward viewPhdParticipants(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("viewPhdParticipants");
    }

    public ActionForward prepareEditPhdParticipant(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdParticipant phdParticipant = (PhdParticipant)((Object)this.getDomainObject(request, "phdParticipantId"));
        PhdParticipantBean bean = new PhdParticipantBean(phdParticipant);
        request.setAttribute("phdParticipantBean", (Object)bean);
        return mapping.findForward("editPhdParticipant");
    }

    public ActionForward editPhdParticipant(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdParticipantBean bean = (PhdParticipantBean)this.getRenderedObject("phdParticipantBean");
        ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), EditPhdParticipant.class, (Object)bean);
        return this.viewPhdParticipants(mapping, form, request, response);
    }

    public ActionForward editPhdParticipantInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdParticipantBean bean = (PhdParticipantBean)this.getRenderedObject("phdParticipantBean");
        request.setAttribute("phdParticipantBean", (Object)bean);
        return mapping.findForward("editPhdParticipant");
    }

    public ActionForward prepareChooseProcessToTransfer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        request.setAttribute("hasEnrolmentsInCurrentYear", (Object)this.hasEnrolmentsInCurrentYear(process2));
        request.setAttribute("enrolmentsInCurrentYear", (Object)(!process2.getStudyPlan().isExempted() ? this.hasEnrolmentsInCurrentYear(process2) : false));
        request.setAttribute("studentProcesses", this.getStudentOtherProcesses(process2));
        return mapping.findForward("chooseProcessToTransfer");
    }

    private Boolean hasEnrolmentsInCurrentYear(PhdIndividualProgramProcess process2) {
        if (process2.getStudyPlan().isExempted()) {
            return false;
        }
        return process2.getRegistration().getLastStudentCurricularPlan().hasAnyEnrolmentForCurrentExecutionYear();
    }

    private List<PhdIndividualProgramProcess> getStudentOtherProcesses(PhdIndividualProgramProcess process2) {
        ArrayList<PhdIndividualProgramProcess> result = new ArrayList<PhdIndividualProgramProcess>();
        result.addAll(CollectionUtils.disjunction((Collection)process2.getPerson().getPhdIndividualProgramProcessesSet(), Collections.singletonList(process2)));
        return result;
    }

    public ActionForward prepareFillRemarksOnTransfer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcessBean bean = new PhdIndividualProgramProcessBean(this.getProcess(request));
        bean.setDestiny((PhdIndividualProgramProcess)((Object)this.getDomainObject(request, "destinyId")));
        request.setAttribute("phdIndividualProgramProcessBean", (Object)bean);
        return mapping.findForward("fillRemarksOnTransfer");
    }

    public ActionForward transferProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            PhdIndividualProgramProcessBean bean = (PhdIndividualProgramProcessBean)this.getRenderedObject("phdIndividualProgramProcessBean");
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), TransferToAnotherProcess.class, (Object)bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.transferProcessInvalid(mapping, form, request, response);
        }
        return this.viewProcess(mapping, form, request, response);
    }

    public ActionForward transferProcessInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdIndividualProgramProcessBean", this.getRenderedObject("phdIndividualProgramProcessBean"));
        return mapping.findForward("fillRemarksOnTransfer");
    }

    public ActionForward prepareDissociateRegistration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        request.setAttribute("process", (Object)process2);
        request.setAttribute("something", (Object)Boolean.TRUE);
        return mapping.findForward("dissociateRegistration");
    }

    public ActionForward dissociateRegistration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), DissociateRegistration.class, null);
        return this.viewProcess(mapping, form, request, response);
    }

    public ActionForward generateReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SearchPhdIndividualProgramProcessBean searchBean = (SearchPhdIndividualProgramProcessBean)this.getObjectFromViewState("searchProcessBean");
        HSSFWorkbook workbook = new HSSFWorkbook();
        PhdIndividualProgramProcessesReport report = new PhdIndividualProgramProcessesReport(workbook);
        report.build(searchBean);
        PhdGuidersReport guidersReport = new PhdGuidersReport(workbook);
        guidersReport.build(searchBean);
        EPFLCandidatesReport epflReport = new EPFLCandidatesReport(workbook);
        epflReport.build(searchBean);
        RecommendationLetterReport recommendationLetterReport = new RecommendationLetterReport(workbook);
        recommendationLetterReport.build(searchBean);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment; filename=phd.xls");
        workbook.write((OutputStream)response.getOutputStream());
        response.getOutputStream().flush();
        response.flushBuffer();
        return null;
    }

    public ActionForward prepareUploadGuidanceAcceptanceLetter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = (PhdIndividualProgramProcess)((Object)this.getDomainObject(request, "processId"));
        PhdParticipant guider = (PhdParticipant)((Object)this.getDomainObject(request, "guidingId"));
        PhdParticipantBean guidingBean = new PhdParticipantBean(guider);
        PhdProgramDocumentUploadBean guidingAcceptanceLetter = new PhdProgramDocumentUploadBean();
        guidingAcceptanceLetter.setType(PhdIndividualProgramDocumentType.GUIDER_ACCEPTANCE_LETTER);
        guidingBean.setGuidingAcceptanceLetter(guidingAcceptanceLetter);
        request.setAttribute("process", (Object)process2);
        request.setAttribute("guidingBean", (Object)guidingBean);
        return mapping.findForward("uploadGuidanceAcceptanceDocument");
    }

    public ActionForward uploadGuidanceAcceptanceLetterInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareUploadGuidanceAcceptanceLetter(mapping, form, request, response);
    }

    public ActionForward uploadGuidanceAcceptanceLetter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = (PhdIndividualProgramProcess)((Object)this.getDomainObject(request, "processId"));
        PhdParticipantBean guidingBean = (PhdParticipantBean)this.getRenderedObject("guidingBean");
        ExecuteProcessActivity.run((Process)((Object)process2), UploadGuidanceAcceptanceLetter.class, (Object)guidingBean);
        return this.prepareManageGuidingInformation(mapping, form, request, response);
    }

    public ActionForward prepareEditState(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProcessState state = (PhdProcessState)((Object)this.getDomainObject(request, "stateId"));
        PhdProcessStateBean bean = new PhdProcessStateBean(state);
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("editPhdProcessState");
    }

    public ActionForward editState(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProcessStateBean bean = (PhdProcessStateBean)this.getRenderedObject("bean");
        bean.getState().editStateDate(bean);
        return this.managePhdIndividualProgramProcessState(mapping, form, request, response);
    }

    public ActionForward editStateInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProcessStateBean bean = (PhdProcessStateBean)this.getRenderedObject("bean");
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("editPhdProcessState");
    }

    public ActionForward viewAllAlertMessages(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        TreeSet<PhdAlertMessage> orderedMessages = new TreeSet<PhdAlertMessage>(Collections.reverseOrder(PhdAlertMessage.COMPARATOR_BY_WHEN_CREATED_AND_ID));
        orderedMessages.addAll(process2.getAlertMessagesSet());
        request.setAttribute("alertMessages", orderedMessages);
        return mapping.findForward("viewAllAlertMessages");
    }

    public ActionForward viewAlertMessageFromAllAlertMessages(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdAlertMessage alertMessage = (PhdAlertMessage)((Object)this.getDomainObject(request, "alertMessageId"));
        request.setAttribute("alertMessage", (Object)alertMessage);
        return mapping.findForward("viewAlertMessageFromAllAlertMessages");
    }

    public ActionForward viewLogs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("viewLogs");
    }
}

