/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.person;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Photograph;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.person.UpdateEmergencyContactDA;
import org.fenixedu.academic.ui.struts.action.person.VisualizePersonalInfo;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(path="/photoHistory", module="person", functionality=VisualizePersonalInfo.class)
@Forwards(value={@Forward(name="userHistory", path="/person/visualizePhotoHistory.jsp"), @Forward(name="visualizePersonalInformation", path="/person/visualizePersonalInfo.jsp")})
public class PhotoHistoryDA
extends FenixDispatchAction {
    public ActionForward userHistory(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = PhotoHistoryDA.getUserView(request).getPerson();
        List<Photograph> photoHistory = person.getPhotographHistory();
        Collections.reverse(photoHistory);
        request.setAttribute("history", photoHistory);
        return mapping.findForward("userHistory");
    }

    public ActionForward backToShowInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Person person = Authenticate.getUser().getPerson();
        request.setAttribute("personBean", (Object)new PersonBean(person));
        UpdateEmergencyContactDA.EmergencyContactBean emergencyContactBean = new UpdateEmergencyContactDA.EmergencyContactBean(person);
        request.setAttribute("emergencyContactBean", (Object)emergencyContactBean);
        return mapping.findForward("visualizePersonalInformation");
    }
}

