/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.messaging;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.util.email.ExecutionCourseSender;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.MessageDeleteService;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.messaging.MessagingApplication;
import org.fenixedu.academic.ui.struts.action.messaging.SearchSendersBean;
import org.fenixedu.academic.ui.struts.action.messaging.ViewSentEmailsDA$callable$resubmit;
import org.fenixedu.academic.util.CollectionPager;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=MessagingApplication.MessagingEmailsApp.class, path="view-sent-emails", titleKey="label.email.sent")
@Mapping(path="/viewSentEmails", module="messaging")
@Forwards(value={@Forward(name="view.sent.emails", path="/messaging/viewSentEmails.jsp"), @Forward(name="view.email", path="/messaging/viewEmail.jsp")})
public class ViewSentEmailsDA
extends FenixDispatchAction {
    public static final Advice advice$resubmit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @EntryPoint
    public ActionForward viewSentEmails(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String senderParam = request.getParameter("senderId");
        if (senderParam != null && !senderParam.isEmpty()) {
            return this.viewSentEmails(mapping, request, senderParam);
        }
        User userView = Authenticate.getUser();
        TreeSet<Sender> sendersGroups = new TreeSet<Sender>(Sender.COMPARATOR_BY_FROM_NAME);
        TreeSet<ExecutionCourseSender> sendersGroupsCourses = new TreeSet<ExecutionCourseSender>(ExecutionCourseSender.COMPARATOR_BY_EXECUTION_COURSE_SENDER);
        for (Sender sender : Bennu.getInstance().getUtilEmailSendersSet()) {
            boolean allow = sender.getMembers().isMember(userView);
            boolean isExecutionCourseSender = sender instanceof ExecutionCourseSender;
            if (allow && !isExecutionCourseSender) {
                sendersGroups.add(sender);
            }
            if (!allow || !isExecutionCourseSender) continue;
            sendersGroupsCourses.add((ExecutionCourseSender)((Object)sender));
        }
        if (this.isSenderUnique(sendersGroups, sendersGroupsCourses)) {
            if (sendersGroupsCourses.size() == 1) {
                return this.viewSentEmails(mapping, request, sendersGroupsCourses.iterator().next().getExternalId());
            }
            return this.viewSentEmails(mapping, request, ((Sender)((Object)sendersGroups.iterator().next())).getExternalId());
        }
        request.setAttribute("sendersGroups", sendersGroups);
        request.setAttribute("sendersGroupsCourses", sendersGroupsCourses);
        Person person = AccessControl.getPerson();
        if (person != null && RoleType.MANAGER.isMember(person.getUser())) {
            SearchSendersBean searchSendersBean = (SearchSendersBean)this.getRenderedObject("searchSendersBean");
            if (searchSendersBean == null) {
                searchSendersBean = new SearchSendersBean();
            }
            request.setAttribute("searchSendersBean", (Object)searchSendersBean);
        }
        return mapping.findForward("view.sent.emails");
    }

    public ActionForward viewSentEmails(ActionMapping mapping, HttpServletRequest request, String senderId) {
        Sender sender = (Sender)FenixFramework.getDomainObject((String)senderId);
        int numberOfMessagesByPage = 40;
        CollectionPager pager = new CollectionPager(sender.getMessagesSet().stream().sorted(Message.COMPARATOR_BY_CREATED_DATE_OLDER_LAST).collect(Collectors.toList()), 40);
        request.setAttribute("numberOfPages", (Object)this.getNumberOfPages(pager));
        String pageParameter = request.getParameter("pageNumber");
        Integer page = StringUtils.isEmpty((String)pageParameter) ? Integer.valueOf(1) : Integer.valueOf(pageParameter);
        request.setAttribute("messages", pager.getPage(page));
        request.setAttribute("senderId", (Object)senderId);
        request.setAttribute("pageNumber", (Object)page);
        return this.viewSentEmails(mapping, request, sender);
    }

    public ActionForward viewSentEmails(ActionMapping mapping, HttpServletRequest request, Sender sender) {
        request.setAttribute("sender", (Object)sender);
        return mapping.findForward("view.sent.emails");
    }

    public ActionForward viewEmail(ActionMapping mapping, HttpServletRequest request, Message message) {
        request.setAttribute("message", (Object)message);
        return mapping.findForward("view.email");
    }

    public ActionForward viewEmail(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String messageParam = request.getParameter("messagesId");
        Message message = messageParam != null && !messageParam.isEmpty() ? (Message)FenixFramework.getDomainObject((String)messageParam) : null;
        return this.viewEmail(mapping, request, message);
    }

    public ActionForward deleteMessage(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Message message;
        String messageParam = request.getParameter("messagesId");
        Message message2 = message = messageParam != null && !messageParam.isEmpty() ? (Message)FenixFramework.getDomainObject((String)messageParam) : null;
        if (message == null) {
            return this.viewSentEmails(mapping, actionForm, request, response);
        }
        Sender sender = message.getSender();
        MessageDeleteService.delete(message);
        return this.viewSentEmails(mapping, request, sender.getExternalId());
    }

    private int getNumberOfPages(CollectionPager<?> pager) {
        if (pager.getCollection().size() <= pager.getMaxElementsPerPage()) {
            return 0;
        }
        return pager.getNumberOfPages();
    }

    private boolean isSenderUnique(Set<?> arg0, Set<?> arg1) {
        if (arg0 == null) {
            return arg1.size() == 1;
        }
        if (arg1 == null) {
            return arg0.size() == 1;
        }
        return arg0.size() + arg0.size() == 1;
    }

    public ActionForward resubmit(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return (ActionForward)advice$resubmit.perform((Callable)new ViewSentEmailsDA$callable$resubmit(this, actionMapping, actionForm, httpServletRequest, httpServletResponse));
    }

    static /* synthetic */ ActionForward advised$resubmit(ViewSentEmailsDA this_, ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Message message = this_.getMessageFromRequest(request);
        message.setSent(null);
        message.setRootDomainObjectFromPendingRelation(rootDomainObject);
        request.setAttribute("message", (Object)message);
        return mapping.findForward("view.email");
    }

    private Message getMessageFromRequest(HttpServletRequest request) {
        String messageParam = request.getParameter("messagesId");
        return (Message)FenixFramework.getDomainObject((String)messageParam);
    }
}

