/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager.payments;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.paymentCodes.IndividualCandidacyPaymentCode;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.academic.ui.struts.action.manager.payments.CandidacyProcessPaymentCodeBean;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.YearMonthDay;

@StrutsFunctionality(app=ManagerApplications.ManagerPaymentsApp.class, path="candidacy-payment-codes", titleKey="title.candidacy.payment.codes")
@Mapping(path="/candidacyPaymentCodes", module="manager")
@Forwards(value={@Forward(name="index", path="/manager/payments/candidacyProcess/index.jsp"), @Forward(name="create", path="/manager/payments/candidacyProcess/create.jsp"), @Forward(name="showNewPaymentCodes", path="/manager/payments/candidacyProcess/showNewPaymentCodes.jsp")})
public class CandidacyProcessPaymentCodesManagementDA
extends FenixDispatchAction {
    private static final Map<PaymentCodeType, Money> MINIMUM_MONEY_MAP = new HashMap<PaymentCodeType, Money>();
    private static final Map<PaymentCodeType, Money> MAXIMUM_MONEY_MAP = new HashMap<PaymentCodeType, Money>();

    @EntryPoint
    public ActionForward index(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Integer over23Size = IndividualCandidacyPaymentCode.getAvailablePaymentCodes(PaymentCodeType.OVER_23_INDIVIDUAL_CANDIDACY_PROCESS, new YearMonthDay()).size();
        Integer externalDegreeCandidacyForGraduatedPersonSize = IndividualCandidacyPaymentCode.getAvailablePaymentCodes(PaymentCodeType.EXTERNAL_DEGREE_CANDIDACY_FOR_GRADUATED_PERSON_INDIVIDUAL_PROCESS, new YearMonthDay()).size();
        Integer internalDegreeCandidacyForGraduatedPersonSize = IndividualCandidacyPaymentCode.getAvailablePaymentCodes(PaymentCodeType.INTERNAL_DEGREE_CANDIDACY_FOR_GRADUATED_PERSON_INDIVIDUAL_PROCESS, new YearMonthDay()).size();
        Integer externalDegreeChangeSize = IndividualCandidacyPaymentCode.getAvailablePaymentCodes(PaymentCodeType.EXTERNAL_DEGREE_CHANGE_INDIVIDUAL_CANDIDACY_PROCESS, new YearMonthDay()).size();
        Integer internalDegreeChangeSize = IndividualCandidacyPaymentCode.getAvailablePaymentCodes(PaymentCodeType.INTERNAL_DEGREE_CHANGE_INDIVIDUAL_CANDIDACY_PROCESS, new YearMonthDay()).size();
        Integer externalDegreeTransferSize = IndividualCandidacyPaymentCode.getAvailablePaymentCodes(PaymentCodeType.EXTERNAL_DEGREE_TRANSFER_INDIVIDUAL_CANDIDACY_PROCESS, new YearMonthDay()).size();
        Integer internalDegreeTransferSize = IndividualCandidacyPaymentCode.getAvailablePaymentCodes(PaymentCodeType.INTERNAL_DEGREE_TRANSFER_INDIVIDUAL_CANDIDACY_PROCESS, new YearMonthDay()).size();
        Integer secondCycleSize = IndividualCandidacyPaymentCode.getAvailablePaymentCodes(PaymentCodeType.SECOND_CYCLE_INDIVIDUAL_CANDIDACY_PROCESS, new YearMonthDay()).size();
        request.setAttribute("over23Size", (Object)over23Size);
        request.setAttribute("externalDegreeCandidacyForGraduatedPersonSize", (Object)externalDegreeCandidacyForGraduatedPersonSize);
        request.setAttribute("internalDegreeCandidacyForGraduatedPersonSize", (Object)internalDegreeCandidacyForGraduatedPersonSize);
        request.setAttribute("externalDegreeChangeSize", (Object)externalDegreeChangeSize);
        request.setAttribute("internalDegreeChangeSize", (Object)internalDegreeChangeSize);
        request.setAttribute("externalDegreeTransferSize", (Object)externalDegreeTransferSize);
        request.setAttribute("internalDegreeTransferSize", (Object)internalDegreeTransferSize);
        request.setAttribute("secondCycleSize", (Object)secondCycleSize);
        return mapping.findForward("index");
    }

    public ActionForward prepareCreatePaymentCodes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String typeString = request.getParameter("type");
        PaymentCodeType type = PaymentCodeType.valueOf(typeString);
        CandidacyProcessPaymentCodeBean bean = new CandidacyProcessPaymentCodeBean(type);
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("create");
    }

    public ActionForward createPaymentCodesInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CandidacyProcessPaymentCodeBean bean = (CandidacyProcessPaymentCodeBean)this.getRenderedObject("bean");
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("create");
    }

    public ActionForward createPaymentCodes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CandidacyProcessPaymentCodeBean bean = (CandidacyProcessPaymentCodeBean)this.getRenderedObject("bean");
        List<IndividualCandidacyPaymentCode> paymentCodes = IndividualCandidacyPaymentCode.createPaymentCodes(bean.getType(), bean.getBeginDate(), bean.getEndDate(), MINIMUM_MONEY_MAP.get((Object)bean.getType()), MAXIMUM_MONEY_MAP.get((Object)bean.getType()), bean.getNumberOfPaymentCodes());
        request.setAttribute("newPaymentCodes", paymentCodes);
        return mapping.findForward("showNewPaymentCodes");
    }

    static {
        MINIMUM_MONEY_MAP.put(PaymentCodeType.EXTERNAL_DEGREE_CANDIDACY_FOR_GRADUATED_PERSON_INDIVIDUAL_PROCESS, new Money("140.00"));
        MINIMUM_MONEY_MAP.put(PaymentCodeType.INTERNAL_DEGREE_CANDIDACY_FOR_GRADUATED_PERSON_INDIVIDUAL_PROCESS, new Money("50.00"));
        MINIMUM_MONEY_MAP.put(PaymentCodeType.EXTERNAL_DEGREE_CHANGE_INDIVIDUAL_CANDIDACY_PROCESS, new Money("140.00"));
        MINIMUM_MONEY_MAP.put(PaymentCodeType.INTERNAL_DEGREE_CHANGE_INDIVIDUAL_CANDIDACY_PROCESS, new Money("50.00"));
        MINIMUM_MONEY_MAP.put(PaymentCodeType.EXTERNAL_DEGREE_TRANSFER_INDIVIDUAL_CANDIDACY_PROCESS, new Money("140.00"));
        MINIMUM_MONEY_MAP.put(PaymentCodeType.INTERNAL_DEGREE_TRANSFER_INDIVIDUAL_CANDIDACY_PROCESS, new Money("50.00"));
        MINIMUM_MONEY_MAP.put(PaymentCodeType.SECOND_CYCLE_INDIVIDUAL_CANDIDACY_PROCESS, new Money("100.00"));
        MINIMUM_MONEY_MAP.put(PaymentCodeType.OVER_23_INDIVIDUAL_CANDIDACY_PROCESS, new Money("140.00"));
        MAXIMUM_MONEY_MAP.put(PaymentCodeType.EXTERNAL_DEGREE_CANDIDACY_FOR_GRADUATED_PERSON_INDIVIDUAL_PROCESS, new Money("140.00"));
        MAXIMUM_MONEY_MAP.put(PaymentCodeType.INTERNAL_DEGREE_CANDIDACY_FOR_GRADUATED_PERSON_INDIVIDUAL_PROCESS, new Money("50.00"));
        MAXIMUM_MONEY_MAP.put(PaymentCodeType.EXTERNAL_DEGREE_CHANGE_INDIVIDUAL_CANDIDACY_PROCESS, new Money("140.00"));
        MAXIMUM_MONEY_MAP.put(PaymentCodeType.INTERNAL_DEGREE_CHANGE_INDIVIDUAL_CANDIDACY_PROCESS, new Money("50.00"));
        MAXIMUM_MONEY_MAP.put(PaymentCodeType.EXTERNAL_DEGREE_TRANSFER_INDIVIDUAL_CANDIDACY_PROCESS, new Money("140.00"));
        MAXIMUM_MONEY_MAP.put(PaymentCodeType.INTERNAL_DEGREE_TRANSFER_INDIVIDUAL_CANDIDACY_PROCESS, new Money("50.00"));
        MAXIMUM_MONEY_MAP.put(PaymentCodeType.SECOND_CYCLE_INDIVIDUAL_CANDIDACY_PROCESS, new Money("3500.00"));
        MAXIMUM_MONEY_MAP.put(PaymentCodeType.OVER_23_INDIVIDUAL_CANDIDACY_PROCESS, new Money("140.00"));
    }
}

