/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EquivalencePlanEntry;
import org.fenixedu.academic.domain.StudentCurricularPlanEquivalencePlan;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.service.services.coordinator.CreateStudentCurricularPlanEquivalencePlan;
import org.fenixedu.academic.service.services.coordinator.DeleteEquivalencePlanEntry;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.coordinator.StudentEquivalencyPlanEntryCreator;
import org.fenixedu.academic.ui.struts.action.coordinator.StudentSearchBean;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=ManagerApplications.ManagerBolonhaTransitionApp.class, path="local-equivalence", titleKey="title.local.equivalence")
@Mapping(path="/degreeCurricularPlan/studentEquivalencyPlan", module="manager")
@Forwards(value={@Forward(name="showPlan", path="/academicAdminOffice/degreeCurricularPlan/showStudentEquivalencyPlan.jsp"), @Forward(name="addEquivalency", path="/academicAdminOffice/degreeCurricularPlan/addStudentEquivalency.jsp")})
public class StudentEquivalencyPlanDA
extends FenixDispatchAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCurricularPlan selectedDegreeCurricularPlan = this.getSelectedDegreeCurricularPlan(request);
        if (selectedDegreeCurricularPlan == null) {
            request.setAttribute("degreeCurricularPlans", DegreeCurricularPlan.getDegreeCurricularPlans(DegreeType.oneOf(DegreeType::isBolonhaDegree, DegreeType::isBolonhaMasterDegree, DegreeType::isIntegratedMasterDegree)));
        } else {
            request.setAttribute("selectedDegreeCurricularPlan", (Object)selectedDegreeCurricularPlan);
        }
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        request.setAttribute("degreeCurricularPlan", (Object)(degreeCurricularPlan != null ? degreeCurricularPlan : selectedDegreeCurricularPlan));
        return super.execute(mapping, actionForm, request, response);
    }

    @EntryPoint
    public ActionForward showPlan(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCurricularPlan degreeCurricularPlan;
        StudentCurricularPlanEquivalencePlan studentCurricularPlanEquivalencePlan;
        Student student = this.getStudent(request);
        if (student != null && (studentCurricularPlanEquivalencePlan = this.getStudentCurricularPlanEquivalencePlan(request, student)) != null && (degreeCurricularPlan = (DegreeCurricularPlan)((Object)request.getAttribute("selectedDegreeCurricularPlan"))) != null) {
            request.setAttribute("studentCurricularPlanEquivalencePlan", (Object)studentCurricularPlanEquivalencePlan);
            studentCurricularPlanEquivalencePlan.getRootEquivalencyPlanEntryCurriculumModuleWrapper(degreeCurricularPlan);
            request.setAttribute("rootEquivalencyPlanEntryCurriculumModuleWrapper", (Object)studentCurricularPlanEquivalencePlan.getRootEquivalencyPlanEntryCurriculumModuleWrapper(degreeCurricularPlan));
        }
        return mapping.findForward("showPlan");
    }

    public ActionForward showTable(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StudentCurricularPlanEquivalencePlan studentCurricularPlanEquivalencePlan;
        Student student = this.getStudent(request);
        if (student != null && (studentCurricularPlanEquivalencePlan = this.getStudentCurricularPlanEquivalencePlan(request, student)) != null) {
            request.setAttribute("studentCurricularPlanEquivalencePlan", (Object)studentCurricularPlanEquivalencePlan);
            DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)((Object)request.getAttribute("selectedDegreeCurricularPlan"));
            CurriculumModule curriculumModule = this.getCurriculumModule(request);
            request.setAttribute("equivalencePlanEntryWrappers", studentCurricularPlanEquivalencePlan.getEquivalencePlanEntryWrappers(degreeCurricularPlan, curriculumModule));
        }
        return mapping.findForward("showPlan");
    }

    public ActionForward prepareAddEquivalency(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CurriculumModule curriculumModule;
        Student student = this.getStudent(request);
        StudentCurricularPlanEquivalencePlan studentCurricularPlanEquivalencePlan = this.getStudentCurricularPlanEquivalencePlan(request, student);
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)((Object)request.getAttribute("selectedDegreeCurricularPlan"));
        StudentEquivalencyPlanEntryCreator studentEquivalencyPlanEntryCreator = (StudentEquivalencyPlanEntryCreator)this.getRenderedObject();
        if (studentEquivalencyPlanEntryCreator == null) {
            studentEquivalencyPlanEntryCreator = new StudentEquivalencyPlanEntryCreator(studentCurricularPlanEquivalencePlan, degreeCurricularPlan.getEquivalencePlan());
        }
        if ((curriculumModule = this.getCurriculumModule(request)) != null) {
            studentEquivalencyPlanEntryCreator.setOriginDegreeModuleToAdd(curriculumModule.getDegreeModule());
            studentEquivalencyPlanEntryCreator.addOrigin(curriculumModule.getDegreeModule());
        }
        request.setAttribute("studentEquivalencyPlanEntryCreator", (Object)studentEquivalencyPlanEntryCreator);
        return mapping.findForward("addEquivalency");
    }

    public ActionForward deleteEquivalency(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getStudent(request);
        EquivalencePlanEntry equivalencePlanEntry = this.getEquivalencePlanEntry(request);
        DeleteEquivalencePlanEntry.runDeleteEquivalencePlanEntry(equivalencePlanEntry);
        return this.showTable(mapping, actionForm, request, response);
    }

    public ActionForward activate(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.changeActiveState(mapping, actionForm, request, response, "ActivateEquivalencePlanEntry");
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.changeActiveState(mapping, actionForm, request, response, "DeActivateEquivalencePlanEntry");
    }

    public ActionForward changeActiveState(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, String service) throws Exception {
        Student student = this.getStudent(request);
        StudentCurricularPlanEquivalencePlan studentCurricularPlanEquivalencePlan = this.getStudentCurricularPlanEquivalencePlan(request, student);
        EquivalencePlanEntry equivalencePlanEntry = this.getEquivalencePlanEntry(request);
        Object[] args = new Object[]{studentCurricularPlanEquivalencePlan, equivalencePlanEntry};
        throw new UnsupportedOperationException("Service " + service + " no longer exists");
    }

    private EquivalencePlanEntry getEquivalencePlanEntry(HttpServletRequest request) {
        String equivalencePlanEntryIDString = request.getParameter("equivalencePlanEntryID");
        return (EquivalencePlanEntry)FenixFramework.getDomainObject((String)equivalencePlanEntryIDString);
    }

    private StudentCurricularPlanEquivalencePlan getStudentCurricularPlanEquivalencePlan(HttpServletRequest request, Student student) throws FenixServiceException {
        return CreateStudentCurricularPlanEquivalencePlan.run(student);
    }

    private Student getStudent(HttpServletRequest request) {
        StudentSearchBean studentSearchBean = (StudentSearchBean)this.getRenderedObject("StudentSearchBeanWithDegreeCurricularPlan");
        if (studentSearchBean == null) {
            studentSearchBean = (StudentSearchBean)this.getRenderedObject("StudentSearchBean");
        }
        if (studentSearchBean == null) {
            studentSearchBean = new StudentSearchBean();
            String studentNumber = request.getParameter("studentNumber");
            if (studentNumber != null && studentNumber.length() > 0) {
                studentSearchBean.setStudentNumber(Integer.valueOf(studentNumber));
            }
            studentSearchBean.setDegreeCurricularPlan((DegreeCurricularPlan)((Object)request.getAttribute("selectedDegreeCurricularPlan")));
            studentSearchBean.setOldDegreeCurricularPlan((DegreeCurricularPlan)((Object)request.getAttribute("degreeCurricularPlan")));
        } else {
            DegreeCurricularPlan degreeCurricularPlan = studentSearchBean.getDegreeCurricularPlan();
            if (degreeCurricularPlan != null) {
                request.setAttribute("selectedDegreeCurricularPlan", (Object)degreeCurricularPlan);
            }
        }
        request.setAttribute("studentSearchBean", (Object)studentSearchBean);
        Student student = studentSearchBean.search();
        if (student != null) {
            request.setAttribute("student", (Object)student);
        }
        return student;
    }

    private CurriculumModule getCurriculumModule(HttpServletRequest request) {
        String curriculumModuleIDString = request.getParameter("curriculumModuleID");
        return (CurriculumModule)FenixFramework.getDomainObject((String)curriculumModuleIDString);
    }

    private DegreeCurricularPlan getDegreeCurricularPlan(HttpServletRequest request) {
        return this.getDegreeCurricularPlan(request, "degreeCurricularPlanID");
    }

    private DegreeCurricularPlan getSelectedDegreeCurricularPlan(HttpServletRequest request) {
        StudentSearchBean studentSearchBean = (StudentSearchBean)this.getRenderedObject("StudentSearchBeanWithDegreeCurricularPlan");
        return studentSearchBean != null ? studentSearchBean.getDegreeCurricularPlan() : this.getDegreeCurricularPlan(request, "selectedDegreeCurricularPlanID");
    }

    private DegreeCurricularPlan getDegreeCurricularPlan(HttpServletRequest request, String attrName) {
        String degreeCurricularPlanIDString = request.getParameter(attrName);
        return (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanIDString);
    }
}

