/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.dto.InfoCurricularCourse;
import org.fenixedu.academic.service.services.commons.ReadCurricularCourseByID;
import org.fenixedu.academic.service.services.commons.student.ReadStudentListByCurricularCourse;
import org.fenixedu.academic.service.services.exceptions.ExistingServiceException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NonExistingServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.masterDegree.administrativeOffice.ReadCurricularCoursesByDegree;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.academic.ui.struts.action.exceptions.ExistingActionException;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.exceptions.NonExistingActionException;
import org.fenixedu.academic.ui.struts.config.FenixErrorExceptionHandler;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.struts.annotations.ExceptionHandling;
import org.fenixedu.bennu.struts.annotations.Exceptions;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(path="/listStudentsByCourse", module="coordinator", functionality=DegreeCoordinatorIndex.class)
@Forwards(value={@Forward(name="ChooseSuccess", path="/coordinator/student/displayStudentListByCourse_bd.jsp"), @Forward(name="PrepareSuccess", path="/coordinator/student/displayStudentListByDegree_bd.jsp"), @Forward(name="NoStudents", path="/coordinator/listStudentsForCoordinator.do?method=getCurricularCourses"), @Forward(name="NotAuthorized", path="/coordinator/student/notAuthorized_bd.jsp")})
@Exceptions(value={@ExceptionHandling(key="resources.Action.exceptions.NonExistingActionException", handler=FenixErrorExceptionHandler.class, type=NonExistingActionException.class)})
public class ChooseCurricularCourseDispatchActionForCoordinator
extends FenixDispatchAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCoordinatorIndex.setCoordinatorContext(request);
        return super.execute(mapping, actionForm, request, response);
    }

    public ActionForward prepareChooseCurricularCourse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String executionYear = this.getFromRequest("executionYear", request);
        String degree = this.getFromRequest("degree", request);
        request.setAttribute("jspTitle", (Object)this.getFromRequest("jspTitle", request));
        request.setAttribute("executionYear", (Object)executionYear);
        request.setAttribute("degree", (Object)degree);
        User userView = ChooseCurricularCourseDispatchActionForCoordinator.getUserView(request);
        List curricularCourseList = null;
        try {
            curricularCourseList = ReadCurricularCoursesByDegree.run(executionYear, degree);
        }
        catch (NonExistingServiceException e) {
            ActionErrors errors = new ActionErrors();
            errors.add("nonExisting", new ActionError("message.public.notfound.curricularCourses"));
            this.saveErrors(request, errors);
            return mapping.getInputForward();
        }
        catch (ExistingServiceException e) {
            throw new ExistingActionException(e);
        }
        Collections.sort(curricularCourseList, new BeanComparator("name"));
        request.setAttribute("curricularCourses", (Object)curricularCourseList);
        return mapping.findForward("PrepareSuccess");
    }

    public ActionForward chooseCurricularCourse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("courseID", (Object)this.getFromRequest("courseID", request));
        request.setAttribute("curricularCourse", (Object)this.getFromRequest("curricularCourse", request));
        request.setAttribute("executionYear", (Object)this.getFromRequest("executionYear", request));
        request.setAttribute("degree", (Object)this.getFromRequest("degree", request));
        request.setAttribute("jspTitle", (Object)this.getFromRequest("jspTitle", request));
        return mapping.findForward("ChooseSuccess");
    }

    public ActionForward chooseCurricularCourseByID(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getParameter("degreeCurricularPlanID") != null) {
            String degreeCurricularPlanID = request.getParameter("degreeCurricularPlanID");
            request.setAttribute("degreeCurricularPlanID", (Object)degreeCurricularPlanID);
        }
        request.setAttribute("courseID", (Object)this.getFromRequest("courseID", request));
        String courseID = this.getFromRequest("courseID", request);
        User userView = ChooseCurricularCourseDispatchActionForCoordinator.getUserView(request);
        List studentList = null;
        try {
            studentList = ReadStudentListByCurricularCourse.runReadStudentListByCurricularCourse(userView, courseID, null);
        }
        catch (NotAuthorizedException e) {
            return mapping.findForward("NotAuthorized");
        }
        catch (NonExistingServiceException e) {
            ActionErrors errors = new ActionErrors();
            errors.add("nonExisting", new ActionError("error.exception.noStudents"));
            this.saveErrors(request, errors);
            return mapping.findForward("NoStudents");
        }
        InfoCurricularCourse infoCurricularCourse = null;
        try {
            infoCurricularCourse = ReadCurricularCourseByID.run(courseID);
        }
        catch (NonExistingServiceException e) {
        }
        catch (FenixServiceException e) {
            throw new FenixActionException(e);
        }
        if (infoCurricularCourse != null) {
            request.setAttribute("infoCurricularCourse", (Object)infoCurricularCourse);
        }
        request.setAttribute("enrolment_list", (Object)studentList);
        String value = request.getParameter("viewPhoto");
        if (value != null && value.equals("true")) {
            request.setAttribute("viewPhoto", (Object)Boolean.TRUE);
        } else {
            request.setAttribute("viewPhoto", (Object)Boolean.FALSE);
        }
        return mapping.findForward("ChooseSuccess");
    }

    private String getFromRequest(String parameter, HttpServletRequest request) {
        String parameterString = request.getParameter(parameter);
        if (parameterString == null) {
            parameterString = (String)request.getAttribute(parameter);
        }
        return parameterString;
    }
}

