/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetEnrolmentEvaluationBean;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetManagementCreateBean;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetRectifyBean;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission.MarkSheetCreateDispatchAction;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.gradeSubmission.OldMarkSheetSearchDispatchAction;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/oldCreateMarkSheet", module="academicAdministration", formBean="markSheetManagementForm", input="/gradeSubmission/oldMarkSheets/createMarkSheetStep1.jsp", functionality=OldMarkSheetSearchDispatchAction.class)
@Forwards(value={@Forward(name="createMarkSheetStep1", path="/academicAdministration/gradeSubmission/oldMarkSheets/createMarkSheetStep1.jsp"), @Forward(name="createMarkSheetStep2", path="/academicAdministration/gradeSubmission/oldMarkSheets/createMarkSheetStep2.jsp"), @Forward(name="searchMarkSheetFilled", path="/academicAdministration/oldMarkSheetManagement.do?method=prepareSearchMarkSheetFilled"), @Forward(name="rectifyMarkSheetStep1", path="/academicAdministration/gradeSubmission/rectifyMarkSheetStep1.jsp"), @Forward(name="rectifyMarkSheetStep2", path="/academicAdministration/gradeSubmission/rectifyMarkSheetStep2.jsp"), @Forward(name="viewMarkSheet", path="/academicAdministration/gradeSubmission/oldMarkSheets/viewMarkSheet.jsp")})
public class OldMarkSheetCreateDispatchAction
extends MarkSheetCreateDispatchAction {
    @Override
    public ActionForward createMarkSheetStepOne(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MarkSheetManagementCreateBean createBean = (MarkSheetManagementCreateBean)RenderUtils.getViewState().getMetaObject().getObject();
        request.setAttribute("edit", (Object)createBean);
        Teacher teacher = Teacher.readByIstId(createBean.getTeacherId());
        createBean.setTeacher(teacher);
        ActionMessages actionMessages = this.createActionMessages();
        this.prepareCreateEnrolmentEvaluationsForMarkSheet(createBean, request, actionMessages);
        if (!actionMessages.isEmpty()) {
            return mapping.findForward("createMarkSheetStep1");
        }
        return mapping.findForward("createMarkSheetStep2");
    }

    @Override
    protected MarkSheet createMarkSheet(MarkSheetManagementCreateBean createBean, User userView) {
        return createBean.createOldMarkSheet(userView.getPerson());
    }

    @Override
    protected void prepareCreateEnrolmentEvaluationsForMarkSheet(MarkSheetManagementCreateBean createBean, HttpServletRequest request, ActionMessages actionMessages) {
        Set<Enrolment> enrolments = createBean.getCurricularCourse().getEnrolmentsNotInAnyMarkSheetForOldMarkSheets(createBean.getEvaluationSeason(), createBean.getExecutionPeriod());
        if (enrolments.isEmpty()) {
            this.addMessage(request, actionMessages, "error.allStudentsAreInMarkSheets", new String[0]);
        } else {
            HashSet<MarkSheetEnrolmentEvaluationBean> enrolmentEvaluationBeans = new HashSet<MarkSheetEnrolmentEvaluationBean>();
            for (Enrolment enrolment : enrolments) {
                MarkSheetEnrolmentEvaluationBean markSheetEnrolmentEvaluationBean = new MarkSheetEnrolmentEvaluationBean();
                markSheetEnrolmentEvaluationBean.setEnrolment(enrolment);
                markSheetEnrolmentEvaluationBean.setEvaluationDate(createBean.getEvaluationDate());
                enrolmentEvaluationBeans.add(markSheetEnrolmentEvaluationBean);
            }
            createBean.setEnrolmentEvaluationBeans(enrolmentEvaluationBeans);
        }
    }

    public ActionForward prepareRectifyMarkSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm form = (DynaActionForm)actionForm;
        MarkSheet markSheet = (MarkSheet)FenixFramework.getDomainObject((String)((String)form.get("msID")));
        MarkSheetRectifyBean rectifyBean = new MarkSheetRectifyBean();
        this.fillMarkSheetBean(actionForm, request, rectifyBean);
        rectifyBean.setUrl(this.buildUrl(form));
        rectifyBean.setMarkSheet(markSheet);
        request.setAttribute("rectifyBean", (Object)rectifyBean);
        request.setAttribute("msID", form.get("msID"));
        ArrayList enrolmentEvaluations = new ArrayList(markSheet.getEnrolmentEvaluationsSet());
        Collections.sort(enrolmentEvaluations, EnrolmentEvaluation.SORT_BY_STUDENT_NUMBER);
        request.setAttribute("enrolmentEvaluations", enrolmentEvaluations);
        return mapping.findForward("rectifyMarkSheetStep1");
    }
}

