/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.documents;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.documents.AnnualIRSDeclarationDocument;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.person.SimpleSearchPersonWithStudentBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.report.IRSCustomDeclaration;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.FenixActionForm;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.LocalDate;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminDocumentsApp.class, path="generated-documents", titleKey="label.documents", accessGroup="academic(MANAGE_DOCUMENTS)")
@Mapping(path="/generatedDocuments", module="academicAdministration", formBeanClass=FenixActionForm.class)
@Forwards(value={@Forward(name="searchPerson", path="/academicAdminOffice/generatedDocuments/searchPerson.jsp"), @Forward(name="showAnnualIRSDocuments", path="/academicAdminOffice/generatedDocuments/showAnnualIRSDocuments.jsp"), @Forward(name="payments.manageIRSDocuments", path="/academicAdminOffice/generatedDocuments/payments/manageIRSDocuments.jsp")})
public class GeneratedDocumentsDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepareSearchPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("searchPersonBean", (Object)new SimpleSearchPersonWithStudentBean());
        return mapping.findForward("searchPerson");
    }

    public ActionForward prepareSearchPersonInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("searchPersonBean", this.getObjectFromViewState("searchPersonBean"));
        return mapping.findForward("searchPerson");
    }

    public ActionForward searchPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        SimpleSearchPersonWithStudentBean searchPersonBean = (SimpleSearchPersonWithStudentBean)this.getObjectFromViewState("searchPersonBean");
        request.setAttribute("searchPersonBean", (Object)searchPersonBean);
        request.setAttribute("persons", searchPersonBean.search());
        return mapping.findForward("searchPerson");
    }

    public ActionForward showAnnualIRSDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("person", (Object)this.getPerson(request));
        request.setAttribute("annualIRSDocuments", this.getPerson(request).getAnnualIRSDocuments());
        return mapping.findForward("showAnnualIRSDocuments");
    }

    private Person getPerson(HttpServletRequest request) {
        return (Person)((Object)this.getDomainObject(request, "personId"));
    }

    public ActionForward showAnnualIRSDocumentsInPayments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.showAnnualIRSDocuments(mapping, actionForm, request, response);
        return mapping.findForward("payments.manageIRSDocuments");
    }

    public ActionForward prepareGenerateNewIRSDeclaration(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("declarationDTO", (Object)new IRSCustomDeclaration.IRSDeclarationDTO(null, this.getPerson(request)));
        return this.showAnnualIRSDocumentsInPayments(mapping, actionForm, request, response);
    }

    public ActionForward generateNewIRSDeclarationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("declarationDTO", this.getRenderedObject("declarationDTO"));
        return this.showAnnualIRSDocumentsInPayments(mapping, actionForm, request, response);
    }

    public ActionForward generateNewIRSDeclaration(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Person person = this.getPerson(request);
        IRSCustomDeclaration.IRSDeclarationDTO declarationDTO = (IRSCustomDeclaration.IRSDeclarationDTO)this.getRenderedObject("declarationDTO");
        try {
            if (declarationDTO.getCivilYear() >= new LocalDate().getYear()) {
                this.addActionMessage("error", request, "error.annual.irs.declaration.year.must.be.previous.to.current");
            } else {
                byte[] declaration = this.buildIRSCustomDeclaration(declarationDTO, person);
                AnnualIRSDeclarationDocument.create(person, this.getLoggedPerson(request), declaration, declarationDTO.getCivilYear());
                this.addActionMessage("success", request, "message.new.irs.annual.document.generated.with.success");
            }
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage(), e.getArgs());
        }
        catch (FenixActionException e) {
            this.addActionMessage("error", request, e.getMessage());
        }
        return this.showAnnualIRSDocumentsInPayments(mapping, actionForm, request, response);
    }

    public ActionForward generateAgainAnnualIRSDeclarationDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            AnnualIRSDeclarationDocument document = (AnnualIRSDeclarationDocument)((Object)this.getDomainObject(request, "annualIRSDocumentOid"));
            request.setAttribute("personId", (Object)document.getAddressee().getExternalId());
            IRSCustomDeclaration.IRSDeclarationDTO declarationDTO = new IRSCustomDeclaration.IRSDeclarationDTO((int)document.getYear(), document.getAddressee());
            byte[] declaration = this.buildIRSCustomDeclaration(declarationDTO, document.getAddressee());
            document.generateAnotherDeclaration(AccessControl.getPerson(), declaration);
            this.addActionMessage("success", request, "message.new.irs.annual.document.generated.with.success");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage(), e.getArgs());
        }
        catch (FenixActionException e) {
            this.addActionMessage("error", request, e.getMessage());
        }
        return this.showAnnualIRSDocumentsInPayments(mapping, actionForm, request, response);
    }

    private byte[] buildIRSCustomDeclaration(IRSCustomDeclaration.IRSDeclarationDTO declarationDTO, Person person) throws FenixActionException {
        this.addPayedAmount(person, declarationDTO.getCivilYear(), declarationDTO);
        IRSCustomDeclaration customDeclaration = new IRSCustomDeclaration(declarationDTO);
        return ReportsUtils.generateReport(customDeclaration.getReportTemplateKey(), customDeclaration.getParameters(), customDeclaration.getDataSource()).getData();
    }

    private void addPayedAmount(Person person, int civilYear, IRSCustomDeclaration.IRSDeclarationDTO declarationDTO) throws FenixActionException {
        for (Event event : person.getEventsSet()) {
            if (!event.hasPaymentsByPersonForCivilYear(civilYear) || !event.getMaxDeductableAmountForLegalTaxes(civilYear).isPositive()) continue;
            declarationDTO.addAmount(event, civilYear);
        }
        if (!declarationDTO.getTotalAmount().isPositive()) {
            throw new FenixActionException("error.annual.irs.declaration.no.payments.for.civil.year", civilYear);
        }
    }
}

