/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller.student;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.ui.spring.controller.student.StudentGroupingService$callable$changeShift;
import org.fenixedu.academic.ui.spring.controller.student.StudentGroupingService$callable$createStudentGroup;
import org.fenixedu.academic.ui.spring.controller.student.StudentGroupingService$callable$enroll;
import org.fenixedu.academic.ui.spring.controller.student.StudentGroupingService$callable$unenroll;
import org.springframework.stereotype.Service;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Service
public class StudentGroupingService {
    public static final Advice advice$enroll = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$unenroll = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createStudentGroup = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$changeShift = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public void enroll(StudentGroup studentGroup, Person person) {
        Object object = advice$enroll.perform((Callable)new StudentGroupingService$callable$enroll(this, studentGroup, person));
    }

    static /* synthetic */ void advised$enroll(StudentGroupingService this_, StudentGroup studentGroup, Person person) {
        if (studentGroup == null) {
            throw new DomainException("error.shift.noShift", new String[0]);
        }
        Grouping grouping = studentGroup.getGrouping();
        if (!this_.groupingIsOpenForEnrollment(grouping).booleanValue()) {
            throw new DomainException("error.grouping.notOpenToEnrollment", new String[0]);
        }
        if (!this_.personInGroupingAttends(grouping, person).booleanValue()) {
            throw new DomainException("error.grouping.notEnroled", new String[0]);
        }
        if (grouping.getStudentGroupsSet().stream().anyMatch(sg -> this.personInStudentGroupAttends((StudentGroup)((Object)sg), person))) {
            throw new DomainException("error.studentGroup.alreadyEnroled", new String[0]);
        }
        if (grouping.getEnrolmentPolicy().equals(1) && grouping.getMinimumCapacity() != null && studentGroup.getAttendsSet().size() + 1 < grouping.getMinimumCapacity()) {
            throw new DomainException("error.invalidNumberOfStudents", new String[0]);
        }
        if (grouping.getMaximumCapacity() != null && studentGroup.getAttendsSet().size() + 1 > grouping.getMaximumCapacity()) {
            throw new DomainException("error.invalidNumberOfStudents", new String[0]);
        }
        studentGroup.addAttends(grouping.getAttendsSet().stream().filter(attends -> attends.getRegistration().getPerson() == person).findAny().get());
    }

    public void unenroll(StudentGroup studentGroup, Person person) {
        Object object = advice$unenroll.perform((Callable)new StudentGroupingService$callable$unenroll(this, studentGroup, person));
    }

    static /* synthetic */ void advised$unenroll(StudentGroupingService this_, StudentGroup studentGroup, Person person) {
        Grouping grouping = studentGroup.getGrouping();
        if (!this_.groupingIsOpenForEnrollment(grouping).booleanValue()) {
            throw new DomainException("error.grouping.notOpenToEnrollment", new String[0]);
        }
        if (!this_.personInGroupingAttends(grouping, person).booleanValue() || !this_.personInStudentGroupAttends(studentGroup, person).booleanValue()) {
            throw new DomainException("error.studentGroup.notEnroled", new String[0]);
        }
        if (grouping.getMinimumCapacity() != null && studentGroup.getAttendsSet().size() - 1 < grouping.getMinimumCapacity()) {
            throw new DomainException("error.invalidNumberOfStudents", new String[0]);
        }
        if (grouping.getMaximumCapacity() != null && studentGroup.getAttendsSet().size() - 1 > grouping.getMaximumCapacity()) {
            throw new DomainException("error.invalidNumberOfStudents", new String[0]);
        }
        studentGroup.removeAttends(grouping.getAttendsSet().stream().filter(attends -> attends.getRegistration().getPerson() == person).findAny().get());
        if (studentGroup.getAttendsSet().isEmpty()) {
            studentGroup.delete();
        }
    }

    public void createStudentGroup(Grouping grouping, Shift shift, List<Person> list) {
        Object object = advice$createStudentGroup.perform((Callable)new StudentGroupingService$callable$createStudentGroup(this, grouping, shift, list));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$createStudentGroup(StudentGroupingService this_, Grouping grouping, Shift shift, List personList) {
        if (!personList.contains((Object)AccessControl.getPerson())) {
            personList.add(AccessControl.getPerson());
        }
        List<Registration> registrationsList = grouping.getAttendsSet().stream().map(Attends::getRegistration).filter(reg -> personList.contains((Object)reg.getPerson())).collect(Collectors.toList());
        if (!this_.groupingIsOpenForEnrollment(grouping).booleanValue()) {
            throw new DomainException("error.grouping.notOpenToEnrollment", new String[0]);
        }
        if (personList.stream().anyMatch(person -> this.personInGroupingAttends(grouping, (Person)((Object)person)) == false)) {
            throw new DomainException("error.studentGroup.notEnroled", new String[0]);
        }
        if (personList.stream().anyMatch(person -> grouping.getStudentGroupsSet().stream().anyMatch(sg -> this.personInStudentGroupAttends((StudentGroup)((Object)((Object)sg)), (Person)((Object)person))))) {
            throw new DomainException("error.studentGroup.alreadyEnrolled", new String[0]);
        }
        if (grouping.getShiftType() != null && !shift.getTypes().contains((Object)grouping.getShiftType())) {
            throw new DomainException("error.wrongShiftType", new String[0]);
        }
        if (shift != null && !grouping.getExecutionCourses().contains((Object)shift.getExecutionCourse())) {
            throw new DomainException("error.wrongShiftType", new String[0]);
        }
        if (grouping.getDifferentiatedCapacity().booleanValue()) {
            if (shift != null && shift.getShiftGroupingProperties().getCapacity() != null && shift.getShiftGroupingProperties().getCapacity() < shift.getAssociatedStudentGroups(grouping).size() + 1) {
                throw new DomainException("error.invalidNumberOfStudentGroups", new String[0]);
            }
        } else if (grouping.getGroupMaximumNumber() != null) {
            if (shift != null && grouping.getGroupMaximumNumber() < shift.getAssociatedStudentGroups(grouping).size() + 1) {
                throw new DomainException("error.invalidNumberOfStudentGroups", new String[0]);
            }
            if (shift == null && grouping.getGroupMaximumNumber() < grouping.getStudentGroupsSet().size() + 1) {
                throw new DomainException("error.invalidNumberOfStudentGroups", new String[0]);
            }
        }
        if (grouping.getEnrolmentPolicy().equals(1) && grouping.getMinimumCapacity() != null && personList.size() < grouping.getMinimumCapacity()) {
            throw new DomainException("error.invalidNumberOfStudents", new String[0]);
        }
        if (grouping.getMaximumCapacity() != null && personList.size() > grouping.getMaximumCapacity()) {
            throw new DomainException("error.invalidNumberOfStudents", new String[0]);
        }
        grouping.createStudentGroup(shift, grouping.findMaxGroupNumber() + 1, registrationsList);
    }

    public void changeShift(StudentGroup studentGroup, Shift shift) {
        Object object = advice$changeShift.perform((Callable)new StudentGroupingService$callable$changeShift(this, studentGroup, shift));
    }

    static /* synthetic */ void advised$changeShift(StudentGroupingService this_, StudentGroup studentGroup, Shift shift) {
        Grouping grouping = studentGroup.getGrouping();
        if (!this_.groupingIsOpenForEnrollment(grouping).booleanValue()) {
            throw new DomainException("error.grouping.notOpenToEnrollment", new String[0]);
        }
        if (shift == null && grouping.getShiftType() != null || !shift.getTypes().contains((Object)grouping.getShiftType())) {
            throw new DomainException("error.wrongShiftType", new String[0]);
        }
        if (grouping.getDifferentiatedCapacity() != false ? shift.getShiftGroupingProperties().getCapacity() < shift.getAssociatedStudentGroups(grouping).size() + 1 : grouping.getGroupMaximumNumber() < shift.getAssociatedStudentGroups(grouping).size() + 1) {
            throw new DomainException("error.invalidNumberOfStudentGroups", new String[0]);
        }
        studentGroup.setShift(shift);
    }

    public Boolean groupingIsOpenForEnrollment(Grouping grouping) {
        return grouping.getEnrolmentBeginDayDateDateTime().isBeforeNow() && grouping.getEnrolmentEndDayDateDateTime().isAfterNow();
    }

    public Boolean personInStudentGroupAttends(StudentGroup studentGroup, Person person) {
        return studentGroup.getAttendsSet().stream().map(Attends::getRegistration).map(Registration::getPerson).anyMatch(p -> p.equals((Object)AccessControl.getPerson()));
    }

    public Boolean personInGroupingAttends(Grouping grouping, Person person) {
        return grouping.getAttendsSet().stream().filter(attends -> grouping.getExecutionCourses().contains((Object)attends.getExecutionCourse())).map(Attends::getRegistration).map(Registration::getPerson).anyMatch(p -> p.equals((Object)AccessControl.getPerson()));
    }
}

