/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.coordinator.evaluation;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.faces.model.SelectItem;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.struts.util.MessageResources;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.resourceAllocationManager.exams.CreateWrittenEvaluation;
import org.fenixedu.academic.service.services.resourceAllocationManager.exams.DeleteWrittenEvaluation;
import org.fenixedu.academic.service.services.resourceAllocationManager.exams.EditWrittenEvaluation;
import org.fenixedu.academic.service.services.teacher.DeleteEvaluation;
import org.fenixedu.academic.ui.faces.bean.base.FenixBackingBean;
import org.fenixedu.academic.ui.faces.components.util.CalendarLink;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.academic.util.DateFormatUtil;
import org.fenixedu.academic.util.EvaluationType;
import pt.ist.fenixframework.FenixFramework;

public class CoordinatorEvaluationsBackingBean
extends FenixBackingBean {
    private static final MessageResources messages = MessageResources.getMessageResources((String)"resources.PublicDegreeInformation");
    private static final Locale locale = new Locale("pt", "PT");
    private String degreeCurricularPlanID = null;
    private String executionPeriodID = null;
    private String curricularYearID = null;
    private String evaluationType = null;
    private String executionCourseID = null;
    private String name = null;
    private String begin = null;
    private String end = null;
    private String description = null;
    private String date = null;
    private String beginTime = null;
    private String endTime = null;
    private String evaluationID = null;
    private Evaluation evalution;
    private Boolean onlineSubmissionsAllowed = null;
    private Integer maxSubmissionsToKeep = null;
    private String groupingID = null;
    private List<SelectItem> executionCourseGroupings = null;
    private Evaluation evaluation;
    private static final Comparator executionCourseComparator = new ComparatorChain();
    private static final Comparator evaluationComparator;

    public String getDegreeCurricularPlanID() {
        DegreeCoordinatorIndex.setCoordinatorContext(this.getRequest());
        return this.degreeCurricularPlanID == null ? (this.degreeCurricularPlanID = this.getAndHoldStringParameter("degreeCurricularPlanID")) : this.degreeCurricularPlanID;
    }

    public String getExecutionPeriodID() throws FenixServiceException {
        if (this.executionPeriodID == null) {
            this.executionPeriodID = this.getAndHoldStringParameter("executionPeriodID");
            if (this.executionPeriodID == null) {
                ExecutionSemester executionSemester = this.getCurrentExecutionPeriod();
                this.executionPeriodID = executionSemester.getExternalId();
            }
        }
        return this.executionPeriodID;
    }

    public void setExecutionPeriodID(String executionPeriodID) {
        this.executionPeriodID = executionPeriodID;
    }

    public String getCurricularYearID() {
        return this.curricularYearID == null ? (this.curricularYearID = this.getAndHoldStringParameter("curricularYearID")) : this.curricularYearID;
    }

    public void setCurricularYearID(String curricularYearID) {
        this.curricularYearID = curricularYearID;
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        String degreeCurricularPlanID = this.getDegreeCurricularPlanID();
        return (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanID);
    }

    private ExecutionSemester getCurrentExecutionPeriod() throws FenixServiceException {
        ExecutionSemester lastExecutionPeriod = null;
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan();
        for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
            ExecutionYear executionYear = executionDegree.getExecutionYear();
            for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
                if (executionSemester.isCurrent()) {
                    return executionSemester;
                }
                if (lastExecutionPeriod != null && !executionSemester.isAfter(lastExecutionPeriod)) continue;
                lastExecutionPeriod = executionSemester;
            }
        }
        return lastExecutionPeriod;
    }

    public List<SelectItem> getExecutionPeriodSelectItems() throws FenixServiceException {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan();
        TreeSet<ExecutionSemester> executionPeriods = new TreeSet<ExecutionSemester>();
        for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
            ExecutionYear executionYear = executionDegree.getExecutionYear();
            for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
                executionPeriods.add(executionSemester);
            }
        }
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (ExecutionSemester executionSemester : executionPeriods) {
            SelectItem selectItem = new SelectItem();
            selectItem.setLabel(executionSemester.getName() + " - " + executionSemester.getExecutionYear().getYear());
            selectItem.setValue((Object)executionSemester.getExternalId());
            selectItems.add(selectItem);
        }
        return selectItems;
    }

    public List<SelectItem> getCurricularYearSelectItems() throws FenixServiceException {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        selectItems.add(new SelectItem((Object)"", messages.getMessage(locale, "public.curricular.years.all")));
        for (int i = 1; i <= 5; ++i) {
            selectItems.add(new SelectItem((Object)i, String.valueOf(i)));
        }
        return selectItems;
    }

    public ExecutionSemester getExecutionPeriod() throws FenixServiceException {
        String executionPeriodID = this.getExecutionPeriodID();
        return (ExecutionSemester)FenixFramework.getDomainObject((String)executionPeriodID);
    }

    private ExecutionDegree getExecutionDegree() throws FenixServiceException {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan();
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
            if (executionDegree.getExecutionYear() != executionSemester.getExecutionYear()) continue;
            return executionDegree;
        }
        return null;
    }

    public Date getCalendarBegin() throws FenixServiceException {
        ExecutionDegree executionDegree = this.getExecutionDegree();
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        if (executionDegree != null) {
            if (executionSemester.getSemester() == 1) {
                return executionDegree.getPeriodLessonsFirstSemester().getStart();
            }
            if (executionSemester.getSemester() == 2) {
                return executionDegree.getPeriodLessonsSecondSemester().getStart();
            }
            return executionSemester.getBeginDate();
        }
        return null;
    }

    public Date getCalendarEnd() throws FenixServiceException {
        ExecutionDegree executionDegree = this.getExecutionDegree();
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        if (executionDegree != null) {
            if (executionSemester.getSemester() == 1) {
                return executionDegree.getPeriodExamsFirstSemester().getEnd();
            }
            if (executionSemester.getSemester() == 2) {
                return executionDegree.getPeriodExamsSecondSemester().getEnd();
            }
            return executionSemester.getEndDate();
        }
        return null;
    }

    public List<ExecutionCourse> getExecutionCourses() throws FenixServiceException {
        ArrayList<ExecutionCourse> executionCourses = new ArrayList<ExecutionCourse>();
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan();
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        CurricularYear curricularYear = this.getCurricularYear();
        for (CurricularCourse curricularCourse : degreeCurricularPlan.getCurricularCoursesSet()) {
            if (!this.isActiveInExecutionPeriodAndYear(curricularCourse, executionSemester, curricularYear)) continue;
            for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
                if (executionCourse.getExecutionPeriod() != executionSemester) continue;
                executionCourses.add(executionCourse);
            }
        }
        return executionCourses;
    }

    public Map<ExecutionCourse, Set<Evaluation>> getExecutionCoursesMap() throws FenixServiceException {
        TreeMap<ExecutionCourse, Set<Evaluation>> executionCourseEvaluationsMap = new TreeMap<ExecutionCourse, Set<Evaluation>>(executionCourseComparator);
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan();
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        CurricularYear curricularYear = this.getCurricularYear();
        for (CurricularCourse curricularCourse : degreeCurricularPlan.getCurricularCoursesSet()) {
            if (!this.isActiveInExecutionPeriodAndYear(curricularCourse, executionSemester, curricularYear)) continue;
            for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
                if (executionCourse.getExecutionPeriod() != executionSemester) continue;
                TreeSet evaluations = new TreeSet(evaluationComparator);
                executionCourseEvaluationsMap.put(executionCourse, evaluations);
                evaluations.addAll(executionCourse.getAssociatedEvaluationsSet());
            }
        }
        return executionCourseEvaluationsMap;
    }

    public List<CalendarLink> getCalendarLinks() throws FenixServiceException {
        ArrayList<CalendarLink> calendarLinks = new ArrayList<CalendarLink>();
        String evaluationType = this.getEvaluationType();
        for (ExecutionCourse executionCourse : this.getExecutionCourses()) {
            for (Evaluation evaluation : executionCourse.getAssociatedEvaluationsSet()) {
                Exam exam;
                if (evaluationType != null && evaluationType.length() != 0 && !evaluationType.equals(((Object)((Object)evaluation)).getClass().getName())) continue;
                if (evaluation instanceof WrittenTest) {
                    WrittenTest writtenTest = (WrittenTest)((Object)evaluation);
                    this.constructCalendarLink(calendarLinks, (WrittenEvaluation)((Object)writtenTest), executionCourse);
                    continue;
                }
                if (evaluation instanceof Project) {
                    Project project = (Project)((Object)evaluation);
                    this.constructCalendarLink(calendarLinks, project, executionCourse);
                    continue;
                }
                if (!(evaluation instanceof Exam) || !(exam = (Exam)((Object)evaluation)).isExamsMapPublished()) continue;
                this.constructEmptyCalendarLink(calendarLinks, (WrittenEvaluation)((Object)exam), executionCourse);
            }
        }
        return calendarLinks;
    }

    public List<ExecutionCourse> getExecutionCoursesWithoutEvaluations() throws FenixServiceException {
        ArrayList<ExecutionCourse> executionCourses = new ArrayList<ExecutionCourse>();
        for (ExecutionCourse executionCourse : this.getExecutionCourses()) {
            if (this.hasNonExamEvaluation(executionCourse)) continue;
            executionCourses.add(executionCourse);
        }
        return executionCourses;
    }

    public List<ExecutionCourse> getExecutionCoursesWithEvaluations() throws FenixServiceException {
        ArrayList<ExecutionCourse> executionCourses = new ArrayList<ExecutionCourse>();
        for (ExecutionCourse executionCourse : this.getExecutionCourses()) {
            if (!this.hasNonExamEvaluation(executionCourse)) continue;
            executionCourses.add(executionCourse);
        }
        return executionCourses;
    }

    private boolean hasNonExamEvaluation(ExecutionCourse executionCourse) {
        for (Evaluation evaluation : executionCourse.getAssociatedEvaluationsSet()) {
            if (evaluation instanceof Exam) continue;
            return true;
        }
        return false;
    }

    private boolean isActiveInExecutionPeriodAndYear(CurricularCourse curricularCourse, ExecutionSemester executionSemester, CurricularYear curricularYear) {
        for (DegreeModuleScope curricularCourseScope : curricularCourse.getDegreeModuleScopes()) {
            if (!curricularCourseScope.isActiveForExecutionPeriod(executionSemester) || curricularYear != null && !curricularYear.getYear().equals(curricularCourseScope.getCurricularYear())) continue;
            return true;
        }
        return false;
    }

    private CurricularYear getCurricularYear() {
        String curricularYearID = this.getCurricularYearID();
        return curricularYearID != null ? (CurricularYear)FenixFramework.getDomainObject((String)curricularYearID) : null;
    }

    private void constructEmptyCalendarLink(List<CalendarLink> calendarLinks, WrittenEvaluation writtenEvaluation, ExecutionCourse executionCourse) {
        CalendarLink calendarLink = new CalendarLink(executionCourse, writtenEvaluation, locale);
        calendarLink.setAsLink(false);
        calendarLinks.add(calendarLink);
    }

    private void constructCalendarLink(List<CalendarLink> calendarLinks, WrittenEvaluation writtenEvaluation, ExecutionCourse executionCourse) {
        CalendarLink calendarLink = new CalendarLink(executionCourse, writtenEvaluation, locale);
        this.addLinkParameters(calendarLink, executionCourse, (Evaluation)((Object)writtenEvaluation));
        this.addWrittenEvaluationLinkParameters(calendarLink, writtenEvaluation);
        calendarLinks.add(calendarLink);
    }

    private void constructCalendarLink(List<CalendarLink> calendarLinks, Project project, ExecutionCourse executionCourse) {
        CalendarLink calendarLinkBegin = new CalendarLink(executionCourse, project, project.getBegin(), messages.getMessage(locale, "label.evaluation.project.begin"), locale);
        this.addLinkParameters(calendarLinkBegin, executionCourse, (Evaluation)((Object)project));
        this.addProjectLinkParameters(calendarLinkBegin, project);
        calendarLinks.add(calendarLinkBegin);
        CalendarLink calendarLinkEnd = new CalendarLink(executionCourse, project, project.getEnd(), messages.getMessage(locale, "label.evaluation.project.end"), locale);
        this.addLinkParameters(calendarLinkEnd, executionCourse, (Evaluation)((Object)project));
        this.addProjectLinkParameters(calendarLinkEnd, project);
        calendarLinks.add(calendarLinkEnd);
    }

    private void addLinkParameters(CalendarLink calendarLink, ExecutionCourse executionCourse, Evaluation evaluation) {
        calendarLink.addLinkParameter("degreeCurricularPlanID", this.getDegreeCurricularPlanID().toString());
        calendarLink.addLinkParameter("executionPeriodID", executionCourse.getExecutionPeriod().getExternalId().toString());
        calendarLink.addLinkParameter("executionCourseID", executionCourse.getExternalId().toString());
        calendarLink.addLinkParameter("curricularYearID", this.getCurricularYearID() != null ? this.getCurricularYearID().toString() : "");
        calendarLink.addLinkParameter("evaluationID", evaluation.getExternalId().toString());
        calendarLink.addLinkParameter("evaluationType", ((Object)((Object)evaluation)).getClass().getName());
    }

    private void addWrittenEvaluationLinkParameters(CalendarLink calendarLink, WrittenEvaluation writtenEvaluation) {
        if (writtenEvaluation instanceof WrittenTest) {
            calendarLink.addLinkParameter("description", ((WrittenTest)((Object)writtenEvaluation)).getDescription());
        }
        calendarLink.addLinkParameter("date", DateFormatUtil.format("dd/MM/yyyy", writtenEvaluation.getDayDate()));
        calendarLink.addLinkParameter("beginTime", DateFormatUtil.format("HH:mm", writtenEvaluation.getBeginningDate()));
        calendarLink.addLinkParameter("endTime", DateFormatUtil.format("HH:mm", writtenEvaluation.getEndDate()));
    }

    private void addProjectLinkParameters(CalendarLink calendarLinkBegin, Project project) {
        calendarLinkBegin.addLinkParameter("name", project.getName());
        calendarLinkBegin.addLinkParameter("begin", DateFormatUtil.format("dd/MM/yyyy HH:mm", project.getBegin()));
        calendarLinkBegin.addLinkParameter("end", DateFormatUtil.format("dd/MM/yyyy HH:mm", project.getEnd()));
        calendarLinkBegin.addLinkParameter("description", project.getDescription());
    }

    public String getEvaluationType() {
        return this.evaluationType == null ? (this.evaluationType = this.getAndHoldStringParameter("evaluationType")) : this.evaluationType;
    }

    public void setEvaluationType(String evaluationType) {
        this.evaluationType = evaluationType;
    }

    public List<SelectItem> getExecutionCourseSelectItems() throws FenixServiceException {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        selectItems.add(new SelectItem((Object)"", messages.getMessage(locale, "public.curricular.years.all")));
        List<ExecutionCourse> executionCourses = this.getExecutionCourses();
        for (ExecutionCourse executionCourse : executionCourses) {
            selectItems.add(new SelectItem((Object)executionCourse.getExternalId(), executionCourse.getNome()));
        }
        return selectItems;
    }

    public String getExecutionCourseID() {
        return this.executionCourseID == null ? (this.executionCourseID = this.getAndHoldStringParameter("executionCourseID")) : this.executionCourseID;
    }

    public void setExecutionCourseID(String executionCourseID) {
        this.executionCourseID = executionCourseID;
    }

    public String getDescription() {
        return this.description == null ? (this.description = this.getAndHoldStringParameter("description")) : this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name == null ? (this.name = this.getAndHoldStringParameter("name")) : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBegin() {
        if (this.begin == null) {
            String parameterString;
            this.begin = this.getAndHoldStringParameter("begin");
            if (this.begin == null && (parameterString = this.getRequestParameter("selectedDate")) != null && parameterString.length() > 0) {
                this.begin = parameterString + " 00:00";
                this.setRequestAttribute("begin", this.begin);
            }
        }
        return this.begin == null ? (this.begin = this.getAndHoldStringParameter("begin")) : this.begin;
    }

    public void setBegin(String begin) {
        this.begin = begin;
    }

    public String getEnd() {
        return this.end == null ? (this.end = this.getAndHoldStringParameter("end")) : this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public String createWrittenTest() throws FenixServiceException {
        ExecutionCourse executionCourse = this.getExecutionCourse();
        ArrayList<String> executionCourseIDs = new ArrayList<String>(1);
        executionCourseIDs.add(this.getExecutionCourseID().toString());
        List<String> degreeModuleScopeIDs = this.getDegreeModuleScopeIDs(executionCourse);
        try {
            CreateWrittenEvaluation.runCreateWrittenEvaluation(this.getExecutionCourseID(), DateFormatUtil.parse("dd/MM/yyyy", this.getDate()), DateFormatUtil.parse("HH:mm", this.getBeginTime()), DateFormatUtil.parse("HH:mm", this.getEndTime()), executionCourseIDs, degreeModuleScopeIDs, null, null, null, this.getDescription());
        }
        catch (ParseException ex) {
            this.setErrorMessage("error.invalid.date");
            return "viewCreationPage";
        }
        return "viewCalendar";
    }

    public String editWrittenTest() throws FenixServiceException {
        ExecutionCourse executionCourse = this.getExecutionCourse();
        ArrayList<String> executionCourseIDs = new ArrayList<String>(1);
        executionCourseIDs.add(this.getExecutionCourseID().toString());
        List<String> degreeModuleScopeIDs = this.getDegreeModuleScopeIDs(executionCourse);
        try {
            EditWrittenEvaluation.runEditWrittenEvaluation(executionCourse.getExternalId(), DateFormatUtil.parse("dd/MM/yyyy", this.getDate()), DateFormatUtil.parse("HH:mm", this.getBeginTime()), DateFormatUtil.parse("HH:mm", this.getEndTime()), executionCourseIDs, degreeModuleScopeIDs, null, this.getEvaluationID(), null, this.getDescription(), null);
        }
        catch (ParseException ex) {
            this.setErrorMessage("error.invalid.date");
            return "viewEditPage";
        }
        catch (NotAuthorizedException ex) {
            this.setErrorMessage(ex.getMessage());
            return "viewEditPage";
        }
        return "viewCalendar";
    }

    public ExecutionCourse getExecutionCourse() {
        return (ExecutionCourse)FenixFramework.getDomainObject((String)this.getExecutionCourseID());
    }

    private List<String> getDegreeModuleScopeIDs(ExecutionCourse executionCourse) {
        ArrayList<String> ids = new ArrayList<String>();
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            List<DegreeModuleScope> degreeModuleScopes = curricularCourse.getDegreeModuleScopes();
            for (DegreeModuleScope degreeModuleScope : degreeModuleScopes) {
                if (!degreeModuleScope.getCurricularSemester().equals(executionCourse.getExecutionPeriod().getSemester())) continue;
                ids.add(degreeModuleScope.getKey());
            }
        }
        return ids;
    }

    public String getBeginTime() {
        return this.beginTime == null ? (this.beginTime = this.getAndHoldStringParameter("beginTime")) : this.beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getDate() {
        if (this.date == null) {
            String parameterString;
            this.date = this.getAndHoldStringParameter("date");
            if (this.date == null && (parameterString = this.getRequestParameter("selectedDate")) != null && parameterString.length() > 0) {
                this.date = parameterString;
                this.setRequestAttribute("date", this.date);
            }
        }
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getEndTime() {
        return this.endTime == null ? (this.endTime = this.getAndHoldStringParameter("endTime")) : this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getEvaluationID() {
        return this.evaluationID == null ? (this.evaluationID = this.getAndHoldStringParameter("evaluationID")) : this.evaluationID;
    }

    public void setEvaluationID(String evaluationID) {
        this.evaluationID = evaluationID;
    }

    public String deleteEvaluation() throws FenixServiceException {
        String evaluationType = this.getEvaluationType();
        if (evaluationType.equals(WrittenEvaluation.class.getName())) {
            try {
                DeleteWrittenEvaluation.runDeleteWrittenEvaluation(this.getExecutionCourseID(), this.getEvaluationID());
            }
            catch (NotAuthorizedException ex) {
                this.setErrorMessage(ex.getMessage());
                return "viewDeletePage";
            }
            catch (DomainException ex) {
                this.setErrorMessage(ex.getKey());
                return "viewDeletePage";
            }
        }
        try {
            DeleteEvaluation.runDeleteEvaluation(this.getExecutionCourseID(), this.getEvaluationID());
        }
        catch (DomainException ex) {
            this.setErrorMessage(ex.getKey());
            return "viewDeletePage";
        }
        return "viewCalendar";
    }

    public List<SelectItem> getExecutionCourseGroupings() throws FenixServiceException {
        if (this.executionCourseGroupings == null) {
            this.executionCourseGroupings = new ArrayList<SelectItem>();
            for (Grouping grouping : this.getExecutionCourse().getGroupings()) {
                this.executionCourseGroupings.add(new SelectItem((Object)grouping.getExternalId(), grouping.getName()));
            }
        }
        return this.executionCourseGroupings;
    }

    private Evaluation getEvaluation() {
        if (this.evalution == null && this.getEvaluationID() != null) {
            this.evaluation = (Evaluation)FenixFramework.getDomainObject((String)this.getEvaluationID());
        }
        return this.evaluation;
    }

    private Project getProject() {
        Evaluation evaluation = this.getEvaluation();
        if (evaluation != null && evaluation.getEvaluationType().equals(EvaluationType.PROJECT_TYPE)) {
            return (Project)((Object)evaluation);
        }
        return null;
    }

    public String getGroupingID() {
        if (this.groupingID == null && this.getProject() != null) {
            Grouping grouping = this.getProject().getGrouping();
            this.groupingID = grouping != null ? grouping.getExternalId() : null;
        }
        return this.groupingID;
    }

    public void setGroupingID(String groupingID) {
        this.groupingID = groupingID;
    }

    public Grouping getGrouping() {
        if (this.getProject() != null) {
            return this.getProject().getGrouping();
        }
        return null;
    }

    public Integer getMaxSubmissionsToKeep() {
        if (this.maxSubmissionsToKeep == null && this.getProject() != null) {
            this.maxSubmissionsToKeep = this.getProject().getMaxSubmissionsToKeep();
        }
        return this.maxSubmissionsToKeep;
    }

    public void setMaxSubmissionsToKeep(Integer maxSubmissionsToKeep) {
        this.maxSubmissionsToKeep = maxSubmissionsToKeep;
    }

    public Boolean getOnlineSubmissionsAllowed() {
        if (this.onlineSubmissionsAllowed == null && this.getProject() != null) {
            this.onlineSubmissionsAllowed = this.getProject().getOnlineSubmissionsAllowed();
        }
        return this.onlineSubmissionsAllowed;
    }

    public void setOnlineSubmissionsAllowed(Boolean onlineSubmissionsAllowed) {
        this.onlineSubmissionsAllowed = onlineSubmissionsAllowed;
    }

    public String returnToCalendar() {
        this.setEvaluationType("");
        return "viewCalendar";
    }

    static {
        ((ComparatorChain)executionCourseComparator).addComparator((Comparator)new BeanComparator("nome"));
        ((ComparatorChain)executionCourseComparator).addComparator((Comparator)new BeanComparator("externalId"));
        evaluationComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1.getClass() != o2.getClass()) {
                    return o1.getClass().getName().compareTo(o2.getClass().getName());
                }
                if (o1 instanceof WrittenTest) {
                    WrittenTest writtenTest1 = (WrittenTest)((Object)o1);
                    WrittenTest writtenTest2 = (WrittenTest)((Object)o2);
                    return writtenTest1.getDayDate().compareTo(writtenTest2.getDayDate());
                }
                if (o2 instanceof Project) {
                    Project project1 = (Project)((Object)o1);
                    Project project2 = (Project)((Object)o2);
                    return project1.getBegin().compareTo(project2.getBegin());
                }
                return -1;
            }
        };
    }
}

