/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet.taglib.sop.v3.renderers;

import org.fenixedu.academic.domain.FrequencyType;
import org.fenixedu.academic.dto.InfoExam;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoLesson;
import org.fenixedu.academic.dto.InfoLessonInstance;
import org.fenixedu.academic.dto.InfoOccupation;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.dto.InfoWrittenTest;
import org.fenixedu.academic.servlet.taglib.sop.v3.LessonSlot;
import org.fenixedu.academic.servlet.taglib.sop.v3.LessonSlotContentRenderer;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class SpaceManagerRoomTimeTableLessonContentRenderer
extends LessonSlotContentRenderer {
    @Override
    public StringBuilder render(String context, LessonSlot lessonSlot) {
        StringBuilder strBuffer = new StringBuilder();
        InfoShowOccupation showOccupation = lessonSlot.getInfoLessonWrapper().getInfoShowOccupation();
        if (showOccupation instanceof InfoLesson) {
            InfoLesson lesson = (InfoLesson)showOccupation;
            strBuffer.append(lesson.getInfoShift().getInfoDisciplinaExecucao().getSigla());
            strBuffer.append("&nbsp;(").append(lesson.getInfoShift().getShiftTypesCodePrettyPrint()).append(")");
            if (lesson.getFrequency().equals((Object)FrequencyType.BIWEEKLY)) {
                strBuffer.append("&nbsp;&nbsp;[Q]");
            }
        } else if (showOccupation instanceof InfoLessonInstance) {
            InfoLessonInstance lesson = (InfoLessonInstance)showOccupation;
            strBuffer.append(lesson.getInfoShift().getInfoDisciplinaExecucao().getSigla());
            strBuffer.append("&nbsp;(").append(lesson.getShiftTypeCodesPrettyPrint()).append(")");
        } else if (showOccupation instanceof InfoExam) {
            InfoExam infoExam = (InfoExam)showOccupation;
            strBuffer.append(BundleUtil.getString((String)"resources.SpaceResources", (String)"label.written.exam", (String[])new String[0])).append(" ");
            strBuffer.append(infoExam.getSeason().getSeason());
            strBuffer.append(BundleUtil.getString((String)"resources.SpaceResources", (String)"label.written.exam.season", (String[])new String[0])).append(" - ");
            for (int iterEC = 0; iterEC < infoExam.getAssociatedExecutionCourse().size(); ++iterEC) {
                InfoExecutionCourse infoEC = infoExam.getAssociatedExecutionCourse().get(iterEC);
                if (iterEC != 0) {
                    strBuffer.append(", ");
                }
                strBuffer.append(infoEC.getSigla());
            }
        } else if (showOccupation instanceof InfoWrittenTest) {
            InfoWrittenTest infoWrittenTest = (InfoWrittenTest)showOccupation;
            strBuffer.append("<span title=\"").append(infoWrittenTest.getDescription()).append("\">");
            strBuffer.append(BundleUtil.getString((String)"resources.SpaceResources", (String)"label.written.test", (String[])new String[0])).append(" - ");
            for (int iterEC = 0; iterEC < infoWrittenTest.getAssociatedExecutionCourse().size(); ++iterEC) {
                InfoExecutionCourse infoEC = infoWrittenTest.getAssociatedExecutionCourse().get(iterEC);
                if (iterEC != 0) {
                    strBuffer.append(", ");
                }
                strBuffer.append(infoEC.getSigla());
            }
            strBuffer.append("</span>");
        } else if (showOccupation instanceof InfoOccupation) {
            InfoOccupation infoGenericEvent = (InfoOccupation)showOccupation;
            strBuffer.append("<span title=\"").append(infoGenericEvent.getDescription()).append("\">");
            strBuffer.append(BundleUtil.getString((String)"resources.SpaceResources", (String)"label.punctual.occupation", (String[])new String[0])).append(" - ");
            strBuffer.append(infoGenericEvent.getTitle());
            strBuffer.append("</span>");
        }
        return strBuffer;
    }
}

