/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.scientificCouncil.thesis;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisEvaluationParticipant;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.PersonSender;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public abstract class ThesisServiceWithMailNotification {
    public void run(Thesis thesis) {
        this.process(thesis);
        this.sendEmail(thesis);
    }

    abstract void process(Thesis var1);

    private void sendEmail(Thesis thesis) {
        PersonSender sender = PersonSender.newInstance(AccessControl.getPerson());
        new Message((Sender)((Object)sender), null, null, this.getSubject(thesis), this.getMessage(thesis), this.getEmails(thesis));
    }

    protected String getMessage(String key, Object ... args) {
        return this.getMessage(I18N.getLocale(), key, args);
    }

    protected String getMessage(Locale locale, String key, Object ... args) {
        String template = BundleUtil.getString((String)"resources.MessagingResources", (Locale)locale, (String)key, (String[])new String[0]);
        return MessageFormat.format(template, args);
    }

    private String getEmails(Thesis thesis) {
        return this.getReceiversEmails(thesis).stream().collect(Collectors.joining(", "));
    }

    protected abstract String getSubject(Thesis var1);

    protected abstract String getMessage(Thesis var1);

    protected abstract Collection<String> getReceiversEmails(Thesis var1);

    protected static Set<Person> personSet(Person ... persons) {
        HashSet<Person> result = new HashSet<Person>();
        for (Person person : persons) {
            if (person == null) continue;
            result.add(person);
        }
        return result;
    }

    protected static Person getPerson(ThesisEvaluationParticipant participant) {
        if (participant == null) {
            return null;
        }
        return participant.getPerson();
    }
}

