/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.commons.searchers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.raides.DegreeDesignation;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.presentationTier.renderers.autoCompleteProvider.AutoCompleteProvider;
import org.fenixedu.commons.StringNormalizer;
import pt.ist.fenixframework.FenixFramework;

public class SearchRaidesDegreeDesignations
implements AutoCompleteProvider<DegreeDesignation> {
    private static int DEFAULT_SIZE = 50;

    public Collection<DegreeDesignation> getSearchResults(Map<String, String> argsMap, String value, int maxCount) {
        int maxLimit = this.getSize(argsMap);
        Unit unit = this.getFilterUnit(argsMap);
        SchoolLevelType schoolLevel = this.getFilterSchoolLevel(argsMap);
        value = StringNormalizer.normalize((String)value);
        ArrayList<DegreeDesignation> result = new ArrayList<DegreeDesignation>();
        Collection<Object> possibleDesignations = null;
        possibleDesignations = unit == null ? Bennu.getInstance().getDegreeDesignationsSet() : unit.getDegreeDesignationSet();
        if (schoolLevel != null) {
            possibleDesignations = this.filterDesignationsBySchoolLevel(possibleDesignations, schoolLevel);
        }
        for (DegreeDesignation degreeDesignation : possibleDesignations) {
            String normalizedDesignation = StringNormalizer.normalize((String)degreeDesignation.getDescription());
            if (normalizedDesignation.contains(value)) {
                result.add(degreeDesignation);
            }
            if (result.size() < maxLimit) continue;
            break;
        }
        return result;
    }

    private Collection<DegreeDesignation> filterDesignationsBySchoolLevel(Collection<DegreeDesignation> possibleDesignations, SchoolLevelType schoolLevel) {
        ArrayList<DegreeDesignation> designationsToKeep = new ArrayList<DegreeDesignation>();
        for (DegreeDesignation designation : possibleDesignations) {
            if (!schoolLevel.getEquivalentDegreeClassifications().contains(designation.getDegreeClassification().getCode())) continue;
            designationsToKeep.add(designation);
        }
        return designationsToKeep;
    }

    private int getSize(Map<String, String> arguments) {
        String size = arguments.get("size");
        if (size == null) {
            return DEFAULT_SIZE;
        }
        return Integer.parseInt(size);
    }

    private SchoolLevelType getFilterSchoolLevel(Map<String, String> arguments) {
        String schoolLevelName = arguments.get("filterSchoolLevelName");
        if (schoolLevelName == null || schoolLevelName.equals("null")) {
            return null;
        }
        return Enum.valueOf(SchoolLevelType.class, schoolLevelName);
    }

    private Unit getFilterUnit(Map<String, String> arguments) {
        String filterUnitOID = arguments.get("filterUnitOID");
        if (filterUnitOID == null || filterUnitOID.equals("null")) {
            return null;
        }
        return (Unit)FenixFramework.getDomainObject((String)filterUnitOID);
    }
}

