/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.commons.searchers;

import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.UnitName;
import org.fenixedu.academic.service.services.commons.searchers.SearchParties;
import org.fenixedu.academic.service.services.person.PersonSearcher;
import org.joda.time.YearMonthDay;

public class SearchAllActiveParties
extends SearchParties<Party> {
    @Override
    protected Collection<Party> search(String value, int size) {
        HashSet<Party> result = new HashSet<Party>();
        result.addAll(new PersonSearcher().bestEffortQuery(value).search(size).collect(Collectors.toSet()));
        YearMonthDay currentDate = new YearMonthDay();
        for (UnitName unitName : UnitName.find(value, size)) {
            if (!unitName.getUnit().isActive(currentDate)) continue;
            result.add((Party)((Object)unitName.getUnit()));
        }
        return result;
    }
}

